/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.impl;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDriver;
import com.google.gwt.editor.client.impl.AbstractEditorDelegate;
import com.google.gwt.editor.client.impl.DelegateMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;

public abstract class SimpleViolation {
    public static Iterable<SimpleViolation> iterableFromConstrantViolations(Iterable<ConstraintViolation<?>> violations) {
        return new ConstraintViolationIterable(violations);
    }

    public static void pushViolations(Iterable<SimpleViolation> violations, EditorDriver<?> driver, DelegateMap.KeyMethod keyMethod) {
        if (violations == null) {
            return;
        }
        DelegateMap delegateMap = DelegateMap.of(driver, keyMethod);
        for (SimpleViolation error : violations) {
            Object key = error.getKey();
            List<AbstractEditorDelegate<?, ?>> delegateList = delegateMap.get(key);
            if (delegateList == null) continue;
            for (AbstractEditorDelegate<?, ?> baseDelegate : delegateList) {
                String absolutePath;
                String basePath = baseDelegate.getPath();
                String originalAbsolutePath = absolutePath = (basePath.length() > 0 ? basePath + "." : "") + error.getPath();
                while (!SimpleViolation.processLeafDelegates(delegateMap, originalAbsolutePath, absolutePath, error) && !SimpleViolation.processEditors(delegateMap, baseDelegate, absolutePath, error)) {
                    if (absolutePath.isEmpty()) {
                        throw new IllegalStateException("No editor: " + originalAbsolutePath);
                    }
                    absolutePath = SimpleViolation.getParentPath(absolutePath);
                }
            }
        }
    }

    private static String getParentPath(String absolutePath) {
        int dotIdx = absolutePath.lastIndexOf(46);
        if (dotIdx > 0) {
            return absolutePath.substring(0, dotIdx);
        }
        return "";
    }

    private static boolean processEditors(DelegateMap delegateMap, AbstractEditorDelegate<?, ?> baseDelegate, String absolutePath, SimpleViolation error) {
        List<Editor<?>> editors = delegateMap.getEditorByPath(absolutePath);
        if (editors == null) {
            return false;
        }
        for (Editor<?> editor : editors) {
            baseDelegate.recordError(error.getMessage(), null, error.getUserDataObject(), error.getPath(), editor);
        }
        return true;
    }

    private static boolean processLeafDelegates(DelegateMap delegateMap, String originalAbsolutePath, String absolutePath, SimpleViolation error) {
        List<AbstractEditorDelegate<?, ?>> leafDelegates = delegateMap.getDelegatesByPath(absolutePath);
        if (leafDelegates == null) {
            return false;
        }
        String addlPath = originalAbsolutePath.substring(absolutePath.length());
        for (AbstractEditorDelegate<?, ?> delegate : leafDelegates) {
            if (addlPath.isEmpty()) {
                delegate.recordError(error.getMessage(), null, error.getUserDataObject());
                continue;
            }
            delegate.recordError(error.getMessage(), null, error.getUserDataObject(), addlPath, (Editor<?>)delegate.getEditor());
        }
        return true;
    }

    protected SimpleViolation() {
    }

    public abstract Object getKey();

    public abstract String getMessage();

    public abstract String getPath();

    public abstract Object getUserDataObject();

    static class SimpleViolationAdapter
    extends SimpleViolation {
        private final ConstraintViolation<?> v;

        public SimpleViolationAdapter(ConstraintViolation<?> v) {
            this.v = v;
        }

        @Override
        public Object getKey() {
            return this.v.getRootBean();
        }

        @Override
        public String getMessage() {
            return this.v.getMessage();
        }

        @Override
        public String getPath() {
            return this.v.getPropertyPath().toString();
        }

        @Override
        public Object getUserDataObject() {
            return this.v;
        }
    }

    static class ConstraintViolationIterable
    implements Iterable<SimpleViolation> {
        private final Iterable<ConstraintViolation<?>> violations;

        public ConstraintViolationIterable(Iterable<ConstraintViolation<?>> violations) {
            this.violations = violations;
        }

        @Override
        public Iterator<SimpleViolation> iterator() {
            final Iterator<ConstraintViolation<?>> source = this.violations.iterator();
            return new Iterator<SimpleViolation>(){

                @Override
                public boolean hasNext() {
                    return source.hasNext();
                }

                @Override
                public SimpleViolation next() {
                    return new SimpleViolationAdapter((ConstraintViolation)source.next());
                }

                @Override
                public void remove() {
                    source.remove();
                }
            };
        }
    }
}

