/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-06 06:14:25 +0100 (Thu, 06 Mar 2014) $
//  number=$Revision: 9876 $
//  type=mr

/**
 * Localized names for the "mr" locale.
 */
public class LocalizedNamesImpl_mr extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AI",
        "AG",
        "AD",
        "AO",
        "AQ",
        "AZ",
        "AF",
        "AS",
        "AW",
        "AR",
        "AM",
        "SV",
        "DZ",
        "AL",
        "AX",
        "AC",
        "IS",
        "QO",
        "IE",
        "CI",
        "ID",
        "EC",
        "GQ",
        "EG",
        "IT",
        "ET",
        "IQ",
        "IL",
        "IM",
        "IR",
        "UZ",
        "KP",
        "MP",
        "UY",
        "ER",
        "EE",
        "AT",
        "AU",
        "OM",
        "KH",
        "KZ",
        "QA",
        "CD",
        "CG",
        "KG",
        "KI",
        "CK",
        "CW",
        "KW",
        "CA",
        "IC",
        "CM",
        "BQ",
        "CF",
        "KE",
        "CV",
        "KY",
        "CC",
        "KM",
        "CO",
        "XK",
        "CR",
        "CU",
        "HR",
        "CP",
        "CX",
        "GY",
        "GM",
        "GN",
        "GW",
        "GU",
        "GA",
        "GL",
        "GR",
        "GD",
        "GT",
        "GP",
        "GG",
        "GH",
        "TD",
        "CL",
        "CN",
        "JP",
        "JM",
        "DE",
        "JE",
        "DJ",
        "GI",
        "GE",
        "JO",
        "ZM",
        "ZW",
        "CZ",
        "TC",
        "TZ",
        "TV",
        "TO",
        "TG",
        "TN",
        "TA",
        "DK",
        "DO",
        "DM",
        "TJ",
        "TM",
        "TR",
        "TW",
        "TK",
        "TT",
        "TH",
        "ZA",
        "KR",
        "GS",
        "SS",
        "DG",
        "NR",
        "NE",
        "NA",
        "NG",
        "NI",
        "NU",
        "NL",
        "AN",
        "NP",
        "NF",
        "NO",
        "NC",
        "NZ",
        "PA",
        "PY",
        "PW",
        "EH",
        "PK",
        "PG",
        "PN",
        "TL",
        "PS",
        "PE",
        "PR",
        "PT",
        "PL",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FK",
        "FR",
        "GF",
        "TF",
        "PF",
        "BM",
        "BG",
        "BS",
        "BH",
        "BD",
        "BB",
        "BI",
        "BF",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BV",
        "BW",
        "BO",
        "BA",
        "BR",
        "IO",
        "VG",
        "BN",
        "IN",
        "BT",
        "MN",
        "MO",
        "MW",
        "MY",
        "MG",
        "FM",
        "YT",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "MK",
        "MX",
        "MS",
        "MR",
        "MU",
        "ME",
        "MZ",
        "MC",
        "MA",
        "MD",
        "MM",
        "UA",
        "UG",
        "GB",
        "US",
        "EU",
        "UM",
        "VI",
        "YE",
        "RW",
        "RU",
        "RE",
        "RO",
        "LU",
        "LA",
        "LV",
        "LR",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "VU",
        "WF",
        "VN",
        "VA",
        "VE",
        "LK",
        "AE",
        "RS",
        "ST",
        "WS",
        "CY",
        "SG",
        "SX",
        "SL",
        "SY",
        "SD",
        "SR",
        "SM",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "SN",
        "SC",
        "SO",
        "SB",
        "SA",
        "ES",
        "EA",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "HU",
        "HM",
        "HK",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "विश्व");
    namesMap.put("002", "आफ्रिका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओशनिया");
    namesMap.put("011", "पश्चिम आफ्रिका");
    namesMap.put("013", "मध्य अमेरिका");
    namesMap.put("014", "पूर्व आफ्रिका");
    namesMap.put("015", "उत्तर आफ्रिका");
    namesMap.put("017", "मध्य आफ्रिका");
    namesMap.put("018", "दक्षिणी आफ्रिका");
    namesMap.put("019", "अमेरिका");
    namesMap.put("021", "उत्तरी अमेरिका");
    namesMap.put("029", "कॅरीबियन");
    namesMap.put("030", "पूर्व अशिया");
    namesMap.put("034", "दक्षिण अशिया");
    namesMap.put("035", "दक्षिण पूर्व अशिया");
    namesMap.put("039", "दक्षिण युरोप");
    namesMap.put("053", "ऑस्‍ट्रेलेशिया");
    namesMap.put("054", "मेलानेशिया");
    namesMap.put("057", "मायक्रोनेशियन प्रदेश");
    namesMap.put("061", "पॉलिनेशिया");
    namesMap.put("142", "अशिया");
    namesMap.put("143", "मध्य अशिया");
    namesMap.put("145", "पश्चिम अशिया");
    namesMap.put("150", "युरोप");
    namesMap.put("151", "पूर्व युरोप");
    namesMap.put("154", "उत्तर युरोप");
    namesMap.put("155", "पश्चिम युरोप");
    namesMap.put("419", "लॅटिन अमेरिका");
    namesMap.put("AC", "अ‍ॅसेन्शियन बेट");
    namesMap.put("AD", "अँडोरा");
    namesMap.put("AE", "संयुक्त अरब अमीरात");
    namesMap.put("AF", "अफगाणिस्तान");
    namesMap.put("AG", "अँटिग्वा आणि बर्बुडा");
    namesMap.put("AI", "अँग्विला");
    namesMap.put("AL", "अल्बानिया");
    namesMap.put("AM", "अर्मेनिया");
    namesMap.put("AN", "नेदरलँड्‍स अँ‍टिल्स");
    namesMap.put("AO", "अंगोला");
    namesMap.put("AQ", "अंटार्क्टिका");
    namesMap.put("AR", "अर्जेंटिना");
    namesMap.put("AS", "अमेरिकन सामोआ");
    namesMap.put("AT", "ऑस्ट्रिया");
    namesMap.put("AU", "ऑस्ट्रेलिया");
    namesMap.put("AW", "अरुबा");
    namesMap.put("AX", "अ‍ॅलँड बेटे");
    namesMap.put("AZ", "अझरबैजान");
    namesMap.put("BA", "बोस्निया अणि हर्जेगोविना");
    namesMap.put("BB", "बार्बाडोस");
    namesMap.put("BD", "बांग्लादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बुर्किना फासो");
    namesMap.put("BG", "बल्गेरिया");
    namesMap.put("BH", "बहारीन");
    namesMap.put("BI", "बुरुंडी");
    namesMap.put("BJ", "बेनिन");
    namesMap.put("BL", "सेंट बार्थेलेमी");
    namesMap.put("BM", "बर्मुडा");
    namesMap.put("BN", "ब्रुनेई");
    namesMap.put("BO", "बोलिव्हिया");
    namesMap.put("BQ", "कॅरिबियन नेदरलँड्स");
    namesMap.put("BR", "ब्राझिल");
    namesMap.put("BS", "बहामाज");
    namesMap.put("BT", "भूतान");
    namesMap.put("BV", "बोउवेट बेट");
    namesMap.put("BW", "बोट्सवाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलिझे");
    namesMap.put("CA", "कॅनडा");
    namesMap.put("CC", "कोकोस बेटे");
    namesMap.put("CD", "काँगो - किंशासा");
    namesMap.put("CF", "केंद्रीय अफ्रिकी प्रजासत्ताक");
    namesMap.put("CG", "काँगो - ब्राझाविले");
    namesMap.put("CH", "स्वित्झर्लंड");
    namesMap.put("CI", "आयव्हरी कोस्ट");
    namesMap.put("CK", "कुक बेटे");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "कॅमेरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलम्बिया");
    namesMap.put("CP", "क्लिपरटोन बेट");
    namesMap.put("CR", "कोस्टारिका");
    namesMap.put("CU", "क्यूबा");
    namesMap.put("CV", "केप व्हर्डे");
    namesMap.put("CW", "कुरॅको");
    namesMap.put("CX", "ख्रिसमस बेट");
    namesMap.put("CY", "सायप्रस");
    namesMap.put("CZ", "झेक प्रजासत्ताक");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DG", "दिएगो गार्सिया");
    namesMap.put("DJ", "जिबौटी");
    namesMap.put("DK", "डेन्मार्क");
    namesMap.put("DM", "डोमिनिका");
    namesMap.put("DO", "डोमिनिकन प्रजासत्ताक");
    namesMap.put("DZ", "अल्जीरिया");
    namesMap.put("EA", "स्यूटा आणि मेलिला");
    namesMap.put("EC", "इक्वाडोर");
    namesMap.put("EE", "एस्टोनिया");
    namesMap.put("EG", "इजिप्त");
    namesMap.put("EH", "पश्चिम सहारा");
    namesMap.put("ER", "एरिट्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथिओपिया");
    namesMap.put("EU", "युरोपीय संघ");
    namesMap.put("FI", "फिनलंड");
    namesMap.put("FJ", "फिजी");
    namesMap.put("FK", "फॉकलंड बेटे");
    namesMap.put("FM", "मायक्रोनेशिया");
    namesMap.put("FO", "फरोए बेटे");
    namesMap.put("FR", "फ्रान्स");
    namesMap.put("GA", "गॅबॉन");
    namesMap.put("GB", "युनायटेड किंगडम");
    namesMap.put("GD", "ग्रेनेडा");
    namesMap.put("GE", "जॉर्जिया");
    namesMap.put("GF", "फ्रेंच गयाना");
    namesMap.put("GG", "ग्वेर्नसे");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टर");
    namesMap.put("GL", "ग्रीनलंड");
    namesMap.put("GM", "गाम्बिया");
    namesMap.put("GN", "गिनी");
    namesMap.put("GP", "ग्वाडेलोउपे");
    namesMap.put("GQ", "इक्वेटोरियल गिनी");
    namesMap.put("GR", "ग्रीस");
    namesMap.put("GS", "दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे");
    namesMap.put("GT", "ग्वाटेमाला");
    namesMap.put("GU", "गुआम");
    namesMap.put("GW", "गिनी-बिसाउ");
    namesMap.put("GY", "गयाना");
    namesMap.put("HK", "हाँगकाँग एसएआर चीन");
    namesMap.put("HM", "हर्ड आणि मॅक्डोनाल्ड बेटे");
    namesMap.put("HN", "होंडुरास");
    namesMap.put("HR", "क्रोएशिया");
    namesMap.put("HT", "हैती");
    namesMap.put("HU", "हंगेरी");
    namesMap.put("IC", "कॅनरी बेटे");
    namesMap.put("ID", "इंडोनेशिया");
    namesMap.put("IE", "आयर्लंड");
    namesMap.put("IL", "इस्त्राइल");
    namesMap.put("IM", "इस्ले ऑफ मॅन");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "ब्रिटिश इंडियन ओशन प्रदेश");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "ईराण");
    namesMap.put("IS", "आइसलँड");
    namesMap.put("IT", "इटली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमैका");
    namesMap.put("JO", "जॉर्डन");
    namesMap.put("JP", "जपान");
    namesMap.put("KE", "केनिया");
    namesMap.put("KG", "किरगिझस्तान");
    namesMap.put("KH", "कंबोडिया");
    namesMap.put("KI", "किरीबाटी");
    namesMap.put("KM", "कोमोरोज");
    namesMap.put("KN", "सेंट किट्स आणि नेव्हिस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवेत");
    namesMap.put("KY", "केमन बेटे");
    namesMap.put("KZ", "कझाकस्तान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनॉन");
    namesMap.put("LC", "सेंट ल्यूसिया");
    namesMap.put("LI", "लिंचेनस्टाइन");
    namesMap.put("LK", "श्रीलंका");
    namesMap.put("LR", "लायबेरिया");
    namesMap.put("LS", "लेसोथो");
    namesMap.put("LT", "लिथुआनिया");
    namesMap.put("LU", "लक्झेंबर्ग");
    namesMap.put("LV", "लाट्‌विया");
    namesMap.put("LY", "लिबिया");
    namesMap.put("MA", "मोरोक्को");
    namesMap.put("MC", "मोनॅको");
    namesMap.put("MD", "मोल्डोव्हा");
    namesMap.put("ME", "मोंटेनेग्रो");
    namesMap.put("MF", "सेंट मार्टिन");
    namesMap.put("MG", "मादागास्कर");
    namesMap.put("MH", "मार्शल बेटे");
    namesMap.put("MK", "मॅसेडोनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यानमार (बर्मा)");
    namesMap.put("MN", "मंगोलिया");
    namesMap.put("MO", "मकाओ एसएआर चीन");
    namesMap.put("MP", "उत्तरी मारियाना बेटे");
    namesMap.put("MQ", "मार्टिनिक");
    namesMap.put("MR", "मॉरिटानिया");
    namesMap.put("MS", "मॉन्ट्सेराट");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "मॉरिशस");
    namesMap.put("MV", "मालदीव");
    namesMap.put("MW", "मलावी");
    namesMap.put("MX", "मेक्सिको");
    namesMap.put("MY", "मलेशिया");
    namesMap.put("MZ", "मोझाम्बिक");
    namesMap.put("NA", "नामिबिया");
    namesMap.put("NC", "न्यू कॅलेडोनिया");
    namesMap.put("NE", "नाइजर");
    namesMap.put("NF", "नॉरफॉक बेट");
    namesMap.put("NG", "नायजेरिया");
    namesMap.put("NI", "निकाराग्वे");
    namesMap.put("NL", "नेदरलँड");
    namesMap.put("NO", "नॉर्वे");
    namesMap.put("NP", "नेपाळ");
    namesMap.put("NR", "नऊरु");
    namesMap.put("NU", "नीयू");
    namesMap.put("NZ", "न्यूझीलंड");
    namesMap.put("OM", "ओमान");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ्रेंच पॉलिनेशिया");
    namesMap.put("PG", "पापुआ न्यू गिनी");
    namesMap.put("PH", "फिलिपिन्स");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोलंड");
    namesMap.put("PM", "सेंट पियरे आणि मिक्वेलोन");
    namesMap.put("PN", "पिटकैर्न बेटे");
    namesMap.put("PR", "पोर्टो रिको");
    namesMap.put("PS", "पॅलेस्टिनियन प्रदेश");
    namesMap.put("PT", "पोर्तुगाल");
    namesMap.put("PW", "पलाऊ");
    namesMap.put("PY", "पराग्वे");
    namesMap.put("QA", "कतार");
    namesMap.put("QO", "आउटलाईंग ओशनिया");
    namesMap.put("RE", "रियुनियन");
    namesMap.put("RO", "रोमानिया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रशिया");
    namesMap.put("RW", "रवांडा");
    namesMap.put("SA", "सौदी अरब");
    namesMap.put("SB", "सोलोमन बेटे");
    namesMap.put("SC", "सेशेल्स");
    namesMap.put("SD", "सुदान");
    namesMap.put("SE", "स्वीडन");
    namesMap.put("SG", "सिंगापूर");
    namesMap.put("SH", "सेंट हेलेना");
    namesMap.put("SI", "स्लोव्हेनिया");
    namesMap.put("SJ", "स्वालबर्ड आणि जान मायेन");
    namesMap.put("SK", "स्लोव्हाकिया");
    namesMap.put("SL", "सिएरा लिओन");
    namesMap.put("SM", "सॅन मरीनो");
    namesMap.put("SN", "सेनेगल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सुरिनाम");
    namesMap.put("SS", "दक्षिण सुदान");
    namesMap.put("ST", "साओ टोम आणि प्रिंसिपे");
    namesMap.put("SV", "अल साल्वाडोर");
    namesMap.put("SX", "सिंट मार्टेन");
    namesMap.put("SY", "सीरिया");
    namesMap.put("SZ", "स्वाझिलँड");
    namesMap.put("TA", "ट्रिस्टन दा कन्हा");
    namesMap.put("TC", "टर्क्स आणि कैकोस बेटे");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ्रेंच दाक्षिणात्य प्रदेश");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थायलंड");
    namesMap.put("TJ", "ताजिकिस्तान");
    namesMap.put("TK", "तोकेलाउ");
    namesMap.put("TL", "पूर्व तिमोर");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "ट्यूनिशिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "तुर्की");
    namesMap.put("TT", "त्रिनिदाद आणि टोबॅगो");
    namesMap.put("TV", "टुवालु");
    namesMap.put("TW", "तैवान");
    namesMap.put("TZ", "टांझानिया");
    namesMap.put("UA", "युक्रेन");
    namesMap.put("UG", "युगांडा");
    namesMap.put("UM", "यू.एस. आउटलाइंग बेटे");
    namesMap.put("US", "युनायटेड स्टेट्स");
    namesMap.put("UY", "उरुग्वे");
    namesMap.put("UZ", "उझबेकिस्तान");
    namesMap.put("VA", "व्हॅटिकन सिटी");
    namesMap.put("VC", "सेंट व्हिन्सेंट आणि ग्रेनडाइन्स");
    namesMap.put("VE", "व्हेनेझुएला");
    namesMap.put("VG", "ब्रिटिश व्हर्जिन बेटे");
    namesMap.put("VI", "यू.एस. व्हर्जिन बेटे");
    namesMap.put("VN", "व्हिएतनाम");
    namesMap.put("VU", "वानौटु");
    namesMap.put("WF", "वालिस आणि फ्यूचूना");
    namesMap.put("WS", "सामोआ");
    namesMap.put("XK", "कोसोव्हो");
    namesMap.put("YE", "येमेन");
    namesMap.put("YT", "मायोट्टे");
    namesMap.put("ZA", "दक्षिण आफ्रिका");
    namesMap.put("ZM", "झाम्बिया");
    namesMap.put("ZW", "झिम्बाब्वे");
    namesMap.put("ZZ", "अज्ञात प्रदेश");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "विश्व",
        "002": "आफ्रिका",
        "003": "उत्तर अमेरिका",
        "005": "दक्षिण अमेरिका",
        "009": "ओशनिया",
        "011": "पश्चिम आफ्रिका",
        "013": "मध्य अमेरिका",
        "014": "पूर्व आफ्रिका",
        "015": "उत्तर आफ्रिका",
        "017": "मध्य आफ्रिका",
        "018": "दक्षिणी आफ्रिका",
        "019": "अमेरिका",
        "021": "उत्तरी अमेरिका",
        "029": "कॅरीबियन",
        "030": "पूर्व अशिया",
        "034": "दक्षिण अशिया",
        "035": "दक्षिण पूर्व अशिया",
        "039": "दक्षिण युरोप",
        "053": "ऑस्‍ट्रेलेशिया",
        "054": "मेलानेशिया",
        "057": "मायक्रोनेशियन प्रदेश",
        "061": "पॉलिनेशिया",
        "142": "अशिया",
        "143": "मध्य अशिया",
        "145": "पश्चिम अशिया",
        "150": "युरोप",
        "151": "पूर्व युरोप",
        "154": "उत्तर युरोप",
        "155": "पश्चिम युरोप",
        "419": "लॅटिन अमेरिका",
        "AC": "अ‍ॅसेन्शियन बेट",
        "AD": "अँडोरा",
        "AE": "संयुक्त अरब अमीरात",
        "AF": "अफगाणिस्तान",
        "AG": "अँटिग्वा आणि बर्बुडा",
        "AI": "अँग्विला",
        "AL": "अल्बानिया",
        "AM": "अर्मेनिया",
        "AN": "नेदरलँड्‍स अँ‍टिल्स",
        "AO": "अंगोला",
        "AQ": "अंटार्क्टिका",
        "AR": "अर्जेंटिना",
        "AS": "अमेरिकन सामोआ",
        "AT": "ऑस्ट्रिया",
        "AU": "ऑस्ट्रेलिया",
        "AW": "अरुबा",
        "AX": "अ‍ॅलँड बेटे",
        "AZ": "अझरबैजान",
        "BA": "बोस्निया अणि हर्जेगोविना",
        "BB": "बार्बाडोस",
        "BD": "बांग्लादेश",
        "BE": "बेल्जियम",
        "BF": "बुर्किना फासो",
        "BG": "बल्गेरिया",
        "BH": "बहारीन",
        "BI": "बुरुंडी",
        "BJ": "बेनिन",
        "BL": "सेंट बार्थेलेमी",
        "BM": "बर्मुडा",
        "BN": "ब्रुनेई",
        "BO": "बोलिव्हिया",
        "BQ": "कॅरिबियन नेदरलँड्स",
        "BR": "ब्राझिल",
        "BS": "बहामाज",
        "BT": "भूतान",
        "BV": "बोउवेट बेट",
        "BW": "बोट्सवाना",
        "BY": "बेलारूस",
        "BZ": "बेलिझे",
        "CA": "कॅनडा",
        "CC": "कोकोस बेटे",
        "CD": "काँगो - किंशासा",
        "CF": "केंद्रीय अफ्रिकी प्रजासत्ताक",
        "CG": "काँगो - ब्राझाविले",
        "CH": "स्वित्झर्लंड",
        "CI": "आयव्हरी कोस्ट",
        "CK": "कुक बेटे",
        "CL": "चिली",
        "CM": "कॅमेरून",
        "CN": "चीन",
        "CO": "कोलम्बिया",
        "CP": "क्लिपरटोन बेट",
        "CR": "कोस्टारिका",
        "CU": "क्यूबा",
        "CV": "केप व्हर्डे",
        "CW": "कुरॅको",
        "CX": "ख्रिसमस बेट",
        "CY": "सायप्रस",
        "CZ": "झेक प्रजासत्ताक",
        "DE": "जर्मनी",
        "DG": "दिएगो गार्सिया",
        "DJ": "जिबौटी",
        "DK": "डेन्मार्क",
        "DM": "डोमिनिका",
        "DO": "डोमिनिकन प्रजासत्ताक",
        "DZ": "अल्जीरिया",
        "EA": "स्यूटा आणि मेलिला",
        "EC": "इक्वाडोर",
        "EE": "एस्टोनिया",
        "EG": "इजिप्त",
        "EH": "पश्चिम सहारा",
        "ER": "एरिट्रिया",
        "ES": "स्पेन",
        "ET": "इथिओपिया",
        "EU": "युरोपीय संघ",
        "FI": "फिनलंड",
        "FJ": "फिजी",
        "FK": "फॉकलंड बेटे",
        "FM": "मायक्रोनेशिया",
        "FO": "फरोए बेटे",
        "FR": "फ्रान्स",
        "GA": "गॅबॉन",
        "GB": "युनायटेड किंगडम",
        "GD": "ग्रेनेडा",
        "GE": "जॉर्जिया",
        "GF": "फ्रेंच गयाना",
        "GG": "ग्वेर्नसे",
        "GH": "घाना",
        "GI": "जिब्राल्टर",
        "GL": "ग्रीनलंड",
        "GM": "गाम्बिया",
        "GN": "गिनी",
        "GP": "ग्वाडेलोउपे",
        "GQ": "इक्वेटोरियल गिनी",
        "GR": "ग्रीस",
        "GS": "दक्षिण जॉर्जिया आणि दक्षिण सँडविच बेटे",
        "GT": "ग्वाटेमाला",
        "GU": "गुआम",
        "GW": "गिनी-बिसाउ",
        "GY": "गयाना",
        "HK": "हाँगकाँग एसएआर चीन",
        "HM": "हर्ड आणि मॅक्डोनाल्ड बेटे",
        "HN": "होंडुरास",
        "HR": "क्रोएशिया",
        "HT": "हैती",
        "HU": "हंगेरी",
        "IC": "कॅनरी बेटे",
        "ID": "इंडोनेशिया",
        "IE": "आयर्लंड",
        "IL": "इस्त्राइल",
        "IM": "इस्ले ऑफ मॅन",
        "IN": "भारत",
        "IO": "ब्रिटिश इंडियन ओशन प्रदेश",
        "IQ": "इराक",
        "IR": "ईराण",
        "IS": "आइसलँड",
        "IT": "इटली",
        "JE": "जर्सी",
        "JM": "जमैका",
        "JO": "जॉर्डन",
        "JP": "जपान",
        "KE": "केनिया",
        "KG": "किरगिझस्तान",
        "KH": "कंबोडिया",
        "KI": "किरीबाटी",
        "KM": "कोमोरोज",
        "KN": "सेंट किट्स आणि नेव्हिस",
        "KP": "उत्तर कोरिया",
        "KR": "दक्षिण कोरिया",
        "KW": "कुवेत",
        "KY": "केमन बेटे",
        "KZ": "कझाकस्तान",
        "LA": "लाओस",
        "LB": "लेबनॉन",
        "LC": "सेंट ल्यूसिया",
        "LI": "लिंचेनस्टाइन",
        "LK": "श्रीलंका",
        "LR": "लायबेरिया",
        "LS": "लेसोथो",
        "LT": "लिथुआनिया",
        "LU": "लक्झेंबर्ग",
        "LV": "लाट्‌विया",
        "LY": "लिबिया",
        "MA": "मोरोक्को",
        "MC": "मोनॅको",
        "MD": "मोल्डोव्हा",
        "ME": "मोंटेनेग्रो",
        "MF": "सेंट मार्टिन",
        "MG": "मादागास्कर",
        "MH": "मार्शल बेटे",
        "MK": "मॅसेडोनिया",
        "ML": "माली",
        "MM": "म्यानमार (बर्मा)",
        "MN": "मंगोलिया",
        "MO": "मकाओ एसएआर चीन",
        "MP": "उत्तरी मारियाना बेटे",
        "MQ": "मार्टिनिक",
        "MR": "मॉरिटानिया",
        "MS": "मॉन्ट्सेराट",
        "MT": "माल्टा",
        "MU": "मॉरिशस",
        "MV": "मालदीव",
        "MW": "मलावी",
        "MX": "मेक्सिको",
        "MY": "मलेशिया",
        "MZ": "मोझाम्बिक",
        "NA": "नामिबिया",
        "NC": "न्यू कॅलेडोनिया",
        "NE": "नाइजर",
        "NF": "नॉरफॉक बेट",
        "NG": "नायजेरिया",
        "NI": "निकाराग्वे",
        "NL": "नेदरलँड",
        "NO": "नॉर्वे",
        "NP": "नेपाळ",
        "NR": "नऊरु",
        "NU": "नीयू",
        "NZ": "न्यूझीलंड",
        "OM": "ओमान",
        "PA": "पनामा",
        "PE": "पेरू",
        "PF": "फ्रेंच पॉलिनेशिया",
        "PG": "पापुआ न्यू गिनी",
        "PH": "फिलिपिन्स",
        "PK": "पाकिस्तान",
        "PL": "पोलंड",
        "PM": "सेंट पियरे आणि मिक्वेलोन",
        "PN": "पिटकैर्न बेटे",
        "PR": "पोर्टो रिको",
        "PS": "पॅलेस्टिनियन प्रदेश",
        "PT": "पोर्तुगाल",
        "PW": "पलाऊ",
        "PY": "पराग्वे",
        "QA": "कतार",
        "QO": "आउटलाईंग ओशनिया",
        "RE": "रियुनियन",
        "RO": "रोमानिया",
        "RS": "सर्बिया",
        "RU": "रशिया",
        "RW": "रवांडा",
        "SA": "सौदी अरब",
        "SB": "सोलोमन बेटे",
        "SC": "सेशेल्स",
        "SD": "सुदान",
        "SE": "स्वीडन",
        "SG": "सिंगापूर",
        "SH": "सेंट हेलेना",
        "SI": "स्लोव्हेनिया",
        "SJ": "स्वालबर्ड आणि जान मायेन",
        "SK": "स्लोव्हाकिया",
        "SL": "सिएरा लिओन",
        "SM": "सॅन मरीनो",
        "SN": "सेनेगल",
        "SO": "सोमालिया",
        "SR": "सुरिनाम",
        "SS": "दक्षिण सुदान",
        "ST": "साओ टोम आणि प्रिंसिपे",
        "SV": "अल साल्वाडोर",
        "SX": "सिंट मार्टेन",
        "SY": "सीरिया",
        "SZ": "स्वाझिलँड",
        "TA": "ट्रिस्टन दा कन्हा",
        "TC": "टर्क्स आणि कैकोस बेटे",
        "TD": "चाड",
        "TF": "फ्रेंच दाक्षिणात्य प्रदेश",
        "TG": "टोगो",
        "TH": "थायलंड",
        "TJ": "ताजिकिस्तान",
        "TK": "तोकेलाउ",
        "TL": "पूर्व तिमोर",
        "TM": "तुर्कमेनिस्तान",
        "TN": "ट्यूनिशिया",
        "TO": "टोंगा",
        "TR": "तुर्की",
        "TT": "त्रिनिदाद आणि टोबॅगो",
        "TV": "टुवालु",
        "TW": "तैवान",
        "TZ": "टांझानिया",
        "UA": "युक्रेन",
        "UG": "युगांडा",
        "UM": "यू.एस. आउटलाइंग बेटे",
        "US": "युनायटेड स्टेट्स",
        "UY": "उरुग्वे",
        "UZ": "उझबेकिस्तान",
        "VA": "व्हॅटिकन सिटी",
        "VC": "सेंट व्हिन्सेंट आणि ग्रेनडाइन्स",
        "VE": "व्हेनेझुएला",
        "VG": "ब्रिटिश व्हर्जिन बेटे",
        "VI": "यू.एस. व्हर्जिन बेटे",
        "VN": "व्हिएतनाम",
        "VU": "वानौटु",
        "WF": "वालिस आणि फ्यूचूना",
        "WS": "सामोआ",
        "XK": "कोसोव्हो",
        "YE": "येमेन",
        "YT": "मायोट्टे",
        "ZA": "दक्षिण आफ्रिका",
        "ZM": "झाम्बिया",
        "ZW": "झिम्बाब्वे",
        "ZZ": "अज्ञात प्रदेश"
    };
  }-*/;
}
