/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts.compound;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.campagnelab.goby.counts.compound.CompoundDirectoryEntry;
import org.campagnelab.goby.counts.compound.CompoundFileReader;

public class CompoundFileTool {
    private String compoundFilename;
    private String[] filenames;

    public static void main(String[] args) throws Exception {
        CompoundFileTool tool = new CompoundFileTool();
        tool.run(args);
    }

    private JSAP configureJsap() throws JSAPException {
        JSAP jsap = new JSAP();
        UnflaggedOption compoundFileFlag = new UnflaggedOption("compound-file").setRequired(true).setStringParser((StringParser)JSAP.STRING_PARSER).setGreedy(false);
        compoundFileFlag.setHelp("The compound file to read/write");
        jsap.registerParameter((Parameter)compoundFileFlag);
        Switch listSwitch = new Switch("list").setShortFlag('l').setLongFlag("list");
        listSwitch.setHelp("List the contents of the compound file");
        jsap.registerParameter((Parameter)listSwitch);
        Switch addSwitch = new Switch("add").setShortFlag('a').setLongFlag("add");
        addSwitch.setHelp("Add files to the compound file");
        jsap.registerParameter((Parameter)addSwitch);
        Switch extractSwitch = new Switch("extract").setShortFlag('x').setLongFlag("extract");
        extractSwitch.setHelp("Extract files from the compound file");
        jsap.registerParameter((Parameter)extractSwitch);
        Switch helpSwitch = new Switch("help").setShortFlag('h').setLongFlag("help");
        helpSwitch.setHelp("This help information");
        jsap.registerParameter((Parameter)helpSwitch);
        UnflaggedOption filenamesUnflag = new UnflaggedOption("filenames").setStringParser((StringParser)JSAP.STRING_PARSER).setGreedy(true);
        filenamesUnflag.setHelp("Filenames (separated by spaces) or pattern(s) to add to the compound file");
        jsap.registerParameter((Parameter)filenamesUnflag);
        return jsap;
    }

    private void run(String[] args) throws JSAPException, IOException {
        JSAP jsap = this.configureJsap();
        JSAPResult config = jsap.parse(args);
        if (!config.success()) {
            this.helpMode(jsap, config);
            System.exit(1);
        }
        this.compoundFilename = config.getString("compound-file");
        this.filenames = config.getStringArray("filenames");
        System.out.println("Compound file: " + this.compoundFilename);
        System.out.print("Filenames: (");
        int i = 0;
        for (String filename : this.filenames) {
            if (i++ > 0) {
                System.out.print(",");
            }
            System.out.print(filename);
        }
        System.out.println(")");
        PROGRAM_MODE mode = this.programMode(config);
        if (mode == PROGRAM_MODE.HELP) {
            this.helpMode(jsap, config);
            System.exit(1);
        } else if (mode == PROGRAM_MODE.LIST) {
            this.listMode();
        } else if (mode == PROGRAM_MODE.ADD) {
            this.addMode();
        } else if (mode == PROGRAM_MODE.EXTRACT) {
            this.extractMode();
        }
    }

    private PROGRAM_MODE programMode(JSAPResult config) {
        if (config.getBoolean("help")) {
            return PROGRAM_MODE.HELP;
        }
        if (config.getBoolean("list")) {
            return PROGRAM_MODE.LIST;
        }
        if (config.getBoolean("add")) {
            return PROGRAM_MODE.ADD;
        }
        if (config.getBoolean("extract")) {
            return PROGRAM_MODE.EXTRACT;
        }
        return PROGRAM_MODE.LIST;
    }

    private void helpMode(JSAP jsap, JSAPResult config) {
        System.err.println();
        if (config != null) {
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
        }
        System.err.println();
        System.err.println("Usage:  java " + this.getClass().getName());
        System.err.println("                " + jsap.getUsage());
        System.err.println();
        System.err.println(jsap.getHelp());
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listMode() throws IOException {
        try (CompoundFileReader compoundFileReader = null;){
            compoundFileReader = this.getExistingReader();
            if (compoundFileReader == null) {
                return;
            }
            Collection<CompoundDirectoryEntry> files = compoundFileReader.getDirectory();
            System.out.println("Directory of compound file");
            for (CompoundDirectoryEntry file : files) {
                System.out.println(file.getName() + "\t\t" + file.getFileSize());
            }
        }
    }

    private void addMode() {
        System.out.println("Add mode currently unsupported.");
    }

    private void extractMode() {
        System.out.println("Extract mode currently unsupported.");
    }

    private CompoundFileReader getExistingReader() throws IOException {
        if (new File(this.compoundFilename).exists()) {
            return new CompoundFileReader(this.compoundFilename);
        }
        System.out.println("Specified compound file '" + this.compoundFilename + "' does not exist.");
        return null;
    }

    public static enum PROGRAM_MODE {
        LIST,
        ADD,
        EXTRACT,
        HELP;

    }
}

