/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

final class EqualityExpr
extends Expr {
    final Expr lhs;
    final Expr rhs;
    final boolean invert;

    public final Object evaluate(Node node2, int n, int n2) {
        boolean bl = this.evaluateImpl(node2, n, n2);
        if (this.invert) {
            return bl ? Boolean.FALSE : Boolean.TRUE;
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private final boolean evaluateImpl(Node node2, int n, int n2) {
        Object object = this.lhs.evaluate(node2, n, n2);
        Object object2 = this.rhs.evaluate(node2, n, n2);
        boolean bl = object instanceof Collection;
        boolean bl2 = object2 instanceof Collection;
        if (bl && bl2) {
            Collection collection = (Collection)object;
            Collection collection2 = (Collection)object2;
            if (collection.isEmpty()) {
                return false;
            }
            boolean bl3 = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Node node3 = (Node)iterator.next();
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    Node node4 = (Node)iterator2.next();
                    if (node3 == node4 || node3.equals(node4)) {
                        if (this.invert) continue;
                        return true;
                    }
                    if (EqualityExpr.stringValue(node3).equals(EqualityExpr.stringValue(node4))) {
                        if (this.invert) continue;
                        return true;
                    }
                    bl3 = false;
                }
            }
            return bl3;
        }
        boolean bl4 = object instanceof Double;
        boolean bl5 = object2 instanceof Double;
        if (bl && bl5 || bl2 && bl4) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            double d = bl4 ? ((Double)object).doubleValue() : ((Double)object2).doubleValue();
            boolean bl6 = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Node node5 = (Node)iterator.next();
                double d2 = EqualityExpr._number(node2, EqualityExpr.stringValue(node5));
                if (d2 == d) {
                    if (this.invert) continue;
                    return true;
                }
                bl6 = false;
            }
            boolean bl7 = false;
            if (this.invert) {
                bl7 = bl6;
            }
            return bl7;
        }
        boolean bl8 = object instanceof String;
        boolean bl9 = object2 instanceof String;
        if (bl && bl9 || bl2 && bl8) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            String string = bl8 ? (String)object : (String)object2;
            boolean bl10 = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Node node6 = (Node)iterator.next();
                if (EqualityExpr.stringValue(node6).equals(string)) {
                    if (this.invert) continue;
                    return true;
                }
                bl10 = false;
            }
            boolean bl11 = false;
            if (this.invert) {
                bl11 = bl10;
            }
            return bl11;
        }
        boolean bl12 = object instanceof Boolean;
        boolean bl13 = object2 instanceof Boolean;
        if (bl && bl13 || bl2 && bl12) {
            Collection collection = bl ? (Collection)object : (Collection)object2;
            boolean bl14 = bl12 ? ((Boolean)object).booleanValue() : ((Boolean)object2).booleanValue();
            return EqualityExpr._boolean(node2, collection) ^ bl14 ^ true;
        }
        if (bl12 || bl13) {
            boolean bl15 = bl12 ? (Boolean)object : EqualityExpr._boolean(node2, object);
            boolean bl16 = bl13 ? (Boolean)object2 : EqualityExpr._boolean(node2, object2);
            return bl15 ^ bl16 ^ true;
        }
        if (bl4 || bl5) {
            double d = bl4 ? (Double)object : EqualityExpr._number(node2, object);
            double d3 = bl5 ? (Double)object2 : EqualityExpr._number(node2, object2);
            boolean bl17 = false;
            if (d == d3) {
                bl17 = true;
            }
            return bl17;
        }
        String string = bl8 ? (String)object : EqualityExpr._string(node2, object);
        String string2 = bl9 ? (String)object2 : EqualityExpr._string(node2, object2);
        return string.equals(string2);
    }

    public final Expr clone(Object object) {
        return new EqualityExpr(this.lhs.clone(object), this.rhs.clone(object), this.invert);
    }

    public final boolean references(QName qName) {
        boolean bl = false;
        if (this.lhs.references(qName) || this.rhs.references(qName)) {
            bl = true;
        }
        return bl;
    }

    public final String toString() {
        if (this.invert) {
            return this.lhs + " != " + this.rhs;
        }
        return this.lhs + " = " + this.rhs;
    }

    EqualityExpr(Expr expr, Expr expr2, boolean bl) {
        this.lhs = expr;
        this.rhs = expr2;
        this.invert = bl;
    }
}

