/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.DTFrame;
import com.ibm.media.bean.multiplayer.JMFUtil;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DTMsgBox
extends DTFrame
implements ActionListener {
    private TextArea msgArea = new TextArea(8, 280);
    private String nullMsg = " ";
    private boolean isCleared = true;

    public DTMsgBox() {
        super(JMFUtil.getBIString("JMF_MultiPlayer"));
        this.initGUI();
    }

    public DTMsgBox(String title) {
        super(title);
        this.initGUI();
    }

    public DTMsgBox(String title, String msg) {
        super(title);
        if (msg != null) {
            this.msgArea.setText(msg);
        }
        this.initGUI();
    }

    private void initGUI() {
        Button o = new Button(JMFUtil.getBIString("OK"));
        Button c = new Button(JMFUtil.getBIString("CLEAR"));
        o.setActionCommand(JMFUtil.getBIString("OK"));
        o.addActionListener(this);
        c.setActionCommand(JMFUtil.getBIString("CLEAR"));
        c.addActionListener(this);
        Panel p = new Panel();
        p.setLayout(new GridLayout(1, 2, 2, 0));
        p.add(o);
        p.add(c);
        this.msgArea.setEditable(false);
        this.msgArea.setBackground(Color.white);
        this.setLayout(new BorderLayout(10, 5));
        this.add("Center", this.msgArea);
        this.add("South", p);
        ((Component)this).setLocation(500, 10);
        ((Component)this).setSize(465, 240);
    }

    public void go() {
        ((Component)this).setVisible(true);
    }

    public void go(String msg) {
        if (msg == null || msg.length() == 0) {
            msg = this.nullMsg;
        }
        if (this.isCleared) {
            this.msgArea.append(" \n" + msg);
        } else {
            this.msgArea.append("\n \n" + msg);
        }
        this.isCleared = false;
        ((Component)this).setVisible(true);
    }

    public void go(String msg, boolean wait) {
        if (wait) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        if (msg == null || msg.length() == 0) {
            msg = this.nullMsg;
        }
        if (this.isCleared) {
            this.msgArea.append(" \n" + msg);
        } else {
            this.msgArea.append("\n \n" + msg);
        }
        this.isCleared = false;
        ((Component)this).setVisible(true);
    }

    public void go(String title, String msg) {
        this.setTitle(title);
        if (msg == null || msg.length() == 0) {
            msg = this.nullMsg;
        }
        if (this.isCleared) {
            this.msgArea.append(" \n" + msg);
        } else {
            this.msgArea.append("\n \n" + msg);
        }
        this.isCleared = false;
        ((Component)this).setVisible(true);
    }

    public static void createAndGo(String msg) {
        DTMsgBox msgBox = new DTMsgBox();
        msgBox.go(msg);
    }

    public static void createAndGo(String title, String msg) {
        DTMsgBox msgBox = new DTMsgBox(title, msg);
        ((Component)msgBox).setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        String s = evt.getActionCommand();
        if (s.equals(JMFUtil.getBIString("CLEAR"))) {
            this.msgArea.setText("");
            this.isCleared = true;
        } else if (s.equals(JMFUtil.getBIString("OK"))) {
            ((Component)this).setVisible(false);
        }
    }
}

