/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.util.ArrayList;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.Preferences;
import net.sf.gogui.version.Version;

public final class GoGuiSettings {
    public boolean m_auto;
    public boolean m_computerBlack;
    public boolean m_computerWhite;
    public boolean m_fastPaint;
    public boolean m_noStartup;
    public boolean m_verbose;
    public int m_move;
    public Preferences m_preferences;
    public String m_file;
    public String m_gtpCommand;
    public String m_gtpFile;
    public String m_initAnalyze;
    public String m_lookAndFeel;
    public String m_program;
    public String m_rules;
    public String m_time;

    public GoGuiSettings(String[] stringArray) throws ErrorMessage {
        String[] stringArray2 = new String[]{"analyze:", "auto", "command:", "computer-black", "computer-both", "computer-none", "config:", "gtpfile:", "fast", "help", "komi:", "laf:", "move:", "program:", "rules:", "size:", "time:", "verbose", "version"};
        Options options = Options.parse(stringArray, stringArray2);
        if (options.isSet("help")) {
            this.printHelp();
            this.m_noStartup = true;
            return;
        }
        if (options.isSet("version")) {
            this.m_noStartup = true;
            System.out.println("GoGui " + Version.get());
            return;
        }
        this.m_preferences = new Preferences();
        GoGuiSettings.setDefaults(this.m_preferences);
        this.m_initAnalyze = options.getString("analyze");
        this.m_fastPaint = options.isSet("fast");
        this.m_auto = options.isSet("auto");
        this.m_computerBlack = false;
        this.m_computerWhite = true;
        if (options.isSet("computer-none")) {
            this.m_computerWhite = false;
        } else if (options.isSet("computer-black")) {
            this.m_computerBlack = true;
            this.m_computerWhite = false;
        } else if (options.isSet("computer-both")) {
            this.m_computerBlack = true;
        }
        this.m_program = options.getString("program", null);
        this.m_gtpFile = options.getString("gtpfile", "");
        this.m_gtpCommand = options.getString("command", "");
        if (options.contains("komi")) {
            this.m_preferences.setDouble("komi", options.getDouble("komi"));
        }
        this.m_lookAndFeel = options.getString("laf", null);
        this.m_move = options.getInteger("move", -1);
        if (options.contains("size")) {
            this.m_preferences.setInt("boardsize", options.getInteger("size"));
        }
        this.m_rules = options.getString("rules", "");
        this.m_preferences.setString("rules", this.m_rules);
        this.m_time = options.getString("time", null);
        this.m_verbose = options.isSet("verbose");
        ArrayList arrayList = options.getArguments();
        this.m_file = null;
        if (arrayList.size() == 1) {
            this.m_file = (String)arrayList.get(0);
        } else if (arrayList.size() > 1) {
            throw new ErrorMessage("Only one argument allowed");
        }
        this.validate();
    }

    private void printHelp() {
        String string = "Usage: java -jar gogui.jar [options] [file]\nGraphical user interface for Go programs\nusing the Go Text Protocol.\n\n-analyze name   Initialize analyze command\n-auto           Auto play games (if computer both)\n-command cmd    Send GTP command at startup\n-computer-both  Computer plays both sides\n-computer-black Computer plays black\n-computer-none  Computer plays no side\n-config         Config file\n-fast           Fast and simple graphics\n-gtpfile file   Send GTP file at startup\n-help           Display this help and exit\n-komi value     Set komi\n-laf name       Set Swing look and feel\n-move n         Load SGF file until move number\n-program cmd    Go program to attach\n-rules name     Use rules (chinese|japanese)\n-size n         Set board size\n-time spec      Set time limits (min[+min/moves])\n-verbose        Print debugging messages\n-version        Print version and exit\n";
        System.out.print(string);
    }

    private static void setDefaults(Preferences preferences) {
        preferences.setBoolDefault("analyze-only-supported-commands", true);
        preferences.setBoolDefault("analyze-sort", true);
        preferences.setBoolDefault("beep-after-move", true);
        preferences.setIntDefault("boardsize", 19);
        preferences.setBoolDefault("comment-font-fixed", false);
        preferences.setIntDefault("gametree-labels", 0);
        preferences.setIntDefault("gametree-size", 1);
        preferences.setBoolDefault("gametree-show-subtree-sizes", false);
        preferences.setBoolDefault("gtpshell-autonumber", false);
        preferences.setBoolDefault("gtpshell-disable-completions", Platform.isMac());
        preferences.setIntDefault("gtpshell-history-max", 3000);
        preferences.setIntDefault("gtpshell-history-min", 2000);
        preferences.setBoolDefault("gtpshell-timestamp", false);
        preferences.setDoubleDefault("komi", 6.5);
        preferences.setStringDefault("rules", "Chinese");
        preferences.setBoolDefault("show-analyze", false);
        preferences.setBoolDefault("show-gtpshell", false);
        preferences.setBoolDefault("show-gametree", false);
        preferences.setBoolDefault("show-cursor", false);
        preferences.setBoolDefault("show-grid", true);
        preferences.setBoolDefault("show-info-panel", true);
        preferences.setBoolDefault("show-last-move", false);
        preferences.setBoolDefault("show-toolbar", true);
        preferences.setBoolDefault("show-variations", false);
    }

    private void validate() throws ErrorMessage {
        int n = this.m_preferences.getInt("boardsize");
        if (n < 1 || n > 25) {
            throw new ErrorMessage("Invalid board size: " + n);
        }
    }
}

