/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.kaffe.util.Ptr;

public class ZipFile
implements ZipConstants {
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String name;
    private Ptr zip;
    private boolean closed;

    private final void checkIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Zip file already closed: " + this.getName());
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            ZipFile.closeZipFile0(this.zip);
            this.closed = true;
        }
    }

    public Enumeration entries() {
        this.checkIfClosed();
        Vector vector = ZipFile.getZipEntries0(this.zip);
        return vector.elements();
    }

    public ZipEntry getEntry(String string) {
        this.checkIfClosed();
        return ZipFile.getZipEntry0(this.zip, string);
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (zipEntry.getSize() == (long)-1) {
            zipEntry = this.getEntry(zipEntry.getName());
        }
        if (zipEntry == null) {
            return null;
        }
        byte[] byArray = ZipFile.getZipData0(this.zip, zipEntry);
        if (byArray == null) {
            throw new ZipException("no data");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        this.checkIfClosed();
        return ZipFile.getZipFileSize0(this.zip);
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static final native Ptr openZipFile0(String var0);

    private static final native void closeZipFile0(Ptr var0);

    private static final native ZipEntry getZipEntry0(Ptr var0, String var1);

    private static final native Vector getZipEntries0(Ptr var0);

    private static final native byte[] getZipData0(Ptr var0, ZipEntry var1);

    private static final native int getZipFileSize0(Ptr var0);

    public ZipFile(String string) throws IOException {
        this.name = string;
        this.zip = ZipFile.openZipFile0(string);
        if (this.zip == null) {
            throw new IOException("No such zip file " + string);
        }
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file.getPath());
    }

    public ZipFile(File file, int n) throws ZipException, IOException {
        this(file);
    }
}

