/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.assembly;

import gnu.javax.crypto.assembly.Cascade;
import gnu.javax.crypto.assembly.CascadeStage;
import gnu.javax.crypto.assembly.Direction;
import gnu.javax.crypto.assembly.ModeStage;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.Map;
import java.util.Set;

public abstract class Stage {
    public static final String DIRECTION = "gnu.crypto.assembly.stage.direction";
    protected Direction forward;
    protected Direction wired;

    public static final Stage getInstance(IMode iMode, Direction direction) {
        return new ModeStage(iMode, direction);
    }

    public static final Stage getInstance(Cascade cascade, Direction direction) {
        return new CascadeStage(cascade, direction);
    }

    public abstract Set blockSizes();

    public void init(Map map) throws InvalidKeyException {
        if (this.wired != null) {
            throw new IllegalStateException();
        }
        Direction direction = (Direction)map.get(DIRECTION);
        if (direction == null) {
            direction = Direction.FORWARD;
            map.put(DIRECTION, direction);
        }
        this.initDelegate(map);
        this.wired = direction;
    }

    public abstract int currentBlockSize() throws IllegalStateException;

    public void reset() {
        this.resetDelegate();
        this.wired = null;
    }

    public void update(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.wired == null) {
            throw new IllegalStateException();
        }
        this.updateDelegate(byArray, n, byArray2, n2);
    }

    public abstract boolean selfTest();

    abstract void initDelegate(Map var1) throws InvalidKeyException;

    abstract void resetDelegate();

    abstract void updateDelegate(byte[] var1, int var2, byte[] var3, int var4);

    protected Stage(Direction direction) {
        this.forward = direction;
        this.wired = null;
    }
}

