/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.lowlevel.alsa.AlsaSeqQueueStatus;
import org.tritonus.midi.device.alsa.AlsaMidiIn;
import org.tritonus.midi.device.alsa.AlsaMidiOut;
import org.tritonus.midi.device.alsa.AlsaReceiver;
import org.tritonus.share.GlobalInfo;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlsaMidiDevice
extends TMidiDevice
implements AlsaMidiIn.AlsaMidiInListener {
    private int m_nPhysicalClient;
    private int m_nPhysicalPort;
    private AlsaSeq m_alsaSeq;
    private AlsaSeqQueueStatus m_queueStatus;
    private int m_nOwnPort;
    private AlsaMidiIn m_alsaMidiIn;
    private AlsaMidiOut m_alsaMidiOut;
    private int m_nTimestampingQueue;
    private AlsaSeqEvent m_event;

    private final AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    private final int getOwnPort() {
        return this.m_nOwnPort;
    }

    private final int getPhysicalClient() {
        return this.m_nPhysicalClient;
    }

    private final int getPhysicalPort() {
        return this.m_nPhysicalPort;
    }

    private final AlsaSeqQueueStatus getQueueStatus() {
        return this.m_queueStatus;
    }

    protected void openImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.openImpl(): begin");
        }
        this.m_alsaSeq = new AlsaSeq("Tritonus Midi port handler");
        this.m_nOwnPort = this.getAlsaSeq().createPort("handler port", 99, 0, 0x100000, 0, 0, 0);
        if (this.getUseIn()) {
            this.m_nTimestampingQueue = this.getAlsaSeq().allocQueue();
            this.m_queueStatus = new AlsaSeqQueueStatus();
            this.startQueue();
            this.m_alsaMidiIn = new AlsaMidiIn(this.getAlsaSeq(), this.getOwnPort(), this.getPhysicalClient(), this.getPhysicalPort(), this.getTimestampingQueue(), true, this);
            this.m_alsaMidiIn.start();
        }
        if (this.getUseOut()) {
            this.m_alsaMidiOut = new AlsaMidiOut(this.getAlsaSeq(), this.getOwnPort());
            AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
            alsaSeqPortSubscribe.setSender(this.getAlsaSeq().getClientId(), this.getOwnPort());
            alsaSeqPortSubscribe.setDest(this.getPhysicalClient(), this.getPhysicalPort());
            this.getAlsaSeq().subscribePort(alsaSeqPortSubscribe);
            alsaSeqPortSubscribe.free();
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.openImpl(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.closeImpl(): begin");
        }
        if (this.getUseIn()) {
            this.m_alsaMidiIn.interrupt();
            this.m_alsaMidiIn = null;
            this.stopQueue();
            this.m_queueStatus.free();
            this.m_queueStatus = null;
        }
        this.getAlsaSeq().close();
        this.m_alsaSeq = null;
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.closeImpl(): end");
        }
    }

    public long getMicroSecondPosition() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.getMicroSecondPosition(): begin");
        }
        long l = 0L;
        if (this.m_queueStatus != null) {
            this.getAlsaSeq().getQueueStatus(this.getTimestampingQueue(), this.getQueueStatus());
            long l2 = this.getQueueStatus().getRealTime();
            l = l2 / 1000L;
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.getMicroSecondPosition(): end");
        }
        return l;
    }

    private final void startQueue() {
        this.controlQueue(30);
    }

    private final void stopQueue() {
        this.controlQueue(32);
    }

    private final void controlQueue(int n) {
        this.m_event.setCommon(n, 3, 0, 253, 0L, 0, this.getOwnPort(), 0, 0);
        this.m_event.setQueueControl(this.getTimestampingQueue(), 0, 0L);
        this.getAlsaSeq().eventOutputDirect(this.m_event);
    }

    protected void receive(MidiMessage midiMessage, long l) {
        if (this.isOpen()) {
            this.m_alsaMidiOut.enqueueMessage(midiMessage, l);
        }
    }

    public void dequeueEvent(MidiMessage midiMessage, long l) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.dequeueEvent(): message: " + midiMessage);
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.dequeueEvent(): tick: " + l);
        }
        this.sendImpl(midiMessage, l);
    }

    private final int getTimestampingQueue() {
        return this.m_nTimestampingQueue;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        if (!this.getUseOut()) {
            throw new MidiUnavailableException("Receivers are not supported by this device");
        }
        return new AlsaMidiDeviceReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        if (!this.getUseIn()) {
            throw new MidiUnavailableException("Transmitters are not supported by this device");
        }
        return new AlsaMidiDeviceTransmitter();
    }

    private final /* synthetic */ void this() {
        this.m_event = new AlsaSeqEvent();
    }

    public AlsaMidiDevice(int n, int n2, boolean bl, boolean bl2) {
        this(new TMidiDevice.Info("ALSA MIDI port (" + n + ':' + n2 + ')', GlobalInfo.getVendor(), "ALSA MIDI port (" + n + ':' + n2 + ')', GlobalInfo.getVersion()), n, n2, bl, bl2);
    }

    protected AlsaMidiDevice(MidiDevice.Info info, int n, int n2, boolean bl, boolean bl2) {
        super(info, bl, bl2);
        this.this();
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.<init>(): begin");
        }
        this.m_nPhysicalClient = n;
        this.m_nPhysicalPort = n2;
        if (TDebug.TraceMidiDevice) {
            TDebug.out("AlsaMidiDevice.<init>(): end");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlsaMidiDeviceReceiver
    extends TMidiDevice.TReceiver
    implements AlsaReceiver {
        public boolean subscribeTo(int n, int n2) {
            try {
                AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
                alsaSeqPortSubscribe.setSender(n, n2);
                alsaSeqPortSubscribe.setDest(AlsaMidiDevice.this.getPhysicalClient(), AlsaMidiDevice.this.getPhysicalPort());
                AlsaMidiDevice.this.getAlsaSeq().subscribePort(alsaSeqPortSubscribe);
                alsaSeqPortSubscribe.free();
                return true;
            }
            catch (RuntimeException runtimeException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(runtimeException);
                }
                return false;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class AlsaMidiDeviceTransmitter
    extends TMidiDevice.TTransmitter {
        private boolean m_bReceiverSubscribed = false;

        public void setReceiver(Receiver receiver) {
            super.setReceiver(receiver);
            if (receiver instanceof AlsaReceiver) {
                this.m_bReceiverSubscribed = ((AlsaReceiver)receiver).subscribeTo(AlsaMidiDevice.this.getPhysicalClient(), AlsaMidiDevice.this.getPhysicalPort());
            }
        }

        public void send(MidiMessage midiMessage, long l) {
            if (!this.m_bReceiverSubscribed) {
                super.send(midiMessage, l);
            }
        }

        public void close() {
            super.close();
        }
    }
}

