/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestDirectoryBrowsing
extends AbstractAppPlugin {
    private static final Pattern patternIIS = Pattern.compile("Parent Directory", 10);
    private static final Pattern patternApache = Pattern.compile("\\bDirectory Listing\\b.*(Tomcat|Apache)", 10);
    private static final Pattern patternGeneralDir1 = Pattern.compile("\\bDirectory\\b", 10);
    private static final Pattern patternGeneralDir2 = Pattern.compile("[\\s<]+IMG\\s*=", 10);
    private static final Pattern patternGeneralParent = Pattern.compile("Parent directory", 10);

    public int getId() {
        return 1;
    }

    public String getName() {
        return "Directory browsing";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "It is possible to view the directory listing.  Directory listing may reveal hidden scripts, include files , backup source files etc which be accessed to read sensitive information.";
    }

    public int getCategory() {
        return 2;
    }

    public String getSolution() {
        return "Disable directory browsing.  If this is required, make sure the listed files does not induce risks.";
    }

    public String getReference() {
        String string = "For IIS, turn off directory browsing.\r\nFor Apache, use the 'Options -Indexes' directive to disable indexes in directory or via .htaccess:\r\n. http://httpd.apache.org/docs/mod/core.html#options\r\n. http://alamo.satlug.org/pipermail/satlug/2002-February/000053.html\r\n. or create a default index.html for each directory.";
        return string;
    }

    public void init() {
    }

    private void checkIfDirectory(HttpMessage httpMessage) throws URIException {
        URI uRI = httpMessage.getRequestHeader().getURI();
        uRI.setQuery(null);
        String string = uRI.toString();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        httpMessage.getRequestHeader().setURI(new URI(string, true));
    }

    public void scan() {
        boolean bl = false;
        HttpMessage httpMessage = this.getNewMsg();
        int n = 1;
        try {
            this.checkIfDirectory(httpMessage);
            this.writeProgress(httpMessage.getRequestHeader().getURI().toString());
            this.sendAndReceive(httpMessage);
            if (httpMessage.getResponseHeader().getStatusCode() != 200) {
                return;
            }
            if (this.matchBodyPattern(httpMessage, patternIIS, null)) {
                bl = true;
            } else if (this.matchBodyPattern(httpMessage, patternApache, null)) {
                bl = true;
            } else if (this.matchBodyPattern(httpMessage, patternGeneralParent, null)) {
                bl = true;
                n = 0;
            } else if (this.matchBodyPattern(httpMessage, patternGeneralDir1, null) && this.matchBodyPattern(httpMessage, patternGeneralDir2, null)) {
                bl = true;
                n = 0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            this.bingo(2, n, httpMessage.getRequestHeader().getURI().toString(), "", "", httpMessage);
        }
    }
}

