/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpState;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.HostAuthentication;

public class ConnectionParam
extends AbstractParam {
    private static final String PROXY_CHAIN_NAME = "connection.proxyChain.hostName";
    private static final String PROXY_CHAIN_PORT = "connection.proxyChain.port";
    private static final String PROXY_CHAIN_SKIP_NAME = "connection.proxyChain.skipName";
    private static final String PROXY_CHAIN_REALM = "connection.proxyChain.realm";
    private static final String PROXY_CHAIN_USER_NAME = "connection.proxyChain.userName";
    private static final String PROXY_CHAIN_PASSWORD = "connection.proxyChain.password";
    private String proxyChainName = "";
    private int proxyChainPort = 8080;
    private String proxyChainSkipName = "";
    private String proxyChainRealm = "";
    private String proxyChainUserName = "";
    private String proxyChainPassword = "";
    private HttpState httpState = null;
    private boolean httpStateEnabled = false;
    private Vector listAuth = new Vector();
    private Pattern patternSkip = null;
    private static final String AUTH = "connection.auth";
    private static final String AUTH_HOST_NAME = "hostName";
    private static final String AUTH_PORT = "port";
    private static final String AUTH_USER_NAME = "userName";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_REALM = "realm";

    public boolean isHttpStateEnabled() {
        return this.httpStateEnabled;
    }

    public void setHttpStateEnabled(boolean bl) {
        this.httpStateEnabled = bl;
        this.httpState = this.httpStateEnabled ? new HttpState() : null;
    }

    protected void parse() {
        this.setProxyChainName(this.getConfig().getString(PROXY_CHAIN_NAME, ""));
        try {
            this.setProxyChainPort(this.getConfig().getInt(PROXY_CHAIN_PORT, 8080));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProxyChainSkipName(this.getConfig().getString(PROXY_CHAIN_SKIP_NAME, ""));
        this.setProxyChainRealm(this.getConfig().getString(PROXY_CHAIN_REALM, ""));
        this.setProxyChainUserName(this.getConfig().getString(PROXY_CHAIN_USER_NAME, ""));
        this.setProxyChainPassword(this.getConfig().getString(PROXY_CHAIN_PASSWORD, ""));
        this.parseAuthentication();
    }

    public String getProxyChainName() {
        return this.proxyChainName;
    }

    public void setProxyChainName(String string) {
        this.proxyChainName = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_NAME, this.proxyChainName);
    }

    public int getProxyChainPort() {
        return this.proxyChainPort;
    }

    public void setProxyChainPort(int n) {
        this.proxyChainPort = n;
        this.getConfig().setProperty(PROXY_CHAIN_PORT, Integer.toString(this.proxyChainPort));
    }

    public String getProxyChainSkipName() {
        return this.proxyChainSkipName;
    }

    public void setProxyChainSkipName(String string) {
        this.proxyChainSkipName = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_SKIP_NAME, this.proxyChainSkipName);
        this.parseProxyChainSkip(this.proxyChainSkipName);
    }

    public String getProxyChainRealm() {
        return this.proxyChainRealm;
    }

    public void setProxyChainRealm(String string) {
        this.proxyChainRealm = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_REALM, this.proxyChainRealm);
    }

    public String getProxyChainUserName() {
        return this.proxyChainUserName;
    }

    public void setProxyChainUserName(String string) {
        this.proxyChainUserName = string.trim();
        this.getConfig().setProperty(PROXY_CHAIN_USER_NAME, this.proxyChainUserName);
    }

    public String getProxyChainPassword() {
        return this.proxyChainPassword.trim();
    }

    public void setProxyChainPassword(String string) {
        this.proxyChainPassword = string;
        this.getConfig().setProperty(PROXY_CHAIN_PASSWORD, this.proxyChainPassword);
    }

    private boolean isUseProxyChain() {
        return !this.getProxyChainName().equals("");
    }

    private boolean isSkipProxyChain(String string) {
        if (this.patternSkip == null || string == null) {
            return false;
        }
        return this.patternSkip.matcher(string).find();
    }

    public boolean isUseProxy(String string) {
        return this.isUseProxyChain() && !this.isSkipProxyChain(string);
    }

    private void parseProxyChainSkip(String string) {
        this.patternSkip = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternSkip = Pattern.compile(string, 2);
    }

    public Vector getListAuth() {
        return this.listAuth;
    }

    public void setListAuth(Vector vector) {
        int n;
        this.listAuth = vector;
        HostAuthentication hostAuthentication = null;
        for (n = 0; n < (vector.size() > 100 ? vector.size() : 100); ++n) {
            this.getConfig().clearProperty(this.getAuth(n, AUTH_HOST_NAME));
            this.getConfig().clearProperty(this.getAuth(n, AUTH_PORT));
            this.getConfig().clearProperty(this.getAuth(n, AUTH_USER_NAME));
            this.getConfig().clearProperty(this.getAuth(n, AUTH_PASSWORD));
            this.getConfig().clearProperty(this.getAuth(n, AUTH_REALM));
            this.getConfig().clearProperty("connection.auth.A" + n);
        }
        for (n = 0; n < vector.size(); ++n) {
            hostAuthentication = (HostAuthentication)vector.get(n);
            this.getConfig().setProperty(this.getAuth(n, AUTH_HOST_NAME), hostAuthentication.getHostName());
            this.getConfig().setProperty(this.getAuth(n, AUTH_PORT), Integer.toString(hostAuthentication.getPort()));
            this.getConfig().setProperty(this.getAuth(n, AUTH_USER_NAME), hostAuthentication.getUserName());
            this.getConfig().setProperty(this.getAuth(n, AUTH_PASSWORD), hostAuthentication.getPassword());
            this.getConfig().setProperty(this.getAuth(n, AUTH_REALM), hostAuthentication.getRealm());
        }
    }

    private String getAuth(int n, String string) {
        return "connection.auth.A" + n + "." + string;
    }

    private void parseAuthentication() {
        this.listAuth.clear();
        String string = "";
        int n = 0;
        while (string != null && (string = this.getConfig().getString(this.getAuth(n, AUTH_HOST_NAME))) != null && !string.equals("")) {
            HostAuthentication hostAuthentication = new HostAuthentication(string, this.getConfig().getInt(this.getAuth(n, AUTH_PORT)), this.getConfig().getString(this.getAuth(n, AUTH_USER_NAME)), this.getConfig().getString(this.getAuth(n, AUTH_PASSWORD)), this.getConfig().getString(this.getAuth(n, AUTH_REALM)));
            this.listAuth.add(hostAuthentication);
            ++n;
        }
    }

    public HttpState getHttpState() {
        return this.httpState;
    }

    public void setHttpState(HttpState httpState) {
        this.httpState = httpState;
    }
}

