/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import java.util.Enumeration;
import java.util.Hashtable;

public class PropertyMapBuilder {
    private Hashtable map;
    private PropertyId[] keys;

    public PropertyMapBuilder() {
        this.map = new Hashtable();
    }

    public PropertyMapBuilder(PropertyMap pm) {
        if (pm instanceof PropertyMapImpl) {
            PropertyMapImpl pmi = (PropertyMapImpl)pm;
            this.map = pmi.map;
            this.keys = pmi.keys;
        } else {
            this.map = new Hashtable();
            int len = pm.size();
            for (int i = 0; i < len; ++i) {
                PropertyId pid = pm.getKey(i);
                this.put(pid, pm.get(pid));
            }
        }
    }

    private void lock() {
        if (this.keys != null) {
            return;
        }
        this.keys = new PropertyId[this.map.size()];
        int i = 0;
        Enumeration e = this.map.keys();
        while (e.hasMoreElements()) {
            this.keys[i++] = (PropertyId)e.nextElement();
        }
    }

    private void copyIfLocked() {
        if (this.keys == null) {
            return;
        }
        Hashtable newMap = new Hashtable();
        for (int i = 0; i < this.keys.length; ++i) {
            newMap.put(this.keys[i], this.map.get(this.keys[i]));
        }
        this.map = newMap;
        this.keys = null;
    }

    public PropertyMap toPropertyMap() {
        this.lock();
        return new PropertyMapImpl(this.map, this.keys);
    }

    public Object put(PropertyId id, Object value) {
        this.copyIfLocked();
        if (value == null) {
            return this.map.remove(id);
        }
        if (!id.getValueClass().isInstance(value)) {
            throw new ClassCastException();
        }
        return this.map.put(id, value);
    }

    public Object get(PropertyId pid) {
        return this.map.get(pid);
    }

    public boolean contains(PropertyId pid) {
        return this.map.get(pid) != null;
    }

    private static class PropertyMapImpl
    implements PropertyMap {
        private final Hashtable map;
        private final PropertyId[] keys;

        private PropertyMapImpl(Hashtable map, PropertyId[] keys) {
            this.map = map;
            this.keys = keys;
        }

        public Object get(PropertyId pid) {
            return this.map.get(pid);
        }

        public int size() {
            return this.keys.length;
        }

        public boolean contains(PropertyId pid) {
            return this.map.get(pid) != null;
        }

        public PropertyId getKey(int i) {
            return this.keys[i];
        }
    }
}

