/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PYTHON_EXPR_H__
#define __SG_PYTHON_EXPR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <glib.h>
#include <gtk/gtk.h>
#include "sg_python.h"

PyObject *python_eval_expr(gchar *command);

PyObject *sg_eval_func(gchar *func_def, gdouble x_value, gdouble *y_value);
PyObject * sg_eval_func_xy(gchar *func_def, gdouble x_value, gdouble y_value, 
           gdouble *z_value);
gdouble *sg_eval_expr_double(gchar *expr, gint *num, gint expect);
gchar **sg_eval_expr_string(gchar *expr, gint *num);
PyObject *sg_eval_expr_xy(gchar *func_def, gdouble x_value, gdouble y_value, gdouble *new_x, gdouble *new_y);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /*__SG_PYTHON_EXPR_H__ */
