/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class URIUtil
implements Cloneable {
    private static final Logger LOG = Log.getLogger(URIUtil.class);
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final Charset __CHARSET = StandardCharsets.UTF_8;

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    public static StringBuilder encodePath(StringBuilder buf, String path) {
        int i;
        byte[] bytes = null;
        if (buf == null) {
            block29: for (i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case ']': {
                        buf = new StringBuilder(path.length() * 2);
                        break block29;
                    }
                    default: {
                        if (c <= '\u007f') continue block29;
                        bytes = path.getBytes(__CHARSET);
                        buf = new StringBuilder(path.length() * 2);
                        break block29;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        if (bytes != null) {
            block30: for (i = 0; i < bytes.length; ++i) {
                void var4_5 = bytes[i];
                switch (var4_5) {
                    case 37: {
                        buf.append("%25");
                        continue block30;
                    }
                    case 63: {
                        buf.append("%3F");
                        continue block30;
                    }
                    case 59: {
                        buf.append("%3B");
                        continue block30;
                    }
                    case 35: {
                        buf.append("%23");
                        continue block30;
                    }
                    case 34: {
                        buf.append("%22");
                        continue block30;
                    }
                    case 39: {
                        buf.append("%27");
                        continue block30;
                    }
                    case 60: {
                        buf.append("%3C");
                        continue block30;
                    }
                    case 62: {
                        buf.append("%3E");
                        continue block30;
                    }
                    case 32: {
                        buf.append("%20");
                        continue block30;
                    }
                    case 91: {
                        buf.append("%5B");
                        continue block30;
                    }
                    case 93: {
                        buf.append("%5D");
                        continue block30;
                    }
                    default: {
                        if (var4_5 < 0) {
                            buf.append('%');
                            TypeUtil.toHex((byte)var4_5, (Appendable)buf);
                            continue block30;
                        }
                        buf.append((char)var4_5);
                        continue block30;
                    }
                }
            }
        } else {
            block31: for (i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        buf.append("%25");
                        continue block31;
                    }
                    case '?': {
                        buf.append("%3F");
                        continue block31;
                    }
                    case ';': {
                        buf.append("%3B");
                        continue block31;
                    }
                    case '#': {
                        buf.append("%23");
                        continue block31;
                    }
                    case '\"': {
                        buf.append("%22");
                        continue block31;
                    }
                    case '\'': {
                        buf.append("%27");
                        continue block31;
                    }
                    case '<': {
                        buf.append("%3C");
                        continue block31;
                    }
                    case '>': {
                        buf.append("%3E");
                        continue block31;
                    }
                    case ' ': {
                        buf.append("%20");
                        continue block31;
                    }
                    case '[': {
                        buf.append("%5B");
                        continue block31;
                    }
                    case ']': {
                        buf.append("%5D");
                        continue block31;
                    }
                    default: {
                        buf.append(c);
                        continue block31;
                    }
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        if (buf == null) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c != '%' && encode.indexOf(c) < 0) continue;
                buf = new StringBuilder(path.length() << 1);
                break;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c), 16);
                    continue;
                }
                buf.append(c);
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        return URIUtil.decodePath(path, 0, path.length());
    }

    public static String decodePath(String path, int offset, int length) {
        try {
            Utf8StringBuilder builder = null;
            int end = offset + length;
            block6: for (int i = offset; i < end; ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '%': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        if (i + 2 < end) {
                            char u = path.charAt(i + 1);
                            if (u == 'u') {
                                builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)));
                                i += 5;
                                continue block6;
                            }
                            builder.append((byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                            i += 2;
                            continue block6;
                        }
                        throw new IllegalArgumentException("Bad URI % encoding");
                    }
                    case ';': {
                        if (builder == null) {
                            builder = new Utf8StringBuilder(path.length());
                            builder.append(path, offset, i - offset);
                        }
                        while (++i < end) {
                            if (path.charAt(i) != '/') continue;
                            builder.append('/');
                            continue block6;
                        }
                        continue block6;
                    }
                    default: {
                        if (builder == null) continue block6;
                        builder.append(c);
                    }
                }
            }
            if (builder != null) {
                return builder.toString();
            }
            if (offset == 0 && length == path.length()) {
                return path;
            }
            return path.substring(offset, end);
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            LOG.warn(path.substring(offset, offset + length) + " " + e, new Object[0]);
            LOG.debug(e);
            return URIUtil.decodeISO88591Path(path, offset, length);
        }
    }

    private static String decodeISO88591Path(String path, int offset, int length) {
        StringBuilder builder = null;
        int end = offset + length;
        block4: for (int i = offset; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '%': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    if (i + 2 < end) {
                        char u = path.charAt(i + 1);
                        if (u == 'u') {
                            builder.append((char)(0xFFFF & TypeUtil.parseInt(path, i + 2, 4, 16)));
                            i += 5;
                            continue block4;
                        }
                        builder.append((byte)(0xFF & TypeUtil.convertHexDigit(u) * 16 + TypeUtil.convertHexDigit(path.charAt(i + 2))));
                        i += 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException();
                }
                case ';': {
                    if (builder == null) {
                        builder = new StringBuilder(path.length());
                        builder.append(path, offset, i - offset);
                    }
                    while (++i < end) {
                        if (path.charAt(i) != '/') continue;
                        builder.append('/');
                        continue block4;
                    }
                    continue block4;
                }
                default: {
                    if (builder == null) continue block4;
                    builder.append(c);
                }
            }
        }
        if (builder != null) {
            return builder.toString();
        }
        if (offset == 0 && length == path.length()) {
            return path;
        }
        return path.substring(offset, end);
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return p2 + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int start = path.lastIndexOf(47, end);
        block8: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block8;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delEnd >= delStart) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static String compactPath(String path) {
        int i;
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        block8: for (i = 0; i < end; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) continue block8;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
        }
        if (state < 2) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }

    public static String newURI(String scheme, String server, int port, String path, String query) {
        StringBuilder builder = URIUtil.newURIBuilder(scheme, server, port);
        builder.append(path);
        if (query != null && query.length() > 0) {
            builder.append('?').append(query);
        }
        return builder.toString();
    }

    public static StringBuilder newURIBuilder(String scheme, String server, int port) {
        StringBuilder builder = new StringBuilder();
        URIUtil.appendSchemeHostPort(builder, scheme, server, port);
        return builder;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
            url.append(scheme).append("://").append('[').append(server).append(']');
        } else {
            url.append(scheme).append("://").append(server);
        }
        if (port > 0) {
            switch (scheme) {
                case "http": {
                    if (port == 80) break;
                    url.append(':').append(port);
                    break;
                }
                case "https": {
                    if (port == 443) break;
                    url.append(':').append(port);
                    break;
                }
                default: {
                    url.append(':').append(port);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
                url.append(scheme).append("://").append('[').append(server).append(']');
            } else {
                url.append(scheme).append("://").append(server);
            }
            if (port > 0) {
                switch (scheme) {
                    case "http": {
                        if (port == 80) break;
                        url.append(':').append(port);
                        break;
                    }
                    case "https": {
                        if (port == 443) break;
                        url.append(':').append(port);
                        break;
                    }
                    default: {
                        url.append(':').append(port);
                    }
                }
            }
        }
    }

    public static boolean equalsIgnoreEncodings(String uriA, String uriB) {
        int lenA = uriA.length();
        int lenB = uriB.length();
        int a = 0;
        int b = 0;
        while (a < lenA && b < lenB) {
            int ob;
            int cb;
            int oa;
            int ca;
            if ((ca = (oa = uriA.charAt(a++))) == 37) {
                ca = TypeUtil.convertHexDigit(uriA.charAt(a++)) * 16 + TypeUtil.convertHexDigit(uriA.charAt(a++));
            }
            if ((cb = (ob = uriB.charAt(b++))) == 37) {
                cb = TypeUtil.convertHexDigit(uriB.charAt(b++)) * 16 + TypeUtil.convertHexDigit(uriB.charAt(b++));
            }
            if (ca == 47 && oa != ob) {
                return false;
            }
            if (ca == cb) continue;
            return URIUtil.decodePath(uriA).equals(URIUtil.decodePath(uriB));
        }
        return a == lenA && b == lenB;
    }
}

