/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.io;

import edu.cornell.med.icb.iterators.TextFileLineIterator;
import edu.cornell.med.icb.maps.LinkedHashToMultiTypeMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TsvToFromMap {
    private final List<String> columnHeaders = new LinkedList<String>();
    private int numColumnHeaders;
    private boolean headerWritten;
    private boolean lenientColumnCount;

    public TsvToFromMap() {
        this.numColumnHeaders = this.columnHeaders.size();
        this.headerWritten = false;
        this.lenientColumnCount = false;
    }

    public TsvToFromMap(String ... columnHeaderLabels) {
        if (columnHeaderLabels != null) {
            this.columnHeaders.addAll(Arrays.asList(columnHeaderLabels));
        }
        this.numColumnHeaders = this.columnHeaders.size();
        this.headerWritten = false;
    }

    public void addColumn(String newColumnHeader) {
        if (!this.columnHeaders.contains(newColumnHeader)) {
            this.columnHeaders.add(newColumnHeader);
            ++this.numColumnHeaders;
        }
    }

    public List<String> getColumnHeaders() {
        ArrayList<String> copy = new ArrayList<String>(this.columnHeaders.size());
        copy.addAll(this.columnHeaders);
        return copy;
    }

    public boolean isHeaderWritten() {
        return this.headerWritten;
    }

    public void setHeaderWritten(boolean headerWritten) {
        this.headerWritten = headerWritten;
    }

    public void writeHeader(PrintWriter out) {
        if (this.headerWritten) {
            return;
        }
        this.headerWritten = true;
        int pos = 0;
        for (String columnHeader : this.columnHeaders) {
            if (pos++ > 0) {
                out.print("\t");
            }
            out.print(columnHeader);
        }
        out.println();
    }

    public LinkedHashToMultiTypeMap<String> readDataToMap(String line) throws IOException {
        if (line.startsWith("#")) {
            return null;
        }
        String[] parts = StringUtils.splitPreserveAllTokens((String)line, (char)'\t');
        if (!this.lenientColumnCount && parts.length != this.numColumnHeaders) {
            throw new IOException(String.format("Line should have %d columns but has %d", this.numColumnHeaders, parts.length));
        }
        LinkedHashToMultiTypeMap<String> result = new LinkedHashToMultiTypeMap<String>();
        int i = 0;
        int numActualParts = parts.length;
        for (String columnHeader : this.columnHeaders) {
            if (this.lenientColumnCount && i >= numActualParts) {
                result.put(columnHeader, "");
            } else {
                result.put(columnHeader, parts[i]);
            }
            ++i;
        }
        return result;
    }

    public void writeDataFromMap(PrintWriter out, Map<String, String> data) {
        int pos = 0;
        for (String columnHeader : this.columnHeaders) {
            String dataItem;
            if (pos++ > 0) {
                out.print('\t');
            }
            if ((dataItem = data.get(columnHeader)) == null) continue;
            out.print(dataItem);
        }
        out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TsvToFromMap createFromTsvFile(File file) throws IOException {
        try (TextFileLineIterator in = null;){
            in = new TextFileLineIterator(file);
            for (String line : in) {
                if (line.startsWith("#")) continue;
                String[] parts = StringUtils.split((String)line, (char)'\t');
                TsvToFromMap tsvToFromMap = new TsvToFromMap(parts);
                return tsvToFromMap;
            }
        }
        return null;
    }

    public int getNumColumnHeaders() {
        return this.numColumnHeaders;
    }

    public boolean isLenientColumnCount() {
        return this.lenientColumnCount;
    }

    public void setLenientColumnCount(boolean lenientColumnCount) {
        this.lenientColumnCount = lenientColumnCount;
    }
}

