/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.util.Prime2;
import gnu.javax.net.ssl.provider.JessieRSAPrivateKey;
import gnu.javax.net.ssl.provider.JessieRSAPublicKey;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;

final class KeyPool {
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    private static final BigInteger E = BigInteger.valueOf(65537L);
    private static final SecureRandom RANDOM = new SecureRandom();

    static final KeyPair generateRSAKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n = 256;
        BigInteger bigInteger4 = TWO.pow(255);
        BigInteger bigInteger5 = TWO.pow(256).subtract(ONE);
        byte[] byArray = new byte[32];
        do {
            KeyPool.nextBytes(byArray);
        } while ((bigInteger3 = new BigInteger(1, byArray).setBit(0)).compareTo(bigInteger4) < 0 || bigInteger3.compareTo(bigInteger5) > 0 || !Prime2.isProbablePrime(bigInteger3) || !bigInteger3.gcd(E).equals(ONE));
        do {
            KeyPool.nextBytes(byArray);
        } while ((bigInteger2 = (bigInteger = new BigInteger(1, byArray).setBit(0)).multiply(bigInteger3)).bitLength() != 512 || !Prime2.isProbablePrime(bigInteger) || !bigInteger.gcd(E).equals(ONE));
        BigInteger bigInteger6 = E.modInverse(bigInteger3.subtract(ONE).multiply(bigInteger.subtract(ONE)));
        return new KeyPair(new JessieRSAPublicKey(bigInteger2, E), new JessieRSAPrivateKey(bigInteger2, bigInteger6));
    }

    private static final void nextBytes(byte[] byArray) {
        RANDOM.nextBytes(byArray);
    }

    private KeyPool() {
    }
}

