/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

final class RETokenPOSIX
extends REToken {
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};
    int type;
    boolean insens;
    boolean negated;

    static final int intValue(String key) {
        int i = 0;
        while (i < s_nameTable.length) {
            if (s_nameTable[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    final int getMinimumLength() {
        return 1;
    }

    final boolean match(CharIndexed input, REMatch mymatch) {
        char ch = input.charAt(mymatch.index);
        if (ch == (char)-1) {
            return false;
        }
        boolean retval = false;
        switch (this.type) {
            case 0: {
                boolean bl = false;
                if (Character.isLetterOrDigit(ch) || ch == '_') {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 1: {
                retval = Character.isLetter(ch);
                break;
            }
            case 2: {
                boolean bl = false;
                if (ch == ' ' || ch == '\t') {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 3: {
                retval = Character.isISOControl(ch);
                break;
            }
            case 4: {
                retval = Character.isDigit(ch);
                break;
            }
            case 5: {
                boolean bl = false;
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    bl = true;
                }
                retval = bl ^ true;
                break;
            }
            case 6: {
                boolean bl = false;
                if (this.insens && Character.isLetter(ch) || Character.isLowerCase(ch)) {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 7: {
                boolean bl = false;
                if (!Character.isWhitespace(ch) && !Character.isISOControl(ch) || ch == ' ') {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 8: {
                boolean bl = false;
                if ("`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(ch) != -1) {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 9: {
                retval = Character.isWhitespace(ch);
                break;
            }
            case 10: {
                boolean bl = false;
                if (this.insens && Character.isLetter(ch) || Character.isUpperCase(ch)) {
                    bl = true;
                }
                retval = bl;
                break;
            }
            case 11: {
                boolean bl = false;
                if (Character.isDigit(ch) || "abcdefABCDEF".indexOf(ch) != -1) {
                    bl = true;
                }
                retval = bl;
                break;
            }
        }
        if (this.negated) {
            retval ^= true;
        }
        if (retval) {
            ++mymatch.index;
            return this.next(input, mymatch);
        }
        return false;
    }

    final void dump(StringBuffer os) {
        if (this.negated) {
            os.append('^');
        }
        os.append("[:" + s_nameTable[this.type] + ":]");
    }

    RETokenPOSIX(int subIndex, int type, boolean insens, boolean negated) {
        super(subIndex);
        this.type = type;
        this.insens = insens;
        this.negated = negated;
    }
}

