/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.alsa;

import gnu.javax.sound.midi.alsa.AlsaInputPortDevice;
import gnu.javax.sound.midi.alsa.AlsaMidiSequencerDevice;
import gnu.javax.sound.midi.alsa.AlsaOutputPortDevice;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class AlsaMidiDeviceProvider
extends MidiDeviceProvider {
    private static AlsaInfo[] infos;

    private static final native AlsaInfo[] getInputDeviceInfo_();

    private static final native AlsaInfo[] getOutputDeviceInfo_();

    private static final native void init_();

    public MidiDevice.Info[] getDeviceInfo() {
        return infos;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        int n = 0;
        while (n < infos.length) {
            if (info.equals(infos[n])) {
                return infos[n].getDevice();
            }
            ++n;
        }
        throw new IllegalArgumentException("Don't recognize MIDI device " + info);
    }

    static {
        System.loadLibrary("gjsmalsa");
        AlsaMidiDeviceProvider.init_();
        AlsaInfo[] alsaInfoArray = AlsaMidiDeviceProvider.getInputDeviceInfo_();
        AlsaInfo[] alsaInfoArray2 = AlsaMidiDeviceProvider.getOutputDeviceInfo_();
        infos = new AlsaInfo[alsaInfoArray.length + alsaInfoArray2.length + 1];
        AlsaMidiDeviceProvider.infos[0] = new AlsaSequencerInfo("/dev/snd/seq", "ALSA Sequencer");
        System.arraycopy(alsaInfoArray, 0, infos, 1, alsaInfoArray.length);
        System.arraycopy(alsaInfoArray2, 0, infos, 1 + alsaInfoArray.length, alsaInfoArray2.length);
    }

    private static abstract class AlsaInfo
    extends MidiDevice.Info {
        abstract MidiDevice getDevice();

        public AlsaInfo(String string, String string2) {
            super(string, "Alsa", string2, "0.0");
        }
    }

    private static class AlsaSequencerInfo
    extends AlsaInfo {
        MidiDevice getDevice() {
            return AlsaMidiSequencerDevice.getInstance();
        }

        public AlsaSequencerInfo(String string, String string2) {
            super(string, string2);
        }
    }

    private static class AlsaOutputPortInfo
    extends AlsaPortInfo {
        MidiDevice getDevice() {
            return new AlsaOutputPortDevice(this);
        }

        public AlsaOutputPortInfo(String string, String string2, long l, long l2) {
            super(string, string2, l, l2);
        }
    }

    private static class AlsaInputPortInfo
    extends AlsaPortInfo {
        MidiDevice getDevice() {
            return new AlsaInputPortDevice(this);
        }

        public AlsaInputPortInfo(String string, String string2, long l, long l2) {
            super(string, string2, l, l2);
        }
    }

    public static abstract class AlsaPortInfo
    extends AlsaInfo {
        long client;
        long port;

        public AlsaPortInfo(String string, String string2, long l, long l2) {
            super(string, string2);
            this.client = l;
            this.port = l2;
        }
    }
}

