/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.ProtocolException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class HttpURLConnection
extends URLConnection {
    static final int HTTP_CONTINUE = 100;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    private static boolean followRedirects = true;
    private static final String valid_methods = "|GET|POST|HEAD|OPTIONS|PUT|DELETE|TRACE|";
    protected String method;
    protected int responseCode;
    protected String responseMessage;
    protected boolean instanceFollowRedirects;
    private boolean gotResponseVals;

    public abstract void disconnect();

    public abstract boolean usingProxy();

    public static void setFollowRedirects(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        followRedirects = bl;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.instanceFollowRedirects = bl;
    }

    public void setRequestMethod(String string) throws ProtocolException {
        if (this.connected) {
            throw new ProtocolException("Already connected");
        }
        if (valid_methods.indexOf("|" + (string = string.toUpperCase()) + '|') == -1) {
            throw new ProtocolException("Invalid HTTP request method: " + string);
        }
        this.method = string;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (!this.gotResponseVals) {
            this.getResponseVals();
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (!this.gotResponseVals) {
            this.getResponseVals();
        }
        return this.responseMessage;
    }

    private final void getResponseVals() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        this.gotResponseVals = true;
        if (this.responseCode == -1) {
            String string = this.getHeaderField(0);
            if (string == null || !string.startsWith("HTTP/")) {
                this.responseCode = -1;
                this.responseMessage = null;
                return;
            }
            int n = string.indexOf(32);
            int n2 = string.indexOf(32, n + 1);
            this.responseMessage = string.substring(n2 + 1);
            String string2 = string.substring(n + 1, n2);
            try {
                this.responseCode = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.responseCode = -1;
                this.responseMessage = null;
            }
        }
    }

    public Permission getPermission() throws IOException {
        URL uRL = this.getURL();
        String string = uRL.getHost();
        int n = uRL.getPort();
        if (n == -1) {
            n = 80;
        }
        string = string + ':' + n;
        return new SocketPermission(string, "connect");
    }

    public InputStream getErrorStream() {
        int n;
        if (!this.connected) {
            return null;
        }
        try {
            n = this.getResponseCode();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (n == -1) {
            return null;
        }
        if (n / 100 != 4 || n / 100 != 5) {
            return null;
        }
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(this.getInputStream());
            int n2 = pushbackInputStream.read();
            if (n2 == -1) {
                return null;
            }
            pushbackInputStream.unread(n2);
            return pushbackInputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getHeaderFieldDate(String string, long l) {
        return super.getHeaderFieldDate(string, l);
    }

    private final /* synthetic */ void this() {
        this.method = "GET";
        this.responseCode = -1;
        this.instanceFollowRedirects = followRedirects;
    }

    protected HttpURLConnection(URL uRL) {
        super(uRL);
        this.this();
    }
}

