/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.file.AiffAudioOutputStream;
import org.tritonus.sampled.file.AiffTool;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TAudioFileWriter;
import org.tritonus.share.sampled.file.TDataOutputStream;

public class AiffAudioFileWriter
extends TAudioFileWriter {
    private static final AudioFileFormat.Type[] FILE_TYPES = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF, AudioFileFormat.Type.AIFC};
    private static final int ALL = -1;
    private static final AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    private static final AudioFormat.Encoding ULAW = AudioFormat.Encoding.ULAW;
    private static final AudioFormat.Encoding IMA_ADPCM = Encodings.getEncoding("IMA_ADPCM");
    private static final AudioFormat[] AUDIO_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ULAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true), new AudioFormat(IMA_ADPCM, -1.0f, 4, -1, -1, -1.0f, true), new AudioFormat(IMA_ADPCM, -1.0f, 4, -1, -1, -1.0f, false)};

    protected boolean isAudioFormatSupportedImpl(AudioFormat audioFormat, AudioFileFormat.Type type) {
        boolean bl = false;
        if (AiffTool.getFormatCode(audioFormat) != 0) {
            bl = true;
        }
        return bl;
    }

    protected AudioOutputStream getAudioOutputStream(AudioFormat audioFormat, long l, AudioFileFormat.Type type, TDataOutputStream tDataOutputStream) throws IOException {
        return new AiffAudioOutputStream(audioFormat, type, l, tDataOutputStream);
    }

    public AiffAudioFileWriter() {
        super(Arrays.asList(FILE_TYPES), Arrays.asList(AUDIO_FORMATS));
    }
}

