/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private int m_nReadPos;
    private int m_nWritePos;
    private Trigger m_trigger;
    private boolean m_bOpen;

    public void close() {
        this.m_bOpen = false;
    }

    private final boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return this.m_nWritePos - this.m_nReadPos;
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private final int getReadPos() {
        return this.m_nReadPos % this.m_nSize;
    }

    private final int getWritePos() {
        return this.m_nWritePos % this.m_nSize;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            this.dumpInternalState();
        }
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                var3_3 = Math.min(var3_3, this.availableRead());
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("reading rest in closed buffer, length: " + var3_3);
                }
            } else {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("< not open. returning -1.");
                }
                return -1;
            }
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (this.m_trigger != null && this.availableRead() < var3_3) {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("executing trigger.");
                }
                this.m_trigger.execute();
            }
            if (!this.m_bBlockingRead) {
                var3_3 = Math.min(this.availableRead(), var3_3);
            }
            var7_5 = var3_3;
            while (true) {
                if (var7_5 > 0) ** GOTO lbl39
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("After read:");
                    this.dumpInternalState();
                    TDebug.out("< completed. Read " + var3_3 + " bytes");
                }
                return var3_3;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var8_7) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(var8_7);
                    }
lbl39:
                    // 4 sources

                    ** while (this.availableRead() == 0)
                }
lbl40:
                // 1 sources

                var8_6 = Math.min(this.availableRead(), var7_5);
                while (var8_6 > 0) {
                    var9_8 = Math.min(var8_6, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), var1_1, var2_2, var9_8);
                    this.m_nReadPos += var9_8;
                    var2_2 += var9_8;
                    var8_6 -= var9_8;
                    var7_5 -= var9_8;
                }
                this.notifyAll();
            }
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(byte[] var1_1, int var2_2, int var3_3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.write(): called; nLength: " + var3_3);
            this.dumpInternalState();
        }
        var4_4 = this;
        synchronized (var4_4) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                var3_3 = Math.min(this.availableWrite(), var3_3);
            }
            var7_5 = var3_3;
            while (true) {
                if (var7_5 > 0) ** GOTO lbl28
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("After write:");
                    this.dumpInternalState();
                    TDebug.out("< completed. Wrote " + var3_3 + " bytes");
                }
                return var3_3;
lbl-1000:
                // 1 sources

                {
                    try {
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException var8_7) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(var8_7);
                    }
lbl28:
                    // 4 sources

                    ** while (this.availableWrite() == 0)
                }
lbl29:
                // 1 sources

                var8_6 = Math.min(this.availableWrite(), var7_5);
                while (var8_6 > 0) {
                    var9_8 = Math.min(var8_6, this.m_nSize - this.getWritePos());
                    System.arraycopy(var1_1, var2_2, this.m_abData, this.getWritePos(), var9_8);
                    this.m_nWritePos += var9_8;
                    var2_2 += var9_8;
                    var8_6 -= var9_8;
                    var7_5 -= var9_8;
                }
                this.notifyAll();
            }
        }
    }

    private final void dumpInternalState() {
        TDebug.out("m_nReadPos  = " + this.m_nReadPos + " ^= " + this.getReadPos());
        TDebug.out("m_nWritePos = " + this.m_nWritePos + " ^= " + this.getWritePos());
        TDebug.out("availableRead()  = " + this.availableRead());
        TDebug.out("availableWrite() = " + this.availableWrite());
    }

    public TCircularBuffer(int n, boolean bl, boolean bl2, Trigger trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n;
        this.m_abData = new byte[this.m_nSize];
        this.m_nReadPos = 0;
        this.m_nWritePos = 0;
        this.m_trigger = trigger;
        this.m_bOpen = true;
    }

    public static interface Trigger {
        public void execute();
    }
}

