/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    static JTextComponent componentWithSelection;
    private static final long serialVersionUID = 4325555698756477346L;
    public static final int ALWAYS_UPDATE = 2;
    public static final int NEVER_UPDATE = 1;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    int policy;
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    DocumentListener documentListener;
    PropertyChangeListener propertyChangeListener;
    private JTextComponent textComponent;
    private boolean selectionVisible;
    private int blinkRate;
    private int dot;
    private int mark;
    private Point magicCaretPosition;
    boolean visible;
    private Object highlightEntry;
    private Timer blinkTimer;
    private BlinkTimerListener blinkListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public void setUpdatePolicy(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("policy must be ALWAYS_UPDATE, NEVER__UPDATE, or UPDATE_WHEN_ON_EDT");
        }
        this.policy = n;
    }

    public int getUpdatePolicy() {
        return this.policy;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if (mouseEvent.getButton() == 1 && n >= 2) {
            int n2 = this.getComponent().viewToModel(mouseEvent.getPoint());
            JTextComponent jTextComponent = this.getComponent();
            try {
                if (n == 3) {
                    this.setDot(Utilities.getRowStart(jTextComponent, n2));
                    this.moveDot(Utilities.getRowEnd(jTextComponent, n2));
                } else {
                    int n3 = Utilities.getNextWord(jTextComponent, n2);
                    if (n2 == n3) {
                        this.setDot(n3);
                        this.moveDot(Utilities.getNextWord(jTextComponent, n3));
                    } else {
                        int n4 = Utilities.getPreviousWord(jTextComponent, n2);
                        int n5 = Utilities.getWordEnd(jTextComponent, n4);
                        if (n2 >= n5 && n2 <= n3) {
                            this.setDot(n5);
                            this.moveDot(n3);
                        } else {
                            this.setDot(n4);
                            this.moveDot(n5);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setVisible(true);
        this.updateTimerStatus();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.setVisible(false);
            if (this.blinkTimer != null && this.blinkTimer.isRunning()) {
                this.blinkTimer.stop();
            }
        }
    }

    private final void updateTimerStatus() {
        if (this.textComponent.isEnabled() && this.textComponent.isEditable()) {
            if (this.blinkTimer == null) {
                this.initBlinkTimer();
            }
            if (!this.blinkTimer.isRunning()) {
                this.blinkTimer.start();
            }
        } else if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.moveDot(n);
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.setDot(n);
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.textComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.textComponent = null;
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        this.blinkTimer = null;
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.textComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.documentListener = new DocumentHandler();
        this.textComponent.getDocument().addDocumentListener(this.documentListener);
        this.repaint();
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void clearHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(0, 0, this.getSelectionPainter());
                } else {
                    highlighter.changeHighlight(this.highlightEntry, 0, 0);
                }
                if (componentWithSelection != this.textComponent) return;
                componentWithSelection = null;
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else {
            if (this.highlightEntry == null) return;
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    private final void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int n = Math.min(this.dot, this.mark);
        int n2 = Math.max(this.dot, this.mark);
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(n, n2, this.getSelectionPainter());
                } else {
                    highlighter.changeHighlight(this.highlightEntry, n, n2);
                }
                if (componentWithSelection != null && componentWithSelection != this.textComponent) {
                    Caret caret = componentWithSelection.getCaret();
                    caret.setDot(caret.getDot());
                }
                componentWithSelection = this.textComponent;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    public void setSelectionVisible(boolean bl) {
        if (this.selectionVisible == bl) {
            return;
        }
        this.selectionVisible = bl;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        this.getComponent().repaint(this.x, this.y, this.width, this.height);
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        this.dot = Math.min(this.dot, this.textComponent.getDocument().getLength());
        this.dot = Math.max(this.dot, 0);
        Rectangle rectangle = null;
        try {
            rectangle = this.textComponent.modelToView(this.dot);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)("Unexpected bad caret location: " + this.dot));
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        if (rectangle == null) {
            return;
        }
        if (this.x != rectangle.x || this.y != rectangle.y) {
            this.repaint();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = 1;
            this.height = rectangle.height;
        }
        if (this.visible) {
            graphics.setColor(this.textComponent.getCaretColor());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = DefaultCaret.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.getListeners(clazz);
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        int n = 0;
        while (n < changeListenerArray.length) {
            changeListenerArray[n].stateChanged(this.changeEvent);
            ++n;
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int n) {
        if (this.blinkTimer != null) {
            this.blinkTimer.setDelay(n);
        }
        this.blinkRate = n;
    }

    public int getDot() {
        return this.dot;
    }

    public void moveDot(int n) {
        if (n >= 0) {
            Document document = this.textComponent.getDocument();
            if (document != null) {
                this.dot = Math.min(n, document.getLength());
            }
            this.dot = Math.max(this.dot, 0);
            this.handleHighlight();
            this.adjustVisibility(this);
            this.appear();
        }
    }

    public void setDot(int n) {
        if (n >= 0) {
            Document document = this.textComponent.getDocument();
            if (document != null) {
                this.dot = Math.min(n, document.getLength());
            }
            this.mark = this.dot = Math.max(this.dot, 0);
            this.clearHighlight();
            this.adjustVisibility(this);
            this.appear();
        }
    }

    void appear() {
        if (this.blinkListener != null) {
            this.blinkListener.ignoreNextEvent = true;
            if (this.visible) {
                this.repaint();
            }
            this.visible = true;
            Rectangle rectangle = null;
            int n = this.getDot();
            try {
                rectangle = this.getComponent().modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("Unexpected bad caret location: " + n));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.updateTimerStatus();
            Rectangle rectangle = null;
            int n = this.getDot();
            try {
                rectangle = this.getComponent().modelToView(n);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("Unexpected bad caret location: " + n));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void damage(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = 1;
        if (this.height <= 0) {
            this.height = this.getComponent().getHeight();
        }
        this.repaint();
    }

    protected void adjustVisibility(Rectangle rectangle) {
        this.getComponent().scrollRectToVisible(rectangle);
    }

    private final void initBlinkTimer() {
        this.blinkListener = new BlinkTimerListener();
        this.blinkTimer = new Timer(this.getBlinkRate(), this.blinkListener);
        this.blinkTimer.setRepeats(true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.policy = 0;
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectionVisible = true;
        this.blinkRate = 500;
        this.dot = 0;
        this.mark = 0;
        this.magicCaretPosition = null;
        this.visible = false;
    }

    public DefaultCaret() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                Document document = (Document)propertyChangeEvent.getOldValue();
                document.removeDocumentListener(DefaultCaret.this.documentListener);
                Document document2 = (Document)propertyChangeEvent.getNewValue();
                document2.addDocumentListener(DefaultCaret.this.documentListener);
            }
        }

        private PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int n = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(n + documentEvent.getLength());
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int n = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(n - documentEvent.getLength());
            } else if (DefaultCaret.this.policy == 1 || !SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int n = documentEvent.getDocument().getLength();
                if (DefaultCaret.this.getDot() > n) {
                    DefaultCaret.this.setDot(n);
                }
            }
        }

        private DocumentHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class BlinkTimerListener
    implements ActionListener {
        boolean ignoreNextEvent;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ignoreNextEvent) {
                this.ignoreNextEvent = false;
            } else {
                DefaultCaret.this.visible ^= true;
                DefaultCaret.this.repaint();
            }
        }

        private BlinkTimerListener() {
        }
    }
}

