require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_DH_H)) {
    eval 'sub HEADER_DH_H () {1;}' unless defined(&HEADER_DH_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_DH)) {
	require 'openssl/e_os2.ph';
	require 'openssl/bio.ph';
	require 'openssl/asn1.ph';
	require 'openssl/ossl_typ.ph';
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    require 'openssl/bn.ph';
	}
	require 'openssl/dherr.ph';
	if(defined(&__cplusplus)) {
	}
	unless(defined(&OPENSSL_DH_MAX_MODULUS_BITS)) {
	    eval 'sub OPENSSL_DH_MAX_MODULUS_BITS () {10000;}' unless defined(&OPENSSL_DH_MAX_MODULUS_BITS);
	}
	eval 'sub OPENSSL_DH_FIPS_MIN_MODULUS_BITS () {1024;}' unless defined(&OPENSSL_DH_FIPS_MIN_MODULUS_BITS);
	eval 'sub DH_FLAG_CACHE_MONT_P () {0x1;}' unless defined(&DH_FLAG_CACHE_MONT_P);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub DH_FLAG_NO_EXP_CONSTTIME () {0x;}' unless defined(&DH_FLAG_NO_EXP_CONSTTIME);
	}
	eval 'sub DH_FLAG_FIPS_METHOD () {0x400;}' unless defined(&DH_FLAG_FIPS_METHOD);
	eval 'sub DH_FLAG_NON_FIPS_ALLOW () {0x400;}' unless defined(&DH_FLAG_NON_FIPS_ALLOW);
	eval 'sub DH_GENERATOR_2 () {2;}' unless defined(&DH_GENERATOR_2);
	eval 'sub DH_GENERATOR_5 () {5;}' unless defined(&DH_GENERATOR_5);
	eval 'sub DH_CHECK_P_NOT_PRIME () {0x1;}' unless defined(&DH_CHECK_P_NOT_PRIME);
	eval 'sub DH_CHECK_P_NOT_SAFE_PRIME () {0x2;}' unless defined(&DH_CHECK_P_NOT_SAFE_PRIME);
	eval 'sub DH_UNABLE_TO_CHECK_GENERATOR () {0x4;}' unless defined(&DH_UNABLE_TO_CHECK_GENERATOR);
	eval 'sub DH_NOT_SUITABLE_GENERATOR () {0x8;}' unless defined(&DH_NOT_SUITABLE_GENERATOR);
	eval 'sub DH_CHECK_Q_NOT_PRIME () {0x10;}' unless defined(&DH_CHECK_Q_NOT_PRIME);
	eval 'sub DH_CHECK_INVALID_Q_VALUE () {0x20;}' unless defined(&DH_CHECK_INVALID_Q_VALUE);
	eval 'sub DH_CHECK_INVALID_J_VALUE () {0x40;}' unless defined(&DH_CHECK_INVALID_J_VALUE);
	eval 'sub DH_CHECK_PUBKEY_TOO_SMALL () {0x1;}' unless defined(&DH_CHECK_PUBKEY_TOO_SMALL);
	eval 'sub DH_CHECK_PUBKEY_TOO_LARGE () {0x2;}' unless defined(&DH_CHECK_PUBKEY_TOO_LARGE);
	eval 'sub DH_CHECK_PUBKEY_INVALID () {0x4;}' unless defined(&DH_CHECK_PUBKEY_INVALID);
	eval 'sub DH_CHECK_P_NOT_STRONG_PRIME () { &DH_CHECK_P_NOT_SAFE_PRIME;}' unless defined(&DH_CHECK_P_NOT_STRONG_PRIME);
	eval 'sub d2i_DHparams_fp {
	    my($fp,$x) = @_;
    	    eval q(( &DH *) &ASN1_d2i_fp((\'char\' *(*)()) &DH_new, (\'char\' *(*)()) &d2i_DHparams, , ($x)));
	}' unless defined(&d2i_DHparams_fp);
	eval 'sub i2d_DHparams_fp {
	    my($fp,$x) = @_;
    	    eval q( &ASN1_i2d_fp( &i2d_DHparams,, ($x)));
	}' unless defined(&i2d_DHparams_fp);
	eval 'sub d2i_DHparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_d2i_bio_of( &DH,  &DH_new,  &d2i_DHparams, $bp, $x));
	}' unless defined(&d2i_DHparams_bio);
	eval 'sub i2d_DHparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_i2d_bio_of_const( &DH, &i2d_DHparams,$bp,$x));
	}' unless defined(&i2d_DHparams_bio);
	eval 'sub d2i_DHxparams_fp {
	    my($fp,$x) = @_;
    	    eval q(( &DH *) &ASN1_d2i_fp((\'char\' *(*)()) &DH_new, (\'char\' *(*)()) &d2i_DHxparams, , ($x)));
	}' unless defined(&d2i_DHxparams_fp);
	eval 'sub i2d_DHxparams_fp {
	    my($fp,$x) = @_;
    	    eval q( &ASN1_i2d_fp( &i2d_DHxparams,, ($x)));
	}' unless defined(&i2d_DHxparams_fp);
	eval 'sub d2i_DHxparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_d2i_bio_of( &DH,  &DH_new,  &d2i_DHxparams, $bp, $x));
	}' unless defined(&d2i_DHxparams_bio);
	eval 'sub i2d_DHxparams_bio {
	    my($bp,$x) = @_;
    	    eval q( &ASN1_i2d_bio_of_const( &DH,  &i2d_DHxparams, $bp, $x));
	}' unless defined(&i2d_DHxparams_bio);
	eval 'sub DH_get_ex_new_index {
	    my($l, $p, $newf, $dupf, $freef) = @_;
    	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_DH, $l, $p, $newf, $dupf, $freef));
	}' unless defined(&DH_get_ex_new_index);
	unless(defined(&OPENSSL_NO_STDIO)) {
	}
	unless(defined(&OPENSSL_NO_CMS)) {
	}
	eval 'sub EVP_PKEY_CTX_set_dh_paramgen_prime_len {
	    my($ctx, $len) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_PARAMGEN_PRIME_LEN, $len,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_paramgen_prime_len);
	eval 'sub EVP_PKEY_CTX_set_dh_paramgen_subprime_len {
	    my($ctx, $len) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_PARAMGEN_SUBPRIME_LEN, $len,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_paramgen_subprime_len);
	eval 'sub EVP_PKEY_CTX_set_dh_paramgen_type {
	    my($ctx, $typ) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_PARAMGEN_TYPE, $typ,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_paramgen_type);
	eval 'sub EVP_PKEY_CTX_set_dh_paramgen_generator {
	    my($ctx, $gen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_PARAMGEN_GENERATOR, $gen,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_paramgen_generator);
	eval 'sub EVP_PKEY_CTX_set_dh_rfc5114 {
	    my($ctx, $gen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_RFC5114, $gen,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_rfc5114);
	eval 'sub EVP_PKEY_CTX_set_dhx_rfc5114 {
	    my($ctx, $gen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_PARAMGEN,  &EVP_PKEY_CTRL_DH_RFC5114, $gen,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dhx_rfc5114);
	eval 'sub EVP_PKEY_CTX_set_dh_nid {
	    my($ctx, $nid) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_PARAMGEN |  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_DH_NID, $nid,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_nid);
	eval 'sub EVP_PKEY_CTX_set_dh_pad {
	    my($ctx, $pad) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DH,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_PAD, $pad,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_pad);
	eval 'sub EVP_PKEY_CTX_set_dh_kdf_type {
	    my($ctx, $kdf) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_TYPE, $kdf,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_kdf_type);
	eval 'sub EVP_PKEY_CTX_get_dh_kdf_type {
	    my($ctx) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_TYPE, -2,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_get_dh_kdf_type);
	eval 'sub EVP_PKEY_CTX_set0_dh_kdf_oid {
	    my($ctx, $oid) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_OID, 0, ( &void *)($oid)));
	}' unless defined(&EVP_PKEY_CTX_set0_dh_kdf_oid);
	eval 'sub EVP_PKEY_CTX_get0_dh_kdf_oid {
	    my($ctx, $poid) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_GET_DH_KDF_OID, 0, ( &void *)($poid)));
	}' unless defined(&EVP_PKEY_CTX_get0_dh_kdf_oid);
	eval 'sub EVP_PKEY_CTX_set_dh_kdf_md {
	    my($ctx, $md) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_dh_kdf_md);
	eval 'sub EVP_PKEY_CTX_get_dh_kdf_md {
	    my($ctx, $pmd) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_GET_DH_KDF_MD, 0, ( &void *)($pmd)));
	}' unless defined(&EVP_PKEY_CTX_get_dh_kdf_md);
	eval 'sub EVP_PKEY_CTX_set_dh_kdf_outlen {
	    my($ctx, $len) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_OUTLEN, $len,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_dh_kdf_outlen);
	eval 'sub EVP_PKEY_CTX_get_dh_kdf_outlen {
	    my($ctx, $plen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_GET_DH_KDF_OUTLEN, 0, ( &void *)($plen)));
	}' unless defined(&EVP_PKEY_CTX_get_dh_kdf_outlen);
	eval 'sub EVP_PKEY_CTX_set0_dh_kdf_ukm {
	    my($ctx, $p, $plen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_DH_KDF_UKM, $plen, ( &void *)($p)));
	}' unless defined(&EVP_PKEY_CTX_set0_dh_kdf_ukm);
	eval 'sub EVP_PKEY_CTX_get0_dh_kdf_ukm {
	    my($ctx, $p) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_DHX,  &EVP_PKEY_OP_DERIVE,  &EVP_PKEY_CTRL_GET_DH_KDF_UKM, 0, ( &void *)($p)));
	}' unless defined(&EVP_PKEY_CTX_get0_dh_kdf_ukm);
	eval 'sub EVP_PKEY_CTRL_DH_PARAMGEN_PRIME_LEN () {( &EVP_PKEY_ALG_CTRL + 1);}' unless defined(&EVP_PKEY_CTRL_DH_PARAMGEN_PRIME_LEN);
	eval 'sub EVP_PKEY_CTRL_DH_PARAMGEN_GENERATOR () {( &EVP_PKEY_ALG_CTRL + 2);}' unless defined(&EVP_PKEY_CTRL_DH_PARAMGEN_GENERATOR);
	eval 'sub EVP_PKEY_CTRL_DH_RFC5114 () {( &EVP_PKEY_ALG_CTRL + 3);}' unless defined(&EVP_PKEY_CTRL_DH_RFC5114);
	eval 'sub EVP_PKEY_CTRL_DH_PARAMGEN_SUBPRIME_LEN () {( &EVP_PKEY_ALG_CTRL + 4);}' unless defined(&EVP_PKEY_CTRL_DH_PARAMGEN_SUBPRIME_LEN);
	eval 'sub EVP_PKEY_CTRL_DH_PARAMGEN_TYPE () {( &EVP_PKEY_ALG_CTRL + 5);}' unless defined(&EVP_PKEY_CTRL_DH_PARAMGEN_TYPE);
	eval 'sub EVP_PKEY_CTRL_DH_KDF_TYPE () {( &EVP_PKEY_ALG_CTRL + 6);}' unless defined(&EVP_PKEY_CTRL_DH_KDF_TYPE);
	eval 'sub EVP_PKEY_CTRL_DH_KDF_MD () {( &EVP_PKEY_ALG_CTRL + 7);}' unless defined(&EVP_PKEY_CTRL_DH_KDF_MD);
	eval 'sub EVP_PKEY_CTRL_GET_DH_KDF_MD () {( &EVP_PKEY_ALG_CTRL + 8);}' unless defined(&EVP_PKEY_CTRL_GET_DH_KDF_MD);
	eval 'sub EVP_PKEY_CTRL_DH_KDF_OUTLEN () {( &EVP_PKEY_ALG_CTRL + 9);}' unless defined(&EVP_PKEY_CTRL_DH_KDF_OUTLEN);
	eval 'sub EVP_PKEY_CTRL_GET_DH_KDF_OUTLEN () {( &EVP_PKEY_ALG_CTRL + 10);}' unless defined(&EVP_PKEY_CTRL_GET_DH_KDF_OUTLEN);
	eval 'sub EVP_PKEY_CTRL_DH_KDF_UKM () {( &EVP_PKEY_ALG_CTRL + 11);}' unless defined(&EVP_PKEY_CTRL_DH_KDF_UKM);
	eval 'sub EVP_PKEY_CTRL_GET_DH_KDF_UKM () {( &EVP_PKEY_ALG_CTRL + 12);}' unless defined(&EVP_PKEY_CTRL_GET_DH_KDF_UKM);
	eval 'sub EVP_PKEY_CTRL_DH_KDF_OID () {( &EVP_PKEY_ALG_CTRL + 13);}' unless defined(&EVP_PKEY_CTRL_DH_KDF_OID);
	eval 'sub EVP_PKEY_CTRL_GET_DH_KDF_OID () {( &EVP_PKEY_ALG_CTRL + 14);}' unless defined(&EVP_PKEY_CTRL_GET_DH_KDF_OID);
	eval 'sub EVP_PKEY_CTRL_DH_NID () {( &EVP_PKEY_ALG_CTRL + 15);}' unless defined(&EVP_PKEY_CTRL_DH_NID);
	eval 'sub EVP_PKEY_CTRL_DH_PAD () {( &EVP_PKEY_ALG_CTRL + 16);}' unless defined(&EVP_PKEY_CTRL_DH_PAD);
	eval 'sub EVP_PKEY_DH_KDF_NONE () {1;}' unless defined(&EVP_PKEY_DH_KDF_NONE);
	unless(defined(&OPENSSL_NO_CMS)) {
	    eval 'sub EVP_PKEY_DH_KDF_X9_42 () {2;}' unless defined(&EVP_PKEY_DH_KDF_X9_42);
	}
	if(defined(&__cplusplus)) {
	}
    }
}
1;
