/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class ToolBarLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int axis;

    public ToolBarLayout() {
        this(0);
    }

    public ToolBarLayout(int n) {
        this.axis = n;
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        switch (this.axis) {
            case 1: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        switch (this.axis) {
            case 1: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        switch (this.axis) {
            case 1: {
                for (Component component : container.getComponents()) {
                    Dimension dimension = component.getPreferredSize();
                    n = Math.max(n, dimension.width);
                    n2 += dimension.height;
                }
                break;
            }
            default: {
                for (Component component : container.getComponents()) {
                    Dimension dimension = component.getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n += dimension.width;
                }
            }
        }
        Insets insets = container.getInsets();
        return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        Insets insets = container.getInsets();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = insets.top;
        switch (this.axis) {
            case 1: {
                for (Component component : container.getComponents()) {
                    dimension = component.getPreferredSize();
                    component.setBounds(n3, n4, n, dimension.height);
                    n4 += dimension.height;
                }
                break;
            }
            default: {
                for (Component component : container.getComponents()) {
                    dimension = component.getPreferredSize();
                    component.setBounds(n3, n4, dimension.width, n2);
                    n3 += dimension.width;
                }
            }
        }
    }
}

