#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

normal = {
('ACE'  , '1HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ACE'  , '2HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ACE'  , '3HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ACE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ACE'  , 'CH3'   ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('ACE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ALA'  , '1HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ALA'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('ALA'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ALA'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ALA'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ALA'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ARG'  , '1HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '1HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '2HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ARG'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('ARG'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.3276 } ,
('ARG'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CZ'    ) : { 'type' : '2'    , 'charge' :  1.2000 } ,
('ARG'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ARG'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , 'HE'    ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ARG'  , 'NE'    ) : { 'type' : '25'   , 'charge' : -0.8443 } ,
('ARG'  , 'NH1'   ) : { 'type' : '25'   , 'charge' : -0.9667 } ,
('ARG'  , 'NH2'   ) : { 'type' : '31'   , 'charge' : -0.9667 } ,
('ARG'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASN'  , '1HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , '2HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('ASN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('ASN'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASN'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ASN'  , 'ND2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('ASN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASN'  , 'OD1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('ASP'  , 'CB'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('ASP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ASP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ASP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASP'  , 'OD1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ASP'  , 'OD2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('CYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('CYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('CYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYS'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('CYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.1800 } ,
('CYS'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('CYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('CYS'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.4100 } ,
('CYX'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('CYX'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('CYX'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYX'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('CYX'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('CYX'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('CYX'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.2300 } ,
('GLN'  , '1HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '2HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('GLN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLN'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLN'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('GLN'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('GLN'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('GLN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLN'  , 'OE1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('GLU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLU'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('GLU'  , 'CG'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('GLU'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('GLU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLU'  , 'OE1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('GLU'  , 'OE2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('GLY'  , '3HA'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLY'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLY'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('GLY'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLY'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLY'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('GLY'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('HID'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HID'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HID'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('HID'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1800 } ,
('HID'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0772 } ,
('HID'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HID'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.3316 } ,
('HID'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HID'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HID'  , 'ND1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HID'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HID'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('HIE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '2HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HIE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HIE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('HIE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('HIE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('HIE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HIE'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.0462 } ,
('HIE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HIE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HIE'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HIE'  , 'NE2'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HIE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('HIP'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('HIP'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '2HE'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('HIP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HIP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('HIP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1680 } ,
('HIP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.2000 } ,
('HIP'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.6500 } ,
('HIP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.1820 } ,
('HIP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HIP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HIP'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.7000 } ,
('HIP'  , 'NE2'   ) : { 'type' : '31'   , 'charge' : -0.7000 } ,
('HIP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ILE'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ILE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('ILE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ILE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ILE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('LEU'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '1HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('LEU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('LEU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('LEU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('LEU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('LYS'  , '1HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('LYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('LYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.5030 } ,
('LYS'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('LYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('LYS'  , 'NZ'    ) : { 'type' : '32'   , 'charge' : -0.8530 } ,
('LYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('MET'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('MET'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('MET'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('MET'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('MET'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('MET'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('MET'  , 'SD'    ) : { 'type' : '49'   , 'charge' : -0.4600 } ,
('NME'  , '1HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('NME'  , '2HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('NME'  , '3HH3'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('NME'  , 'CH3'   ) : { 'type' : '3'    , 'charge' :  0.3001 } ,
('NME'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('NME'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('PHE'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('PHE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('PHE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1435 } ,
('PHE'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1435 } ,
('PHE'  , 'CZ'    ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('PHE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , 'HZ'    ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('PHE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('PRO'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('PRO'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('PRO'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.3001 } ,
('PRO'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.6602 } ,
('PRO'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('SER'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('SER'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('SER'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('SER'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('SER'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , 'HG'    ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('SER'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('SER'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('SER'  , 'OG'    ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('THR'  , '1HG'   ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('THR'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('THR'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('THR'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('THR'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('THR'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('THR'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('THR'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('THR'  , 'OG1'   ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('TRP'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '1HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('TRP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '2HH'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '2HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('TRP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('TRP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('TRP'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('TRP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0000 } ,
('TRP'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1516 } ,
('TRP'  , 'CE3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1810 } ,
('TRP'  , 'CH2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('TRP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('TRP'  , 'NE1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('TRP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('TYR'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TYR'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TYR'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TYR'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TYR'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TYR'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TYR'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('TYR'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('TYR'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1435 } ,
('TYR'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TYR'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TYR'  , 'CE1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TYR'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TYR'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1435 } ,
('TYR'  , 'CZ'    ) : { 'type' : '2'    , 'charge' :  0.0825 } ,
('TYR'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('TYR'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TYR'  , 'HH'    ) : { 'type' : '42'   , 'charge' :  0.4500 } ,
('TYR'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('TYR'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('TYR'  , 'OH'    ) : { 'type' : '16'   , 'charge' : -0.5325 } ,
('VAL'  , '1HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('VAL'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.3611 } ,
('VAL'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('VAL'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('VAL'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
}

n_terminal = {
('ALA'  , '1HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '1HT'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ALA'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '2HT'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ALA'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '3HT'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ALA'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ALA'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('ALA'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ALA'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , 'N'     ) : { 'type' : '32'   , 'charge' : -0.8530 } ,
('ALA'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ARG'  , '1HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '1HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ARG'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '2HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ARG'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ARG'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ARG'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('ARG'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.3276 } ,
('ARG'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CZ'    ) : { 'type' : '2'    , 'charge' :  1.2000 } ,
('ARG'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , 'HE'    ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('ARG'  , 'NE'    ) : { 'type' : '25'   , 'charge' : -0.8443 } ,
('ARG'  , 'NH1'   ) : { 'type' : '25'   , 'charge' : -0.9667 } ,
('ARG'  , 'NH2'   ) : { 'type' : '31'   , 'charge' : -0.9667 } ,
('ARG'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASN'  , '1HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , '2HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('ASN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('ASN'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('ASN'  , 'ND2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('ASN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASN'  , 'OD1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASP'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ASP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('ASP'  , 'CB'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('ASP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ASP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('ASP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASP'  , 'OD1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ASP'  , 'OD2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,

('CYS'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('CYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('CYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.1800 } ,
('CYS'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('CYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('CYS'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.4100 } ,
('CYX'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYX'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYX'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('CYX'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('CYX'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('CYX'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYX'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('CYX'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('CYX'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.2300 } ,
('GLN'  , '1HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '2HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('GLN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLN'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLN'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('GLN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('GLN'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('GLN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLN'  , 'OE1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLU'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('GLU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('GLU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLU'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('GLU'  , 'CG'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('GLU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('GLU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLU'  , 'OE1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('GLU'  , 'OE2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('HID'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HID'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HID'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HID'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HID'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HID'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('HID'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1800 } ,
('HID'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0772 } ,
('HID'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HID'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.3316 } ,
('HID'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('HID'  , 'ND1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HID'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HID'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('HIE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '2HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HIE'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HIE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('HIE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('HIE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('HIE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HIE'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.0462 } ,
('HIE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('HIE'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HIE'  , 'NE2'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HIE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('HIP'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('HIP'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '2HE'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('HIP'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('HIP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('HIP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('HIP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1680 } ,
('HIP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.2000 } ,
('HIP'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.6500 } ,
('HIP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.1820 } ,
('HIP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('HIP'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.7000 } ,
('HIP'  , 'NE2'   ) : { 'type' : '31'   , 'charge' : -0.7000 } ,
('HIP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ILE'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ILE'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ILE'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('ILE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ILE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('ILE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('ILE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('LEU'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '1HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LEU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LEU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LEU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('LEU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('LEU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('LEU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('LYS'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LYS'  , '1HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LYS'  , '2HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('LYS'  , '3HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('LYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('LYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.5030 } ,
('LYS'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('LYS'  , 'NZ'    ) : { 'type' : '32'   , 'charge' : -0.8530 } ,
('LYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('MET'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('MET'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('MET'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('MET'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('MET'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('MET'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('MET'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('MET'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('MET'  , 'SD'    ) : { 'type' : '49'   , 'charge' : -0.4600 } ,
('PHE'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('PHE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('PHE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('PHE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('PHE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('PHE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1435 } ,
('PHE'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1435 } ,
('PHE'  , 'CZ'    ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , 'HZ'    ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('PHE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('PRO'  , '2H'    ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('PRO'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3H'    ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('PRO'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'C'     ) : { 'type' : '7'    , 'charge' :  0.5690 } ,
('PRO'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('PRO'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.5030 } ,
('PRO'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.9060 } ,
('PRO'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('SER'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('SER'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('SER'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('SER'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('SER'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('SER'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('SER'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , 'HG'    ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('SER'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('SER'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('SER'  , 'OG'    ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('THR'  , '1HG'   ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('THR'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('THR'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('THR'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('THR'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('THR'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('THR'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('THR'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('THR'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('THR'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('THR'  , 'OG1'   ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('TRP'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '1HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('TRP'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('TRP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '2HH'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('TRP'  , '2HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('TRP'  , '3HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('TRP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('TRP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('TRP'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('TRP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0000 } ,
('TRP'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1516 } ,
('TRP'  , 'CE3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1810 } ,
('TRP'  , 'CH2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('TRP'  , 'NE1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('TRP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('VAL'  , '1HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '1HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('VAL'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('VAL'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HT'   ) : { 'type' : '41'   , 'charge' :  0.4500 } ,
('VAL'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('VAL'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.5640 } ,
('VAL'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'N'     ) : { 'type' : '26'   , 'charge' : -0.8530 } ,
('VAL'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
}

c_terminal = {
('ALA'  , '1HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ALA'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('ALA'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ALA'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ALA'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ALA'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ALA'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ALA'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ARG'  , '1HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '1HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '2HH1'  ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , '2HH2'  ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('ARG'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ARG'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('ARG'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.3276 } ,
('ARG'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ARG'  , 'CZ'    ) : { 'type' : '2'    , 'charge' :  1.2000 } ,
('ARG'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ARG'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ARG'  , 'HE'    ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('ARG'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ARG'  , 'NE'    ) : { 'type' : '25'   , 'charge' : -0.8443 } ,
('ARG'  , 'NH1'   ) : { 'type' : '25'   , 'charge' : -0.9667 } ,
('ARG'  , 'NH2'   ) : { 'type' : '31'   , 'charge' : -0.9667 } ,
('ARG'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ARG'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ASN'  , '1HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , '2HD2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ASN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('ASN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('ASN'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('ASN'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASN'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ASN'  , 'ND2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('ASN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ASN'  , 'OD1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('ASN'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ASP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ASP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('ASP'  , 'CB'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('ASP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ASP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ASP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ASP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ASP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ASP'  , 'OD1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ASP'  , 'OD2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ASP'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('CYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('CYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('CYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYS'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('CYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYS'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.1800 } ,
('CYS'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('CYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('CYS'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('CYS'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.4100 } ,
('CYX'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('CYX'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('CYX'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('CYX'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('CYX'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('CYX'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('CYX'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('CYX'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('CYX'  , 'SG'    ) : { 'type' : '49'   , 'charge' : -0.2300 } ,
('GLN'  , '1HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '2HE2'  ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('GLN'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('GLN'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLN'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.5690 } ,
('GLN'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0610 } ,
('GLN'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLN'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLN'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('GLN'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.8000 } ,
('GLN'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('GLN'  , 'OE1'   ) : { 'type' : '15'   , 'charge' : -0.5700 } ,
('GLN'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('GLU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('GLU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('GLU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('GLU'  , 'CD'    ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('GLU'  , 'CG'    ) : { 'type' : '3'    , 'charge' : -0.1060 } ,
('GLU'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('GLU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('GLU'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('GLU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('GLU'  , 'OE1'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('GLU'  , 'OE2'   ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('GLU'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('HID'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HID'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HID'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('HID'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('HID'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1800 } ,
('HID'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0772 } ,
('HID'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HID'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.3316 } ,
('HID'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HID'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HID'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HID'  , 'ND1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HID'  , 'NE2'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HID'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('HID'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('HIE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIE'  , '2HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('HIE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('HIE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('HIE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('HIE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('HIE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.0365 } ,
('HIE'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.0462 } ,
('HIE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HIE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HIE'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.5653 } ,
('HIE'  , 'NE2'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('HIE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('HIE'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('HIP'  , '1HD'   ) : { 'type' : '43'   , 'charge' :  0.4500 } ,
('HIP'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('HIP'  , '2HE'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('HIP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('HIP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('HIP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1680 } ,
('HIP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.2000 } ,
('HIP'  , 'CE1'   ) : { 'type' : '2'    , 'charge' :  0.6500 } ,
('HIP'  , 'CG'    ) : { 'type' : '2'    , 'charge' :  0.1820 } ,
('HIP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('HIP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('HIP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('HIP'  , 'ND1'   ) : { 'type' : '25'   , 'charge' : -0.7000 } ,
('HIP'  , 'NE2'   ) : { 'type' : '31'   , 'charge' : -0.7000 } ,
('HIP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('HIP'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('ILE'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('ILE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('ILE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('ILE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('ILE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('ILE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('ILE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('ILE'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('LEU'  , '1HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '1HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '2HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , '3HD2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('LEU'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('LEU'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CD2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LEU'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('LEU'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'HG'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LEU'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('LEU'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('LEU'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('LYS'  , '1HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '2HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , '3HZ'   ) : { 'type' : '44'   , 'charge' :  0.4500 } ,
('LYS'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('LYS'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('LYS'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.5030 } ,
('LYS'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('LYS'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('LYS'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('LYS'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('LYS'  , 'NZ'    ) : { 'type' : '32'   , 'charge' : -0.8530 } ,
('LYS'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('LYS'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('MET'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('MET'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('MET'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('MET'  , 'CE'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.2300 } ,
('MET'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('MET'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('MET'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('MET'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('MET'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('MET'  , 'SD'    ) : { 'type' : '49'   , 'charge' : -0.4600 } ,
('PHE'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '1HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '2HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('PHE'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('PHE'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1435 } ,
('PHE'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CD2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE1'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1435 } ,
('PHE'  , 'CZ'    ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('PHE'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('PHE'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PHE'  , 'HZ'    ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('PHE'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('PHE'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('PHE'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('PRO'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '2HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HD'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , '3HG'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('PRO'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('PRO'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'CD'    ) : { 'type' : '3'    , 'charge' :  0.3001 } ,
('PRO'  , 'CG'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('PRO'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('PRO'  , 'N'     ) : { 'type' : '27'   , 'charge' : -0.6602 } ,
('PRO'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('PRO'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('SER'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('SER'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('SER'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('SER'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('SER'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('SER'  , 'HG'    ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('SER'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('SER'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('SER'  , 'OG'    ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('SER'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('THR'  , '1HG'   ) : { 'type' : '42'   , 'charge' :  0.4000 } ,
('THR'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('THR'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('THR'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.2800 } ,
('THR'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('THR'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('THR'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('THR'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('THR'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('THR'  , 'OG1'   ) : { 'type' : '16'   , 'charge' : -0.6800 } ,
('THR'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('TRP'  , '1HD'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '1HE'   ) : { 'type' : '43'   , 'charge' :  0.2700 } ,
('TRP'  , '2HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '2HH'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '2HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HB'   ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , '3HE'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , '3HZ'   ) : { 'type' : '41'   , 'charge' :  0.1500 } ,
('TRP'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('TRP'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('TRP'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.1810 } ,
('TRP'  , 'CD1'   ) : { 'type' : '2'    , 'charge' : -0.3016 } ,
('TRP'  , 'CD2'   ) : { 'type' : '2'    , 'charge' :  0.0000 } ,
('TRP'  , 'CE2'   ) : { 'type' : '2'    , 'charge' : -0.1516 } ,
('TRP'  , 'CE3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CG'    ) : { 'type' : '2'    , 'charge' : -0.1810 } ,
('TRP'  , 'CH2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ2'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'CZ3'   ) : { 'type' : '2'    , 'charge' : -0.1500 } ,
('TRP'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('TRP'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('TRP'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('TRP'  , 'NE1'   ) : { 'type' : '25'   , 'charge' :  0.0332 } ,
('TRP'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('TRP'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
('VAL'  , '1HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '1HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '2HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HG1'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , '3HG2'  ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'C'     ) : { 'type' : '2'    , 'charge' :  0.9060 } ,
('VAL'  , 'CA'    ) : { 'type' : '3'    , 'charge' :  0.1941 } ,
('VAL'  , 'CB'    ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG1'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'CG2'   ) : { 'type' : '3'    , 'charge' :  0.0000 } ,
('VAL'  , 'H'     ) : { 'type' : '43'   , 'charge' :  0.3700 } ,
('VAL'  , 'HA'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'HB'    ) : { 'type' : '41'   , 'charge' :  0.0000 } ,
('VAL'  , 'N'     ) : { 'type' : '25'   , 'charge' : -0.7301 } ,
('VAL'  , 'O'     ) : { 'type' : '15'   , 'charge' : -0.9000 } ,
('VAL'  , 'OXT'   ) : { 'type' : '18'   , 'charge' : -0.9000 } ,
}

numeric_map = {
    1  : 'C1',
    2  : 'C2',
    3  : 'C3',
    4  : 'CA',
    5  : 'CB',
    6  : 'CC',
    7  : 'CD',
    8  : 'CE',
    9  : 'CF',
    10 : 'CM',
    11 : 'CP',
    12 : 'CR',
    14 : 'C0',
    15 : 'O2',
    16 : 'O3',
    17 : 'OA',
    18 : 'OM',
    19 : 'OW',
    20 : 'OP',
    21 : 'OQ',
    23 : 'O0',
    24 : 'N1',
    25 : 'N2',
    26 : 'N3',
    27 : 'NA',
    28 : 'NB',
    29 : 'NC',
    30 : 'ND',
    31 : 'N4',
    32 : 'N5',
    33 : 'NE',
    34 : 'NF',
    35 : 'NG',
    36 : 'NH',
    37 : 'NI',
    40 : 'N0',
    41 : 'H1',
    42 : 'H2',
    43 : 'H3',
    44 : 'H4',
    45 : 'H5',
    48 : 'H0',
    49 : 'S1',
    50 : 'SA',
    51 : 'SM',
    52 : 'S0',
    53 : 'P0',
    54 : 'B2',
    55 : 'B3',
    56 : 'F0',
    57 : 'Cl',
    58 : 'Br',
    59 : 'I0',
    60 : 'Si',
    61 : 'Du',
    62 : 'Z0',
    63 : 'Lp',
    64 : '00',
    }

alpha_map = {}

for a in numeric_map.keys():
    alpha_map[numeric_map[a]] = a

# convert numeric entries in type definitions above
# alpha-numeric

for a in normal.keys():
    na = normal[a]
    na['type'] = numeric_map[int(na['type'])]

for a in n_terminal.keys():   
    na = n_terminal[a]
    na['type'] = numeric_map[int(na['type'])]

for a in c_terminal.keys():
    na = c_terminal[a]
    na['type'] = numeric_map[int(na['type'])]


def check_sum(dct):
    sm = {}
    for a in dct.keys():
        if not sm.has_key(a[0]):
            sm[a[0]] = dct[a]['charge']
        else:
            sm[a[0]] = sm[a[0]]+ dct[a]['charge']         

    for a in sm.keys():
        print a,'%7.4f'%sm[a]
        
