/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* // just moved the filters here 
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/


package GoGrinder;

import javax.swing.filechooser.FileFilter;
import java.io.File;

public class FileFilters {
  public static GGFileFilter gxpFilter;
  public static GGFileFilter ggsFilter;
  public static GGFileFilter sgfFilter;
  public static GGFileFilter txtFilter;
  public static GGFileFilter wgfFilter;

/**
 *
 * @author  tkington
 */
  public FileFilters(){
    gxpFilter = new GGFileFilter(Messages.getString("gg_export_files"), ".gxp");
    ggsFilter = new GGFileFilter(Messages.getString("gg_state_files"), ".ggs");
    sgfFilter = new GGFileFilter("Smart Game Format files, *.sgf", ".sgf"); 
    txtFilter = new GGFileFilter("Plain text files, *.txt", ".txt");
    wgfFilter = new GGFileFilter(Messages.getString("Main.WGFFiles"), ".wgf");
  }

  // file filter with description (desc) and file name extension (ext)
  static class GGFileFilter extends FileFilter { // javax.swing.filechooser.FileFilter !! NOT java.io.FileFilter
    private String desc;
    private String ext;
    
    GGFileFilter(String desc, String ext) {
        this.desc = desc;
        this.ext = ext;
    }
    
    public String getDescription() { return desc; }
    public String getExt() { return ext; }
    
    public boolean accept(File f) {
        if(f.isDirectory()) return true;
        return f.getName().toLowerCase().endsWith(ext); // toLowerCase: just for identifying the extension
    }
  }

}