/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import com.gentlyweb.utils.ChainException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.StringTokenizer;

public class GeneralUtils {
    public static String GENTLYWEB_EMAIL = "code-monkey@gentlyweb.com";

    public static String getExceptionTraceAsString(Exception e) throws IOException {
        StringWriter sout = new StringWriter();
        PrintWriter pout = new PrintWriter(sout);
        e.printStackTrace(pout);
        pout.println();
        if (e instanceof ChainException) {
            ChainException ee = (ChainException)e;
            ee.printInnerExceptionChain(pout);
        }
        return sout.toString();
    }

    public static void validateIPv4Address(String ipaddress) throws Exception {
        StringTokenizer t = new StringTokenizer(ipaddress, ".");
        if (t.countTokens() != 4) {
            throw new Exception("IP address: " + ipaddress + ", does not consist of 4 parts");
        }
        String octet1 = t.nextToken();
        String octet2 = t.nextToken();
        String octet3 = t.nextToken();
        String lastpart = t.nextToken();
        try {
            int intoctet1 = Integer.parseInt(octet1);
            if (intoctet1 > 223 || intoctet1 < 0) {
                throw new Exception("First octet of IP address: " + ipaddress + " must be in the range 0-223");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("First octet of IP address: " + ipaddress + ", is not a number");
        }
        try {
            int intoctet2 = Integer.parseInt(octet2);
            if (intoctet2 > 255 || intoctet2 < 0) {
                throw new Exception("Second octet of IP address: " + ipaddress + " must be in the range 0-255");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("Second octet of IP address: " + ipaddress + ", is not a number");
        }
        try {
            int intoctet3 = Integer.parseInt(octet3);
            if (intoctet3 > 255 || intoctet3 < 0) {
                throw new Exception("Third octet of IP address: " + ipaddress + " must be in the range 0-255");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("Third octet of IP address: " + ipaddress + ", is not a number");
        }
        try {
            int intlastpart = Integer.parseInt(lastpart);
            if (intlastpart > 254 || intlastpart < 1) {
                throw new Exception("Final octet of IP address: " + ipaddress + " must be in the range 1-254");
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("Final octet of IP address: " + ipaddress + ", is not a number");
        }
    }

    public static void getMethods(Class c, String name, int mods, List ms) {
        if (c == null) {
            return;
        }
        Method[] meths = c.getDeclaredMethods();
        for (int i = 0; i < meths.length; ++i) {
            Method m = meths[i];
            if (!m.getName().equals(name) || (m.getModifiers() & mods) != mods || ms.contains(m)) continue;
            ms.add(m);
        }
        Class sup = c.getSuperclass();
        if (sup != null) {
            GeneralUtils.getMethods(sup, name, mods, ms);
        }
        Class<?>[] ints = c.getInterfaces();
        for (int i = 0; i < ints.length; ++i) {
            Class<?> in = ints[i];
            GeneralUtils.getMethods(in, name, mods, ms);
        }
    }
}

