/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.store;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.apollo.broker.store.DirectBuffer;
import org.apache.activemq.apollo.broker.store.DirectBufferAllocator;
import org.apache.activemq.apollo.broker.store.FileDirectBufferAllocator;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u001f\t\u00193i\u001c8dkJ\u0014XM\u001c;GS2,G)\u001b:fGR\u0014UO\u001a4fe\u0006cGn\\2bi>\u0014(BA\u0002\u0005\u0003\u0015\u0019Ho\u001c:f\u0015\t)a!\u0001\u0004ce>\\WM\u001d\u0006\u0003\u000f!\ta!\u00199pY2|'BA\u0005\u000b\u0003!\t7\r^5wK6\f(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!aa\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!!\u0006#je\u0016\u001cGOQ;gM\u0016\u0014\u0018\t\u001c7pG\u0006$xN\u001d\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005$\u0001\t\u0015\r\u0011\"\u0001%\u0003%!\u0017N]3di>\u0014\u00180F\u0001&!\t1\u0013&D\u0001(\u0015\tAC#\u0001\u0002j_&\u0011!f\n\u0002\u0005\r&dW\r\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003&\u0003)!\u0017N]3di>\u0014\u0018\u0010\t\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004CA\r\u0001\u0011\u0015\u0019S\u00061\u0001&\u0011\u001d\u0019\u0004A1A\u0005\u0006Q\nqbY8oi\u0016DHoX2pk:$XM]\u000b\u0002kA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0007CR|W.[2\u000b\u0005iZ\u0014AC2p]\u000e,(O]3oi*\u0011A\bF\u0001\u0005kRLG.\u0003\u0002?o\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u0011\u0001!\u0002\u001b)\u0014\u0001E2p]R,\u0007\u0010^0d_VtG/\u001a:!\u0011\u001d\u0011\u0005A1A\u0005\u0006\r\u000b\u0001bY8oi\u0016DHo]\u000b\u0002\tB!QI\u0012%L\u001b\u0005I\u0014BA$:\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003#%K!A\u0013\n\u0003\rQC'/Z1e!\tIB*\u0003\u0002N\u0005\tIb)\u001b7f\t&\u0014Xm\u0019;Ck\u001a4WM]!mY>\u001c\u0017\r^8s\u0011\u0019y\u0005\u0001)A\u0007\t\u0006I1m\u001c8uKb$8\u000f\t\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0003\u0019\u0019Gn\\:fIV\t1\u000b\u0005\u0002\u001e)&\u0011QK\b\u0002\b\u0005>|G.Z1o\u0011\u001d9\u0006\u00011A\u0005\u0002a\u000b!b\u00197pg\u0016$w\fJ3r)\tIF\f\u0005\u0002\u001e5&\u00111L\b\u0002\u0005+:LG\u000fC\u0004^-\u0006\u0005\t\u0019A*\u0002\u0007a$\u0013\u0007\u0003\u0004`\u0001\u0001\u0006KaU\u0001\bG2|7/\u001a3!Q\tq\u0016\r\u0005\u0002\u001eE&\u00111M\b\u0002\tm>d\u0017\r^5mK\")Q\r\u0001C\u0001M\u0006)1\r\\8tKR\t\u0011\fC\u0003i\u0001\u0011\u0005\u0011.A\u0003bY2|7\r\u0006\u0002k[B\u0011\u0011d[\u0005\u0003Y\n\u0011A\u0002R5sK\u000e$()\u001e4gKJDQA\\4A\u0002=\fAa]5{KB\u0011Q\u0004]\u0005\u0003cz\u00111!\u00138u\u0001")
public class ConcurrentFileDirectBufferAllocator
implements DirectBufferAllocator,
ScalaObject {
    private final File directory;
    private final AtomicInteger context_counter;
    private final ConcurrentHashMap<Thread, FileDirectBufferAllocator> contexts;
    private volatile boolean closed;

    public File directory() {
        return this.directory;
    }

    public final AtomicInteger context_counter() {
        return this.context_counter;
    }

    public final ConcurrentHashMap<Thread, FileDirectBufferAllocator> contexts() {
        return this.contexts;
    }

    public boolean closed() {
        return this.closed;
    }

    public void closed_$eq(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void close() {
        this.closed_$eq(true);
        JavaConversions$.MODULE$.collectionAsScalaIterable(this.contexts().values()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(FileDirectBufferAllocator fileDirectBufferAllocator) {
                fileDirectBufferAllocator.close();
            }
        });
        this.contexts().clear();
    }

    @Override
    public DirectBuffer alloc(int size) {
        Object object;
        Thread thread = Thread.currentThread();
        FileDirectBufferAllocator ctx = this.contexts().get(thread);
        if (ctx == null) {
            if (this.closed()) {
                throw new IllegalStateException("Stopped");
            }
            int id = this.context_counter().incrementAndGet();
            ctx = new FileDirectBufferAllocator(new File(this.directory(), new StringBuilder().append((Object)"zerocp-").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)".data").toString()));
            object = this.contexts().put(thread, ctx);
        } else {
            object = BoxedUnit.UNIT;
        }
        return ctx.alloc(size);
    }

    public ConcurrentFileDirectBufferAllocator(File directory) {
        this.directory = directory;
        this.context_counter = new AtomicInteger();
        this.contexts = new ConcurrentHashMap();
        this.closed = false;
        directory.mkdirs();
        this.closed_$eq(false);
    }
}

