package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;

import itunes.FieldPair;

import org.cdavies.itunes.*;
import org.cdavies.itunes.hash.*;

public class Itunes45TrackRequest extends Request implements TrackRequest {
	
	private BufferedInputStream _buf;
	private int _requestId;
	
	public Itunes45TrackRequest(String server, int port, int sessionId, int dbId, int trackId, String songFmt, int reqId) {
		
		super(server, port, "databases/" +  dbId  + "/items/" + trackId + "." + songFmt + "?session-id=" + sessionId);
		
		_requestId = reqId;
		
	}
	
	public void constructQuery() {
		
		URL _url = null;
		
		try {
			
			_url = new URL("http://"+server+":"+port+"/"+requestString);
			URLConnection _urlc = _url.openConnection();
			
			_urlc.setRequestProperty("User-Agent", "AppleRecords");
			_urlc.addRequestProperty("Client-DAAP-Access-Index", "2");
			_urlc.addRequestProperty("Client-DAAP-Validation", hash.generateHash("/"+requestString, 2, _requestId));
			_urlc.addRequestProperty("Client-DAAP-Request-ID", new Integer(_requestId).toString());
			_conn = _urlc;
			
		}
		catch (Exception e) {
			
			/* Should never happen */
			_conn = null;
			
		}
		
	}
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
			else if (_len == 0)
				throw new NoServerPermissionException("Cannot get input stream for track");
			
			_buf = new BufferedInputStream(_conn.getInputStream());
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
	public void process() { /* NOOP in this class */  }
	
	public InputStream getInputStream() {
		
		return _buf;
		
	}
	

}
