/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import javax.swing.UIManager;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.utils.RadialGradientPaint;

public class GuiField {
    private boolean m_crossHair;
    private boolean m_cursor;
    private boolean m_lastMoveMarker;
    private boolean m_mark;
    private boolean m_markCircle;
    private boolean m_markSquare;
    private boolean m_markTriangle;
    private boolean m_influenceSet;
    private boolean m_select;
    private static int s_cachedFontFieldSize;
    private int m_paintSizeBlack;
    private int m_paintSizeWhite;
    private int m_size;
    private double m_influence;
    private static final long serialVersionUID = 0L;
    private static final AlphaComposite COMPOSITE_5;
    private static final AlphaComposite COMPOSITE_7;
    private static final AlphaComposite COMPOSITE_95;
    private static final Stroke THICK_STROKE;
    private String m_label = "";
    private Color m_fieldColor;
    private GoColor m_territory = GoColor.EMPTY;
    private static final Color COLOR_INFLUENCE_BLACK;
    private static final Color COLOR_INFLUENCE_WHITE;
    private static final Color COLOR_LAST_MOVE;
    private static final Color COLOR_MARK;
    private static final Color COLOR_STONE_BLACK;
    private static final Color COLOR_STONE_BLACK_BRIGHT;
    private static final Color COLOR_STONE_WHITE;
    private static final Color COLOR_STONE_WHITE_BRIGHT;
    private static Font s_cachedFont;
    private GoColor m_color = GoColor.EMPTY;
    private Graphics m_graphics;
    private Graphics2D m_graphics2D;
    private RadialGradientPaint m_paintBlack;
    private RadialGradientPaint m_paintWhite;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void clearInfluence() {
        this.m_influenceSet = false;
        this.m_influence = 0.0;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, boolean bl) {
        if (!graphics.hitClip(n2, n3, n, n)) {
            return;
        }
        this.m_graphics = graphics.create(n2, n3, n, n);
        this.m_graphics2D = !bl && this.m_graphics instanceof Graphics2D ? (Graphics2D)this.m_graphics : null;
        this.m_size = n;
        if (this.m_fieldColor != null) {
            this.drawFieldColor();
        }
        if (this.m_territory != GoColor.EMPTY && this.m_graphics2D == null) {
            this.drawTerritoryGraphics();
        }
        if (this.m_color != GoColor.EMPTY) {
            this.drawStone();
        }
        if (this.m_territory != GoColor.EMPTY && this.m_graphics2D != null) {
            this.drawTerritoryGraphics2D();
        }
        if (this.m_influenceSet) {
            this.drawInfluence();
        }
        this.drawMarks();
        if (this.m_crossHair) {
            this.drawCrossHair();
        }
        if (this.m_lastMoveMarker) {
            this.drawLastMoveMarker();
        }
        if (this.m_select) {
            this.drawSelect();
        }
        if (this.m_label != null && !this.m_label.equals("")) {
            this.drawLabel();
        }
        if (this.m_cursor) {
            this.drawCursor();
        }
        this.m_graphics = null;
    }

    public GoColor getColor() {
        return this.m_color;
    }

    public boolean getCursor() {
        return this.m_cursor;
    }

    public boolean getCrossHair() {
        return this.m_crossHair;
    }

    public Color getFieldBackground() {
        return this.m_fieldColor;
    }

    public boolean getMark() {
        return this.m_mark;
    }

    public boolean getMarkCircle() {
        return this.m_markCircle;
    }

    public boolean getMarkSquare() {
        return this.m_markSquare;
    }

    public boolean getMarkTriangle() {
        return this.m_markTriangle;
    }

    public boolean getSelect() {
        return this.m_select;
    }

    public static int getStoneMargin(int n) {
        return n / 17;
    }

    public String getLabel() {
        return this.m_label;
    }

    public GoColor getTerritory() {
        return this.m_territory;
    }

    public boolean isInfluenceSet() {
        return this.m_influenceSet;
    }

    public void paintComponent(Graphics graphics) {
    }

    public void setFieldBackground(Color color) {
        this.m_fieldColor = color;
    }

    public void setColor(GoColor goColor) {
        this.m_color = goColor;
    }

    public void setCrossHair(boolean bl) {
        this.m_crossHair = bl;
    }

    public void setCursor(boolean bl) {
        this.m_cursor = bl;
    }

    public void setInfluence(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (d < -1.0) {
            d = -1.0;
        }
        this.m_influence = d;
        this.m_influenceSet = true;
    }

    public void setLastMoveMarker(boolean bl) {
        this.m_lastMoveMarker = bl;
    }

    public void setMark(boolean bl) {
        this.m_mark = bl;
    }

    public void setMarkCircle(boolean bl) {
        this.m_markCircle = bl;
    }

    public void setMarkSquare(boolean bl) {
        this.m_markSquare = bl;
    }

    public void setMarkTriangle(boolean bl) {
        this.m_markTriangle = bl;
    }

    public void setSelect(boolean bl) {
        this.m_select = bl;
    }

    public void setLabel(String string) {
        this.m_label = string;
    }

    public void setTerritory(GoColor goColor) {
        if (!$assertionsDisabled && goColor == null) {
            throw new AssertionError();
        }
        this.m_territory = goColor;
    }

    private void drawCircle(Color color) {
        this.m_graphics.setColor(color);
        int n = this.m_size * 4 / 10;
        int n2 = this.m_size - 2 * n;
        this.m_graphics.fillOval(n, n, n2, n2);
    }

    private void drawCrossHair() {
        this.setComposite(COMPOSITE_7);
        int n = this.m_size / 5;
        int n2 = this.m_size / 2;
        this.m_graphics.setColor(Color.red);
        this.m_graphics.drawLine(n, n2, this.m_size - n, n2);
        this.m_graphics.drawLine(n2, n, n2, this.m_size - n);
        this.m_graphics.setPaintMode();
    }

    private void drawCursor() {
        this.setComposite(COMPOSITE_7);
        int n = this.m_size / 6;
        int n2 = this.m_size;
        int n3 = 2 * n;
        this.m_graphics.setColor(COLOR_LAST_MOVE);
        this.m_graphics.drawLine(n, n, n3, n);
        this.m_graphics.drawLine(n, n, n, n3);
        this.m_graphics.drawLine(n, n2 - n3 - 1, n, n2 - n - 1);
        this.m_graphics.drawLine(n, n2 - n - 1, n3, n2 - n - 1);
        this.m_graphics.drawLine(n2 - n3 - 1, n, n2 - n - 1, n);
        this.m_graphics.drawLine(n2 - n - 1, n, n2 - n - 1, n3);
        this.m_graphics.drawLine(n2 - n - 1, n2 - n - 1, n2 - n - 1, n2 - n3 - 1);
        this.m_graphics.drawLine(n2 - n - 1, n2 - n - 1, n2 - n3 - 1, n2 - n - 1);
        this.m_graphics.setPaintMode();
    }

    private void drawFieldColor() {
        this.setComposite(COMPOSITE_5);
        this.m_graphics.setColor(this.m_fieldColor);
        this.m_graphics.fillRect(0, 0, this.m_size, this.m_size);
        this.m_graphics.setPaintMode();
    }

    private void drawInfluence() {
        double d = Math.abs(this.m_influence);
        if (d < 0.01) {
            return;
        }
        this.setComposite(COMPOSITE_7);
        if (this.m_influence > 0.0) {
            this.m_graphics.setColor(COLOR_INFLUENCE_BLACK);
        } else {
            this.m_graphics.setColor(COLOR_INFLUENCE_WHITE);
        }
        int n = (int)((double)this.m_size * (0.38 + (1.0 - d) * 0.62));
        int n2 = this.m_size - n;
        this.m_graphics.fillRect(n / 2, n / 2, n2, n2);
    }

    private void drawLabel() {
        GuiField.setFont(this.m_graphics, this.m_size);
        FontMetrics fontMetrics = this.m_graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.m_label);
        int n2 = fontMetrics.getAscent();
        int n3 = Math.max((this.m_size - n) / 2, 0);
        int n4 = n2 + (this.m_size - n2) / 2;
        if (this.m_color == GoColor.WHITE) {
            this.m_graphics.setColor(Color.black);
        } else {
            this.m_graphics.setColor(Color.white);
        }
        Rectangle rectangle = null;
        if ((double)n > 0.95 * (double)this.m_size) {
            rectangle = this.m_graphics.getClipBounds();
            this.m_graphics.setClip(rectangle.x, rectangle.y, (int)(0.95 * (double)rectangle.width), rectangle.height);
        }
        this.m_graphics.drawString(this.m_label, n3, n4);
        if (rectangle != null) {
            this.m_graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void drawLastMoveMarker() {
        this.setComposite(COMPOSITE_7);
        this.drawCircle(COLOR_LAST_MOVE);
        this.m_graphics.setPaintMode();
    }

    private void drawMarks() {
        this.setComposite(COMPOSITE_95);
        int n = this.m_size / 4;
        int n2 = this.m_size - 2 * n;
        this.m_graphics.setColor(COLOR_MARK);
        Stroke stroke = null;
        if (this.m_graphics2D != null && this.m_size > 10) {
            stroke = this.m_graphics2D.getStroke();
            this.m_graphics2D.setStroke(THICK_STROKE);
        }
        if (this.m_mark) {
            this.m_graphics.drawLine(n, n, n + n2, n + n2);
            this.m_graphics.drawLine(n, n + n2, n + n2, n);
        }
        if (this.m_markCircle) {
            this.m_graphics.drawOval(n, n, n2 - 1, n2 - 1);
        }
        if (this.m_markSquare) {
            this.m_graphics.drawRect(n, n, n2 - 1, n2 - 1);
        }
        if (this.m_markTriangle) {
            int n3 = (int)(0.866 * (double)n2);
            int n4 = (int)(0.866 * (double)(n2 - n3) / 2.0);
            int n5 = n4 + n3 - 1;
            this.m_graphics.drawLine(n, n + n5, n + n2 / 2, n + n4);
            this.m_graphics.drawLine(n + n2 / 2, n + n4, n + n2, n + n5);
            this.m_graphics.drawLine(n + n2, n + n5, n, n + n5);
        }
        if (stroke != null) {
            this.m_graphics2D.setStroke(stroke);
        }
        this.m_graphics.setPaintMode();
    }

    private void drawSelect() {
        this.setComposite(COMPOSITE_95);
        this.drawCircle(COLOR_MARK);
        this.m_graphics.setPaintMode();
    }

    private void drawStone() {
        if (this.m_color == GoColor.BLACK) {
            this.drawStone(COLOR_STONE_BLACK, COLOR_STONE_BLACK_BRIGHT);
        } else if (this.m_color == GoColor.WHITE) {
            this.drawStone(COLOR_STONE_WHITE, COLOR_STONE_WHITE_BRIGHT);
        }
    }

    private void drawStone(Color color, Color color2) {
        int n = GuiField.getStoneMargin(this.m_size);
        if (this.m_graphics2D != null && this.m_size >= 7) {
            RadialGradientPaint radialGradientPaint = this.getPaint(this.m_color, this.m_size, color, color2);
            this.m_graphics2D.setPaint(radialGradientPaint);
        } else {
            this.m_graphics.setColor(color);
        }
        this.m_graphics.fillOval(n, n, this.m_size - 2 * n, this.m_size - 2 * n);
    }

    private void drawTerritoryGraphics() {
        if (this.m_territory == GoColor.BLACK) {
            this.m_graphics.setColor(Color.darkGray);
        } else {
            if (!$assertionsDisabled && this.m_territory != GoColor.WHITE) {
                throw new AssertionError();
            }
            this.m_graphics.setColor(Color.lightGray);
        }
        this.m_graphics.fillRect(0, 0, this.m_size, this.m_size);
    }

    private void drawTerritoryGraphics2D() {
        this.setComposite(COMPOSITE_5);
        if (this.m_territory == GoColor.BLACK) {
            this.m_graphics2D.setColor(Color.darkGray);
        } else {
            if (!$assertionsDisabled && this.m_territory != GoColor.WHITE) {
                throw new AssertionError();
            }
            this.m_graphics2D.setColor(Color.white);
        }
        this.m_graphics2D.fillRect(0, 0, this.m_size, this.m_size);
        this.m_graphics2D.setPaintMode();
    }

    private RadialGradientPaint getPaint(GoColor goColor, int n, Color color, Color color2) {
        int n2;
        RadialGradientPaint radialGradientPaint;
        if (goColor == GoColor.BLACK) {
            radialGradientPaint = this.m_paintBlack;
            n2 = this.m_paintSizeBlack;
        } else {
            if (!$assertionsDisabled && goColor != GoColor.WHITE) {
                throw new AssertionError();
            }
            radialGradientPaint = this.m_paintWhite;
            n2 = this.m_paintSizeWhite;
        }
        if (n == n2 && radialGradientPaint != null) {
            return radialGradientPaint;
        }
        int n3 = Math.max(n / 3, 1);
        int n4 = n / 3;
        Point2D.Double double_ = new Point2D.Double(n4, n4);
        Point2D.Double double_2 = new Point2D.Double(n3, n3);
        radialGradientPaint = new RadialGradientPaint(double_, color2, double_2, color);
        if (goColor == GoColor.BLACK) {
            this.m_paintBlack = radialGradientPaint;
            this.m_paintSizeBlack = n;
        } else {
            this.m_paintWhite = radialGradientPaint;
            this.m_paintSizeWhite = n;
        }
        return radialGradientPaint;
    }

    private void setComposite(AlphaComposite alphaComposite) {
        if (this.m_graphics2D != null) {
            this.m_graphics2D.setComposite(alphaComposite);
        }
    }

    private static void setFont(Graphics graphics, int n) {
        if (s_cachedFont != null && s_cachedFontFieldSize == n) {
            graphics.setFont(s_cachedFont);
            return;
        }
        Font font = UIManager.getFont("Label.font");
        if (font != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            double d = (double)n / (double)fontMetrics.getAscent() / 2.3;
            if (d < 0.95) {
                int n2 = font.getSize();
                Font font2 = font.deriveFont(1, (float)((double)n2 * d));
                if (font2 != null) {
                    font = font2;
                }
            } else {
                font = font.deriveFont(1);
            }
        }
        s_cachedFont = font;
        s_cachedFontFieldSize = n;
        graphics.setFont(font);
    }

    static {
        $assertionsDisabled = !GuiField.class.desiredAssertionStatus();
        COMPOSITE_5 = AlphaComposite.getInstance(3, 0.5f);
        COMPOSITE_7 = AlphaComposite.getInstance(3, 0.7f);
        COMPOSITE_95 = AlphaComposite.getInstance(3, 0.95f);
        THICK_STROKE = new BasicStroke(2.0f, 1, 0);
        COLOR_INFLUENCE_BLACK = Color.gray;
        COLOR_INFLUENCE_WHITE = Color.white;
        COLOR_LAST_MOVE = Color.decode("#888888");
        COLOR_MARK = Color.decode("#4040ff");
        COLOR_STONE_BLACK = Color.decode("#030303");
        COLOR_STONE_BLACK_BRIGHT = Color.decode("#666666");
        COLOR_STONE_WHITE = Color.decode("#d7d0c9");
        COLOR_STONE_WHITE_BRIGHT = Color.decode("#f6eee6");
    }
}

