/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.server;

import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.ProxyFor;
import com.google.web.bindery.requestfactory.shared.ProxyForName;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.Service;
import com.google.web.bindery.requestfactory.shared.ServiceName;
import com.google.web.bindery.requestfactory.vm.impl.Deobfuscator;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ResolverServiceLayer
extends ServiceLayerDecorator {
    private static Deobfuscator deobfuscator;

    ResolverServiceLayer() {
    }

    private static synchronized void updateDeobfuscator(Class<? extends RequestFactory> clazz, ClassLoader resolveClassesWith) {
        Deobfuscator.Builder builder = Deobfuscator.Builder.load(clazz, resolveClassesWith);
        if (deobfuscator != null) {
            builder.merge(deobfuscator);
        }
        deobfuscator = builder.build();
    }

    @Override
    public ClassLoader getDomainClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Class<? extends BaseProxy> resolveClass(String typeToken) {
        String deobfuscated = deobfuscator.getTypeFromToken(typeToken);
        if (deobfuscated == null) {
            this.die(null, "No type for token %s", typeToken);
        }
        return this.forName(deobfuscated).asSubclass(BaseProxy.class);
    }

    @Override
    public <T> Class<? extends T> resolveClientType(Class<?> domainClass, Class<T> clientClass, boolean required) {
        if (List.class.isAssignableFrom(domainClass)) {
            return List.class.asSubclass(clientClass);
        }
        if (Set.class.isAssignableFrom(domainClass)) {
            return Set.class.asSubclass(clientClass);
        }
        if (Map.class.isAssignableFrom(domainClass)) {
            return Map.class.asSubclass(clientClass);
        }
        if (TypeUtils.isValueType(domainClass)) {
            return domainClass.asSubclass(clientClass);
        }
        Class<T> ret = this.resolveClientType(domainClass, clientClass);
        if (ret == null && required) {
            this.die(null, "The domain type %s cannot be sent to the client", domainClass.getCanonicalName());
        }
        return ret;
    }

    @Override
    public Class<?> resolveDomainClass(Class<?> clazz) {
        if (List.class.equals(clazz)) {
            return List.class;
        }
        if (Set.class.equals(clazz)) {
            return Set.class;
        }
        if (Map.class.equals(clazz)) {
            return Map.class;
        }
        if (BaseProxy.class.isAssignableFrom(clazz)) {
            ProxyFor pf = clazz.getAnnotation(ProxyFor.class);
            if (pf != null) {
                return pf.value();
            }
            ProxyForName pfn = clazz.getAnnotation(ProxyForName.class);
            if (pfn != null) {
                Class<?> toReturn = this.forName(pfn.value());
                return toReturn;
            }
        }
        return (Class)this.die(null, "Could not resolve a domain type for client type %s", clazz.getCanonicalName());
    }

    @Override
    public Method resolveDomainMethod(String operation) {
        Exception ex;
        String domainDescriptor = deobfuscator.getDomainMethodDescriptor(operation);
        if (domainDescriptor == null) {
            return (Method)this.die(null, "No domain method descriptor is mapped to operation %s", operation);
        }
        Class<?>[] domainArgs = this.getArgumentTypes(domainDescriptor);
        Class<? extends RequestContext> requestContext = this.getTop().resolveRequestContext(operation);
        Class<?> serviceImplementation = this.getTop().resolveServiceClass(requestContext);
        Method requestContextMethod = this.getTop().resolveRequestContextMethod(operation);
        try {
            return serviceImplementation.getMethod(requestContextMethod.getName(), domainArgs);
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        return (Method)this.die(ex, "Could not find method in implementation %s matching descriptor %s for operation %s", serviceImplementation.getCanonicalName(), domainDescriptor, operation);
    }

    @Override
    public Class<? extends RequestContext> resolveRequestContext(String operation) {
        String requestContextClass = deobfuscator.getRequestContext(operation);
        if (requestContextClass == null) {
            this.die(null, "No RequestContext for operation %s", operation);
        }
        return this.forName(requestContextClass).asSubclass(RequestContext.class);
    }

    @Override
    public Method resolveRequestContextMethod(String operation) {
        Class<? extends RequestContext> searchIn = this.getTop().resolveRequestContext(operation);
        String methodName = deobfuscator.getRequestContextMethodName(operation);
        String descriptor = deobfuscator.getRequestContextMethodDescriptor(operation);
        Class<?>[] params = this.getArgumentTypes(descriptor);
        try {
            return searchIn.getMethod(methodName, params);
        }
        catch (NoSuchMethodException ex) {
            return (Method)this.report("Could not locate %s operation %s", RequestContext.class.getSimpleName(), operation);
        }
    }

    @Override
    public Class<? extends RequestFactory> resolveRequestFactory(String binaryName) {
        Class<RequestFactory> toReturn = this.forName(binaryName).asSubclass(RequestFactory.class);
        ResolverServiceLayer.updateDeobfuscator(toReturn, this.getTop().getDomainClassLoader());
        return toReturn;
    }

    @Override
    public Class<?> resolveServiceClass(Class<? extends RequestContext> requestContextClass) {
        ServiceName sn;
        Class<?> searchIn = null;
        Service s = requestContextClass.getAnnotation(Service.class);
        if (s != null) {
            searchIn = s.value();
        }
        if ((sn = requestContextClass.getAnnotation(ServiceName.class)) != null) {
            searchIn = this.forName(sn.value());
        }
        if (searchIn == null) {
            this.die(null, "The %s type %s did not specify a service type", RequestContext.class.getSimpleName(), requestContextClass.getCanonicalName());
        }
        return searchIn;
    }

    @Override
    public String resolveTypeToken(Class<? extends BaseProxy> clazz) {
        return OperationKey.hash(clazz.getName());
    }

    private Class<?> forName(String name) {
        try {
            return Class.forName(name, false, this.getTop().getDomainClassLoader());
        }
        catch (ClassNotFoundException e) {
            return (Class)this.die(e, "Could not locate class %s", name);
        }
    }

    private Class<?>[] getArgumentTypes(String descriptor) {
        assert (descriptor.startsWith("(") && descriptor.endsWith(")V"));
        ArrayList params = new ArrayList();
        block13: for (int i = 1; i < descriptor.length() - 2; ++i) {
            switch (descriptor.charAt(i)) {
                case 'Z': {
                    params.add(Boolean.TYPE);
                    continue block13;
                }
                case 'B': {
                    params.add(Byte.TYPE);
                    continue block13;
                }
                case 'C': {
                    params.add(Character.TYPE);
                    continue block13;
                }
                case 'D': {
                    params.add(Double.TYPE);
                    continue block13;
                }
                case 'F': {
                    params.add(Float.TYPE);
                    continue block13;
                }
                case 'I': {
                    params.add(Integer.TYPE);
                    continue block13;
                }
                case 'J': {
                    params.add(Long.TYPE);
                    continue block13;
                }
                case 'S': {
                    params.add(Short.TYPE);
                    continue block13;
                }
                case 'V': {
                    params.add(Void.TYPE);
                    continue block13;
                }
                case 'L': {
                    int end = descriptor.indexOf(59, i);
                    params.add(this.forName(descriptor.substring(i + 1, end).replace('/', '.')));
                    i = end;
                    continue block13;
                }
                case '[': {
                    return (Class[])this.die(null, "Unsupported Type (array) used in operation descriptor: %s", descriptor);
                }
                default: {
                    return (Class[])this.die(null, "Invalid operation descriptor: %s", descriptor);
                }
            }
        }
        return params.toArray(new Class[params.size()]);
    }

    private <T> Class<? extends T> resolveClientType(Class<?> domainClass, Class<T> clientClass) {
        if (domainClass == null) {
            return null;
        }
        List<String> clientTypes = deobfuscator.getClientProxies(domainClass.getName());
        if (clientTypes != null) {
            for (String clientType : clientTypes) {
                Class<?> proxy = this.forName(clientType);
                if (!clientClass.isAssignableFrom(proxy)) continue;
                return proxy.asSubclass(clientClass);
            }
        }
        for (Class<?> toSearch : domainClass.getInterfaces()) {
            Class<T> ret = this.resolveClientType(toSearch, clientClass);
            if (ret == null) continue;
            return ret;
        }
        return this.resolveClientType(domainClass.getSuperclass(), clientClass);
    }
}

