/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class ChannelReader
extends Reader {
    private static final int DEFAULT_BUFFER_CAP = 8192;
    private ReadableByteChannel channel;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.channel.isOpen()) {
            throw new IOException("Reader was already closed.");
        }
        if (this.decoder == null) {
            return -1;
        }
        int n3 = -1;
        if (this.charBuffer.remaining() > 0) {
            n3 = Math.min(n2, this.charBuffer.remaining());
            this.charBuffer.get(cArray, n, n3);
            n += n3;
            n2 -= n3;
        }
        this.charBuffer.compact();
        int n4 = 0;
        boolean bl = false;
        while (n2 != 0) {
            CoderResult coderResult = this.decoder.decode(this.byteBuffer, this.charBuffer, bl);
            if (coderResult.isMalformed() || coderResult.isUnmappable()) {
                coderResult.throwException();
            }
            if (bl) {
                this.decoder = null;
            } else if (coderResult.isUnderflow()) {
                this.byteBuffer.compact();
                if (this.channel.read(this.byteBuffer) == -1) {
                    bl = true;
                }
                this.byteBuffer.flip();
            }
            this.charBuffer.flip();
            n4 = Math.min(n2, this.charBuffer.remaining());
            this.charBuffer.get(cArray, n, n4);
            this.charBuffer.compact();
            n += n4;
            n2 -= n4;
            n3 += n4;
            if (this.decoder == null) break;
        }
        this.charBuffer.flip();
        return n3;
    }

    public void close() throws IOException {
        this.channel.close();
        if (this.decoder != null) {
            this.decoder.reset();
        }
    }

    public ChannelReader(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n) {
        this.channel = readableByteChannel;
        this.decoder = charsetDecoder;
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        charsetDecoder.reset();
        int n2 = n == -1 ? 8192 : n;
        this.byteBuffer = ByteBuffer.allocate(n2);
        this.byteBuffer.flip();
        this.charBuffer = CharBuffer.allocate((int)((float)n2 * charsetDecoder.averageCharsPerByte()));
    }
}

