/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private static final int propertyChangeSupportSerializedDataVersion = 2;
    private Hashtable children;
    private final Object source;
    private transient Vector listeners;

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.addPropertyChangeListener(propertyChangeListenerProxy.propertyName, (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.add(propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy propertyChangeListenerProxy = (PropertyChangeListenerProxy)propertyChangeListener;
            this.removePropertyChangeListener(propertyChangeListenerProxy.propertyName, (PropertyChangeListener)propertyChangeListenerProxy.getListener());
        } else if (this.listeners != null) {
            this.listeners.remove(propertyChangeListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList arrayList = new ArrayList();
        if (this.listeners != null) {
            arrayList.addAll(this.listeners);
        }
        if (this.children != null) {
            int n = this.children.size();
            Iterator iterator = this.children.entrySet().iterator();
            while (--n >= 0) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                Vector vector = ((PropertyChangeSupport)entry.getValue()).listeners;
                int n2 = vector.size();
                while (--n2 >= 0) {
                    arrayList.add(new PropertyChangeListenerProxy(string, (PropertyChangeListener)vector.get(n2)));
                }
            }
        }
        return (PropertyChangeListener[])arrayList.toArray(new PropertyChangeListener[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void addPropertyChangeListener(String var1_1, PropertyChangeListener var2_2) {
        if (var2_2 != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (PropertyChangeListenerProxy)var2_2;
            if (var1_1 == null ? var3_3.propertyName != null : var1_1.equals(var3_3.propertyName) == false) {
                return;
            }
            var2_2 = (PropertyChangeListener)var3_3.getListener();
lbl7:
            // 2 sources

            ** while (var2_2 instanceof PropertyChangeListenerProxy)
        }
lbl8:
        // 1 sources

        var3_3 = null;
        if (this.children == null) {
            this.children = new Hashtable();
        } else {
            var3_3 = (PropertyChangeSupport)this.children.get(var1_1);
        }
        if (var3_3 == null) {
            var3_3 = new PropertyChangeSupport(this.source);
            var3_3.listeners = new Vector();
            this.children.put(var1_1, var3_3);
        }
        var3_3.listeners.add(var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void removePropertyChangeListener(String var1_1, PropertyChangeListener var2_2) {
        if (this.children == null) {
            return;
        }
        var3_3 = (PropertyChangeSupport)this.children.get(var1_1);
        if (var3_3 != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            var4_4 = (PropertyChangeListenerProxy)var2_2;
            if (var1_1 == null ? var4_4.propertyName != null : var1_1.equals(var4_4.propertyName) == false) {
                return;
            }
            var2_2 = (PropertyChangeListener)var4_4.getListener();
lbl10:
            // 2 sources

            ** while (var2_2 instanceof PropertyChangeListenerProxy)
        }
lbl11:
        // 1 sources

        var3_3.listeners.remove(var2_2);
        if (var3_3.listeners.isEmpty()) {
            this.children.remove(var1_1);
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.children == null || string == null) {
            return new PropertyChangeListener[0];
        }
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.children.get(string);
        if (propertyChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return (PropertyChangeListener[])propertyChangeSupport.listeners.toArray(new PropertyChangeListener[propertyChangeSupport.listeners.size()]);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(new PropertyChangeEvent(this.source, string, object, object2));
    }

    public void firePropertyChange(String string, int n, int n2) {
        if (n != n2) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, string, new Integer(n), new Integer(n2)));
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, string, bl, bl2));
        }
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeSupport propertyChangeSupport;
        Hashtable hashtable;
        if (propertyChangeEvent.oldValue != null && propertyChangeEvent.oldValue.equals(propertyChangeEvent.newValue)) {
            return;
        }
        Vector vector = this.listeners;
        if (vector != null) {
            int n = vector.size();
            while (--n >= 0) {
                ((PropertyChangeListener)vector.get(n)).propertyChange(propertyChangeEvent);
            }
        }
        if ((hashtable = this.children) != null && propertyChangeEvent.propertyName != null && (propertyChangeSupport = (PropertyChangeSupport)hashtable.get(propertyChangeEvent.propertyName)) != null) {
            vector = propertyChangeSupport.listeners;
            int n = 0;
            if (vector != null) {
                n = vector.size();
            }
            int n2 = n;
            while (--n2 >= 0) {
                ((PropertyChangeListener)vector.get(n2)).propertyChange(propertyChangeEvent);
            }
        }
    }

    public void fireIndexedPropertyChange(String string, int n, Object object, Object object2) {
        this.firePropertyChange(new IndexedPropertyChangeEvent(this.source, string, object, object2, n));
    }

    public void fireIndexedPropertyChange(String string, int n, int n2, int n3) {
        if (n2 != n3) {
            this.fireIndexedPropertyChange(string, n, (Object)n2, (Object)n3);
        }
    }

    public void fireIndexedPropertyChange(String string, int n, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.fireIndexedPropertyChange(string, n, (Object)bl, (Object)bl2);
        }
    }

    public synchronized boolean hasListeners(String string) {
        boolean bl = false;
        if (this.listeners != null || this.children != null && this.children.get(string) != null) {
            bl = true;
        }
        return bl;
    }

    private final synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.listeners != null) {
            int n = this.listeners.size();
            while (--n >= 0) {
                if (!(this.listeners.get(n) instanceof Serializable)) continue;
                objectOutputStream.writeObject(this.listeners.get(n));
            }
        }
        objectOutputStream.writeObject(null);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectInputStream.readObject();
        while (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
            propertyChangeListener = (PropertyChangeListener)objectInputStream.readObject();
        }
        if (this.children != null) {
            int n = this.children.size();
            Iterator iterator = this.children.entrySet().iterator();
            while (--n >= 0) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)entry.getValue();
                if (propertyChangeSupport.listeners == null) {
                    propertyChangeSupport.listeners = new Vector();
                }
                if (propertyChangeSupport.children != null) {
                    propertyChangeSupport.listeners.addAll(Arrays.asList(propertyChangeSupport.getPropertyChangeListeners(string)));
                }
                if (propertyChangeSupport.listeners.size() == 0) {
                    iterator.remove();
                    continue;
                }
                propertyChangeSupport.children = null;
            }
            if (this.children.size() == 0) {
                this.children = null;
            }
        }
    }

    public PropertyChangeSupport(Object object) {
        this.source = object;
        if (object == null) {
            throw new NullPointerException();
        }
    }
}

