/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.net.VMInetAddress;
import java.util.HashMap;
import java.util.StringTokenizer;

public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int DEFAULT_CACHE_SIZE = 89;
    private static final int DEFAULT_CACHE_PERIOD = 240;
    private static final int DEFAULT_CACHE_PURGE_PCT = 30;
    private static final String LOCALHOST_NAME = "localhost";
    private static InetAddress inaddr_any;
    static InetAddress ANY_IF;
    static InetAddress LOCALHOST;
    private static int cache_size;
    private static int cache_period;
    private static int cache_purge_pct;
    private static HashMap cache;
    private int address;
    transient byte[] addr;
    String hostName;
    transient long lookup_time;
    int family;

    public boolean isMulticastAddress() {
        if (this.addr.length == 4) {
            boolean bl = false;
            if ((this.addr[0] & 0xF0) == 224) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean isAnyLocalAddress() {
        return this.equals(ANY_IF);
    }

    public boolean isLoopbackAddress() {
        boolean bl = false;
        if ((this.addr[0] & 0xFF) == 127) {
            bl = true;
        }
        return bl;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        if ((this.addr[0] & 0xFF) == 10) {
            return true;
        }
        if ((this.addr[0] & 0xFF) == 172 && (this.addr[1] & 0xF0) == 16) {
            return true;
        }
        return (this.addr[0] & 0xFF) == 192 && (this.addr[1] & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        boolean bl = false;
        if ((this.addr[0] & 0xFF) == 224 && (this.addr[1] & 0xFF) == 0 && (this.addr[2] & 0xFF) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public String getHostName() {
        if (this.hostName != null) {
            return this.hostName;
        }
        try {
            this.hostName = VMInetAddress.getHostByAddr(this.addr);
            return this.hostName;
        }
        catch (UnknownHostException unknownHostException) {
            return this.getHostAddress();
        }
    }

    public String getCanonicalHostName() {
        byte[] byArray;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkConnect(this.hostName, -1);
            }
            catch (SecurityException securityException) {
                return this.getHostAddress();
            }
        }
        InetAddress inetAddress = (byArray = this.getAddress()).length == 16 ? new Inet6Address(this.getAddress(), null) : new Inet4Address(this.getAddress(), null);
        return inetAddress.getHostName();
    }

    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.addr.length;
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.addr[n2] & 0xFF);
            if (++n2 == n) break;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.addr.length;
        int n3 = 0;
        if (n2 > 4) {
            n3 = n2 - 4;
        }
        int n4 = n3;
        while (n4 < n2) {
            n = n << 8 | this.addr[n4] & 0xFF;
            ++n4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InetAddress)) {
            return false;
        }
        byte[] byArray = ((InetAddress)object).addr;
        if (this.addr.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.addr.length) {
            if (this.addr[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        String string = this.getHostAddress();
        String string2 = this.hostName != null ? this.hostName : "";
        return string2 + '/' + string;
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (byArray.length == 4) {
            return new Inet4Address(byArray, string);
        }
        if (byArray.length == 16) {
            return new Inet6Address(byArray, string);
        }
        throw new UnknownHostException("IP address has illegal length");
    }

    private static final byte[] aton(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() == 4) {
            byte[] byArray = new byte[4];
            int n = 0;
            while (n < 4) {
                try {
                    short s = Short.parseShort(stringTokenizer.nextToken());
                    if (s < 0 || s > 255) break;
                    byArray[n] = (byte)s;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                ++n;
            }
            if (n == 4) {
                return byArray;
            }
        }
        return null;
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        return inetAddressArray[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(string, -1);
        }
        if (string == null || string.equals("")) {
            string = LOCALHOST_NAME;
        }
        if (string.equals(LOCALHOST_NAME)) {
            InetAddress[] inetAddressArray = new InetAddress[]{LOCALHOST};
            return inetAddressArray;
        }
        InetAddress[] inetAddressArray = InetAddress.checkCacheFor(string);
        if (inetAddressArray != null) {
            return inetAddressArray;
        }
        byte[][] byArray = VMInetAddress.getHostByName(string);
        if (byArray.length == 0) {
            throw new UnknownHostException(string);
        }
        inetAddressArray = new InetAddress[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n].length != 4 && byArray[n].length != 16) {
                throw new UnknownHostException(string);
            }
            inetAddressArray[n] = byArray[n].length == 16 ? new Inet6Address(byArray[n], string) : new Inet4Address(byArray[n], string);
            ++n;
        }
        InetAddress.addToCache(string, inetAddressArray);
        return inetAddressArray;
    }

    private static final synchronized InetAddress[] checkCacheFor(String string) {
        InetAddress[] inetAddressArray = null;
        if (cache_size == 0) {
            return null;
        }
        Object object = cache.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof InetAddress[]) {
            inetAddressArray = (InetAddress[])object;
        }
        if (inetAddressArray == null) {
            return null;
        }
        if (cache_period != -1 && System.currentTimeMillis() - inetAddressArray[0].lookup_time > (long)cache_period) {
            cache.remove(string);
            return null;
        }
        return inetAddressArray;
    }

    private static final synchronized void addToCache(String string, Object object) {
        if (cache_size == 0) {
            return;
        }
        if (cache_size != -1) {
            cache.size();
        }
        cache.put(string, object);
    }

    static InetAddress getInaddrAny() throws UnknownHostException {
        if (inaddr_any == null) {
            byte[] byArray = VMInetAddress.lookupInaddrAny();
            inaddr_any = new Inet4Address(byArray, null);
        }
        return inaddr_any;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        String string = VMInetAddress.getLocalHostname();
        return InetAddress.getByName(string);
    }

    private final void readResolve() throws ObjectStreamException {
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.addr = new byte[4];
        this.addr[3] = (byte)this.address;
        int n = 2;
        while (n >= 0) {
            this.addr[n] = (byte)(this.address >>= 8);
            --n;
        }
        this.family = 2;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.addr.length;
        int n2 = n - 4;
        while (n2 < n) {
            this.address = this.address << 8 | this.addr[n2] & 0xFF;
            ++n2;
        }
        objectOutputStream.defaultWriteObject();
    }

    InetAddress(byte[] byArray, String string) {
        this.addr = byArray == null ? null : (byte[])byArray.clone();
        this.hostName = string;
        this.lookup_time = System.currentTimeMillis();
        this.family = 2;
    }

    static {
        cache_size = 0;
        cache_period = 0;
        cache_purge_pct = 0;
        cache_size = Integer.getInteger("gnu.java.net.dns_cache_size", 89);
        cache_period = Integer.getInteger("gnu.java.net.dns_cache_period", 14400000);
        cache_purge_pct = Integer.getInteger("gnu.java.net.dns_cache_purge_pct", 30);
        if (cache_purge_pct < 1 || cache_purge_pct > 100) {
            cache_purge_pct = 30;
        }
        if (cache_size != 0) {
            cache = new HashMap(cache_size);
        }
        try {
            ANY_IF = InetAddress.getInaddrAny();
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            byte[] byArray2 = byArray;
            LOCALHOST = new Inet4Address(byArray2, LOCALHOST_NAME);
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            ANY_IF = new Inet4Address(byArray, "0.0.0.0");
        }
    }
}

