/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.activation.ActivationSystemTransient;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.UnicastRemoteObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ActivationGroup
extends UnicastRemoteObject
implements ActivationInstantiator {
    static final long serialVersionUID = -7696947875314805420L;
    static ActivationGroupID currentGroupId;
    static ActivationSystem system;
    static final Class[] cConstructorTypes;
    final ActivationGroupID groupId;
    ActivationMonitor monitor;
    long incarnation;
    static /* synthetic */ Class class$java$rmi$activation$ActivationGroupID;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;
    static /* synthetic */ Class class$gnu$java$rmi$activation$DefaultActivationGroup;

    public abstract void activeObject(ActivationID var1, Remote var2) throws ActivationException, UnknownObjectException, RemoteException;

    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveObject(activationID);
        }
        return true;
    }

    public static ActivationGroup createGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, long l) throws ActivationException {
        Class clazz;
        Object object;
        ActivationGroup activationGroup = null;
        if (activationGroupDesc.className != null) {
            try {
                object = Thread.currentThread().getContextClassLoader();
                clazz = ((ClassLoader)object).loadClass(activationGroupDesc.className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ActivationException activationException = new ActivationException("Cannot load " + activationGroupDesc.className);
                activationException.initCause(classNotFoundException);
                throw activationException;
            }
        } else {
            Class clazz2 = class$gnu$java$rmi$activation$DefaultActivationGroup;
            if (clazz2 == null) {
                clazz2 = class$gnu$java$rmi$activation$DefaultActivationGroup = ActivationGroup.class("[Lgnu.java.rmi.activation.DefaultActivationGroup;", false);
            }
            clazz = clazz2;
        }
        try {
            object = clazz.getConstructor(cConstructorTypes);
            activationGroup = (ActivationGroup)((Constructor)object).newInstance(new Object[]{activationGroupID, activationGroupDesc.data});
        }
        catch (Exception exception) {
            ActivationException activationException = new ActivationException("Cannot instantiate " + activationGroupDesc.className);
            activationException.initCause(exception);
            throw activationException;
        }
        currentGroupId = activationGroupID;
        try {
            activationGroup.monitor = ActivationGroup.getSystem().activeGroup(activationGroupID, activationGroup, l);
            return activationGroup;
        }
        catch (RemoteException remoteException) {
            ActivationException activationException = new ActivationException("createGroup");
            activationException.initCause(remoteException);
            throw activationException;
        }
    }

    public static ActivationGroupID currentGroupID() {
        try {
            if (currentGroupId == null) {
                ActivationGroup.setSystem(ActivationSystemTransient.getInstance());
            }
        }
        catch (ActivationException activationException) {
            InternalError internalError = new InternalError("Unable to activate AS");
            internalError.initCause(activationException);
            throw internalError;
        }
        return currentGroupId;
    }

    public static void setSystem(ActivationSystem activationSystem) throws ActivationException {
        if (currentGroupId != null) {
            throw new ActivationException("Group active");
        }
        try {
            system = activationSystem;
            Class clazz = class$gnu$java$rmi$activation$DefaultActivationGroup;
            if (clazz == null) {
                clazz = class$gnu$java$rmi$activation$DefaultActivationGroup = ActivationGroup.class("[Lgnu.java.rmi.activation.DefaultActivationGroup;", false);
            }
            ActivationGroupDesc activationGroupDesc = new ActivationGroupDesc(clazz.getName(), "", null, null, null);
            currentGroupId = system.registerGroup(activationGroupDesc);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Unable to start default AG");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static ActivationSystem getSystem() throws ActivationException {
        if (system == null) {
            return DefaultActivationSystem.singleton;
        }
        return system;
    }

    protected void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws ActivationException, UnknownObjectException, RemoteException {
        if (this.monitor != null) {
            this.monitor.activeObject(activationID, marshalledObject);
        }
        activationID.group = this;
    }

    protected void inactiveGroup() throws UnknownGroupException, RemoteException {
        if (this.monitor != null) {
            this.monitor.inactiveGroup(this.groupId, this.incarnation);
        }
        if (currentGroupId != null && currentGroupId.equals(this.groupId)) {
            currentGroupId = null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected ActivationGroup(ActivationGroupID activationGroupID) throws RemoteException {
        this.groupId = activationGroupID;
    }

    static {
        Class clazz;
        currentGroupId = null;
        Class[] classArray = new Class[2];
        Class clazz2 = class$java$rmi$activation$ActivationGroupID;
        if (clazz2 == null) {
            clazz2 = classArray[0] = (class$java$rmi$activation$ActivationGroupID = ActivationGroup.class("[Ljava.rmi.activation.ActivationGroupID;", false));
        }
        if ((clazz = class$java$rmi$MarshalledObject) == null) {
            clazz = class$java$rmi$MarshalledObject = ActivationGroup.class("[Ljava.rmi.MarshalledObject;", false);
        }
        classArray[1] = clazz;
        cConstructorTypes = classArray;
    }
}

