/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import java.io.File;
import vcf.Marker;
import vcf.Markers;
import vcf.PlinkGenMap;
import vcf.PositionMap;

public interface GeneticMap {
    public int basePos(int var1, double var2);

    public double genPos(Marker var1);

    public double genPos(int var1, int var2);

    public String toString();

    public static GeneticMap geneticMap(File file, ChromInterval chromInterval) {
        if (file == null) {
            double d = 1.0E-6;
            return new PositionMap(d);
        }
        if (chromInterval == null) {
            return PlinkGenMap.fromPlinkMapFile(file);
        }
        return PlinkGenMap.fromPlinkMapFile(file, chromInterval.chrom());
    }

    public static double[] genPos(GeneticMap geneticMap, Markers markers) {
        if (markers.marker(0).chromIndex() != markers.marker(markers.size() - 1).chromIndex()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        double[] dArray = new double[markers.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = geneticMap.genPos(markers.marker(i));
        }
        return dArray;
    }

    public static double[] genPos(GeneticMap geneticMap, double d, Markers markers) {
        if (markers.marker(0).chromIndex() != markers.marker(markers.size() - 1).chromIndex()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        if (!Double.isFinite(d)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
        double[] dArray = new double[markers.size()];
        dArray[0] = geneticMap.genPos(markers.marker(0));
        double d2 = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            double d3 = geneticMap.genPos(markers.marker(i));
            double d4 = Math.max(d3 - d2, d);
            dArray[i] = dArray[i - 1] + d4;
            d2 = d3;
        }
        return dArray;
    }
}

