/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.igoweb.util.xml.WeakPool;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XhtmlValidator {
    private final DocumentBuilderFactory factory;
    private final WeakPool<DocumentBuilder> builderPool = new WeakPool();
    private final Object lock = new Object();

    public XhtmlValidator() {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setValidating(true);
    }

    public static String wrapXhtmlBody(String body) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"application/xhtml+xml;charset=UTF-8\"/><title>Default title</title></head><body>" + body + "</body></html>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validate(String xhtml) {
        try {
            DocumentBuilder builder = this.builderPool.remove();
            if (builder == null) {
                Object object = this.lock;
                synchronized (object) {
                    builder = this.factory.newDocumentBuilder();
                }
                builder.setErrorHandler(new ValidatingErrorHandler());
                builder.setEntityResolver(new LocalizingEntityResolver());
            }
            builder.parse(new ByteArrayInputStream(xhtml.getBytes("UTF-8")));
            this.builderPool.add(builder);
            return null;
        }
        catch (SAXException excep) {
            return excep.getMessage() == null ? excep.toString() : excep.getMessage();
        }
        catch (ParserConfigurationException excep) {
            throw new RuntimeException(excep);
        }
        catch (UnsupportedEncodingException excep) {
            throw new RuntimeException("Doesn't know UTF-8?");
        }
        catch (IOException excep) {
            throw new RuntimeException("I/O error validating text", excep);
        }
    }

    private static class ValidatingErrorHandler
    implements ErrorHandler {
        private ValidatingErrorHandler() {
        }

        @Override
        public void error(SAXParseException excep) throws SAXParseException {
            throw excep;
        }

        @Override
        public void fatalError(SAXParseException excep) throws SAXParseException {
            throw excep;
        }

        @Override
        public void warning(SAXParseException excep) {
        }
    }

    private static class LocalizingEntityResolver
    implements EntityResolver {
        private LocalizingEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputStream in = this.getClass().getResourceAsStream(systemId.substring(systemId.lastIndexOf(47) + 1));
            if (in == null) {
                throw new SAXException("Can't find entity: " + systemId);
            }
            InputSource result = new InputSource(in);
            result.setPublicId(publicId);
            result.setSystemId(systemId);
            return result;
        }
    }
}

