/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpterminal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpClient;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.sgf.SgfReader;
import net.sf.gogui.sgf.SgfWriter;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public class GtpTerminal
implements GtpClient.IOCallback {
    private final boolean m_verbose;
    private Board m_board;
    private GameTree m_gameTree;
    private final GtpClient m_gtp;
    private Node m_currentNode;

    public GtpTerminal(String string, int n, boolean bl) throws Exception {
        if (string.equals("")) {
            throw new Exception("No program set");
        }
        this.m_verbose = bl;
        this.m_gtp = new GtpClient(string, bl, this);
        this.m_gtp.queryProtocolVersion();
        this.m_gtp.querySupportedCommands();
        this.initGame(n);
    }

    public void close() {
        this.m_gtp.close();
        this.m_gtp.waitForExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mainLoop() throws IOException {
        this.newGame(this.m_board.getSize());
        this.printBoard();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string;
            do {
                System.out.print("> ");
                string = bufferedReader.readLine();
                if (string != null) continue;
                break;
            } while ((string = string.trim()).equals("") || !this.handleCommand(string));
        }
        finally {
            System.out.println();
        }
    }

    public void receivedInvalidResponse(String string) {
        System.out.print(string);
    }

    public void receivedResponse(boolean bl, String string) {
    }

    public void receivedStdErr(String string) {
        if (!this.m_verbose) {
            System.err.print(string);
        }
    }

    public void sentCommand(String string) {
    }

    private void cmdPlay(GoPoint goPoint) {
        if (!this.cmdPlay(this.m_board.getToMove(), goPoint)) {
            return;
        }
        this.printBoard();
        this.genmove();
    }

    private boolean cmdPlay(GoColor goColor, GoPoint goPoint) {
        StringBuffer stringBuffer;
        String string = this.m_gtp.getCommandPlay(Move.get(goPoint, goColor));
        if (!this.send(string, stringBuffer = new StringBuffer())) {
            System.out.println(stringBuffer);
            return false;
        }
        this.play(Move.get(goPoint, goColor));
        return true;
    }

    private void genmove() {
        StringBuffer stringBuffer;
        GoColor goColor = this.m_board.getToMove();
        String string = this.m_gtp.getCommandGenmove(goColor);
        if (!this.send(string, stringBuffer = new StringBuffer())) {
            System.out.println(stringBuffer);
            return;
        }
        try {
            GoPoint goPoint = GtpUtils.parsePoint(stringBuffer.toString(), this.m_board.getSize());
            System.out.println("Computer move: " + GoPoint.toString(goPoint));
            this.play(Move.get(goPoint, goColor));
            this.printBoard();
        }
        catch (GtpError gtpError) {
            System.out.println(stringBuffer);
        }
    }

    private boolean handleCommand(String string) {
        String[] stringArray = StringUtils.splitArguments(string);
        String string2 = stringArray[0];
        if (string2.equals("quit")) {
            this.send("quit");
            return true;
        }
        if (string2.equals("genmove")) {
            this.genmove();
        } else if (string2.equals("help")) {
            this.help();
        } else if (string2.equals("list")) {
            this.listCommands();
        } else if (string2.equals("load")) {
            this.load(stringArray);
        } else if (string2.equals("newgame")) {
            this.newGame(stringArray);
        } else if (string2.equals("save")) {
            this.save(stringArray);
        } else if (string2.equals("undo")) {
            this.undo();
        } else if (string2.equals("black") || string2.equals("boardsize") || string2.equals("clear_board") || string2.equals("genmove_white") || string2.equals("genmove_black") || string2.equals("white")) {
            System.out.println("Command not allowed");
        } else {
            try {
                GoPoint goPoint = GtpUtils.parsePoint(string, this.m_board.getSize());
                this.cmdPlay(goPoint);
            }
            catch (GtpError gtpError) {
                StringBuffer stringBuffer = new StringBuffer();
                this.send(string, stringBuffer);
                System.out.println(stringBuffer);
            }
        }
        return false;
    }

    private void help() {
        System.out.print("Enter a move or one of the following commands:\n  genmove\n  help\n  load\n  list\n  newgame\n  save\n  undo\n  quit\nThe following commands are not allowed:\n  black, boardsize, clear_board, genmove_black\n  genmove_white, white\nOther commands are forwarded to the program.\n");
    }

    private void initGame(int n) {
        this.m_board = new Board(n);
        this.m_gameTree = new GameTree(n, 0.0, null, null, null);
        this.m_currentNode = this.m_gameTree.getRoot();
    }

    private void listCommands() {
        try {
            this.m_gtp.querySupportedCommands();
        }
        catch (GtpError gtpError) {
            System.out.println(gtpError.getMessage());
            return;
        }
        ArrayList arrayList = this.m_gtp.getSupportedCommands();
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println((String)arrayList.get(i));
        }
    }

    private void load(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Need filename argument");
            return;
        }
        File file = new File(stringArray[1]);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            SgfReader sgfReader = new SgfReader(fileInputStream, file.toString(), null, 0L);
            String string = sgfReader.getWarnings();
            if (string != null) {
                System.out.print(string);
            }
            GameTree gameTree = sgfReader.getGameTree();
            GameInformation gameInformation = gameTree.getGameInformation();
            if (gameInformation.m_handicap > 0) {
                System.out.println("Handicap games not supported");
                return;
            }
            if (!this.newGame(gameInformation.m_boardSize)) {
                return;
            }
            this.send("komi " + gameInformation.m_komi);
            for (Node node = gameTree.getRoot(); node != null; node = node.getChild()) {
                int n;
                for (n = 0; n < node.getNumberAddBlack(); ++n) {
                    if (this.cmdPlay(GoColor.BLACK, node.getAddBlack(n))) continue;
                    return;
                }
                for (n = 0; n < node.getNumberAddWhite(); ++n) {
                    if (this.cmdPlay(GoColor.WHITE, node.getAddWhite(n))) continue;
                    return;
                }
                Move move = node.getMove();
                if (move == null || this.cmdPlay(move.getColor(), move.getPoint())) continue;
                return;
            }
            this.printBoard();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + file);
        }
        catch (SgfReader.SgfError sgfError) {
            System.out.println("Could not read file " + file + ": " + sgfError.getMessage());
        }
    }

    private boolean newGame(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_gtp.getCommandBoardsize(n);
        if (string != null && !this.send(string, stringBuffer)) {
            System.out.println(stringBuffer);
            return false;
        }
        string = this.m_gtp.getCommandClearBoard(n);
        if (!this.send(string, stringBuffer)) {
            System.out.println(stringBuffer);
            return false;
        }
        this.initGame(n);
        return true;
    }

    private void newGame(String[] stringArray) {
        int n = this.m_board.getSize();
        if (stringArray.length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.newGame(n);
        this.printBoard();
    }

    private void play(Move move) {
        this.m_board.play(move);
        Node node = new Node(move);
        this.m_currentNode.append(node);
        this.m_currentNode = node;
    }

    private void printBoard() {
        BoardUtils.print(this.m_board, System.out, true);
    }

    private void save(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Need filename argument");
            return;
        }
        File file = new File(stringArray[1]);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            new SgfWriter((OutputStream)fileOutputStream, this.m_gameTree, "GtpTerminal", Version.get());
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Write error");
            return;
        }
    }

    private String send(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.send(string, stringBuffer);
        return stringBuffer.toString();
    }

    private boolean send(String string, StringBuffer stringBuffer) {
        try {
            stringBuffer.append(this.m_gtp.send(string));
            return true;
        }
        catch (GtpError gtpError) {
            stringBuffer.append(gtpError.getMessage());
            return false;
        }
    }

    private void undo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.send("undo", stringBuffer)) {
            System.out.println(stringBuffer);
            return;
        }
        this.m_board.undo();
        this.m_currentNode = this.m_currentNode.getFather();
        this.printBoard();
    }
}

