/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import java.nio.ByteBuffer;

public class ProfileHeader {
    private static final int icMagicNumber = 1633907568;
    private static final int[] csTypeMap;
    public static final int HEADERSIZE = 128;
    private static final int[] classMap;
    private int size;
    private int cmmId;
    private int majorVersion;
    private int minorVersion;
    private int profileClass;
    private int colorSpace;
    private int profileColorSpace;
    private byte[] timestamp;
    private int platform;
    private int flags;
    private int magic;
    private int manufacturerSig;
    private int modelSig;
    private byte[] attributes;
    private int intent;
    private byte[] illuminant;
    private int creatorSig;

    public void verifyHeader(int n) throws IllegalArgumentException {
        if (n != -1 && this.size != n) {
            throw new IllegalArgumentException("Invalid profile length:" + n);
        }
        if (this.majorVersion != 2) {
            throw new IllegalArgumentException("Wrong major version number:" + this.majorVersion);
        }
        if (this.profileClass == -1) {
            throw new IllegalArgumentException("Invalid profile/device class");
        }
        if (this.colorSpace == -1) {
            throw new IllegalArgumentException("Invalid colorspace");
        }
        if (this.profileColorSpace == -1) {
            throw new IllegalArgumentException("Invalid PCS.");
        }
        if (this.magic != 1633907568) {
            throw new IllegalArgumentException("Invalid magic number!");
        }
    }

    public byte[] getData(int n) {
        byte[] byArray = new byte[128];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(0, n);
        byteBuffer.putInt(4, this.cmmId);
        byteBuffer.putShort(8, (short)(this.majorVersion << 8 | this.minorVersion));
        int n2 = 1;
        while (n2 < classMap.length) {
            if (this.profileClass == classMap[n2]) {
                byteBuffer.putInt(12, classMap[n2 - 1]);
            }
            n2 += 2;
        }
        n2 = 1;
        while (n2 < csTypeMap.length) {
            if (csTypeMap[n2] == this.colorSpace) {
                byteBuffer.putInt(16, csTypeMap[n2 - 1]);
            }
            n2 += 2;
        }
        n2 = 1;
        while (n2 < csTypeMap.length) {
            if (csTypeMap[n2] == this.profileColorSpace) {
                byteBuffer.putInt(20, csTypeMap[n2 - 1]);
            }
            n2 += 2;
        }
        System.arraycopy(this.timestamp, 0, byArray, 24, this.timestamp.length);
        byteBuffer.putInt(36, 1633907568);
        byteBuffer.putInt(40, this.platform);
        byteBuffer.putInt(44, this.flags);
        byteBuffer.putInt(48, this.manufacturerSig);
        byteBuffer.putInt(52, this.modelSig);
        System.arraycopy(this.attributes, 0, byArray, 56, this.attributes.length);
        byteBuffer.putInt(64, this.intent);
        System.arraycopy(this.illuminant, 0, byArray, 68, this.illuminant.length);
        byteBuffer.putInt(80, this.creatorSig);
        return byteBuffer.array();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getProfileClass() {
        return this.profileClass;
    }

    public void setProfileClass(int n) {
        this.profileClass = n;
    }

    public int getColorSpace() {
        return this.colorSpace;
    }

    public int getProfileColorSpace() {
        return this.profileColorSpace;
    }

    public void setColorSpace(int n) {
        this.colorSpace = n;
    }

    public void setProfileColorSpace(int n) {
        this.profileColorSpace = n;
    }

    public ProfileHeader() {
        this.creatorSig = 0;
        this.intent = 0;
        this.manufacturerSig = 1852796517;
        this.modelSig = 1852796517;
        this.magic = 1633907568;
        this.cmmId = 0;
        this.platform = 0;
        this.timestamp = new byte[8];
        this.majorVersion = 2;
        this.minorVersion = 16;
        this.flags = 0;
        byte[] byArray = new byte[12];
        byArray[2] = -10;
        byArray[3] = -42;
        byArray[5] = 1;
        byArray[10] = -45;
        byArray[11] = 45;
        this.illuminant = byArray;
        this.attributes = new byte[8];
        this.profileClass = 1;
    }

    public ProfileHeader(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.size = byteBuffer.getInt(0);
        this.cmmId = byteBuffer.getInt(4);
        this.majorVersion = byArray[8];
        this.minorVersion = byArray[9];
        int n = byteBuffer.getInt(12);
        this.profileClass = -1;
        int n2 = 0;
        while (n2 < classMap.length) {
            if (classMap[n2] == n) {
                this.profileClass = classMap[n2 + 1];
                break;
            }
            n2 += 2;
        }
        n2 = byteBuffer.getInt(16);
        this.colorSpace = -1;
        int n3 = 0;
        while (n3 < csTypeMap.length) {
            if (csTypeMap[n3] == n2) {
                this.colorSpace = csTypeMap[n3 + 1];
                break;
            }
            n3 += 2;
        }
        n3 = byteBuffer.getInt(20);
        this.profileColorSpace = -1;
        if (this.profileClass != 3) {
            if (n3 == 1482250784) {
                this.profileColorSpace = 0;
            }
            if (n3 == 1281450528) {
                this.profileColorSpace = 1;
            }
        } else {
            int n4 = 0;
            while (n4 < csTypeMap.length) {
                if (csTypeMap[n4] == n3) {
                    this.profileColorSpace = csTypeMap[n4 + 1];
                    break;
                }
                n4 += 2;
            }
        }
        this.timestamp = new byte[8];
        System.arraycopy(byArray, 24, this.timestamp, 0, 8);
        this.magic = byteBuffer.getInt(36);
        this.platform = byteBuffer.getInt(40);
        this.flags = byteBuffer.getInt(44);
        this.manufacturerSig = byteBuffer.getInt(48);
        this.modelSig = byteBuffer.getInt(52);
        this.attributes = new byte[8];
        System.arraycopy(byArray, 56, this.attributes, 0, 8);
        this.intent = byteBuffer.getInt(64);
        this.illuminant = new byte[12];
        System.arraycopy(byArray, 68, this.illuminant, 0, 12);
        this.creatorSig = byteBuffer.getInt(80);
    }

    static {
        int[] nArray = new int[50];
        nArray[0] = 1482250784;
        nArray[2] = 1281450528;
        nArray[3] = 1;
        nArray[4] = 1282766368;
        nArray[5] = 2;
        nArray[6] = 1497588338;
        nArray[7] = 3;
        nArray[8] = 1501067552;
        nArray[9] = 4;
        nArray[10] = 1380401696;
        nArray[11] = 5;
        nArray[12] = 1196573017;
        nArray[13] = 6;
        nArray[14] = 1213421088;
        nArray[15] = 7;
        nArray[16] = 1212961568;
        nArray[17] = 8;
        nArray[18] = 1129142603;
        nArray[19] = 9;
        nArray[20] = 1129142560;
        nArray[21] = 11;
        nArray[22] = 843271250;
        nArray[23] = 12;
        nArray[24] = 860048466;
        nArray[25] = 13;
        nArray[26] = 876825682;
        nArray[27] = 14;
        nArray[28] = 893602898;
        nArray[29] = 15;
        nArray[30] = 910380114;
        nArray[31] = 16;
        nArray[32] = 927157330;
        nArray[33] = 17;
        nArray[34] = 943934546;
        nArray[35] = 18;
        nArray[36] = 960711762;
        nArray[37] = 19;
        nArray[38] = 1094929490;
        nArray[39] = 20;
        nArray[40] = 1111706706;
        nArray[41] = 21;
        nArray[42] = 1128483922;
        nArray[43] = 22;
        nArray[44] = 1145261138;
        nArray[45] = 23;
        nArray[46] = 1162038354;
        nArray[47] = 24;
        nArray[48] = 1178815570;
        nArray[49] = 25;
        csTypeMap = nArray;
        int[] nArray2 = new int[14];
        nArray2[0] = 1935896178;
        nArray2[2] = 1835955314;
        nArray2[3] = 1;
        nArray2[4] = 1886549106;
        nArray2[5] = 2;
        nArray2[6] = 1818848875;
        nArray2[7] = 3;
        nArray2[8] = 1936744803;
        nArray2[9] = 4;
        nArray2[10] = 1633842036;
        nArray2[11] = 5;
        nArray2[12] = 1852662636;
        nArray2[13] = 6;
        classMap = nArray2;
    }
}

