/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.BacktrackStack;
import gnu.regexp.CharIndexed;
import java.io.Serializable;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    private CharIndexed matchedCharIndexed;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] end;
    boolean empty;
    BacktrackStack backtrackStack;

    public final Object clone() {
        try {
            REMatch rEMatch = (REMatch)super.clone();
            rEMatch.start = (int[])this.start.clone();
            rEMatch.end = (int[])this.end.clone();
            return rEMatch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    final void assignFrom(REMatch rEMatch) {
        this.start = rEMatch.start;
        this.end = rEMatch.end;
        this.index = rEMatch.index;
        this.backtrackStack = rEMatch.backtrackStack;
    }

    final void finish(CharIndexed charIndexed) {
        this.start[0] = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.end[0]) {
            stringBuffer.append(charIndexed.charAt(n));
            ++n;
        }
        this.matchedText = stringBuffer.toString();
        this.matchedCharIndexed = charIndexed;
        n = 0;
        while (n < this.start.length) {
            boolean bl = false;
            if (this.start[n] == -1) {
                bl = true;
            }
            boolean bl2 = false;
            if (this.end[n] == -1) {
                bl2 = true;
            }
            if (bl != bl2) {
                this.start[n] = -1;
                this.end[n] = -1;
            }
            ++n;
        }
        this.backtrackStack = null;
    }

    final void clear(int n) {
        this.offset = n;
        this.index = 0;
        int n2 = 0;
        while (n2 < this.start.length) {
            this.end[n2] = -1;
            this.start[n2] = -1;
            ++n2;
        }
        this.backtrackStack = null;
    }

    public final String toString() {
        return this.matchedText;
    }

    public final int getStartIndex() {
        return this.offset + this.start[0];
    }

    public final int getEndIndex() {
        return this.offset + this.end[0];
    }

    public final String toString(int n) {
        if (n >= this.start.length || n < 0) {
            throw new IndexOutOfBoundsException("No group " + n);
        }
        if (this.start[n] == -1) {
            return null;
        }
        if (this.start[n] >= 0 && this.end[n] <= this.matchedText.length()) {
            return this.matchedText.substring(this.start[n], this.end[n]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.start[n];
        int n3 = this.end[n];
        if (n2 < 0) {
            ++n2;
        }
        if (n3 < 0) {
            ++n3;
        }
        int n4 = this.start[0] + n2;
        while (n4 < this.start[0] + n3) {
            stringBuffer.append(this.matchedCharIndexed.charAt(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public final int getSubStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public final int getStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public final int getSubEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public final int getEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : (n2 >= 0 ? this.offset + n2 : this.offset + n2 + 1);
    }

    public final String substituteInto(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '$' && Character.isDigit(string.charAt(n + 1))) {
                int n2 = Character.digit(string.charAt(++n), 10);
                int n3 = n + 1;
                while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                    int n4 = n2 * 10 + Character.digit(string.charAt(n3), 10);
                    if (n4 >= this.start.length) break;
                    ++n3;
                    n2 = n4;
                }
                n = n3 - 1;
                if (n2 < this.start.length) {
                    stringBuffer.append(this.toString(n2));
                }
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    REMatch(int n, int n2, int n3) {
        this.start = new int[n + 1];
        this.end = new int[n + 1];
        this.anchor = n2;
        this.eflags = n3;
        this.clear(n2);
    }
}

