/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBufferImpl;

public abstract class CharBuffer
extends Buffer
implements Comparable,
CharSequence {
    int array_offset = 0;
    char[] backing_buffer;

    public static CharBuffer allocate(int n) {
        return new CharBufferImpl(n);
    }

    public static final CharBuffer wrap(char[] cArray, int n, int n2) {
        return new CharBufferImpl(cArray, 0, cArray.length, n + n2, n, -1, false);
    }

    public static final CharBuffer wrap(CharSequence charSequence) {
        return CharBuffer.wrap(charSequence, 0, charSequence.length());
    }

    public static final CharBuffer wrap(CharSequence charSequence, int n, int n2) {
        if (n < 0 || n > charSequence.length() || n2 < n || n2 > charSequence.length() - n) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = charSequence.charAt(n4 + n);
            ++n4;
        }
        return CharBuffer.wrap(cArray, 0, n3).asReadOnlyBuffer();
    }

    public static final CharBuffer wrap(char[] cArray) {
        return CharBuffer.wrap(cArray, 0, cArray.length);
    }

    public CharBuffer get(char[] cArray, int n, int n2) {
        CharBuffer.checkArraySize(cArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            cArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public CharBuffer get(char[] cArray) {
        return this.get(cArray, 0, cArray.length);
    }

    public CharBuffer put(CharBuffer charBuffer) {
        if (charBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(charBuffer.remaining());
        if (charBuffer.remaining() > 0) {
            char[] cArray = new char[charBuffer.remaining()];
            charBuffer.get(cArray);
            this.put(cArray);
        }
        return this;
    }

    public CharBuffer put(char[] cArray, int n, int n2) {
        CharBuffer.checkArraySize(cArray.length, n, n2);
        this.checkForOverflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            this.put(cArray[n3]);
            ++n3;
        }
        return this;
    }

    public final CharBuffer put(char[] cArray) {
        return this.put(cArray, 0, cArray.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final char[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        int n3 = this.position() + 1;
        while (n3 < this.limit()) {
            n += (this.get(n3) + 30) * (n2 *= 31);
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof CharBuffer) {
            boolean bl = false;
            if (this.compareTo(object) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        CharBuffer charBuffer = (CharBuffer)object;
        int n = Math.min(this.remaining(), charBuffer.remaining());
        int n2 = this.position();
        int n3 = charBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            char c;
            char c2;
            if ((c2 = this.get(n2++)) != (c = charBuffer.get(n3++))) {
                if (c2 < c) {
                    return -1;
                }
                return 1;
            }
            ++n4;
        }
        return this.remaining() - charBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract char get();

    public abstract CharBuffer put(char var1);

    public abstract char get(int var1);

    public abstract CharBuffer put(int var1, char var2);

    public abstract CharBuffer compact();

    public abstract boolean isDirect();

    public abstract CharBuffer slice();

    public abstract CharBuffer duplicate();

    public abstract CharBuffer asReadOnlyBuffer();

    public String toString() {
        if (this.hasArray()) {
            return new String(this.array(), this.position(), this.length());
        }
        char[] cArray = new char[this.length()];
        int n = this.position();
        this.get(cArray, 0, cArray.length);
        this.position(n);
        return new String(cArray);
    }

    public final int length() {
        return this.remaining();
    }

    public abstract CharSequence subSequence(int var1, int var2);

    public CharBuffer put(String string, int n, int n2) {
        return this.put(string.toCharArray(), n, n2);
    }

    public final CharBuffer put(String string) {
        return this.put(string.toCharArray(), 0, string.length());
    }

    public final char charAt(int n) {
        if (n < 0 || n >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position() + n);
    }

    CharBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }
}

