/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5987973545549424702L;
    private static final String[] formatPrefixes = new String[]{"full", "long", "medium", "short"};
    String[] ampms;
    String[] eras;
    private String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    private String[][] zoneStrings;
    transient String[] dateFormats;
    transient String[] timeFormats;

    private static final String[] getStringArray(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string).split("\u00ae");
    }

    private final String[][] getZoneStrings(ResourceBundle resourceBundle) {
        try {
            boolean bl = false;
            String string = resourceBundle.getString("zoneStrings");
            String[] stringArray = string.split("\u00a9");
            String[][] stringArray2 = new String[stringArray.length][];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n].split("\u00ae");
                ++n;
            }
            return stringArray2;
        }
        catch (MissingResourceException missingResourceException) {
            return new String[0][];
        }
    }

    private final String[] formatsForKey(ResourceBundle resourceBundle, String string) {
        String[] stringArray = new String[formatPrefixes.length];
        int n = 0;
        while (n < formatPrefixes.length) {
            stringArray[n] = resourceBundle.getString(formatPrefixes[n] + string);
            ++n;
        }
        return stringArray;
    }

    public String[] getAmPmStrings() {
        return this.ampms;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public void setAmPmStrings(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.ampms = stringArray;
    }

    public void setEras(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.eras = stringArray;
    }

    public void setLocalPatternChars(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.localPatternChars = string;
    }

    public void setMonths(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.months = stringArray;
    }

    public void setShortMonths(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.shortMonths = stringArray;
    }

    public void setShortWeekdays(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.shortWeekdays = stringArray;
    }

    public void setWeekdays(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.weekdays = stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.zoneStrings = stringArray;
    }

    private static final boolean equals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
            return object.equals(object2);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (DateFormatSymbols.equals(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    private static final int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Object[])) {
            return object.hashCode();
        }
        Object[] objectArray = (Object[])object;
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n = 37 * DateFormatSymbols.hashCode(objectArray[n2]);
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateFormatSymbols)) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        boolean bl = false;
        if (DateFormatSymbols.equals(this.ampms, dateFormatSymbols.ampms) && DateFormatSymbols.equals(this.eras, dateFormatSymbols.eras) && DateFormatSymbols.equals(this.localPatternChars, dateFormatSymbols.localPatternChars) && DateFormatSymbols.equals(this.months, dateFormatSymbols.months) && DateFormatSymbols.equals(this.shortMonths, dateFormatSymbols.shortMonths) && DateFormatSymbols.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && DateFormatSymbols.equals(this.weekdays, dateFormatSymbols.weekdays) && DateFormatSymbols.equals(this.zoneStrings, dateFormatSymbols.zoneStrings)) {
            bl = true;
        }
        return bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        return DateFormatSymbols.hashCode(this.ampms) ^ DateFormatSymbols.hashCode(this.eras) ^ DateFormatSymbols.hashCode(this.localPatternChars) ^ DateFormatSymbols.hashCode(this.months) ^ DateFormatSymbols.hashCode(this.shortMonths) ^ DateFormatSymbols.hashCode(this.shortWeekdays) ^ DateFormatSymbols.hashCode(this.weekdays) ^ DateFormatSymbols.hashCode(this.zoneStrings);
    }

    public DateFormatSymbols(Locale locale) throws MissingResourceException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
        this.ampms = DateFormatSymbols.getStringArray(resourceBundle, "ampms");
        this.eras = DateFormatSymbols.getStringArray(resourceBundle, "eras");
        this.localPatternChars = resourceBundle.getString("localPatternChars");
        this.months = DateFormatSymbols.getStringArray(resourceBundle, "months");
        this.shortMonths = DateFormatSymbols.getStringArray(resourceBundle, "shortMonths");
        this.shortWeekdays = DateFormatSymbols.getStringArray(resourceBundle, "shortWeekdays");
        this.weekdays = DateFormatSymbols.getStringArray(resourceBundle, "weekdays");
        this.zoneStrings = this.getZoneStrings(resourceBundle);
        this.dateFormats = this.formatsForKey(resourceBundle, "DateFormat");
        this.timeFormats = this.formatsForKey(resourceBundle, "TimeFormat");
    }

    public DateFormatSymbols() throws MissingResourceException {
        this(Locale.getDefault());
    }
}

