/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    GlyphPainter glyphPainter;
    private int startOffset = -1;
    private int endOffset = -1;

    public GlyphPainter getGlyphPainter() {
        return this.glyphPainter;
    }

    public void setGlyphPainter(GlyphPainter glyphPainter) {
        this.glyphPainter = glyphPainter;
    }

    protected void checkPainter() {
        if (this.glyphPainter == null) {
            this.glyphPainter = new DefaultGlyphPainter();
        }
    }

    public void paint(Graphics graphics, Shape shape) {
        Element element = this.getElement();
        this.checkPainter();
        this.getGlyphPainter().paint(this, graphics, shape, this.getStartOffset(), this.getEndOffset());
    }

    public float getPreferredSpan(int n) {
        float f = 0.0f;
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        if (n == 0) {
            Element element = this.getElement();
            TabExpander tabExpander = null;
            View view = this.getParent();
            if (view instanceof TabExpander) {
                tabExpander = (TabExpander)((Object)view);
            }
            f = glyphPainter.getSpan(this, this.getStartOffset(), this.getEndOffset(), tabExpander, 0.0f);
        } else {
            f = glyphPainter.getHeight(this);
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.modelToView(this, n, bias, shape);
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.viewToModel(this, f, f2, shape, biasArray);
    }

    public TabExpander getTabExpander() {
        TabExpander tabExpander = null;
        View view = this.getParent();
        if (view instanceof TabExpander) {
            tabExpander = (TabExpander)((Object)view);
        }
        return tabExpander;
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        Element element = this.getElement();
        return this.getGlyphPainter().getSpan(this, element.getStartOffset(), element.getEndOffset(), tabExpander, f);
    }

    public float getPartialSpan(int n, int n2) {
        Element element = this.getElement();
        Document document = element.getDocument();
        Segment segment = new Segment();
        try {
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"BadLocationException must not be thrown here");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        FontMetrics fontMetrics = null;
        return Utilities.getTabbedTextWidth(segment, fontMetrics, 0, null, n);
    }

    public int getStartOffset() {
        int n = this.startOffset;
        if (n < 0) {
            n = super.getStartOffset();
        }
        return n;
    }

    public int getEndOffset() {
        int n = this.endOffset;
        if (n < 0) {
            n = super.getEndOffset();
        }
        return n;
    }

    public Segment getText(int n, int n2) {
        Segment segment = new Segment();
        try {
            this.getDocument().getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)("BadLocationException should not be thrown here. p0 = " + n + ", p1 = " + n2));
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        return segment;
    }

    public Font getFont() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        String string = StyleConstants.getFontFamily(attributeSet);
        int n = StyleConstants.getFontSize(attributeSet);
        int n2 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n2 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n2 |= 2;
        }
        Font font = new Font(string, n2, n);
        return font;
    }

    public Color getForeground() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return (Color)attributeSet.getAttribute(StyleConstants.Background);
    }

    public boolean isStrikeThrough() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public boolean isSubscript() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isSubscript(attributeSet);
    }

    public boolean isSuperscript() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isSuperscript(attributeSet);
    }

    public boolean isUnderline() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        return StyleConstants.isUnderline(attributeSet);
    }

    protected final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            AssertionError assertionError = new AssertionError((Object)"CloneNotSupportedException must not be thrown here");
            ((Throwable)((Object)assertionError)).initCause(cloneNotSupportedException);
            throw assertionError;
        }
    }

    public View breakView(int n, int n2, float f, float f2) {
        int n3;
        if (n == 1) {
            return this;
        }
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        Segment segment = new Segment();
        try {
            n3 = this.getStartOffset();
            int n4 = this.getEndOffset() - n3;
            this.getDocument().getText(n3, n4, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"BadLocationException must not be thrown here.");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        n3 = Utilities.getBreakLocation(segment, this.getContainer().getFontMetrics(this.getFont()), (int)f, (int)(f + f2), this.getTabExpander(), n2);
        View view = this.createFragment(n2, n3);
        return view;
    }

    public int getBreakWeight(int n, float f, float f2) {
        int n2 = n == 1 ? super.getBreakWeight(n, f, f2) : 1000;
        return n2;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(this, true, true);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(this, true, false);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.preferenceChanged(this, true, false);
    }

    public View createFragment(int n, int n2) {
        GlyphView glyphView = (GlyphView)this.clone();
        if (n != this.getStartOffset()) {
            glyphView.startOffset = n;
        }
        if (n2 != this.getEndOffset()) {
            glyphView.endOffset = n2;
        }
        return glyphView;
    }

    public float getAlignment(int n) {
        float f;
        if (n == 1) {
            this.checkPainter();
            GlyphPainter glyphPainter = this.getGlyphPainter();
            float f2 = glyphPainter.getHeight(this);
            float f3 = glyphPainter.getDescent(this);
            f = (f2 - f3) / f2;
        } else {
            f = super.getAlignment(n);
        }
        return f;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        this.checkPainter();
        GlyphPainter glyphPainter = this.getGlyphPainter();
        return glyphPainter.getNextVisualPositionFrom(this, n, bias, shape, n2, biasArray);
    }

    public GlyphView(Element element) {
        super(element);
    }

    static class DefaultGlyphPainter
    extends GlyphPainter {
        public float getHeight(GlyphView glyphView) {
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            float f = fontMetrics.getHeight();
            return f;
        }

        public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
            int n3;
            Color color = graphics.getColor();
            int n4 = (int)this.getHeight(glyphView);
            Segment segment = glyphView.getText(n, n2);
            Rectangle rectangle = shape.getBounds();
            TabExpander tabExpander = null;
            View view = glyphView.getParent();
            if (view instanceof TabExpander) {
                tabExpander = (TabExpander)((Object)view);
            }
            int n5 = Utilities.getTabbedTextWidth(segment, graphics.getFontMetrics(), rectangle.x, tabExpander, segment.offset);
            Color color2 = glyphView.getBackground();
            if (color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, rectangle.y, n5, n4);
            }
            graphics.setColor(glyphView.getForeground());
            graphics.setFont(glyphView.getFont());
            int n6 = graphics.getFontMetrics().getAscent();
            if (glyphView.isSuperscript()) {
                Utilities.drawTabbedText(segment, rectangle.x, rectangle.y + n6 - n4 / 2, graphics, tabExpander, segment.offset);
            } else if (glyphView.isSubscript()) {
                Utilities.drawTabbedText(segment, rectangle.x, rectangle.y + n6 + n4 / 2, graphics, tabExpander, segment.offset);
            } else {
                Utilities.drawTabbedText(segment, rectangle.x, rectangle.y + n6, graphics, tabExpander, segment.offset);
            }
            if (glyphView.isStrikeThrough()) {
                n3 = (int)(this.getAscent(glyphView) / 2.0f);
                graphics.drawLine(rectangle.x, rectangle.y + n3, rectangle.height + n5, rectangle.y + n3);
            }
            if (glyphView.isUnderline()) {
                n3 = (int)this.getAscent(glyphView);
                graphics.drawLine(rectangle.x, rectangle.y + n3, rectangle.height + n5, rectangle.y + n3);
            }
            graphics.setColor(color);
        }

        public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
            Element element = glyphView.getElement();
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = glyphView.getContainer().getFontMetrics(font);
            Segment segment = glyphView.getText(element.getStartOffset(), n);
            int n2 = fontMetrics.charsWidth(segment.array, segment.offset, segment.count);
            int n3 = fontMetrics.getHeight();
            Rectangle rectangle = shape.getBounds();
            Rectangle rectangle2 = new Rectangle(rectangle.x + n2, rectangle.y, rectangle.x + n2, n3);
            return rectangle2;
        }

        public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
            Element element = glyphView.getElement();
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            Segment segment = glyphView.getText(n, n2);
            int n3 = Utilities.getTabbedTextWidth(segment, fontMetrics, (int)f, tabExpander, n);
            return n3;
        }

        public float getAscent(GlyphView glyphView) {
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = glyphView.getContainer().getFontMetrics(font);
            return fontMetrics.getAscent();
        }

        public float getDescent(GlyphView glyphView) {
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = glyphView.getContainer().getFontMetrics(font);
            return fontMetrics.getDescent();
        }

        public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
            TabExpander tabExpander = glyphView.getTabExpander();
            Segment segment = glyphView.getText(n, glyphView.getEndOffset());
            Font font = glyphView.getFont();
            FontMetrics fontMetrics = glyphView.getContainer().getFontMetrics(font);
            int n2 = Utilities.getTabbedTextOffset(segment, fontMetrics, (int)f, (int)(f + f2), tabExpander, n, false);
            return n2;
        }

        public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Rectangle rectangle = shape.getBounds();
            int n = this.getBoundedPosition(glyphView, glyphView.getStartOffset(), rectangle.x, f - (float)rectangle.x);
            return n;
        }

        DefaultGlyphPainter() {
        }
    }

    public static abstract class GlyphPainter {
        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract float getHeight(GlyphView var1);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = n;
            switch (n2) {
                case 3: {
                    n3 = n + 1;
                    break;
                }
                case 7: {
                    n3 = n - 1;
                    break;
                }
            }
            return n3;
        }

        public GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
            return this;
        }
    }
}

