/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalUtils;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c, Graphics g2, int x, int y) {
            ButtonModel model = ((JCheckBox)c).getModel();
            g2.translate(x, y);
            int w = this.getIconWidth();
            int h2 = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(0, 0, w, h2);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.fillRect(0, 0, w, 2);
                    g2.fillRect(0, 2, 2, h2 - 2);
                    g2.fillRect(w - 1, 1, 1, h2 - 1);
                    g2.fillRect(1, h2 - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    MetalUtils.drawGradient(c, g2, "CheckBox.gradient", 0, 0, w, h2, true);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.drawRect(0, 0, w - 1, h2 - 1);
                    g2.setColor(MetalLookAndFeel.getPrimaryControl());
                    g2.drawRect(1, 1, w - 3, h2 - 3);
                    g2.drawRect(2, 2, w - 5, h2 - 5);
                } else {
                    MetalUtils.drawGradient(c, g2, "CheckBox.gradient", 0, 0, w, h2, true);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.drawRect(0, 0, w - 1, h2 - 1);
                }
                g2.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                g2.drawRect(0, 0, w - 1, h2 - 1);
            }
            g2.translate(-x, -y);
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c, g2, x, y);
            } else if (model.isSelected()) {
                this.drawCheck(c, g2, x, y);
            }
        }

        public void paintIcon(Component c, Graphics g2, int x, int y) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanIcon(c, g2, x, y);
                return;
            }
            ButtonModel model = ((JCheckBox)c).getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(x, y, controlSize - 1, controlSize - 1);
                    MetalUtils.drawPressed3DBorder(g2, x, y, controlSize, controlSize);
                } else {
                    MetalUtils.drawFlush3DBorder(g2, x, y, controlSize, controlSize);
                }
                g2.setColor(c.getForeground());
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawRect(x, y, controlSize - 2, controlSize - 2);
            }
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c, g2, x, y);
            } else if (model.isSelected()) {
                this.drawCheck(c, g2, x, y);
            }
        }

        protected void drawCheck(Component c, Graphics g2, int x, int y) {
            int controlSize = this.getControlSize();
            g2.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g2.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g2.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        protected void drawSquare(Component c, Graphics g2, int x, int y) {
            int controlSize = this.getControlSize();
            g2.fillRect(x + 3, y + 3, controlSize - 6, controlSize - 6);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

