/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

public class TypeSignature {
    public static String getEncodingOfClass(String type, boolean descriptor) {
        if (!descriptor || type.charAt(0) == '[') {
            return type.replace('.', '/');
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("void")) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ';';
    }

    public static String getEncodingOfClass(Class clazz, boolean descriptor) {
        return TypeSignature.getEncodingOfClass(clazz.getName(), descriptor);
    }

    public static String getEncodingOfClass(Class clazz) {
        return TypeSignature.getEncodingOfClass(clazz.getName(), true);
    }

    public static Class getClassForEncoding(String type_code, boolean descriptor) throws ClassNotFoundException {
        return TypeSignature.getClassForEncoding(type_code, descriptor, null);
    }

    public static Class getClassForEncoding(String type_code, boolean descriptor, ClassLoader loader) throws ClassNotFoundException {
        if (descriptor) {
            switch (type_code.charAt(0)) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                default: {
                    throw new ClassNotFoundException("Invalid class name: " + type_code);
                }
                case 'L': {
                    type_code = type_code.substring(1, type_code.length() - 1);
                }
                case '[': 
            }
        }
        return Class.forName(type_code.replace('/', '.'), true, loader);
    }

    public static Class getClassForEncoding(String type_code) throws ClassNotFoundException {
        return TypeSignature.getClassForEncoding(type_code, true);
    }

    public static String getEncodingOfMethod(Method m) {
        Class[] paramTypes = m.getParameterTypes();
        StringBuffer buf = new StringBuffer().append('(');
        int i = 0;
        while (i < paramTypes.length) {
            buf.append(TypeSignature.getEncodingOfClass(paramTypes[i].getName(), true));
            ++i;
        }
        buf.append(')').append(TypeSignature.getEncodingOfClass(m.getReturnType().getName(), true));
        return buf.toString();
    }

    public static String getEncodingOfConstructor(Constructor c) {
        Class[] paramTypes = c.getParameterTypes();
        StringBuffer buf = new StringBuffer().append('(');
        int i = 0;
        while (i < paramTypes.length) {
            buf.append(TypeSignature.getEncodingOfClass(paramTypes[i].getName(), true));
            ++i;
        }
        buf.append(")V");
        return buf.toString();
    }

    public static String getEncodingOfMember(Member mem) {
        if (mem instanceof Constructor) {
            return TypeSignature.getEncodingOfConstructor((Constructor)mem);
        }
        if (mem instanceof Method) {
            return TypeSignature.getEncodingOfMethod((Method)mem);
        }
        return TypeSignature.getEncodingOfClass(((Field)mem).getType().getName(), true);
    }
}

