<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Tests Date_Calc::julianDay()
 *
 * Any individual tests that fail will have their name, expected result
 * and actual result printed out.  So seeing no output when executing
 * this file is a good thing.
 *
 * Can be run via CLI or a web server.
 *
 * This test senses whether it is from an installation of PEAR::Date or if
 * it's from CVS or a .tar file.  If it's an installed version, use the
 * installed version of Date.  Otherwise, use the local development
 * copy of Date.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 *
 * Copyright (c) 2007 C.A. Woodcock <c01234@netcomuk.co.uk>
 * All rights reserved.
 *
 * This source file is subject to the New BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/bsd-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to pear-dev@lists.php.net so we can send you a copy immediately.
 *
 * @category   Date and Time
 * @package    Date
 * @author     C.A. Woodcock <c01234@netcomuk.co.uk>
 * @copyright  Copyright (c) 2007 C.A. Woodcock <c01234@netcomuk.co.uk>
 * @license    http://www.opensource.org/licenses/bsd-license.php
 *             BSD License
 * @link       http://pear.php.net/package/Date
 * @since      [next version]
 */

if ('@include_path@' != '@'.'include_path'.'@') {
    ini_set('include_path', ini_get('include_path')
            . PATH_SEPARATOR . '.'
    );
} else {
    ini_set('include_path', realpath(dirname(__FILE__) . '/../')
            . PATH_SEPARATOR . '.' . PATH_SEPARATOR
            . ini_get('include_path')
    );
}


/**
 * Get the needed class
 */
require_once 'Date.php';

/**
 * Compare the test result to the expected result
 *
 * If the test fails, echo out the results.
 *
 * @param mixed  $expect     the scalar or array you expect from the test
 * @param mixed  $actual     the scalar or array results from the test
 * @param string $test_name  the name of the test
 *
 * @return void
 */
function compare($expect, $actual, $test_name) {
    if (is_array($expect)) {
        if (count(array_diff($actual, $expect))) {
            echo "$test_name failed.  Expect:\n";
            print_r($expect);
            echo "Actual:\n";
            print_r($actual);
        }
    } else {
        if ($expect !== $actual) {
            echo "'$test_name' failed.  Expect: '$expect'  Actual: '$actual'\n";
        }
    }
}

if (php_sapi_name() != 'cli') {
    echo "<pre>\n";
}


compare('-4713 11 24', Date_Calc::DaysToDate(0, "%Y %m %d"), '0000 (top)');
compare(0, Date_Calc::DateToDays(24, 11, -4713), '-4713 11 24 (top)');
compare('-0001 12 31', Date_Calc::DaysToDate(1721059, "%Y %m %d"), '1721059 (top)');
compare(1721059, Date_Calc::DateToDays(31, 12, -1), '-0001 12 31 (top)');
compare('0000 01 01', Date_Calc::DaysToDate(1721060, "%Y %m %d"), '1721060 (top)');
compare(1721060, Date_Calc::DateToDays(1, 1, 0), '0000 01 01 (top)');
compare('0000 01 02', Date_Calc::DaysToDate(1721061, "%Y %m %d"), '1721061 (top)');
compare(1721061, Date_Calc::DateToDays(2, 1, 0), '0000 01 02 (top)');
compare('1858 11 16', Date_Calc::DaysToDate(2400000, "%Y %m %d"), '2400000 (top)');
compare(2400000, Date_Calc::DateToDays(16, 11, 1858), '1858 11 16 (top)');
compare('2132 08 31', Date_Calc::DaysToDate(2500000, "%Y %m %d"), '2500000 (top)');
compare(2500000, Date_Calc::DateToDays(31, 8, 2132), '2132 08 31 (top)');

compare('-4714 11 24', $hs_date = Date_Calc::DaysToDate(-365, "%Y %m %d"), '-365');
compare(-365, Date_Calc::DateToDays(24, 11, -4714), '-4714 11 24');
compare('-4714 11 25', $hs_date = Date_Calc::DaysToDate(-364, "%Y %m %d"), '-364');
compare(-364, Date_Calc::DateToDays(25, 11, -4714), '-4714 11 25');
compare('-4714 11 26', $hs_date = Date_Calc::DaysToDate(-363, "%Y %m %d"), '-363');
compare(-363, Date_Calc::DateToDays(26, 11, -4714), '-4714 11 26');
compare('-4714 11 27', $hs_date = Date_Calc::DaysToDate(-362, "%Y %m %d"), '-362');
compare(-362, Date_Calc::DateToDays(27, 11, -4714), '-4714 11 27');
compare('-4714 11 28', $hs_date = Date_Calc::DaysToDate(-361, "%Y %m %d"), '-361');
compare(-361, Date_Calc::DateToDays(28, 11, -4714), '-4714 11 28');
compare('-4714 11 29', $hs_date = Date_Calc::DaysToDate(-360, "%Y %m %d"), '-360');
compare(-360, Date_Calc::DateToDays(29, 11, -4714), '-4714 11 29');
compare('-4714 11 30', $hs_date = Date_Calc::DaysToDate(-359, "%Y %m %d"), '-359');
compare(-359, Date_Calc::DateToDays(30, 11, -4714), '-4714 11 30');
compare('-4714 12 01', $hs_date = Date_Calc::DaysToDate(-358, "%Y %m %d"), '-358');
compare(-358, Date_Calc::DateToDays(1, 12, -4714), '-4714 12 01');
compare('-4714 12 02', $hs_date = Date_Calc::DaysToDate(-357, "%Y %m %d"), '-357');
compare(-357, Date_Calc::DateToDays(2, 12, -4714), '-4714 12 02');
compare('-4714 12 03', $hs_date = Date_Calc::DaysToDate(-356, "%Y %m %d"), '-356');
compare(-356, Date_Calc::DateToDays(3, 12, -4714), '-4714 12 03');
compare('-4714 12 04', $hs_date = Date_Calc::DaysToDate(-355, "%Y %m %d"), '-355');
compare(-355, Date_Calc::DateToDays(4, 12, -4714), '-4714 12 04');
compare('-4714 12 05', $hs_date = Date_Calc::DaysToDate(-354, "%Y %m %d"), '-354');
compare(-354, Date_Calc::DateToDays(5, 12, -4714), '-4714 12 05');
compare('-4714 12 06', $hs_date = Date_Calc::DaysToDate(-353, "%Y %m %d"), '-353');
compare(-353, Date_Calc::DateToDays(6, 12, -4714), '-4714 12 06');
compare('-4714 12 07', $hs_date = Date_Calc::DaysToDate(-352, "%Y %m %d"), '-352');
compare(-352, Date_Calc::DateToDays(7, 12, -4714), '-4714 12 07');
compare('-4714 12 08', $hs_date = Date_Calc::DaysToDate(-351, "%Y %m %d"), '-351');
compare(-351, Date_Calc::DateToDays(8, 12, -4714), '-4714 12 08');
compare('-4714 12 09', $hs_date = Date_Calc::DaysToDate(-350, "%Y %m %d"), '-350');
compare(-350, Date_Calc::DateToDays(9, 12, -4714), '-4714 12 09');
compare('-4714 12 10', $hs_date = Date_Calc::DaysToDate(-349, "%Y %m %d"), '-349');
compare(-349, Date_Calc::DateToDays(10, 12, -4714), '-4714 12 10');
compare('-4714 12 11', $hs_date = Date_Calc::DaysToDate(-348, "%Y %m %d"), '-348');
compare(-348, Date_Calc::DateToDays(11, 12, -4714), '-4714 12 11');
compare('-4714 12 12', $hs_date = Date_Calc::DaysToDate(-347, "%Y %m %d"), '-347');
compare(-347, Date_Calc::DateToDays(12, 12, -4714), '-4714 12 12');
compare('-4714 12 13', $hs_date = Date_Calc::DaysToDate(-346, "%Y %m %d"), '-346');
compare(-346, Date_Calc::DateToDays(13, 12, -4714), '-4714 12 13');
compare('-4714 12 14', $hs_date = Date_Calc::DaysToDate(-345, "%Y %m %d"), '-345');
compare(-345, Date_Calc::DateToDays(14, 12, -4714), '-4714 12 14');
compare('-4714 12 15', $hs_date = Date_Calc::DaysToDate(-344, "%Y %m %d"), '-344');
compare(-344, Date_Calc::DateToDays(15, 12, -4714), '-4714 12 15');
compare('-4714 12 16', $hs_date = Date_Calc::DaysToDate(-343, "%Y %m %d"), '-343');
compare(-343, Date_Calc::DateToDays(16, 12, -4714), '-4714 12 16');
compare('-4714 12 17', $hs_date = Date_Calc::DaysToDate(-342, "%Y %m %d"), '-342');
compare(-342, Date_Calc::DateToDays(17, 12, -4714), '-4714 12 17');
compare('-4714 12 18', $hs_date = Date_Calc::DaysToDate(-341, "%Y %m %d"), '-341');
compare(-341, Date_Calc::DateToDays(18, 12, -4714), '-4714 12 18');
compare('-4714 12 19', $hs_date = Date_Calc::DaysToDate(-340, "%Y %m %d"), '-340');
compare(-340, Date_Calc::DateToDays(19, 12, -4714), '-4714 12 19');
compare('-4714 12 20', $hs_date = Date_Calc::DaysToDate(-339, "%Y %m %d"), '-339');
compare(-339, Date_Calc::DateToDays(20, 12, -4714), '-4714 12 20');
compare('-4714 12 21', $hs_date = Date_Calc::DaysToDate(-338, "%Y %m %d"), '-338');
compare(-338, Date_Calc::DateToDays(21, 12, -4714), '-4714 12 21');
compare('-4714 12 22', $hs_date = Date_Calc::DaysToDate(-337, "%Y %m %d"), '-337');
compare(-337, Date_Calc::DateToDays(22, 12, -4714), '-4714 12 22');
compare('-4714 12 23', $hs_date = Date_Calc::DaysToDate(-336, "%Y %m %d"), '-336');
compare(-336, Date_Calc::DateToDays(23, 12, -4714), '-4714 12 23');
compare('-4714 12 24', $hs_date = Date_Calc::DaysToDate(-335, "%Y %m %d"), '-335');
compare(-335, Date_Calc::DateToDays(24, 12, -4714), '-4714 12 24');
compare('-4714 12 25', $hs_date = Date_Calc::DaysToDate(-334, "%Y %m %d"), '-334');
compare(-334, Date_Calc::DateToDays(25, 12, -4714), '-4714 12 25');
compare('-4714 12 26', $hs_date = Date_Calc::DaysToDate(-333, "%Y %m %d"), '-333');
compare(-333, Date_Calc::DateToDays(26, 12, -4714), '-4714 12 26');
compare('-4714 12 27', $hs_date = Date_Calc::DaysToDate(-332, "%Y %m %d"), '-332');
compare(-332, Date_Calc::DateToDays(27, 12, -4714), '-4714 12 27');
compare('-4714 12 28', $hs_date = Date_Calc::DaysToDate(-331, "%Y %m %d"), '-331');
compare(-331, Date_Calc::DateToDays(28, 12, -4714), '-4714 12 28');
compare('-4714 12 29', $hs_date = Date_Calc::DaysToDate(-330, "%Y %m %d"), '-330');
compare(-330, Date_Calc::DateToDays(29, 12, -4714), '-4714 12 29');
compare('-4714 12 30', $hs_date = Date_Calc::DaysToDate(-329, "%Y %m %d"), '-329');
compare(-329, Date_Calc::DateToDays(30, 12, -4714), '-4714 12 30');
compare('-4714 12 31', $hs_date = Date_Calc::DaysToDate(-328, "%Y %m %d"), '-328');
compare(-328, Date_Calc::DateToDays(31, 12, -4714), '-4714 12 31');
compare('-4713 01 01', $hs_date = Date_Calc::DaysToDate(-327, "%Y %m %d"), '-327');
compare(-327, Date_Calc::DateToDays(1, 1, -4713), '-4713 01 01');
compare('-4713 01 02', $hs_date = Date_Calc::DaysToDate(-326, "%Y %m %d"), '-326');
compare(-326, Date_Calc::DateToDays(2, 1, -4713), '-4713 01 02');
compare('-4713 01 03', $hs_date = Date_Calc::DaysToDate(-325, "%Y %m %d"), '-325');
compare(-325, Date_Calc::DateToDays(3, 1, -4713), '-4713 01 03');
compare('-4713 01 04', $hs_date = Date_Calc::DaysToDate(-324, "%Y %m %d"), '-324');
compare(-324, Date_Calc::DateToDays(4, 1, -4713), '-4713 01 04');
compare('-4713 01 05', $hs_date = Date_Calc::DaysToDate(-323, "%Y %m %d"), '-323');
compare(-323, Date_Calc::DateToDays(5, 1, -4713), '-4713 01 05');
compare('-4713 01 06', $hs_date = Date_Calc::DaysToDate(-322, "%Y %m %d"), '-322');
compare(-322, Date_Calc::DateToDays(6, 1, -4713), '-4713 01 06');
compare('-4713 01 07', $hs_date = Date_Calc::DaysToDate(-321, "%Y %m %d"), '-321');
compare(-321, Date_Calc::DateToDays(7, 1, -4713), '-4713 01 07');
compare('-4713 01 08', $hs_date = Date_Calc::DaysToDate(-320, "%Y %m %d"), '-320');
compare(-320, Date_Calc::DateToDays(8, 1, -4713), '-4713 01 08');
compare('-4713 01 09', $hs_date = Date_Calc::DaysToDate(-319, "%Y %m %d"), '-319');
compare(-319, Date_Calc::DateToDays(9, 1, -4713), '-4713 01 09');
compare('-4713 01 10', $hs_date = Date_Calc::DaysToDate(-318, "%Y %m %d"), '-318');
compare(-318, Date_Calc::DateToDays(10, 1, -4713), '-4713 01 10');
compare('-4713 01 11', $hs_date = Date_Calc::DaysToDate(-317, "%Y %m %d"), '-317');
compare(-317, Date_Calc::DateToDays(11, 1, -4713), '-4713 01 11');
compare('-4713 01 12', $hs_date = Date_Calc::DaysToDate(-316, "%Y %m %d"), '-316');
compare(-316, Date_Calc::DateToDays(12, 1, -4713), '-4713 01 12');
compare('-4713 01 13', $hs_date = Date_Calc::DaysToDate(-315, "%Y %m %d"), '-315');
compare(-315, Date_Calc::DateToDays(13, 1, -4713), '-4713 01 13');
compare('-4713 01 14', $hs_date = Date_Calc::DaysToDate(-314, "%Y %m %d"), '-314');
compare(-314, Date_Calc::DateToDays(14, 1, -4713), '-4713 01 14');
compare('-4713 01 15', $hs_date = Date_Calc::DaysToDate(-313, "%Y %m %d"), '-313');
compare(-313, Date_Calc::DateToDays(15, 1, -4713), '-4713 01 15');
compare('-4713 01 16', $hs_date = Date_Calc::DaysToDate(-312, "%Y %m %d"), '-312');
compare(-312, Date_Calc::DateToDays(16, 1, -4713), '-4713 01 16');
compare('-4713 01 17', $hs_date = Date_Calc::DaysToDate(-311, "%Y %m %d"), '-311');
compare(-311, Date_Calc::DateToDays(17, 1, -4713), '-4713 01 17');
compare('-4713 01 18', $hs_date = Date_Calc::DaysToDate(-310, "%Y %m %d"), '-310');
compare(-310, Date_Calc::DateToDays(18, 1, -4713), '-4713 01 18');
compare('-4713 01 19', $hs_date = Date_Calc::DaysToDate(-309, "%Y %m %d"), '-309');
compare(-309, Date_Calc::DateToDays(19, 1, -4713), '-4713 01 19');
compare('-4713 01 20', $hs_date = Date_Calc::DaysToDate(-308, "%Y %m %d"), '-308');
compare(-308, Date_Calc::DateToDays(20, 1, -4713), '-4713 01 20');
compare('-4713 01 21', $hs_date = Date_Calc::DaysToDate(-307, "%Y %m %d"), '-307');
compare(-307, Date_Calc::DateToDays(21, 1, -4713), '-4713 01 21');
compare('-4713 01 22', $hs_date = Date_Calc::DaysToDate(-306, "%Y %m %d"), '-306');
compare(-306, Date_Calc::DateToDays(22, 1, -4713), '-4713 01 22');
compare('-4713 01 23', $hs_date = Date_Calc::DaysToDate(-305, "%Y %m %d"), '-305');
compare(-305, Date_Calc::DateToDays(23, 1, -4713), '-4713 01 23');
compare('-4713 01 24', $hs_date = Date_Calc::DaysToDate(-304, "%Y %m %d"), '-304');
compare(-304, Date_Calc::DateToDays(24, 1, -4713), '-4713 01 24');
compare('-4713 01 25', $hs_date = Date_Calc::DaysToDate(-303, "%Y %m %d"), '-303');
compare(-303, Date_Calc::DateToDays(25, 1, -4713), '-4713 01 25');
compare('-4713 01 26', $hs_date = Date_Calc::DaysToDate(-302, "%Y %m %d"), '-302');
compare(-302, Date_Calc::DateToDays(26, 1, -4713), '-4713 01 26');
compare('-4713 01 27', $hs_date = Date_Calc::DaysToDate(-301, "%Y %m %d"), '-301');
compare(-301, Date_Calc::DateToDays(27, 1, -4713), '-4713 01 27');
compare('-4713 01 28', $hs_date = Date_Calc::DaysToDate(-300, "%Y %m %d"), '-300');
compare(-300, Date_Calc::DateToDays(28, 1, -4713), '-4713 01 28');
compare('-4713 01 29', $hs_date = Date_Calc::DaysToDate(-299, "%Y %m %d"), '-299');
compare(-299, Date_Calc::DateToDays(29, 1, -4713), '-4713 01 29');
compare('-4713 01 30', $hs_date = Date_Calc::DaysToDate(-298, "%Y %m %d"), '-298');
compare(-298, Date_Calc::DateToDays(30, 1, -4713), '-4713 01 30');
compare('-4713 01 31', $hs_date = Date_Calc::DaysToDate(-297, "%Y %m %d"), '-297');
compare(-297, Date_Calc::DateToDays(31, 1, -4713), '-4713 01 31');
compare('-4713 02 01', $hs_date = Date_Calc::DaysToDate(-296, "%Y %m %d"), '-296');
compare(-296, Date_Calc::DateToDays(1, 2, -4713), '-4713 02 01');
compare('-4713 02 02', $hs_date = Date_Calc::DaysToDate(-295, "%Y %m %d"), '-295');
compare(-295, Date_Calc::DateToDays(2, 2, -4713), '-4713 02 02');
compare('-4713 02 03', $hs_date = Date_Calc::DaysToDate(-294, "%Y %m %d"), '-294');
compare(-294, Date_Calc::DateToDays(3, 2, -4713), '-4713 02 03');
compare('-4713 02 04', $hs_date = Date_Calc::DaysToDate(-293, "%Y %m %d"), '-293');
compare(-293, Date_Calc::DateToDays(4, 2, -4713), '-4713 02 04');
compare('-4713 02 05', $hs_date = Date_Calc::DaysToDate(-292, "%Y %m %d"), '-292');
compare(-292, Date_Calc::DateToDays(5, 2, -4713), '-4713 02 05');
compare('-4713 02 06', $hs_date = Date_Calc::DaysToDate(-291, "%Y %m %d"), '-291');
compare(-291, Date_Calc::DateToDays(6, 2, -4713), '-4713 02 06');
compare('-4713 02 07', $hs_date = Date_Calc::DaysToDate(-290, "%Y %m %d"), '-290');
compare(-290, Date_Calc::DateToDays(7, 2, -4713), '-4713 02 07');
compare('-4713 02 08', $hs_date = Date_Calc::DaysToDate(-289, "%Y %m %d"), '-289');
compare(-289, Date_Calc::DateToDays(8, 2, -4713), '-4713 02 08');
compare('-4713 02 09', $hs_date = Date_Calc::DaysToDate(-288, "%Y %m %d"), '-288');
compare(-288, Date_Calc::DateToDays(9, 2, -4713), '-4713 02 09');
compare('-4713 02 10', $hs_date = Date_Calc::DaysToDate(-287, "%Y %m %d"), '-287');
compare(-287, Date_Calc::DateToDays(10, 2, -4713), '-4713 02 10');
compare('-4713 02 11', $hs_date = Date_Calc::DaysToDate(-286, "%Y %m %d"), '-286');
compare(-286, Date_Calc::DateToDays(11, 2, -4713), '-4713 02 11');
compare('-4713 02 12', $hs_date = Date_Calc::DaysToDate(-285, "%Y %m %d"), '-285');
compare(-285, Date_Calc::DateToDays(12, 2, -4713), '-4713 02 12');
compare('-4713 02 13', $hs_date = Date_Calc::DaysToDate(-284, "%Y %m %d"), '-284');
compare(-284, Date_Calc::DateToDays(13, 2, -4713), '-4713 02 13');
compare('-4713 02 14', $hs_date = Date_Calc::DaysToDate(-283, "%Y %m %d"), '-283');
compare(-283, Date_Calc::DateToDays(14, 2, -4713), '-4713 02 14');
compare('-4713 02 15', $hs_date = Date_Calc::DaysToDate(-282, "%Y %m %d"), '-282');
compare(-282, Date_Calc::DateToDays(15, 2, -4713), '-4713 02 15');
compare('-4713 02 16', $hs_date = Date_Calc::DaysToDate(-281, "%Y %m %d"), '-281');
compare(-281, Date_Calc::DateToDays(16, 2, -4713), '-4713 02 16');
compare('-4713 02 17', $hs_date = Date_Calc::DaysToDate(-280, "%Y %m %d"), '-280');
compare(-280, Date_Calc::DateToDays(17, 2, -4713), '-4713 02 17');
compare('-4713 02 18', $hs_date = Date_Calc::DaysToDate(-279, "%Y %m %d"), '-279');
compare(-279, Date_Calc::DateToDays(18, 2, -4713), '-4713 02 18');
compare('-4713 02 19', $hs_date = Date_Calc::DaysToDate(-278, "%Y %m %d"), '-278');
compare(-278, Date_Calc::DateToDays(19, 2, -4713), '-4713 02 19');
compare('-4713 02 20', $hs_date = Date_Calc::DaysToDate(-277, "%Y %m %d"), '-277');
compare(-277, Date_Calc::DateToDays(20, 2, -4713), '-4713 02 20');
compare('-4713 02 21', $hs_date = Date_Calc::DaysToDate(-276, "%Y %m %d"), '-276');
compare(-276, Date_Calc::DateToDays(21, 2, -4713), '-4713 02 21');
compare('-4713 02 22', $hs_date = Date_Calc::DaysToDate(-275, "%Y %m %d"), '-275');
compare(-275, Date_Calc::DateToDays(22, 2, -4713), '-4713 02 22');
compare('-4713 02 23', $hs_date = Date_Calc::DaysToDate(-274, "%Y %m %d"), '-274');
compare(-274, Date_Calc::DateToDays(23, 2, -4713), '-4713 02 23');
compare('-4713 02 24', $hs_date = Date_Calc::DaysToDate(-273, "%Y %m %d"), '-273');
compare(-273, Date_Calc::DateToDays(24, 2, -4713), '-4713 02 24');
compare('-4713 02 25', $hs_date = Date_Calc::DaysToDate(-272, "%Y %m %d"), '-272');
compare(-272, Date_Calc::DateToDays(25, 2, -4713), '-4713 02 25');
compare('-4713 02 26', $hs_date = Date_Calc::DaysToDate(-271, "%Y %m %d"), '-271');
compare(-271, Date_Calc::DateToDays(26, 2, -4713), '-4713 02 26');
compare('-4713 02 27', $hs_date = Date_Calc::DaysToDate(-270, "%Y %m %d"), '-270');
compare(-270, Date_Calc::DateToDays(27, 2, -4713), '-4713 02 27');
compare('-4713 02 28', $hs_date = Date_Calc::DaysToDate(-269, "%Y %m %d"), '-269');
compare(-269, Date_Calc::DateToDays(28, 2, -4713), '-4713 02 28');
compare('-4713 03 01', $hs_date = Date_Calc::DaysToDate(-268, "%Y %m %d"), '-268');
compare(-268, Date_Calc::DateToDays(1, 3, -4713), '-4713 03 01');
compare('-4713 03 02', $hs_date = Date_Calc::DaysToDate(-267, "%Y %m %d"), '-267');
compare(-267, Date_Calc::DateToDays(2, 3, -4713), '-4713 03 02');
compare('-4713 03 03', $hs_date = Date_Calc::DaysToDate(-266, "%Y %m %d"), '-266');
compare(-266, Date_Calc::DateToDays(3, 3, -4713), '-4713 03 03');
compare('-4713 03 04', $hs_date = Date_Calc::DaysToDate(-265, "%Y %m %d"), '-265');
compare(-265, Date_Calc::DateToDays(4, 3, -4713), '-4713 03 04');
compare('-4713 03 05', $hs_date = Date_Calc::DaysToDate(-264, "%Y %m %d"), '-264');
compare(-264, Date_Calc::DateToDays(5, 3, -4713), '-4713 03 05');
compare('-4713 03 06', $hs_date = Date_Calc::DaysToDate(-263, "%Y %m %d"), '-263');
compare(-263, Date_Calc::DateToDays(6, 3, -4713), '-4713 03 06');
compare('-4713 03 07', $hs_date = Date_Calc::DaysToDate(-262, "%Y %m %d"), '-262');
compare(-262, Date_Calc::DateToDays(7, 3, -4713), '-4713 03 07');
compare('-4713 03 08', $hs_date = Date_Calc::DaysToDate(-261, "%Y %m %d"), '-261');
compare(-261, Date_Calc::DateToDays(8, 3, -4713), '-4713 03 08');
compare('-4713 03 09', $hs_date = Date_Calc::DaysToDate(-260, "%Y %m %d"), '-260');
compare(-260, Date_Calc::DateToDays(9, 3, -4713), '-4713 03 09');
compare('-4713 03 10', $hs_date = Date_Calc::DaysToDate(-259, "%Y %m %d"), '-259');
compare(-259, Date_Calc::DateToDays(10, 3, -4713), '-4713 03 10');
compare('-4713 03 11', $hs_date = Date_Calc::DaysToDate(-258, "%Y %m %d"), '-258');
compare(-258, Date_Calc::DateToDays(11, 3, -4713), '-4713 03 11');
compare('-4713 03 12', $hs_date = Date_Calc::DaysToDate(-257, "%Y %m %d"), '-257');
compare(-257, Date_Calc::DateToDays(12, 3, -4713), '-4713 03 12');
compare('-4713 03 13', $hs_date = Date_Calc::DaysToDate(-256, "%Y %m %d"), '-256');
compare(-256, Date_Calc::DateToDays(13, 3, -4713), '-4713 03 13');
compare('-4713 03 14', $hs_date = Date_Calc::DaysToDate(-255, "%Y %m %d"), '-255');
compare(-255, Date_Calc::DateToDays(14, 3, -4713), '-4713 03 14');
compare('-4713 03 15', $hs_date = Date_Calc::DaysToDate(-254, "%Y %m %d"), '-254');
compare(-254, Date_Calc::DateToDays(15, 3, -4713), '-4713 03 15');
compare('-4713 03 16', $hs_date = Date_Calc::DaysToDate(-253, "%Y %m %d"), '-253');
compare(-253, Date_Calc::DateToDays(16, 3, -4713), '-4713 03 16');
compare('-4713 03 17', $hs_date = Date_Calc::DaysToDate(-252, "%Y %m %d"), '-252');
compare(-252, Date_Calc::DateToDays(17, 3, -4713), '-4713 03 17');
compare('-4713 03 18', $hs_date = Date_Calc::DaysToDate(-251, "%Y %m %d"), '-251');
compare(-251, Date_Calc::DateToDays(18, 3, -4713), '-4713 03 18');
compare('-4713 03 19', $hs_date = Date_Calc::DaysToDate(-250, "%Y %m %d"), '-250');
compare(-250, Date_Calc::DateToDays(19, 3, -4713), '-4713 03 19');
compare('-4713 03 20', $hs_date = Date_Calc::DaysToDate(-249, "%Y %m %d"), '-249');
compare(-249, Date_Calc::DateToDays(20, 3, -4713), '-4713 03 20');
compare('-4713 03 21', $hs_date = Date_Calc::DaysToDate(-248, "%Y %m %d"), '-248');
compare(-248, Date_Calc::DateToDays(21, 3, -4713), '-4713 03 21');
compare('-4713 03 22', $hs_date = Date_Calc::DaysToDate(-247, "%Y %m %d"), '-247');
compare(-247, Date_Calc::DateToDays(22, 3, -4713), '-4713 03 22');
compare('-4713 03 23', $hs_date = Date_Calc::DaysToDate(-246, "%Y %m %d"), '-246');
compare(-246, Date_Calc::DateToDays(23, 3, -4713), '-4713 03 23');
compare('-4713 03 24', $hs_date = Date_Calc::DaysToDate(-245, "%Y %m %d"), '-245');
compare(-245, Date_Calc::DateToDays(24, 3, -4713), '-4713 03 24');
compare('-4713 03 25', $hs_date = Date_Calc::DaysToDate(-244, "%Y %m %d"), '-244');
compare(-244, Date_Calc::DateToDays(25, 3, -4713), '-4713 03 25');
compare('-4713 03 26', $hs_date = Date_Calc::DaysToDate(-243, "%Y %m %d"), '-243');
compare(-243, Date_Calc::DateToDays(26, 3, -4713), '-4713 03 26');
compare('-4713 03 27', $hs_date = Date_Calc::DaysToDate(-242, "%Y %m %d"), '-242');
compare(-242, Date_Calc::DateToDays(27, 3, -4713), '-4713 03 27');
compare('-4713 03 28', $hs_date = Date_Calc::DaysToDate(-241, "%Y %m %d"), '-241');
compare(-241, Date_Calc::DateToDays(28, 3, -4713), '-4713 03 28');
compare('-4713 03 29', $hs_date = Date_Calc::DaysToDate(-240, "%Y %m %d"), '-240');
compare(-240, Date_Calc::DateToDays(29, 3, -4713), '-4713 03 29');
compare('-4713 03 30', $hs_date = Date_Calc::DaysToDate(-239, "%Y %m %d"), '-239');
compare(-239, Date_Calc::DateToDays(30, 3, -4713), '-4713 03 30');
compare('-4713 03 31', $hs_date = Date_Calc::DaysToDate(-238, "%Y %m %d"), '-238');
compare(-238, Date_Calc::DateToDays(31, 3, -4713), '-4713 03 31');
compare('-4713 04 01', $hs_date = Date_Calc::DaysToDate(-237, "%Y %m %d"), '-237');
compare(-237, Date_Calc::DateToDays(1, 4, -4713), '-4713 04 01');
compare('-4713 04 02', $hs_date = Date_Calc::DaysToDate(-236, "%Y %m %d"), '-236');
compare(-236, Date_Calc::DateToDays(2, 4, -4713), '-4713 04 02');
compare('-4713 04 03', $hs_date = Date_Calc::DaysToDate(-235, "%Y %m %d"), '-235');
compare(-235, Date_Calc::DateToDays(3, 4, -4713), '-4713 04 03');
compare('-4713 04 04', $hs_date = Date_Calc::DaysToDate(-234, "%Y %m %d"), '-234');
compare(-234, Date_Calc::DateToDays(4, 4, -4713), '-4713 04 04');
compare('-4713 04 05', $hs_date = Date_Calc::DaysToDate(-233, "%Y %m %d"), '-233');
compare(-233, Date_Calc::DateToDays(5, 4, -4713), '-4713 04 05');
compare('-4713 04 06', $hs_date = Date_Calc::DaysToDate(-232, "%Y %m %d"), '-232');
compare(-232, Date_Calc::DateToDays(6, 4, -4713), '-4713 04 06');
compare('-4713 04 07', $hs_date = Date_Calc::DaysToDate(-231, "%Y %m %d"), '-231');
compare(-231, Date_Calc::DateToDays(7, 4, -4713), '-4713 04 07');
compare('-4713 04 08', $hs_date = Date_Calc::DaysToDate(-230, "%Y %m %d"), '-230');
compare(-230, Date_Calc::DateToDays(8, 4, -4713), '-4713 04 08');
compare('-4713 04 09', $hs_date = Date_Calc::DaysToDate(-229, "%Y %m %d"), '-229');
compare(-229, Date_Calc::DateToDays(9, 4, -4713), '-4713 04 09');
compare('-4713 04 10', $hs_date = Date_Calc::DaysToDate(-228, "%Y %m %d"), '-228');
compare(-228, Date_Calc::DateToDays(10, 4, -4713), '-4713 04 10');
compare('-4713 04 11', $hs_date = Date_Calc::DaysToDate(-227, "%Y %m %d"), '-227');
compare(-227, Date_Calc::DateToDays(11, 4, -4713), '-4713 04 11');
compare('-4713 04 12', $hs_date = Date_Calc::DaysToDate(-226, "%Y %m %d"), '-226');
compare(-226, Date_Calc::DateToDays(12, 4, -4713), '-4713 04 12');
compare('-4713 04 13', $hs_date = Date_Calc::DaysToDate(-225, "%Y %m %d"), '-225');
compare(-225, Date_Calc::DateToDays(13, 4, -4713), '-4713 04 13');
compare('-4713 04 14', $hs_date = Date_Calc::DaysToDate(-224, "%Y %m %d"), '-224');
compare(-224, Date_Calc::DateToDays(14, 4, -4713), '-4713 04 14');
compare('-4713 04 15', $hs_date = Date_Calc::DaysToDate(-223, "%Y %m %d"), '-223');
compare(-223, Date_Calc::DateToDays(15, 4, -4713), '-4713 04 15');
compare('-4713 04 16', $hs_date = Date_Calc::DaysToDate(-222, "%Y %m %d"), '-222');
compare(-222, Date_Calc::DateToDays(16, 4, -4713), '-4713 04 16');
compare('-4713 04 17', $hs_date = Date_Calc::DaysToDate(-221, "%Y %m %d"), '-221');
compare(-221, Date_Calc::DateToDays(17, 4, -4713), '-4713 04 17');
compare('-4713 04 18', $hs_date = Date_Calc::DaysToDate(-220, "%Y %m %d"), '-220');
compare(-220, Date_Calc::DateToDays(18, 4, -4713), '-4713 04 18');
compare('-4713 04 19', $hs_date = Date_Calc::DaysToDate(-219, "%Y %m %d"), '-219');
compare(-219, Date_Calc::DateToDays(19, 4, -4713), '-4713 04 19');
compare('-4713 04 20', $hs_date = Date_Calc::DaysToDate(-218, "%Y %m %d"), '-218');
compare(-218, Date_Calc::DateToDays(20, 4, -4713), '-4713 04 20');
compare('-4713 04 21', $hs_date = Date_Calc::DaysToDate(-217, "%Y %m %d"), '-217');
compare(-217, Date_Calc::DateToDays(21, 4, -4713), '-4713 04 21');
compare('-4713 04 22', $hs_date = Date_Calc::DaysToDate(-216, "%Y %m %d"), '-216');
compare(-216, Date_Calc::DateToDays(22, 4, -4713), '-4713 04 22');
compare('-4713 04 23', $hs_date = Date_Calc::DaysToDate(-215, "%Y %m %d"), '-215');
compare(-215, Date_Calc::DateToDays(23, 4, -4713), '-4713 04 23');
compare('-4713 04 24', $hs_date = Date_Calc::DaysToDate(-214, "%Y %m %d"), '-214');
compare(-214, Date_Calc::DateToDays(24, 4, -4713), '-4713 04 24');
compare('-4713 04 25', $hs_date = Date_Calc::DaysToDate(-213, "%Y %m %d"), '-213');
compare(-213, Date_Calc::DateToDays(25, 4, -4713), '-4713 04 25');
compare('-4713 04 26', $hs_date = Date_Calc::DaysToDate(-212, "%Y %m %d"), '-212');
compare(-212, Date_Calc::DateToDays(26, 4, -4713), '-4713 04 26');
compare('-4713 04 27', $hs_date = Date_Calc::DaysToDate(-211, "%Y %m %d"), '-211');
compare(-211, Date_Calc::DateToDays(27, 4, -4713), '-4713 04 27');
compare('-4713 04 28', $hs_date = Date_Calc::DaysToDate(-210, "%Y %m %d"), '-210');
compare(-210, Date_Calc::DateToDays(28, 4, -4713), '-4713 04 28');
compare('-4713 04 29', $hs_date = Date_Calc::DaysToDate(-209, "%Y %m %d"), '-209');
compare(-209, Date_Calc::DateToDays(29, 4, -4713), '-4713 04 29');
compare('-4713 04 30', $hs_date = Date_Calc::DaysToDate(-208, "%Y %m %d"), '-208');
compare(-208, Date_Calc::DateToDays(30, 4, -4713), '-4713 04 30');
compare('-4713 05 01', $hs_date = Date_Calc::DaysToDate(-207, "%Y %m %d"), '-207');
compare(-207, Date_Calc::DateToDays(1, 5, -4713), '-4713 05 01');
compare('-4713 05 02', $hs_date = Date_Calc::DaysToDate(-206, "%Y %m %d"), '-206');
compare(-206, Date_Calc::DateToDays(2, 5, -4713), '-4713 05 02');
compare('-4713 05 03', $hs_date = Date_Calc::DaysToDate(-205, "%Y %m %d"), '-205');
compare(-205, Date_Calc::DateToDays(3, 5, -4713), '-4713 05 03');
compare('-4713 05 04', $hs_date = Date_Calc::DaysToDate(-204, "%Y %m %d"), '-204');
compare(-204, Date_Calc::DateToDays(4, 5, -4713), '-4713 05 04');
compare('-4713 05 05', $hs_date = Date_Calc::DaysToDate(-203, "%Y %m %d"), '-203');
compare(-203, Date_Calc::DateToDays(5, 5, -4713), '-4713 05 05');
compare('-4713 05 06', $hs_date = Date_Calc::DaysToDate(-202, "%Y %m %d"), '-202');
compare(-202, Date_Calc::DateToDays(6, 5, -4713), '-4713 05 06');
compare('-4713 05 07', $hs_date = Date_Calc::DaysToDate(-201, "%Y %m %d"), '-201');
compare(-201, Date_Calc::DateToDays(7, 5, -4713), '-4713 05 07');
compare('-4713 05 08', $hs_date = Date_Calc::DaysToDate(-200, "%Y %m %d"), '-200');
compare(-200, Date_Calc::DateToDays(8, 5, -4713), '-4713 05 08');
compare('-4713 05 09', $hs_date = Date_Calc::DaysToDate(-199, "%Y %m %d"), '-199');
compare(-199, Date_Calc::DateToDays(9, 5, -4713), '-4713 05 09');
compare('-4713 05 10', $hs_date = Date_Calc::DaysToDate(-198, "%Y %m %d"), '-198');
compare(-198, Date_Calc::DateToDays(10, 5, -4713), '-4713 05 10');
compare('-4713 05 11', $hs_date = Date_Calc::DaysToDate(-197, "%Y %m %d"), '-197');
compare(-197, Date_Calc::DateToDays(11, 5, -4713), '-4713 05 11');
compare('-4713 05 12', $hs_date = Date_Calc::DaysToDate(-196, "%Y %m %d"), '-196');
compare(-196, Date_Calc::DateToDays(12, 5, -4713), '-4713 05 12');
compare('-4713 05 13', $hs_date = Date_Calc::DaysToDate(-195, "%Y %m %d"), '-195');
compare(-195, Date_Calc::DateToDays(13, 5, -4713), '-4713 05 13');
compare('-4713 05 14', $hs_date = Date_Calc::DaysToDate(-194, "%Y %m %d"), '-194');
compare(-194, Date_Calc::DateToDays(14, 5, -4713), '-4713 05 14');
compare('-4713 05 15', $hs_date = Date_Calc::DaysToDate(-193, "%Y %m %d"), '-193');
compare(-193, Date_Calc::DateToDays(15, 5, -4713), '-4713 05 15');
compare('-4713 05 16', $hs_date = Date_Calc::DaysToDate(-192, "%Y %m %d"), '-192');
compare(-192, Date_Calc::DateToDays(16, 5, -4713), '-4713 05 16');
compare('-4713 05 17', $hs_date = Date_Calc::DaysToDate(-191, "%Y %m %d"), '-191');
compare(-191, Date_Calc::DateToDays(17, 5, -4713), '-4713 05 17');
compare('-4713 05 18', $hs_date = Date_Calc::DaysToDate(-190, "%Y %m %d"), '-190');
compare(-190, Date_Calc::DateToDays(18, 5, -4713), '-4713 05 18');
compare('-4713 05 19', $hs_date = Date_Calc::DaysToDate(-189, "%Y %m %d"), '-189');
compare(-189, Date_Calc::DateToDays(19, 5, -4713), '-4713 05 19');
compare('-4713 05 20', $hs_date = Date_Calc::DaysToDate(-188, "%Y %m %d"), '-188');
compare(-188, Date_Calc::DateToDays(20, 5, -4713), '-4713 05 20');
compare('-4713 05 21', $hs_date = Date_Calc::DaysToDate(-187, "%Y %m %d"), '-187');
compare(-187, Date_Calc::DateToDays(21, 5, -4713), '-4713 05 21');
compare('-4713 05 22', $hs_date = Date_Calc::DaysToDate(-186, "%Y %m %d"), '-186');
compare(-186, Date_Calc::DateToDays(22, 5, -4713), '-4713 05 22');
compare('-4713 05 23', $hs_date = Date_Calc::DaysToDate(-185, "%Y %m %d"), '-185');
compare(-185, Date_Calc::DateToDays(23, 5, -4713), '-4713 05 23');
compare('-4713 05 24', $hs_date = Date_Calc::DaysToDate(-184, "%Y %m %d"), '-184');
compare(-184, Date_Calc::DateToDays(24, 5, -4713), '-4713 05 24');
compare('-4713 05 25', $hs_date = Date_Calc::DaysToDate(-183, "%Y %m %d"), '-183');
compare(-183, Date_Calc::DateToDays(25, 5, -4713), '-4713 05 25');
compare('-4713 05 26', $hs_date = Date_Calc::DaysToDate(-182, "%Y %m %d"), '-182');
compare(-182, Date_Calc::DateToDays(26, 5, -4713), '-4713 05 26');
compare('-4713 05 27', $hs_date = Date_Calc::DaysToDate(-181, "%Y %m %d"), '-181');
compare(-181, Date_Calc::DateToDays(27, 5, -4713), '-4713 05 27');
compare('-4713 05 28', $hs_date = Date_Calc::DaysToDate(-180, "%Y %m %d"), '-180');
compare(-180, Date_Calc::DateToDays(28, 5, -4713), '-4713 05 28');
compare('-4713 05 29', $hs_date = Date_Calc::DaysToDate(-179, "%Y %m %d"), '-179');
compare(-179, Date_Calc::DateToDays(29, 5, -4713), '-4713 05 29');
compare('-4713 05 30', $hs_date = Date_Calc::DaysToDate(-178, "%Y %m %d"), '-178');
compare(-178, Date_Calc::DateToDays(30, 5, -4713), '-4713 05 30');
compare('-4713 05 31', $hs_date = Date_Calc::DaysToDate(-177, "%Y %m %d"), '-177');
compare(-177, Date_Calc::DateToDays(31, 5, -4713), '-4713 05 31');
compare('-4713 06 01', $hs_date = Date_Calc::DaysToDate(-176, "%Y %m %d"), '-176');
compare(-176, Date_Calc::DateToDays(1, 6, -4713), '-4713 06 01');
compare('-4713 06 02', $hs_date = Date_Calc::DaysToDate(-175, "%Y %m %d"), '-175');
compare(-175, Date_Calc::DateToDays(2, 6, -4713), '-4713 06 02');
compare('-4713 06 03', $hs_date = Date_Calc::DaysToDate(-174, "%Y %m %d"), '-174');
compare(-174, Date_Calc::DateToDays(3, 6, -4713), '-4713 06 03');
compare('-4713 06 04', $hs_date = Date_Calc::DaysToDate(-173, "%Y %m %d"), '-173');
compare(-173, Date_Calc::DateToDays(4, 6, -4713), '-4713 06 04');
compare('-4713 06 05', $hs_date = Date_Calc::DaysToDate(-172, "%Y %m %d"), '-172');
compare(-172, Date_Calc::DateToDays(5, 6, -4713), '-4713 06 05');
compare('-4713 06 06', $hs_date = Date_Calc::DaysToDate(-171, "%Y %m %d"), '-171');
compare(-171, Date_Calc::DateToDays(6, 6, -4713), '-4713 06 06');
compare('-4713 06 07', $hs_date = Date_Calc::DaysToDate(-170, "%Y %m %d"), '-170');
compare(-170, Date_Calc::DateToDays(7, 6, -4713), '-4713 06 07');
compare('-4713 06 08', $hs_date = Date_Calc::DaysToDate(-169, "%Y %m %d"), '-169');
compare(-169, Date_Calc::DateToDays(8, 6, -4713), '-4713 06 08');
compare('-4713 06 09', $hs_date = Date_Calc::DaysToDate(-168, "%Y %m %d"), '-168');
compare(-168, Date_Calc::DateToDays(9, 6, -4713), '-4713 06 09');
compare('-4713 06 10', $hs_date = Date_Calc::DaysToDate(-167, "%Y %m %d"), '-167');
compare(-167, Date_Calc::DateToDays(10, 6, -4713), '-4713 06 10');
compare('-4713 06 11', $hs_date = Date_Calc::DaysToDate(-166, "%Y %m %d"), '-166');
compare(-166, Date_Calc::DateToDays(11, 6, -4713), '-4713 06 11');
compare('-4713 06 12', $hs_date = Date_Calc::DaysToDate(-165, "%Y %m %d"), '-165');
compare(-165, Date_Calc::DateToDays(12, 6, -4713), '-4713 06 12');
compare('-4713 06 13', $hs_date = Date_Calc::DaysToDate(-164, "%Y %m %d"), '-164');
compare(-164, Date_Calc::DateToDays(13, 6, -4713), '-4713 06 13');
compare('-4713 06 14', $hs_date = Date_Calc::DaysToDate(-163, "%Y %m %d"), '-163');
compare(-163, Date_Calc::DateToDays(14, 6, -4713), '-4713 06 14');
compare('-4713 06 15', $hs_date = Date_Calc::DaysToDate(-162, "%Y %m %d"), '-162');
compare(-162, Date_Calc::DateToDays(15, 6, -4713), '-4713 06 15');
compare('-4713 06 16', $hs_date = Date_Calc::DaysToDate(-161, "%Y %m %d"), '-161');
compare(-161, Date_Calc::DateToDays(16, 6, -4713), '-4713 06 16');
compare('-4713 06 17', $hs_date = Date_Calc::DaysToDate(-160, "%Y %m %d"), '-160');
compare(-160, Date_Calc::DateToDays(17, 6, -4713), '-4713 06 17');
compare('-4713 06 18', $hs_date = Date_Calc::DaysToDate(-159, "%Y %m %d"), '-159');
compare(-159, Date_Calc::DateToDays(18, 6, -4713), '-4713 06 18');
compare('-4713 06 19', $hs_date = Date_Calc::DaysToDate(-158, "%Y %m %d"), '-158');
compare(-158, Date_Calc::DateToDays(19, 6, -4713), '-4713 06 19');
compare('-4713 06 20', $hs_date = Date_Calc::DaysToDate(-157, "%Y %m %d"), '-157');
compare(-157, Date_Calc::DateToDays(20, 6, -4713), '-4713 06 20');
compare('-4713 06 21', $hs_date = Date_Calc::DaysToDate(-156, "%Y %m %d"), '-156');
compare(-156, Date_Calc::DateToDays(21, 6, -4713), '-4713 06 21');
compare('-4713 06 22', $hs_date = Date_Calc::DaysToDate(-155, "%Y %m %d"), '-155');
compare(-155, Date_Calc::DateToDays(22, 6, -4713), '-4713 06 22');
compare('-4713 06 23', $hs_date = Date_Calc::DaysToDate(-154, "%Y %m %d"), '-154');
compare(-154, Date_Calc::DateToDays(23, 6, -4713), '-4713 06 23');
compare('-4713 06 24', $hs_date = Date_Calc::DaysToDate(-153, "%Y %m %d"), '-153');
compare(-153, Date_Calc::DateToDays(24, 6, -4713), '-4713 06 24');
compare('-4713 06 25', $hs_date = Date_Calc::DaysToDate(-152, "%Y %m %d"), '-152');
compare(-152, Date_Calc::DateToDays(25, 6, -4713), '-4713 06 25');
compare('-4713 06 26', $hs_date = Date_Calc::DaysToDate(-151, "%Y %m %d"), '-151');
compare(-151, Date_Calc::DateToDays(26, 6, -4713), '-4713 06 26');
compare('-4713 06 27', $hs_date = Date_Calc::DaysToDate(-150, "%Y %m %d"), '-150');
compare(-150, Date_Calc::DateToDays(27, 6, -4713), '-4713 06 27');
compare('-4713 06 28', $hs_date = Date_Calc::DaysToDate(-149, "%Y %m %d"), '-149');
compare(-149, Date_Calc::DateToDays(28, 6, -4713), '-4713 06 28');
compare('-4713 06 29', $hs_date = Date_Calc::DaysToDate(-148, "%Y %m %d"), '-148');
compare(-148, Date_Calc::DateToDays(29, 6, -4713), '-4713 06 29');
compare('-4713 06 30', $hs_date = Date_Calc::DaysToDate(-147, "%Y %m %d"), '-147');
compare(-147, Date_Calc::DateToDays(30, 6, -4713), '-4713 06 30');
compare('-4713 07 01', $hs_date = Date_Calc::DaysToDate(-146, "%Y %m %d"), '-146');
compare(-146, Date_Calc::DateToDays(1, 7, -4713), '-4713 07 01');
compare('-4713 07 02', $hs_date = Date_Calc::DaysToDate(-145, "%Y %m %d"), '-145');
compare(-145, Date_Calc::DateToDays(2, 7, -4713), '-4713 07 02');
compare('-4713 07 03', $hs_date = Date_Calc::DaysToDate(-144, "%Y %m %d"), '-144');
compare(-144, Date_Calc::DateToDays(3, 7, -4713), '-4713 07 03');
compare('-4713 07 04', $hs_date = Date_Calc::DaysToDate(-143, "%Y %m %d"), '-143');
compare(-143, Date_Calc::DateToDays(4, 7, -4713), '-4713 07 04');
compare('-4713 07 05', $hs_date = Date_Calc::DaysToDate(-142, "%Y %m %d"), '-142');
compare(-142, Date_Calc::DateToDays(5, 7, -4713), '-4713 07 05');
compare('-4713 07 06', $hs_date = Date_Calc::DaysToDate(-141, "%Y %m %d"), '-141');
compare(-141, Date_Calc::DateToDays(6, 7, -4713), '-4713 07 06');
compare('-4713 07 07', $hs_date = Date_Calc::DaysToDate(-140, "%Y %m %d"), '-140');
compare(-140, Date_Calc::DateToDays(7, 7, -4713), '-4713 07 07');
compare('-4713 07 08', $hs_date = Date_Calc::DaysToDate(-139, "%Y %m %d"), '-139');
compare(-139, Date_Calc::DateToDays(8, 7, -4713), '-4713 07 08');
compare('-4713 07 09', $hs_date = Date_Calc::DaysToDate(-138, "%Y %m %d"), '-138');
compare(-138, Date_Calc::DateToDays(9, 7, -4713), '-4713 07 09');
compare('-4713 07 10', $hs_date = Date_Calc::DaysToDate(-137, "%Y %m %d"), '-137');
compare(-137, Date_Calc::DateToDays(10, 7, -4713), '-4713 07 10');
compare('-4713 07 11', $hs_date = Date_Calc::DaysToDate(-136, "%Y %m %d"), '-136');
compare(-136, Date_Calc::DateToDays(11, 7, -4713), '-4713 07 11');
compare('-4713 07 12', $hs_date = Date_Calc::DaysToDate(-135, "%Y %m %d"), '-135');
compare(-135, Date_Calc::DateToDays(12, 7, -4713), '-4713 07 12');
compare('-4713 07 13', $hs_date = Date_Calc::DaysToDate(-134, "%Y %m %d"), '-134');
compare(-134, Date_Calc::DateToDays(13, 7, -4713), '-4713 07 13');
compare('-4713 07 14', $hs_date = Date_Calc::DaysToDate(-133, "%Y %m %d"), '-133');
compare(-133, Date_Calc::DateToDays(14, 7, -4713), '-4713 07 14');
compare('-4713 07 15', $hs_date = Date_Calc::DaysToDate(-132, "%Y %m %d"), '-132');
compare(-132, Date_Calc::DateToDays(15, 7, -4713), '-4713 07 15');
compare('-4713 07 16', $hs_date = Date_Calc::DaysToDate(-131, "%Y %m %d"), '-131');
compare(-131, Date_Calc::DateToDays(16, 7, -4713), '-4713 07 16');
compare('-4713 07 17', $hs_date = Date_Calc::DaysToDate(-130, "%Y %m %d"), '-130');
compare(-130, Date_Calc::DateToDays(17, 7, -4713), '-4713 07 17');
compare('-4713 07 18', $hs_date = Date_Calc::DaysToDate(-129, "%Y %m %d"), '-129');
compare(-129, Date_Calc::DateToDays(18, 7, -4713), '-4713 07 18');
compare('-4713 07 19', $hs_date = Date_Calc::DaysToDate(-128, "%Y %m %d"), '-128');
compare(-128, Date_Calc::DateToDays(19, 7, -4713), '-4713 07 19');
compare('-4713 07 20', $hs_date = Date_Calc::DaysToDate(-127, "%Y %m %d"), '-127');
compare(-127, Date_Calc::DateToDays(20, 7, -4713), '-4713 07 20');
compare('-4713 07 21', $hs_date = Date_Calc::DaysToDate(-126, "%Y %m %d"), '-126');
compare(-126, Date_Calc::DateToDays(21, 7, -4713), '-4713 07 21');
compare('-4713 07 22', $hs_date = Date_Calc::DaysToDate(-125, "%Y %m %d"), '-125');
compare(-125, Date_Calc::DateToDays(22, 7, -4713), '-4713 07 22');
compare('-4713 07 23', $hs_date = Date_Calc::DaysToDate(-124, "%Y %m %d"), '-124');
compare(-124, Date_Calc::DateToDays(23, 7, -4713), '-4713 07 23');
compare('-4713 07 24', $hs_date = Date_Calc::DaysToDate(-123, "%Y %m %d"), '-123');
compare(-123, Date_Calc::DateToDays(24, 7, -4713), '-4713 07 24');
compare('-4713 07 25', $hs_date = Date_Calc::DaysToDate(-122, "%Y %m %d"), '-122');
compare(-122, Date_Calc::DateToDays(25, 7, -4713), '-4713 07 25');
compare('-4713 07 26', $hs_date = Date_Calc::DaysToDate(-121, "%Y %m %d"), '-121');
compare(-121, Date_Calc::DateToDays(26, 7, -4713), '-4713 07 26');
compare('-4713 07 27', $hs_date = Date_Calc::DaysToDate(-120, "%Y %m %d"), '-120');
compare(-120, Date_Calc::DateToDays(27, 7, -4713), '-4713 07 27');
compare('-4713 07 28', $hs_date = Date_Calc::DaysToDate(-119, "%Y %m %d"), '-119');
compare(-119, Date_Calc::DateToDays(28, 7, -4713), '-4713 07 28');
compare('-4713 07 29', $hs_date = Date_Calc::DaysToDate(-118, "%Y %m %d"), '-118');
compare(-118, Date_Calc::DateToDays(29, 7, -4713), '-4713 07 29');
compare('-4713 07 30', $hs_date = Date_Calc::DaysToDate(-117, "%Y %m %d"), '-117');
compare(-117, Date_Calc::DateToDays(30, 7, -4713), '-4713 07 30');
compare('-4713 07 31', $hs_date = Date_Calc::DaysToDate(-116, "%Y %m %d"), '-116');
compare(-116, Date_Calc::DateToDays(31, 7, -4713), '-4713 07 31');
compare('-4713 08 01', $hs_date = Date_Calc::DaysToDate(-115, "%Y %m %d"), '-115');
compare(-115, Date_Calc::DateToDays(1, 8, -4713), '-4713 08 01');
compare('-4713 08 02', $hs_date = Date_Calc::DaysToDate(-114, "%Y %m %d"), '-114');
compare(-114, Date_Calc::DateToDays(2, 8, -4713), '-4713 08 02');
compare('-4713 08 03', $hs_date = Date_Calc::DaysToDate(-113, "%Y %m %d"), '-113');
compare(-113, Date_Calc::DateToDays(3, 8, -4713), '-4713 08 03');
compare('-4713 08 04', $hs_date = Date_Calc::DaysToDate(-112, "%Y %m %d"), '-112');
compare(-112, Date_Calc::DateToDays(4, 8, -4713), '-4713 08 04');
compare('-4713 08 05', $hs_date = Date_Calc::DaysToDate(-111, "%Y %m %d"), '-111');
compare(-111, Date_Calc::DateToDays(5, 8, -4713), '-4713 08 05');
compare('-4713 08 06', $hs_date = Date_Calc::DaysToDate(-110, "%Y %m %d"), '-110');
compare(-110, Date_Calc::DateToDays(6, 8, -4713), '-4713 08 06');
compare('-4713 08 07', $hs_date = Date_Calc::DaysToDate(-109, "%Y %m %d"), '-109');
compare(-109, Date_Calc::DateToDays(7, 8, -4713), '-4713 08 07');
compare('-4713 08 08', $hs_date = Date_Calc::DaysToDate(-108, "%Y %m %d"), '-108');
compare(-108, Date_Calc::DateToDays(8, 8, -4713), '-4713 08 08');
compare('-4713 08 09', $hs_date = Date_Calc::DaysToDate(-107, "%Y %m %d"), '-107');
compare(-107, Date_Calc::DateToDays(9, 8, -4713), '-4713 08 09');
compare('-4713 08 10', $hs_date = Date_Calc::DaysToDate(-106, "%Y %m %d"), '-106');
compare(-106, Date_Calc::DateToDays(10, 8, -4713), '-4713 08 10');
compare('-4713 08 11', $hs_date = Date_Calc::DaysToDate(-105, "%Y %m %d"), '-105');
compare(-105, Date_Calc::DateToDays(11, 8, -4713), '-4713 08 11');
compare('-4713 08 12', $hs_date = Date_Calc::DaysToDate(-104, "%Y %m %d"), '-104');
compare(-104, Date_Calc::DateToDays(12, 8, -4713), '-4713 08 12');
compare('-4713 08 13', $hs_date = Date_Calc::DaysToDate(-103, "%Y %m %d"), '-103');
compare(-103, Date_Calc::DateToDays(13, 8, -4713), '-4713 08 13');
compare('-4713 08 14', $hs_date = Date_Calc::DaysToDate(-102, "%Y %m %d"), '-102');
compare(-102, Date_Calc::DateToDays(14, 8, -4713), '-4713 08 14');
compare('-4713 08 15', $hs_date = Date_Calc::DaysToDate(-101, "%Y %m %d"), '-101');
compare(-101, Date_Calc::DateToDays(15, 8, -4713), '-4713 08 15');
compare('-4713 08 16', $hs_date = Date_Calc::DaysToDate(-100, "%Y %m %d"), '-100');
compare(-100, Date_Calc::DateToDays(16, 8, -4713), '-4713 08 16');
compare('-4713 08 17', $hs_date = Date_Calc::DaysToDate(-99, "%Y %m %d"), '-99');
compare(-99, Date_Calc::DateToDays(17, 8, -4713), '-4713 08 17');
compare('-4713 08 18', $hs_date = Date_Calc::DaysToDate(-98, "%Y %m %d"), '-98');
compare(-98, Date_Calc::DateToDays(18, 8, -4713), '-4713 08 18');
compare('-4713 08 19', $hs_date = Date_Calc::DaysToDate(-97, "%Y %m %d"), '-97');
compare(-97, Date_Calc::DateToDays(19, 8, -4713), '-4713 08 19');
compare('-4713 08 20', $hs_date = Date_Calc::DaysToDate(-96, "%Y %m %d"), '-96');
compare(-96, Date_Calc::DateToDays(20, 8, -4713), '-4713 08 20');
compare('-4713 08 21', $hs_date = Date_Calc::DaysToDate(-95, "%Y %m %d"), '-95');
compare(-95, Date_Calc::DateToDays(21, 8, -4713), '-4713 08 21');
compare('-4713 08 22', $hs_date = Date_Calc::DaysToDate(-94, "%Y %m %d"), '-94');
compare(-94, Date_Calc::DateToDays(22, 8, -4713), '-4713 08 22');
compare('-4713 08 23', $hs_date = Date_Calc::DaysToDate(-93, "%Y %m %d"), '-93');
compare(-93, Date_Calc::DateToDays(23, 8, -4713), '-4713 08 23');
compare('-4713 08 24', $hs_date = Date_Calc::DaysToDate(-92, "%Y %m %d"), '-92');
compare(-92, Date_Calc::DateToDays(24, 8, -4713), '-4713 08 24');
compare('-4713 08 25', $hs_date = Date_Calc::DaysToDate(-91, "%Y %m %d"), '-91');
compare(-91, Date_Calc::DateToDays(25, 8, -4713), '-4713 08 25');
compare('-4713 08 26', $hs_date = Date_Calc::DaysToDate(-90, "%Y %m %d"), '-90');
compare(-90, Date_Calc::DateToDays(26, 8, -4713), '-4713 08 26');
compare('-4713 08 27', $hs_date = Date_Calc::DaysToDate(-89, "%Y %m %d"), '-89');
compare(-89, Date_Calc::DateToDays(27, 8, -4713), '-4713 08 27');
compare('-4713 08 28', $hs_date = Date_Calc::DaysToDate(-88, "%Y %m %d"), '-88');
compare(-88, Date_Calc::DateToDays(28, 8, -4713), '-4713 08 28');
compare('-4713 08 29', $hs_date = Date_Calc::DaysToDate(-87, "%Y %m %d"), '-87');
compare(-87, Date_Calc::DateToDays(29, 8, -4713), '-4713 08 29');
compare('-4713 08 30', $hs_date = Date_Calc::DaysToDate(-86, "%Y %m %d"), '-86');
compare(-86, Date_Calc::DateToDays(30, 8, -4713), '-4713 08 30');
compare('-4713 08 31', $hs_date = Date_Calc::DaysToDate(-85, "%Y %m %d"), '-85');
compare(-85, Date_Calc::DateToDays(31, 8, -4713), '-4713 08 31');
compare('-4713 09 01', $hs_date = Date_Calc::DaysToDate(-84, "%Y %m %d"), '-84');
compare(-84, Date_Calc::DateToDays(1, 9, -4713), '-4713 09 01');
compare('-4713 09 02', $hs_date = Date_Calc::DaysToDate(-83, "%Y %m %d"), '-83');
compare(-83, Date_Calc::DateToDays(2, 9, -4713), '-4713 09 02');
compare('-4713 09 03', $hs_date = Date_Calc::DaysToDate(-82, "%Y %m %d"), '-82');
compare(-82, Date_Calc::DateToDays(3, 9, -4713), '-4713 09 03');
compare('-4713 09 04', $hs_date = Date_Calc::DaysToDate(-81, "%Y %m %d"), '-81');
compare(-81, Date_Calc::DateToDays(4, 9, -4713), '-4713 09 04');
compare('-4713 09 05', $hs_date = Date_Calc::DaysToDate(-80, "%Y %m %d"), '-80');
compare(-80, Date_Calc::DateToDays(5, 9, -4713), '-4713 09 05');
compare('-4713 09 06', $hs_date = Date_Calc::DaysToDate(-79, "%Y %m %d"), '-79');
compare(-79, Date_Calc::DateToDays(6, 9, -4713), '-4713 09 06');
compare('-4713 09 07', $hs_date = Date_Calc::DaysToDate(-78, "%Y %m %d"), '-78');
compare(-78, Date_Calc::DateToDays(7, 9, -4713), '-4713 09 07');
compare('-4713 09 08', $hs_date = Date_Calc::DaysToDate(-77, "%Y %m %d"), '-77');
compare(-77, Date_Calc::DateToDays(8, 9, -4713), '-4713 09 08');
compare('-4713 09 09', $hs_date = Date_Calc::DaysToDate(-76, "%Y %m %d"), '-76');
compare(-76, Date_Calc::DateToDays(9, 9, -4713), '-4713 09 09');
compare('-4713 09 10', $hs_date = Date_Calc::DaysToDate(-75, "%Y %m %d"), '-75');
compare(-75, Date_Calc::DateToDays(10, 9, -4713), '-4713 09 10');
compare('-4713 09 11', $hs_date = Date_Calc::DaysToDate(-74, "%Y %m %d"), '-74');
compare(-74, Date_Calc::DateToDays(11, 9, -4713), '-4713 09 11');
compare('-4713 09 12', $hs_date = Date_Calc::DaysToDate(-73, "%Y %m %d"), '-73');
compare(-73, Date_Calc::DateToDays(12, 9, -4713), '-4713 09 12');
compare('-4713 09 13', $hs_date = Date_Calc::DaysToDate(-72, "%Y %m %d"), '-72');
compare(-72, Date_Calc::DateToDays(13, 9, -4713), '-4713 09 13');
compare('-4713 09 14', $hs_date = Date_Calc::DaysToDate(-71, "%Y %m %d"), '-71');
compare(-71, Date_Calc::DateToDays(14, 9, -4713), '-4713 09 14');
compare('-4713 09 15', $hs_date = Date_Calc::DaysToDate(-70, "%Y %m %d"), '-70');
compare(-70, Date_Calc::DateToDays(15, 9, -4713), '-4713 09 15');
compare('-4713 09 16', $hs_date = Date_Calc::DaysToDate(-69, "%Y %m %d"), '-69');
compare(-69, Date_Calc::DateToDays(16, 9, -4713), '-4713 09 16');
compare('-4713 09 17', $hs_date = Date_Calc::DaysToDate(-68, "%Y %m %d"), '-68');
compare(-68, Date_Calc::DateToDays(17, 9, -4713), '-4713 09 17');
compare('-4713 09 18', $hs_date = Date_Calc::DaysToDate(-67, "%Y %m %d"), '-67');
compare(-67, Date_Calc::DateToDays(18, 9, -4713), '-4713 09 18');
compare('-4713 09 19', $hs_date = Date_Calc::DaysToDate(-66, "%Y %m %d"), '-66');
compare(-66, Date_Calc::DateToDays(19, 9, -4713), '-4713 09 19');
compare('-4713 09 20', $hs_date = Date_Calc::DaysToDate(-65, "%Y %m %d"), '-65');
compare(-65, Date_Calc::DateToDays(20, 9, -4713), '-4713 09 20');
compare('-4713 09 21', $hs_date = Date_Calc::DaysToDate(-64, "%Y %m %d"), '-64');
compare(-64, Date_Calc::DateToDays(21, 9, -4713), '-4713 09 21');
compare('-4713 09 22', $hs_date = Date_Calc::DaysToDate(-63, "%Y %m %d"), '-63');
compare(-63, Date_Calc::DateToDays(22, 9, -4713), '-4713 09 22');
compare('-4713 09 23', $hs_date = Date_Calc::DaysToDate(-62, "%Y %m %d"), '-62');
compare(-62, Date_Calc::DateToDays(23, 9, -4713), '-4713 09 23');
compare('-4713 09 24', $hs_date = Date_Calc::DaysToDate(-61, "%Y %m %d"), '-61');
compare(-61, Date_Calc::DateToDays(24, 9, -4713), '-4713 09 24');
compare('-4713 09 25', $hs_date = Date_Calc::DaysToDate(-60, "%Y %m %d"), '-60');
compare(-60, Date_Calc::DateToDays(25, 9, -4713), '-4713 09 25');
compare('-4713 09 26', $hs_date = Date_Calc::DaysToDate(-59, "%Y %m %d"), '-59');
compare(-59, Date_Calc::DateToDays(26, 9, -4713), '-4713 09 26');
compare('-4713 09 27', $hs_date = Date_Calc::DaysToDate(-58, "%Y %m %d"), '-58');
compare(-58, Date_Calc::DateToDays(27, 9, -4713), '-4713 09 27');
compare('-4713 09 28', $hs_date = Date_Calc::DaysToDate(-57, "%Y %m %d"), '-57');
compare(-57, Date_Calc::DateToDays(28, 9, -4713), '-4713 09 28');
compare('-4713 09 29', $hs_date = Date_Calc::DaysToDate(-56, "%Y %m %d"), '-56');
compare(-56, Date_Calc::DateToDays(29, 9, -4713), '-4713 09 29');
compare('-4713 09 30', $hs_date = Date_Calc::DaysToDate(-55, "%Y %m %d"), '-55');
compare(-55, Date_Calc::DateToDays(30, 9, -4713), '-4713 09 30');
compare('-4713 10 01', $hs_date = Date_Calc::DaysToDate(-54, "%Y %m %d"), '-54');
compare(-54, Date_Calc::DateToDays(1, 10, -4713), '-4713 10 01');
compare('-4713 10 02', $hs_date = Date_Calc::DaysToDate(-53, "%Y %m %d"), '-53');
compare(-53, Date_Calc::DateToDays(2, 10, -4713), '-4713 10 02');
compare('-4713 10 03', $hs_date = Date_Calc::DaysToDate(-52, "%Y %m %d"), '-52');
compare(-52, Date_Calc::DateToDays(3, 10, -4713), '-4713 10 03');
compare('-4713 10 04', $hs_date = Date_Calc::DaysToDate(-51, "%Y %m %d"), '-51');
compare(-51, Date_Calc::DateToDays(4, 10, -4713), '-4713 10 04');
compare('-4713 10 05', $hs_date = Date_Calc::DaysToDate(-50, "%Y %m %d"), '-50');
compare(-50, Date_Calc::DateToDays(5, 10, -4713), '-4713 10 05');
compare('-4713 10 06', $hs_date = Date_Calc::DaysToDate(-49, "%Y %m %d"), '-49');
compare(-49, Date_Calc::DateToDays(6, 10, -4713), '-4713 10 06');
compare('-4713 10 07', $hs_date = Date_Calc::DaysToDate(-48, "%Y %m %d"), '-48');
compare(-48, Date_Calc::DateToDays(7, 10, -4713), '-4713 10 07');
compare('-4713 10 08', $hs_date = Date_Calc::DaysToDate(-47, "%Y %m %d"), '-47');
compare(-47, Date_Calc::DateToDays(8, 10, -4713), '-4713 10 08');
compare('-4713 10 09', $hs_date = Date_Calc::DaysToDate(-46, "%Y %m %d"), '-46');
compare(-46, Date_Calc::DateToDays(9, 10, -4713), '-4713 10 09');
compare('-4713 10 10', $hs_date = Date_Calc::DaysToDate(-45, "%Y %m %d"), '-45');
compare(-45, Date_Calc::DateToDays(10, 10, -4713), '-4713 10 10');
compare('-4713 10 11', $hs_date = Date_Calc::DaysToDate(-44, "%Y %m %d"), '-44');
compare(-44, Date_Calc::DateToDays(11, 10, -4713), '-4713 10 11');
compare('-4713 10 12', $hs_date = Date_Calc::DaysToDate(-43, "%Y %m %d"), '-43');
compare(-43, Date_Calc::DateToDays(12, 10, -4713), '-4713 10 12');
compare('-4713 10 13', $hs_date = Date_Calc::DaysToDate(-42, "%Y %m %d"), '-42');
compare(-42, Date_Calc::DateToDays(13, 10, -4713), '-4713 10 13');
compare('-4713 10 14', $hs_date = Date_Calc::DaysToDate(-41, "%Y %m %d"), '-41');
compare(-41, Date_Calc::DateToDays(14, 10, -4713), '-4713 10 14');
compare('-4713 10 15', $hs_date = Date_Calc::DaysToDate(-40, "%Y %m %d"), '-40');
compare(-40, Date_Calc::DateToDays(15, 10, -4713), '-4713 10 15');
compare('-4713 10 16', $hs_date = Date_Calc::DaysToDate(-39, "%Y %m %d"), '-39');
compare(-39, Date_Calc::DateToDays(16, 10, -4713), '-4713 10 16');
compare('-4713 10 17', $hs_date = Date_Calc::DaysToDate(-38, "%Y %m %d"), '-38');
compare(-38, Date_Calc::DateToDays(17, 10, -4713), '-4713 10 17');
compare('-4713 10 18', $hs_date = Date_Calc::DaysToDate(-37, "%Y %m %d"), '-37');
compare(-37, Date_Calc::DateToDays(18, 10, -4713), '-4713 10 18');
compare('-4713 10 19', $hs_date = Date_Calc::DaysToDate(-36, "%Y %m %d"), '-36');
compare(-36, Date_Calc::DateToDays(19, 10, -4713), '-4713 10 19');
compare('-4713 10 20', $hs_date = Date_Calc::DaysToDate(-35, "%Y %m %d"), '-35');
compare(-35, Date_Calc::DateToDays(20, 10, -4713), '-4713 10 20');
compare('-4713 10 21', $hs_date = Date_Calc::DaysToDate(-34, "%Y %m %d"), '-34');
compare(-34, Date_Calc::DateToDays(21, 10, -4713), '-4713 10 21');
compare('-4713 10 22', $hs_date = Date_Calc::DaysToDate(-33, "%Y %m %d"), '-33');
compare(-33, Date_Calc::DateToDays(22, 10, -4713), '-4713 10 22');
compare('-4713 10 23', $hs_date = Date_Calc::DaysToDate(-32, "%Y %m %d"), '-32');
compare(-32, Date_Calc::DateToDays(23, 10, -4713), '-4713 10 23');
compare('-4713 10 24', $hs_date = Date_Calc::DaysToDate(-31, "%Y %m %d"), '-31');
compare(-31, Date_Calc::DateToDays(24, 10, -4713), '-4713 10 24');
compare('-4713 10 25', $hs_date = Date_Calc::DaysToDate(-30, "%Y %m %d"), '-30');
compare(-30, Date_Calc::DateToDays(25, 10, -4713), '-4713 10 25');
compare('-4713 10 26', $hs_date = Date_Calc::DaysToDate(-29, "%Y %m %d"), '-29');
compare(-29, Date_Calc::DateToDays(26, 10, -4713), '-4713 10 26');
compare('-4713 10 27', $hs_date = Date_Calc::DaysToDate(-28, "%Y %m %d"), '-28');
compare(-28, Date_Calc::DateToDays(27, 10, -4713), '-4713 10 27');
compare('-4713 10 28', $hs_date = Date_Calc::DaysToDate(-27, "%Y %m %d"), '-27');
compare(-27, Date_Calc::DateToDays(28, 10, -4713), '-4713 10 28');
compare('-4713 10 29', $hs_date = Date_Calc::DaysToDate(-26, "%Y %m %d"), '-26');
compare(-26, Date_Calc::DateToDays(29, 10, -4713), '-4713 10 29');
compare('-4713 10 30', $hs_date = Date_Calc::DaysToDate(-25, "%Y %m %d"), '-25');
compare(-25, Date_Calc::DateToDays(30, 10, -4713), '-4713 10 30');
compare('-4713 10 31', $hs_date = Date_Calc::DaysToDate(-24, "%Y %m %d"), '-24');
compare(-24, Date_Calc::DateToDays(31, 10, -4713), '-4713 10 31');
compare('-4713 11 01', $hs_date = Date_Calc::DaysToDate(-23, "%Y %m %d"), '-23');
compare(-23, Date_Calc::DateToDays(1, 11, -4713), '-4713 11 01');
compare('-4713 11 02', $hs_date = Date_Calc::DaysToDate(-22, "%Y %m %d"), '-22');
compare(-22, Date_Calc::DateToDays(2, 11, -4713), '-4713 11 02');
compare('-4713 11 03', $hs_date = Date_Calc::DaysToDate(-21, "%Y %m %d"), '-21');
compare(-21, Date_Calc::DateToDays(3, 11, -4713), '-4713 11 03');
compare('-4713 11 04', $hs_date = Date_Calc::DaysToDate(-20, "%Y %m %d"), '-20');
compare(-20, Date_Calc::DateToDays(4, 11, -4713), '-4713 11 04');
compare('-4713 11 05', $hs_date = Date_Calc::DaysToDate(-19, "%Y %m %d"), '-19');
compare(-19, Date_Calc::DateToDays(5, 11, -4713), '-4713 11 05');
compare('-4713 11 06', $hs_date = Date_Calc::DaysToDate(-18, "%Y %m %d"), '-18');
compare(-18, Date_Calc::DateToDays(6, 11, -4713), '-4713 11 06');
compare('-4713 11 07', $hs_date = Date_Calc::DaysToDate(-17, "%Y %m %d"), '-17');
compare(-17, Date_Calc::DateToDays(7, 11, -4713), '-4713 11 07');
compare('-4713 11 08', $hs_date = Date_Calc::DaysToDate(-16, "%Y %m %d"), '-16');
compare(-16, Date_Calc::DateToDays(8, 11, -4713), '-4713 11 08');
compare('-4713 11 09', $hs_date = Date_Calc::DaysToDate(-15, "%Y %m %d"), '-15');
compare(-15, Date_Calc::DateToDays(9, 11, -4713), '-4713 11 09');
compare('-4713 11 10', $hs_date = Date_Calc::DaysToDate(-14, "%Y %m %d"), '-14');
compare(-14, Date_Calc::DateToDays(10, 11, -4713), '-4713 11 10');
compare('-4713 11 11', $hs_date = Date_Calc::DaysToDate(-13, "%Y %m %d"), '-13');
compare(-13, Date_Calc::DateToDays(11, 11, -4713), '-4713 11 11');
compare('-4713 11 12', $hs_date = Date_Calc::DaysToDate(-12, "%Y %m %d"), '-12');
compare(-12, Date_Calc::DateToDays(12, 11, -4713), '-4713 11 12');
compare('-4713 11 13', $hs_date = Date_Calc::DaysToDate(-11, "%Y %m %d"), '-11');
compare(-11, Date_Calc::DateToDays(13, 11, -4713), '-4713 11 13');
compare('-4713 11 14', $hs_date = Date_Calc::DaysToDate(-10, "%Y %m %d"), '-10');
compare(-10, Date_Calc::DateToDays(14, 11, -4713), '-4713 11 14');
compare('-4713 11 15', $hs_date = Date_Calc::DaysToDate(-9, "%Y %m %d"), '-9');
compare(-9, Date_Calc::DateToDays(15, 11, -4713), '-4713 11 15');
compare('-4713 11 16', $hs_date = Date_Calc::DaysToDate(-8, "%Y %m %d"), '-8');
compare(-8, Date_Calc::DateToDays(16, 11, -4713), '-4713 11 16');
compare('-4713 11 17', $hs_date = Date_Calc::DaysToDate(-7, "%Y %m %d"), '-7');
compare(-7, Date_Calc::DateToDays(17, 11, -4713), '-4713 11 17');
compare('-4713 11 18', $hs_date = Date_Calc::DaysToDate(-6, "%Y %m %d"), '-6');
compare(-6, Date_Calc::DateToDays(18, 11, -4713), '-4713 11 18');
compare('-4713 11 19', $hs_date = Date_Calc::DaysToDate(-5, "%Y %m %d"), '-5');
compare(-5, Date_Calc::DateToDays(19, 11, -4713), '-4713 11 19');
compare('-4713 11 20', $hs_date = Date_Calc::DaysToDate(-4, "%Y %m %d"), '-4');
compare(-4, Date_Calc::DateToDays(20, 11, -4713), '-4713 11 20');
compare('-4713 11 21', $hs_date = Date_Calc::DaysToDate(-3, "%Y %m %d"), '-3');
compare(-3, Date_Calc::DateToDays(21, 11, -4713), '-4713 11 21');
compare('-4713 11 22', $hs_date = Date_Calc::DaysToDate(-2, "%Y %m %d"), '-2');
compare(-2, Date_Calc::DateToDays(22, 11, -4713), '-4713 11 22');
compare('-4713 11 23', $hs_date = Date_Calc::DaysToDate(-1, "%Y %m %d"), '-1');
compare(-1, Date_Calc::DateToDays(23, 11, -4713), '-4713 11 23');
compare('-4713 11 24', $hs_date = Date_Calc::DaysToDate(0, "%Y %m %d"), '0');
compare(0, Date_Calc::DateToDays(24, 11, -4713), '-4713 11 24');
compare('-4713 11 25', $hs_date = Date_Calc::DaysToDate(1, "%Y %m %d"), '1');
compare(1, Date_Calc::DateToDays(25, 11, -4713), '-4713 11 25');
compare('-4713 11 26', $hs_date = Date_Calc::DaysToDate(2, "%Y %m %d"), '2');
compare(2, Date_Calc::DateToDays(26, 11, -4713), '-4713 11 26');
compare('-4713 11 27', $hs_date = Date_Calc::DaysToDate(3, "%Y %m %d"), '3');
compare(3, Date_Calc::DateToDays(27, 11, -4713), '-4713 11 27');
compare('-4713 11 28', $hs_date = Date_Calc::DaysToDate(4, "%Y %m %d"), '4');
compare(4, Date_Calc::DateToDays(28, 11, -4713), '-4713 11 28');
compare('-4713 11 29', $hs_date = Date_Calc::DaysToDate(5, "%Y %m %d"), '5');
compare(5, Date_Calc::DateToDays(29, 11, -4713), '-4713 11 29');
compare('-4713 11 30', $hs_date = Date_Calc::DaysToDate(6, "%Y %m %d"), '6');
compare(6, Date_Calc::DateToDays(30, 11, -4713), '-4713 11 30');
compare('-4713 12 01', $hs_date = Date_Calc::DaysToDate(7, "%Y %m %d"), '7');
compare(7, Date_Calc::DateToDays(1, 12, -4713), '-4713 12 01');
compare('-4713 12 02', $hs_date = Date_Calc::DaysToDate(8, "%Y %m %d"), '8');
compare(8, Date_Calc::DateToDays(2, 12, -4713), '-4713 12 02');
compare('-4713 12 03', $hs_date = Date_Calc::DaysToDate(9, "%Y %m %d"), '9');
compare(9, Date_Calc::DateToDays(3, 12, -4713), '-4713 12 03');
compare('-4713 12 04', $hs_date = Date_Calc::DaysToDate(10, "%Y %m %d"), '10');
compare(10, Date_Calc::DateToDays(4, 12, -4713), '-4713 12 04');
compare('-4713 12 05', $hs_date = Date_Calc::DaysToDate(11, "%Y %m %d"), '11');
compare(11, Date_Calc::DateToDays(5, 12, -4713), '-4713 12 05');
compare('-4713 12 06', $hs_date = Date_Calc::DaysToDate(12, "%Y %m %d"), '12');
compare(12, Date_Calc::DateToDays(6, 12, -4713), '-4713 12 06');
compare('-4713 12 07', $hs_date = Date_Calc::DaysToDate(13, "%Y %m %d"), '13');
compare(13, Date_Calc::DateToDays(7, 12, -4713), '-4713 12 07');
compare('-4713 12 08', $hs_date = Date_Calc::DaysToDate(14, "%Y %m %d"), '14');
compare(14, Date_Calc::DateToDays(8, 12, -4713), '-4713 12 08');
compare('-4713 12 09', $hs_date = Date_Calc::DaysToDate(15, "%Y %m %d"), '15');
compare(15, Date_Calc::DateToDays(9, 12, -4713), '-4713 12 09');
compare('-4713 12 10', $hs_date = Date_Calc::DaysToDate(16, "%Y %m %d"), '16');
compare(16, Date_Calc::DateToDays(10, 12, -4713), '-4713 12 10');
compare('-4713 12 11', $hs_date = Date_Calc::DaysToDate(17, "%Y %m %d"), '17');
compare(17, Date_Calc::DateToDays(11, 12, -4713), '-4713 12 11');
compare('-4713 12 12', $hs_date = Date_Calc::DaysToDate(18, "%Y %m %d"), '18');
compare(18, Date_Calc::DateToDays(12, 12, -4713), '-4713 12 12');
compare('-4713 12 13', $hs_date = Date_Calc::DaysToDate(19, "%Y %m %d"), '19');
compare(19, Date_Calc::DateToDays(13, 12, -4713), '-4713 12 13');
compare('-4713 12 14', $hs_date = Date_Calc::DaysToDate(20, "%Y %m %d"), '20');
compare(20, Date_Calc::DateToDays(14, 12, -4713), '-4713 12 14');
compare('-4713 12 15', $hs_date = Date_Calc::DaysToDate(21, "%Y %m %d"), '21');
compare(21, Date_Calc::DateToDays(15, 12, -4713), '-4713 12 15');
compare('-4713 12 16', $hs_date = Date_Calc::DaysToDate(22, "%Y %m %d"), '22');
compare(22, Date_Calc::DateToDays(16, 12, -4713), '-4713 12 16');
compare('-4713 12 17', $hs_date = Date_Calc::DaysToDate(23, "%Y %m %d"), '23');
compare(23, Date_Calc::DateToDays(17, 12, -4713), '-4713 12 17');
compare('-4713 12 18', $hs_date = Date_Calc::DaysToDate(24, "%Y %m %d"), '24');
compare(24, Date_Calc::DateToDays(18, 12, -4713), '-4713 12 18');
compare('-4713 12 19', $hs_date = Date_Calc::DaysToDate(25, "%Y %m %d"), '25');
compare(25, Date_Calc::DateToDays(19, 12, -4713), '-4713 12 19');
compare('-4713 12 20', $hs_date = Date_Calc::DaysToDate(26, "%Y %m %d"), '26');
compare(26, Date_Calc::DateToDays(20, 12, -4713), '-4713 12 20');
compare('-4713 12 21', $hs_date = Date_Calc::DaysToDate(27, "%Y %m %d"), '27');
compare(27, Date_Calc::DateToDays(21, 12, -4713), '-4713 12 21');
compare('-4713 12 22', $hs_date = Date_Calc::DaysToDate(28, "%Y %m %d"), '28');
compare(28, Date_Calc::DateToDays(22, 12, -4713), '-4713 12 22');
compare('-4713 12 23', $hs_date = Date_Calc::DaysToDate(29, "%Y %m %d"), '29');
compare(29, Date_Calc::DateToDays(23, 12, -4713), '-4713 12 23');
compare('-4713 12 24', $hs_date = Date_Calc::DaysToDate(30, "%Y %m %d"), '30');
compare(30, Date_Calc::DateToDays(24, 12, -4713), '-4713 12 24');
compare('-4713 12 25', $hs_date = Date_Calc::DaysToDate(31, "%Y %m %d"), '31');
compare(31, Date_Calc::DateToDays(25, 12, -4713), '-4713 12 25');
compare('-4713 12 26', $hs_date = Date_Calc::DaysToDate(32, "%Y %m %d"), '32');
compare(32, Date_Calc::DateToDays(26, 12, -4713), '-4713 12 26');
compare('-4713 12 27', $hs_date = Date_Calc::DaysToDate(33, "%Y %m %d"), '33');
compare(33, Date_Calc::DateToDays(27, 12, -4713), '-4713 12 27');
compare('-4713 12 28', $hs_date = Date_Calc::DaysToDate(34, "%Y %m %d"), '34');
compare(34, Date_Calc::DateToDays(28, 12, -4713), '-4713 12 28');
compare('-4713 12 29', $hs_date = Date_Calc::DaysToDate(35, "%Y %m %d"), '35');
compare(35, Date_Calc::DateToDays(29, 12, -4713), '-4713 12 29');
compare('-4713 12 30', $hs_date = Date_Calc::DaysToDate(36, "%Y %m %d"), '36');
compare(36, Date_Calc::DateToDays(30, 12, -4713), '-4713 12 30');
compare('-4713 12 31', $hs_date = Date_Calc::DaysToDate(37, "%Y %m %d"), '37');
compare(37, Date_Calc::DateToDays(31, 12, -4713), '-4713 12 31');
compare('-4712 01 01', $hs_date = Date_Calc::DaysToDate(38, "%Y %m %d"), '38');
compare(38, Date_Calc::DateToDays(1, 1, -4712), '-4712 01 01');
compare('-4712 01 02', $hs_date = Date_Calc::DaysToDate(39, "%Y %m %d"), '39');
compare(39, Date_Calc::DateToDays(2, 1, -4712), '-4712 01 02');
compare('-4712 01 03', $hs_date = Date_Calc::DaysToDate(40, "%Y %m %d"), '40');
compare(40, Date_Calc::DateToDays(3, 1, -4712), '-4712 01 03');
compare('-4712 01 04', $hs_date = Date_Calc::DaysToDate(41, "%Y %m %d"), '41');
compare(41, Date_Calc::DateToDays(4, 1, -4712), '-4712 01 04');
compare('-4712 01 05', $hs_date = Date_Calc::DaysToDate(42, "%Y %m %d"), '42');
compare(42, Date_Calc::DateToDays(5, 1, -4712), '-4712 01 05');
compare('-4712 01 06', $hs_date = Date_Calc::DaysToDate(43, "%Y %m %d"), '43');
compare(43, Date_Calc::DateToDays(6, 1, -4712), '-4712 01 06');
compare('-4712 01 07', $hs_date = Date_Calc::DaysToDate(44, "%Y %m %d"), '44');
compare(44, Date_Calc::DateToDays(7, 1, -4712), '-4712 01 07');
compare('-4712 01 08', $hs_date = Date_Calc::DaysToDate(45, "%Y %m %d"), '45');
compare(45, Date_Calc::DateToDays(8, 1, -4712), '-4712 01 08');
compare('-4712 01 09', $hs_date = Date_Calc::DaysToDate(46, "%Y %m %d"), '46');
compare(46, Date_Calc::DateToDays(9, 1, -4712), '-4712 01 09');
compare('-4712 01 10', $hs_date = Date_Calc::DaysToDate(47, "%Y %m %d"), '47');
compare(47, Date_Calc::DateToDays(10, 1, -4712), '-4712 01 10');
compare('-4712 01 11', $hs_date = Date_Calc::DaysToDate(48, "%Y %m %d"), '48');
compare(48, Date_Calc::DateToDays(11, 1, -4712), '-4712 01 11');
compare('-4712 01 12', $hs_date = Date_Calc::DaysToDate(49, "%Y %m %d"), '49');
compare(49, Date_Calc::DateToDays(12, 1, -4712), '-4712 01 12');
compare('-4712 01 13', $hs_date = Date_Calc::DaysToDate(50, "%Y %m %d"), '50');
compare(50, Date_Calc::DateToDays(13, 1, -4712), '-4712 01 13');
compare('-4712 01 14', $hs_date = Date_Calc::DaysToDate(51, "%Y %m %d"), '51');
compare(51, Date_Calc::DateToDays(14, 1, -4712), '-4712 01 14');
compare('-4712 01 15', $hs_date = Date_Calc::DaysToDate(52, "%Y %m %d"), '52');
compare(52, Date_Calc::DateToDays(15, 1, -4712), '-4712 01 15');
compare('-4712 01 16', $hs_date = Date_Calc::DaysToDate(53, "%Y %m %d"), '53');
compare(53, Date_Calc::DateToDays(16, 1, -4712), '-4712 01 16');
compare('-4712 01 17', $hs_date = Date_Calc::DaysToDate(54, "%Y %m %d"), '54');
compare(54, Date_Calc::DateToDays(17, 1, -4712), '-4712 01 17');
compare('-4712 01 18', $hs_date = Date_Calc::DaysToDate(55, "%Y %m %d"), '55');
compare(55, Date_Calc::DateToDays(18, 1, -4712), '-4712 01 18');
compare('-4712 01 19', $hs_date = Date_Calc::DaysToDate(56, "%Y %m %d"), '56');
compare(56, Date_Calc::DateToDays(19, 1, -4712), '-4712 01 19');
compare('-4712 01 20', $hs_date = Date_Calc::DaysToDate(57, "%Y %m %d"), '57');
compare(57, Date_Calc::DateToDays(20, 1, -4712), '-4712 01 20');
compare('-4712 01 21', $hs_date = Date_Calc::DaysToDate(58, "%Y %m %d"), '58');
compare(58, Date_Calc::DateToDays(21, 1, -4712), '-4712 01 21');
compare('-4712 01 22', $hs_date = Date_Calc::DaysToDate(59, "%Y %m %d"), '59');
compare(59, Date_Calc::DateToDays(22, 1, -4712), '-4712 01 22');
compare('-4712 01 23', $hs_date = Date_Calc::DaysToDate(60, "%Y %m %d"), '60');
compare(60, Date_Calc::DateToDays(23, 1, -4712), '-4712 01 23');
compare('-4712 01 24', $hs_date = Date_Calc::DaysToDate(61, "%Y %m %d"), '61');
compare(61, Date_Calc::DateToDays(24, 1, -4712), '-4712 01 24');
compare('-4712 01 25', $hs_date = Date_Calc::DaysToDate(62, "%Y %m %d"), '62');
compare(62, Date_Calc::DateToDays(25, 1, -4712), '-4712 01 25');
compare('-4712 01 26', $hs_date = Date_Calc::DaysToDate(63, "%Y %m %d"), '63');
compare(63, Date_Calc::DateToDays(26, 1, -4712), '-4712 01 26');
compare('-4712 01 27', $hs_date = Date_Calc::DaysToDate(64, "%Y %m %d"), '64');
compare(64, Date_Calc::DateToDays(27, 1, -4712), '-4712 01 27');
compare('-4712 01 28', $hs_date = Date_Calc::DaysToDate(65, "%Y %m %d"), '65');
compare(65, Date_Calc::DateToDays(28, 1, -4712), '-4712 01 28');
compare('-4712 01 29', $hs_date = Date_Calc::DaysToDate(66, "%Y %m %d"), '66');
compare(66, Date_Calc::DateToDays(29, 1, -4712), '-4712 01 29');
compare('-4712 01 30', $hs_date = Date_Calc::DaysToDate(67, "%Y %m %d"), '67');
compare(67, Date_Calc::DateToDays(30, 1, -4712), '-4712 01 30');
compare('-4712 01 31', $hs_date = Date_Calc::DaysToDate(68, "%Y %m %d"), '68');
compare(68, Date_Calc::DateToDays(31, 1, -4712), '-4712 01 31');
compare('-4712 02 01', $hs_date = Date_Calc::DaysToDate(69, "%Y %m %d"), '69');
compare(69, Date_Calc::DateToDays(1, 2, -4712), '-4712 02 01');
compare('-4712 02 02', $hs_date = Date_Calc::DaysToDate(70, "%Y %m %d"), '70');
compare(70, Date_Calc::DateToDays(2, 2, -4712), '-4712 02 02');
compare('-4712 02 03', $hs_date = Date_Calc::DaysToDate(71, "%Y %m %d"), '71');
compare(71, Date_Calc::DateToDays(3, 2, -4712), '-4712 02 03');
compare('-4712 02 04', $hs_date = Date_Calc::DaysToDate(72, "%Y %m %d"), '72');
compare(72, Date_Calc::DateToDays(4, 2, -4712), '-4712 02 04');
compare('-4712 02 05', $hs_date = Date_Calc::DaysToDate(73, "%Y %m %d"), '73');
compare(73, Date_Calc::DateToDays(5, 2, -4712), '-4712 02 05');
compare('-4712 02 06', $hs_date = Date_Calc::DaysToDate(74, "%Y %m %d"), '74');
compare(74, Date_Calc::DateToDays(6, 2, -4712), '-4712 02 06');
compare('-4712 02 07', $hs_date = Date_Calc::DaysToDate(75, "%Y %m %d"), '75');
compare(75, Date_Calc::DateToDays(7, 2, -4712), '-4712 02 07');
compare('-4712 02 08', $hs_date = Date_Calc::DaysToDate(76, "%Y %m %d"), '76');
compare(76, Date_Calc::DateToDays(8, 2, -4712), '-4712 02 08');
compare('-4712 02 09', $hs_date = Date_Calc::DaysToDate(77, "%Y %m %d"), '77');
compare(77, Date_Calc::DateToDays(9, 2, -4712), '-4712 02 09');
compare('-4712 02 10', $hs_date = Date_Calc::DaysToDate(78, "%Y %m %d"), '78');
compare(78, Date_Calc::DateToDays(10, 2, -4712), '-4712 02 10');
compare('-4712 02 11', $hs_date = Date_Calc::DaysToDate(79, "%Y %m %d"), '79');
compare(79, Date_Calc::DateToDays(11, 2, -4712), '-4712 02 11');
compare('-4712 02 12', $hs_date = Date_Calc::DaysToDate(80, "%Y %m %d"), '80');
compare(80, Date_Calc::DateToDays(12, 2, -4712), '-4712 02 12');
compare('-4712 02 13', $hs_date = Date_Calc::DaysToDate(81, "%Y %m %d"), '81');
compare(81, Date_Calc::DateToDays(13, 2, -4712), '-4712 02 13');
compare('-4712 02 14', $hs_date = Date_Calc::DaysToDate(82, "%Y %m %d"), '82');
compare(82, Date_Calc::DateToDays(14, 2, -4712), '-4712 02 14');
compare('-4712 02 15', $hs_date = Date_Calc::DaysToDate(83, "%Y %m %d"), '83');
compare(83, Date_Calc::DateToDays(15, 2, -4712), '-4712 02 15');
compare('-4712 02 16', $hs_date = Date_Calc::DaysToDate(84, "%Y %m %d"), '84');
compare(84, Date_Calc::DateToDays(16, 2, -4712), '-4712 02 16');
compare('-4712 02 17', $hs_date = Date_Calc::DaysToDate(85, "%Y %m %d"), '85');
compare(85, Date_Calc::DateToDays(17, 2, -4712), '-4712 02 17');
compare('-4712 02 18', $hs_date = Date_Calc::DaysToDate(86, "%Y %m %d"), '86');
compare(86, Date_Calc::DateToDays(18, 2, -4712), '-4712 02 18');
compare('-4712 02 19', $hs_date = Date_Calc::DaysToDate(87, "%Y %m %d"), '87');
compare(87, Date_Calc::DateToDays(19, 2, -4712), '-4712 02 19');
compare('-4712 02 20', $hs_date = Date_Calc::DaysToDate(88, "%Y %m %d"), '88');
compare(88, Date_Calc::DateToDays(20, 2, -4712), '-4712 02 20');
compare('-4712 02 21', $hs_date = Date_Calc::DaysToDate(89, "%Y %m %d"), '89');
compare(89, Date_Calc::DateToDays(21, 2, -4712), '-4712 02 21');
compare('-4712 02 22', $hs_date = Date_Calc::DaysToDate(90, "%Y %m %d"), '90');
compare(90, Date_Calc::DateToDays(22, 2, -4712), '-4712 02 22');
compare('-4712 02 23', $hs_date = Date_Calc::DaysToDate(91, "%Y %m %d"), '91');
compare(91, Date_Calc::DateToDays(23, 2, -4712), '-4712 02 23');
compare('-4712 02 24', $hs_date = Date_Calc::DaysToDate(92, "%Y %m %d"), '92');
compare(92, Date_Calc::DateToDays(24, 2, -4712), '-4712 02 24');
compare('-4712 02 25', $hs_date = Date_Calc::DaysToDate(93, "%Y %m %d"), '93');
compare(93, Date_Calc::DateToDays(25, 2, -4712), '-4712 02 25');
compare('-4712 02 26', $hs_date = Date_Calc::DaysToDate(94, "%Y %m %d"), '94');
compare(94, Date_Calc::DateToDays(26, 2, -4712), '-4712 02 26');
compare('-4712 02 27', $hs_date = Date_Calc::DaysToDate(95, "%Y %m %d"), '95');
compare(95, Date_Calc::DateToDays(27, 2, -4712), '-4712 02 27');
compare('-4712 02 28', $hs_date = Date_Calc::DaysToDate(96, "%Y %m %d"), '96');
compare(96, Date_Calc::DateToDays(28, 2, -4712), '-4712 02 28');
compare('-4712 02 29', $hs_date = Date_Calc::DaysToDate(97, "%Y %m %d"), '97');
compare(97, Date_Calc::DateToDays(29, 2, -4712), '-4712 02 29');
compare('-4712 03 01', $hs_date = Date_Calc::DaysToDate(98, "%Y %m %d"), '98');
compare(98, Date_Calc::DateToDays(1, 3, -4712), '-4712 03 01');
compare('-4712 03 02', $hs_date = Date_Calc::DaysToDate(99, "%Y %m %d"), '99');
compare(99, Date_Calc::DateToDays(2, 3, -4712), '-4712 03 02');
compare('-4712 03 03', $hs_date = Date_Calc::DaysToDate(100, "%Y %m %d"), '100');
compare(100, Date_Calc::DateToDays(3, 3, -4712), '-4712 03 03');
compare('-4712 03 04', $hs_date = Date_Calc::DaysToDate(101, "%Y %m %d"), '101');
compare(101, Date_Calc::DateToDays(4, 3, -4712), '-4712 03 04');
compare('-4712 03 05', $hs_date = Date_Calc::DaysToDate(102, "%Y %m %d"), '102');
compare(102, Date_Calc::DateToDays(5, 3, -4712), '-4712 03 05');
compare('-4712 03 06', $hs_date = Date_Calc::DaysToDate(103, "%Y %m %d"), '103');
compare(103, Date_Calc::DateToDays(6, 3, -4712), '-4712 03 06');
compare('-4712 03 07', $hs_date = Date_Calc::DaysToDate(104, "%Y %m %d"), '104');
compare(104, Date_Calc::DateToDays(7, 3, -4712), '-4712 03 07');
compare('-4712 03 08', $hs_date = Date_Calc::DaysToDate(105, "%Y %m %d"), '105');
compare(105, Date_Calc::DateToDays(8, 3, -4712), '-4712 03 08');
compare('-4712 03 09', $hs_date = Date_Calc::DaysToDate(106, "%Y %m %d"), '106');
compare(106, Date_Calc::DateToDays(9, 3, -4712), '-4712 03 09');
compare('-4712 03 10', $hs_date = Date_Calc::DaysToDate(107, "%Y %m %d"), '107');
compare(107, Date_Calc::DateToDays(10, 3, -4712), '-4712 03 10');
compare('-4712 03 11', $hs_date = Date_Calc::DaysToDate(108, "%Y %m %d"), '108');
compare(108, Date_Calc::DateToDays(11, 3, -4712), '-4712 03 11');
compare('-4712 03 12', $hs_date = Date_Calc::DaysToDate(109, "%Y %m %d"), '109');
compare(109, Date_Calc::DateToDays(12, 3, -4712), '-4712 03 12');
compare('-4712 03 13', $hs_date = Date_Calc::DaysToDate(110, "%Y %m %d"), '110');
compare(110, Date_Calc::DateToDays(13, 3, -4712), '-4712 03 13');
compare('-4712 03 14', $hs_date = Date_Calc::DaysToDate(111, "%Y %m %d"), '111');
compare(111, Date_Calc::DateToDays(14, 3, -4712), '-4712 03 14');
compare('-4712 03 15', $hs_date = Date_Calc::DaysToDate(112, "%Y %m %d"), '112');
compare(112, Date_Calc::DateToDays(15, 3, -4712), '-4712 03 15');
compare('-4712 03 16', $hs_date = Date_Calc::DaysToDate(113, "%Y %m %d"), '113');
compare(113, Date_Calc::DateToDays(16, 3, -4712), '-4712 03 16');
compare('-4712 03 17', $hs_date = Date_Calc::DaysToDate(114, "%Y %m %d"), '114');
compare(114, Date_Calc::DateToDays(17, 3, -4712), '-4712 03 17');
compare('-4712 03 18', $hs_date = Date_Calc::DaysToDate(115, "%Y %m %d"), '115');
compare(115, Date_Calc::DateToDays(18, 3, -4712), '-4712 03 18');
compare('-4712 03 19', $hs_date = Date_Calc::DaysToDate(116, "%Y %m %d"), '116');
compare(116, Date_Calc::DateToDays(19, 3, -4712), '-4712 03 19');
compare('-4712 03 20', $hs_date = Date_Calc::DaysToDate(117, "%Y %m %d"), '117');
compare(117, Date_Calc::DateToDays(20, 3, -4712), '-4712 03 20');
compare('-4712 03 21', $hs_date = Date_Calc::DaysToDate(118, "%Y %m %d"), '118');
compare(118, Date_Calc::DateToDays(21, 3, -4712), '-4712 03 21');
compare('-4712 03 22', $hs_date = Date_Calc::DaysToDate(119, "%Y %m %d"), '119');
compare(119, Date_Calc::DateToDays(22, 3, -4712), '-4712 03 22');
compare('-4712 03 23', $hs_date = Date_Calc::DaysToDate(120, "%Y %m %d"), '120');
compare(120, Date_Calc::DateToDays(23, 3, -4712), '-4712 03 23');
compare('-4712 03 24', $hs_date = Date_Calc::DaysToDate(121, "%Y %m %d"), '121');
compare(121, Date_Calc::DateToDays(24, 3, -4712), '-4712 03 24');
compare('-4712 03 25', $hs_date = Date_Calc::DaysToDate(122, "%Y %m %d"), '122');
compare(122, Date_Calc::DateToDays(25, 3, -4712), '-4712 03 25');
compare('-4712 03 26', $hs_date = Date_Calc::DaysToDate(123, "%Y %m %d"), '123');
compare(123, Date_Calc::DateToDays(26, 3, -4712), '-4712 03 26');
compare('-4712 03 27', $hs_date = Date_Calc::DaysToDate(124, "%Y %m %d"), '124');
compare(124, Date_Calc::DateToDays(27, 3, -4712), '-4712 03 27');
compare('-4712 03 28', $hs_date = Date_Calc::DaysToDate(125, "%Y %m %d"), '125');
compare(125, Date_Calc::DateToDays(28, 3, -4712), '-4712 03 28');
compare('-4712 03 29', $hs_date = Date_Calc::DaysToDate(126, "%Y %m %d"), '126');
compare(126, Date_Calc::DateToDays(29, 3, -4712), '-4712 03 29');
compare('-4712 03 30', $hs_date = Date_Calc::DaysToDate(127, "%Y %m %d"), '127');
compare(127, Date_Calc::DateToDays(30, 3, -4712), '-4712 03 30');
compare('-4712 03 31', $hs_date = Date_Calc::DaysToDate(128, "%Y %m %d"), '128');
compare(128, Date_Calc::DateToDays(31, 3, -4712), '-4712 03 31');
compare('-4712 04 01', $hs_date = Date_Calc::DaysToDate(129, "%Y %m %d"), '129');
compare(129, Date_Calc::DateToDays(1, 4, -4712), '-4712 04 01');
compare('-4712 04 02', $hs_date = Date_Calc::DaysToDate(130, "%Y %m %d"), '130');
compare(130, Date_Calc::DateToDays(2, 4, -4712), '-4712 04 02');
compare('-4712 04 03', $hs_date = Date_Calc::DaysToDate(131, "%Y %m %d"), '131');
compare(131, Date_Calc::DateToDays(3, 4, -4712), '-4712 04 03');
compare('-4712 04 04', $hs_date = Date_Calc::DaysToDate(132, "%Y %m %d"), '132');
compare(132, Date_Calc::DateToDays(4, 4, -4712), '-4712 04 04');
compare('-4712 04 05', $hs_date = Date_Calc::DaysToDate(133, "%Y %m %d"), '133');
compare(133, Date_Calc::DateToDays(5, 4, -4712), '-4712 04 05');
compare('-4712 04 06', $hs_date = Date_Calc::DaysToDate(134, "%Y %m %d"), '134');
compare(134, Date_Calc::DateToDays(6, 4, -4712), '-4712 04 06');
compare('-4712 04 07', $hs_date = Date_Calc::DaysToDate(135, "%Y %m %d"), '135');
compare(135, Date_Calc::DateToDays(7, 4, -4712), '-4712 04 07');
compare('-4712 04 08', $hs_date = Date_Calc::DaysToDate(136, "%Y %m %d"), '136');
compare(136, Date_Calc::DateToDays(8, 4, -4712), '-4712 04 08');
compare('-4712 04 09', $hs_date = Date_Calc::DaysToDate(137, "%Y %m %d"), '137');
compare(137, Date_Calc::DateToDays(9, 4, -4712), '-4712 04 09');
compare('-4712 04 10', $hs_date = Date_Calc::DaysToDate(138, "%Y %m %d"), '138');
compare(138, Date_Calc::DateToDays(10, 4, -4712), '-4712 04 10');
compare('-4712 04 11', $hs_date = Date_Calc::DaysToDate(139, "%Y %m %d"), '139');
compare(139, Date_Calc::DateToDays(11, 4, -4712), '-4712 04 11');
compare('-4712 04 12', $hs_date = Date_Calc::DaysToDate(140, "%Y %m %d"), '140');
compare(140, Date_Calc::DateToDays(12, 4, -4712), '-4712 04 12');
compare('-4712 04 13', $hs_date = Date_Calc::DaysToDate(141, "%Y %m %d"), '141');
compare(141, Date_Calc::DateToDays(13, 4, -4712), '-4712 04 13');
compare('-4712 04 14', $hs_date = Date_Calc::DaysToDate(142, "%Y %m %d"), '142');
compare(142, Date_Calc::DateToDays(14, 4, -4712), '-4712 04 14');
compare('-4712 04 15', $hs_date = Date_Calc::DaysToDate(143, "%Y %m %d"), '143');
compare(143, Date_Calc::DateToDays(15, 4, -4712), '-4712 04 15');
compare('-4712 04 16', $hs_date = Date_Calc::DaysToDate(144, "%Y %m %d"), '144');
compare(144, Date_Calc::DateToDays(16, 4, -4712), '-4712 04 16');
compare('-4712 04 17', $hs_date = Date_Calc::DaysToDate(145, "%Y %m %d"), '145');
compare(145, Date_Calc::DateToDays(17, 4, -4712), '-4712 04 17');
compare('-4712 04 18', $hs_date = Date_Calc::DaysToDate(146, "%Y %m %d"), '146');
compare(146, Date_Calc::DateToDays(18, 4, -4712), '-4712 04 18');
compare('-4712 04 19', $hs_date = Date_Calc::DaysToDate(147, "%Y %m %d"), '147');
compare(147, Date_Calc::DateToDays(19, 4, -4712), '-4712 04 19');
compare('-4712 04 20', $hs_date = Date_Calc::DaysToDate(148, "%Y %m %d"), '148');
compare(148, Date_Calc::DateToDays(20, 4, -4712), '-4712 04 20');
compare('-4712 04 21', $hs_date = Date_Calc::DaysToDate(149, "%Y %m %d"), '149');
compare(149, Date_Calc::DateToDays(21, 4, -4712), '-4712 04 21');
compare('-4712 04 22', $hs_date = Date_Calc::DaysToDate(150, "%Y %m %d"), '150');
compare(150, Date_Calc::DateToDays(22, 4, -4712), '-4712 04 22');
compare('-4712 04 23', $hs_date = Date_Calc::DaysToDate(151, "%Y %m %d"), '151');
compare(151, Date_Calc::DateToDays(23, 4, -4712), '-4712 04 23');
compare('-4712 04 24', $hs_date = Date_Calc::DaysToDate(152, "%Y %m %d"), '152');
compare(152, Date_Calc::DateToDays(24, 4, -4712), '-4712 04 24');
compare('-4712 04 25', $hs_date = Date_Calc::DaysToDate(153, "%Y %m %d"), '153');
compare(153, Date_Calc::DateToDays(25, 4, -4712), '-4712 04 25');
compare('-4712 04 26', $hs_date = Date_Calc::DaysToDate(154, "%Y %m %d"), '154');
compare(154, Date_Calc::DateToDays(26, 4, -4712), '-4712 04 26');
compare('-4712 04 27', $hs_date = Date_Calc::DaysToDate(155, "%Y %m %d"), '155');
compare(155, Date_Calc::DateToDays(27, 4, -4712), '-4712 04 27');
compare('-4712 04 28', $hs_date = Date_Calc::DaysToDate(156, "%Y %m %d"), '156');
compare(156, Date_Calc::DateToDays(28, 4, -4712), '-4712 04 28');
compare('-4712 04 29', $hs_date = Date_Calc::DaysToDate(157, "%Y %m %d"), '157');
compare(157, Date_Calc::DateToDays(29, 4, -4712), '-4712 04 29');
compare('-4712 04 30', $hs_date = Date_Calc::DaysToDate(158, "%Y %m %d"), '158');
compare(158, Date_Calc::DateToDays(30, 4, -4712), '-4712 04 30');
compare('-4712 05 01', $hs_date = Date_Calc::DaysToDate(159, "%Y %m %d"), '159');
compare(159, Date_Calc::DateToDays(1, 5, -4712), '-4712 05 01');
compare('-4712 05 02', $hs_date = Date_Calc::DaysToDate(160, "%Y %m %d"), '160');
compare(160, Date_Calc::DateToDays(2, 5, -4712), '-4712 05 02');
compare('-4712 05 03', $hs_date = Date_Calc::DaysToDate(161, "%Y %m %d"), '161');
compare(161, Date_Calc::DateToDays(3, 5, -4712), '-4712 05 03');
compare('-4712 05 04', $hs_date = Date_Calc::DaysToDate(162, "%Y %m %d"), '162');
compare(162, Date_Calc::DateToDays(4, 5, -4712), '-4712 05 04');
compare('-4712 05 05', $hs_date = Date_Calc::DaysToDate(163, "%Y %m %d"), '163');
compare(163, Date_Calc::DateToDays(5, 5, -4712), '-4712 05 05');
compare('-4712 05 06', $hs_date = Date_Calc::DaysToDate(164, "%Y %m %d"), '164');
compare(164, Date_Calc::DateToDays(6, 5, -4712), '-4712 05 06');
compare('-4712 05 07', $hs_date = Date_Calc::DaysToDate(165, "%Y %m %d"), '165');
compare(165, Date_Calc::DateToDays(7, 5, -4712), '-4712 05 07');
compare('-4712 05 08', $hs_date = Date_Calc::DaysToDate(166, "%Y %m %d"), '166');
compare(166, Date_Calc::DateToDays(8, 5, -4712), '-4712 05 08');
compare('-4712 05 09', $hs_date = Date_Calc::DaysToDate(167, "%Y %m %d"), '167');
compare(167, Date_Calc::DateToDays(9, 5, -4712), '-4712 05 09');
compare('-4712 05 10', $hs_date = Date_Calc::DaysToDate(168, "%Y %m %d"), '168');
compare(168, Date_Calc::DateToDays(10, 5, -4712), '-4712 05 10');
compare('-4712 05 11', $hs_date = Date_Calc::DaysToDate(169, "%Y %m %d"), '169');
compare(169, Date_Calc::DateToDays(11, 5, -4712), '-4712 05 11');
compare('-4712 05 12', $hs_date = Date_Calc::DaysToDate(170, "%Y %m %d"), '170');
compare(170, Date_Calc::DateToDays(12, 5, -4712), '-4712 05 12');
compare('-4712 05 13', $hs_date = Date_Calc::DaysToDate(171, "%Y %m %d"), '171');
compare(171, Date_Calc::DateToDays(13, 5, -4712), '-4712 05 13');
compare('-4712 05 14', $hs_date = Date_Calc::DaysToDate(172, "%Y %m %d"), '172');
compare(172, Date_Calc::DateToDays(14, 5, -4712), '-4712 05 14');
compare('-4712 05 15', $hs_date = Date_Calc::DaysToDate(173, "%Y %m %d"), '173');
compare(173, Date_Calc::DateToDays(15, 5, -4712), '-4712 05 15');
compare('-4712 05 16', $hs_date = Date_Calc::DaysToDate(174, "%Y %m %d"), '174');
compare(174, Date_Calc::DateToDays(16, 5, -4712), '-4712 05 16');
compare('-4712 05 17', $hs_date = Date_Calc::DaysToDate(175, "%Y %m %d"), '175');
compare(175, Date_Calc::DateToDays(17, 5, -4712), '-4712 05 17');
compare('-4712 05 18', $hs_date = Date_Calc::DaysToDate(176, "%Y %m %d"), '176');
compare(176, Date_Calc::DateToDays(18, 5, -4712), '-4712 05 18');
compare('-4712 05 19', $hs_date = Date_Calc::DaysToDate(177, "%Y %m %d"), '177');
compare(177, Date_Calc::DateToDays(19, 5, -4712), '-4712 05 19');
compare('-4712 05 20', $hs_date = Date_Calc::DaysToDate(178, "%Y %m %d"), '178');
compare(178, Date_Calc::DateToDays(20, 5, -4712), '-4712 05 20');
compare('-4712 05 21', $hs_date = Date_Calc::DaysToDate(179, "%Y %m %d"), '179');
compare(179, Date_Calc::DateToDays(21, 5, -4712), '-4712 05 21');
compare('-4712 05 22', $hs_date = Date_Calc::DaysToDate(180, "%Y %m %d"), '180');
compare(180, Date_Calc::DateToDays(22, 5, -4712), '-4712 05 22');
compare('-4712 05 23', $hs_date = Date_Calc::DaysToDate(181, "%Y %m %d"), '181');
compare(181, Date_Calc::DateToDays(23, 5, -4712), '-4712 05 23');
compare('-4712 05 24', $hs_date = Date_Calc::DaysToDate(182, "%Y %m %d"), '182');
compare(182, Date_Calc::DateToDays(24, 5, -4712), '-4712 05 24');
compare('-4712 05 25', $hs_date = Date_Calc::DaysToDate(183, "%Y %m %d"), '183');
compare(183, Date_Calc::DateToDays(25, 5, -4712), '-4712 05 25');
compare('-4712 05 26', $hs_date = Date_Calc::DaysToDate(184, "%Y %m %d"), '184');
compare(184, Date_Calc::DateToDays(26, 5, -4712), '-4712 05 26');
compare('-4712 05 27', $hs_date = Date_Calc::DaysToDate(185, "%Y %m %d"), '185');
compare(185, Date_Calc::DateToDays(27, 5, -4712), '-4712 05 27');
compare('-4712 05 28', $hs_date = Date_Calc::DaysToDate(186, "%Y %m %d"), '186');
compare(186, Date_Calc::DateToDays(28, 5, -4712), '-4712 05 28');
compare('-4712 05 29', $hs_date = Date_Calc::DaysToDate(187, "%Y %m %d"), '187');
compare(187, Date_Calc::DateToDays(29, 5, -4712), '-4712 05 29');
compare('-4712 05 30', $hs_date = Date_Calc::DaysToDate(188, "%Y %m %d"), '188');
compare(188, Date_Calc::DateToDays(30, 5, -4712), '-4712 05 30');
compare('-4712 05 31', $hs_date = Date_Calc::DaysToDate(189, "%Y %m %d"), '189');
compare(189, Date_Calc::DateToDays(31, 5, -4712), '-4712 05 31');
compare('-4712 06 01', $hs_date = Date_Calc::DaysToDate(190, "%Y %m %d"), '190');
compare(190, Date_Calc::DateToDays(1, 6, -4712), '-4712 06 01');
compare('-4712 06 02', $hs_date = Date_Calc::DaysToDate(191, "%Y %m %d"), '191');
compare(191, Date_Calc::DateToDays(2, 6, -4712), '-4712 06 02');
compare('-4712 06 03', $hs_date = Date_Calc::DaysToDate(192, "%Y %m %d"), '192');
compare(192, Date_Calc::DateToDays(3, 6, -4712), '-4712 06 03');
compare('-4712 06 04', $hs_date = Date_Calc::DaysToDate(193, "%Y %m %d"), '193');
compare(193, Date_Calc::DateToDays(4, 6, -4712), '-4712 06 04');
compare('-4712 06 05', $hs_date = Date_Calc::DaysToDate(194, "%Y %m %d"), '194');
compare(194, Date_Calc::DateToDays(5, 6, -4712), '-4712 06 05');
compare('-4712 06 06', $hs_date = Date_Calc::DaysToDate(195, "%Y %m %d"), '195');
compare(195, Date_Calc::DateToDays(6, 6, -4712), '-4712 06 06');
compare('-4712 06 07', $hs_date = Date_Calc::DaysToDate(196, "%Y %m %d"), '196');
compare(196, Date_Calc::DateToDays(7, 6, -4712), '-4712 06 07');
compare('-4712 06 08', $hs_date = Date_Calc::DaysToDate(197, "%Y %m %d"), '197');
compare(197, Date_Calc::DateToDays(8, 6, -4712), '-4712 06 08');
compare('-4712 06 09', $hs_date = Date_Calc::DaysToDate(198, "%Y %m %d"), '198');
compare(198, Date_Calc::DateToDays(9, 6, -4712), '-4712 06 09');
compare('-4712 06 10', $hs_date = Date_Calc::DaysToDate(199, "%Y %m %d"), '199');
compare(199, Date_Calc::DateToDays(10, 6, -4712), '-4712 06 10');
compare('-4712 06 11', $hs_date = Date_Calc::DaysToDate(200, "%Y %m %d"), '200');
compare(200, Date_Calc::DateToDays(11, 6, -4712), '-4712 06 11');
compare('-4712 06 12', $hs_date = Date_Calc::DaysToDate(201, "%Y %m %d"), '201');
compare(201, Date_Calc::DateToDays(12, 6, -4712), '-4712 06 12');
compare('-4712 06 13', $hs_date = Date_Calc::DaysToDate(202, "%Y %m %d"), '202');
compare(202, Date_Calc::DateToDays(13, 6, -4712), '-4712 06 13');
compare('-4712 06 14', $hs_date = Date_Calc::DaysToDate(203, "%Y %m %d"), '203');
compare(203, Date_Calc::DateToDays(14, 6, -4712), '-4712 06 14');
compare('-4712 06 15', $hs_date = Date_Calc::DaysToDate(204, "%Y %m %d"), '204');
compare(204, Date_Calc::DateToDays(15, 6, -4712), '-4712 06 15');
compare('-4712 06 16', $hs_date = Date_Calc::DaysToDate(205, "%Y %m %d"), '205');
compare(205, Date_Calc::DateToDays(16, 6, -4712), '-4712 06 16');
compare('-4712 06 17', $hs_date = Date_Calc::DaysToDate(206, "%Y %m %d"), '206');
compare(206, Date_Calc::DateToDays(17, 6, -4712), '-4712 06 17');
compare('-4712 06 18', $hs_date = Date_Calc::DaysToDate(207, "%Y %m %d"), '207');
compare(207, Date_Calc::DateToDays(18, 6, -4712), '-4712 06 18');
compare('-4712 06 19', $hs_date = Date_Calc::DaysToDate(208, "%Y %m %d"), '208');
compare(208, Date_Calc::DateToDays(19, 6, -4712), '-4712 06 19');
compare('-4712 06 20', $hs_date = Date_Calc::DaysToDate(209, "%Y %m %d"), '209');
compare(209, Date_Calc::DateToDays(20, 6, -4712), '-4712 06 20');
compare('-4712 06 21', $hs_date = Date_Calc::DaysToDate(210, "%Y %m %d"), '210');
compare(210, Date_Calc::DateToDays(21, 6, -4712), '-4712 06 21');
compare('-4712 06 22', $hs_date = Date_Calc::DaysToDate(211, "%Y %m %d"), '211');
compare(211, Date_Calc::DateToDays(22, 6, -4712), '-4712 06 22');
compare('-4712 06 23', $hs_date = Date_Calc::DaysToDate(212, "%Y %m %d"), '212');
compare(212, Date_Calc::DateToDays(23, 6, -4712), '-4712 06 23');
compare('-4712 06 24', $hs_date = Date_Calc::DaysToDate(213, "%Y %m %d"), '213');
compare(213, Date_Calc::DateToDays(24, 6, -4712), '-4712 06 24');
compare('-4712 06 25', $hs_date = Date_Calc::DaysToDate(214, "%Y %m %d"), '214');
compare(214, Date_Calc::DateToDays(25, 6, -4712), '-4712 06 25');
compare('-4712 06 26', $hs_date = Date_Calc::DaysToDate(215, "%Y %m %d"), '215');
compare(215, Date_Calc::DateToDays(26, 6, -4712), '-4712 06 26');
compare('-4712 06 27', $hs_date = Date_Calc::DaysToDate(216, "%Y %m %d"), '216');
compare(216, Date_Calc::DateToDays(27, 6, -4712), '-4712 06 27');
compare('-4712 06 28', $hs_date = Date_Calc::DaysToDate(217, "%Y %m %d"), '217');
compare(217, Date_Calc::DateToDays(28, 6, -4712), '-4712 06 28');
compare('-4712 06 29', $hs_date = Date_Calc::DaysToDate(218, "%Y %m %d"), '218');
compare(218, Date_Calc::DateToDays(29, 6, -4712), '-4712 06 29');
compare('-4712 06 30', $hs_date = Date_Calc::DaysToDate(219, "%Y %m %d"), '219');
compare(219, Date_Calc::DateToDays(30, 6, -4712), '-4712 06 30');
compare('-4712 07 01', $hs_date = Date_Calc::DaysToDate(220, "%Y %m %d"), '220');
compare(220, Date_Calc::DateToDays(1, 7, -4712), '-4712 07 01');
compare('-4712 07 02', $hs_date = Date_Calc::DaysToDate(221, "%Y %m %d"), '221');
compare(221, Date_Calc::DateToDays(2, 7, -4712), '-4712 07 02');
compare('-4712 07 03', $hs_date = Date_Calc::DaysToDate(222, "%Y %m %d"), '222');
compare(222, Date_Calc::DateToDays(3, 7, -4712), '-4712 07 03');
compare('-4712 07 04', $hs_date = Date_Calc::DaysToDate(223, "%Y %m %d"), '223');
compare(223, Date_Calc::DateToDays(4, 7, -4712), '-4712 07 04');
compare('-4712 07 05', $hs_date = Date_Calc::DaysToDate(224, "%Y %m %d"), '224');
compare(224, Date_Calc::DateToDays(5, 7, -4712), '-4712 07 05');
compare('-4712 07 06', $hs_date = Date_Calc::DaysToDate(225, "%Y %m %d"), '225');
compare(225, Date_Calc::DateToDays(6, 7, -4712), '-4712 07 06');
compare('-4712 07 07', $hs_date = Date_Calc::DaysToDate(226, "%Y %m %d"), '226');
compare(226, Date_Calc::DateToDays(7, 7, -4712), '-4712 07 07');
compare('-4712 07 08', $hs_date = Date_Calc::DaysToDate(227, "%Y %m %d"), '227');
compare(227, Date_Calc::DateToDays(8, 7, -4712), '-4712 07 08');
compare('-4712 07 09', $hs_date = Date_Calc::DaysToDate(228, "%Y %m %d"), '228');
compare(228, Date_Calc::DateToDays(9, 7, -4712), '-4712 07 09');
compare('-4712 07 10', $hs_date = Date_Calc::DaysToDate(229, "%Y %m %d"), '229');
compare(229, Date_Calc::DateToDays(10, 7, -4712), '-4712 07 10');
compare('-4712 07 11', $hs_date = Date_Calc::DaysToDate(230, "%Y %m %d"), '230');
compare(230, Date_Calc::DateToDays(11, 7, -4712), '-4712 07 11');
compare('-4712 07 12', $hs_date = Date_Calc::DaysToDate(231, "%Y %m %d"), '231');
compare(231, Date_Calc::DateToDays(12, 7, -4712), '-4712 07 12');
compare('-4712 07 13', $hs_date = Date_Calc::DaysToDate(232, "%Y %m %d"), '232');
compare(232, Date_Calc::DateToDays(13, 7, -4712), '-4712 07 13');
compare('-4712 07 14', $hs_date = Date_Calc::DaysToDate(233, "%Y %m %d"), '233');
compare(233, Date_Calc::DateToDays(14, 7, -4712), '-4712 07 14');
compare('-4712 07 15', $hs_date = Date_Calc::DaysToDate(234, "%Y %m %d"), '234');
compare(234, Date_Calc::DateToDays(15, 7, -4712), '-4712 07 15');
compare('-4712 07 16', $hs_date = Date_Calc::DaysToDate(235, "%Y %m %d"), '235');
compare(235, Date_Calc::DateToDays(16, 7, -4712), '-4712 07 16');
compare('-4712 07 17', $hs_date = Date_Calc::DaysToDate(236, "%Y %m %d"), '236');
compare(236, Date_Calc::DateToDays(17, 7, -4712), '-4712 07 17');
compare('-4712 07 18', $hs_date = Date_Calc::DaysToDate(237, "%Y %m %d"), '237');
compare(237, Date_Calc::DateToDays(18, 7, -4712), '-4712 07 18');
compare('-4712 07 19', $hs_date = Date_Calc::DaysToDate(238, "%Y %m %d"), '238');
compare(238, Date_Calc::DateToDays(19, 7, -4712), '-4712 07 19');
compare('-4712 07 20', $hs_date = Date_Calc::DaysToDate(239, "%Y %m %d"), '239');
compare(239, Date_Calc::DateToDays(20, 7, -4712), '-4712 07 20');
compare('-4712 07 21', $hs_date = Date_Calc::DaysToDate(240, "%Y %m %d"), '240');
compare(240, Date_Calc::DateToDays(21, 7, -4712), '-4712 07 21');
compare('-4712 07 22', $hs_date = Date_Calc::DaysToDate(241, "%Y %m %d"), '241');
compare(241, Date_Calc::DateToDays(22, 7, -4712), '-4712 07 22');
compare('-4712 07 23', $hs_date = Date_Calc::DaysToDate(242, "%Y %m %d"), '242');
compare(242, Date_Calc::DateToDays(23, 7, -4712), '-4712 07 23');
compare('-4712 07 24', $hs_date = Date_Calc::DaysToDate(243, "%Y %m %d"), '243');
compare(243, Date_Calc::DateToDays(24, 7, -4712), '-4712 07 24');
compare('-4712 07 25', $hs_date = Date_Calc::DaysToDate(244, "%Y %m %d"), '244');
compare(244, Date_Calc::DateToDays(25, 7, -4712), '-4712 07 25');
compare('-4712 07 26', $hs_date = Date_Calc::DaysToDate(245, "%Y %m %d"), '245');
compare(245, Date_Calc::DateToDays(26, 7, -4712), '-4712 07 26');
compare('-4712 07 27', $hs_date = Date_Calc::DaysToDate(246, "%Y %m %d"), '246');
compare(246, Date_Calc::DateToDays(27, 7, -4712), '-4712 07 27');
compare('-4712 07 28', $hs_date = Date_Calc::DaysToDate(247, "%Y %m %d"), '247');
compare(247, Date_Calc::DateToDays(28, 7, -4712), '-4712 07 28');
compare('-4712 07 29', $hs_date = Date_Calc::DaysToDate(248, "%Y %m %d"), '248');
compare(248, Date_Calc::DateToDays(29, 7, -4712), '-4712 07 29');
compare('-4712 07 30', $hs_date = Date_Calc::DaysToDate(249, "%Y %m %d"), '249');
compare(249, Date_Calc::DateToDays(30, 7, -4712), '-4712 07 30');
compare('-4712 07 31', $hs_date = Date_Calc::DaysToDate(250, "%Y %m %d"), '250');
compare(250, Date_Calc::DateToDays(31, 7, -4712), '-4712 07 31');
compare('-4712 08 01', $hs_date = Date_Calc::DaysToDate(251, "%Y %m %d"), '251');
compare(251, Date_Calc::DateToDays(1, 8, -4712), '-4712 08 01');
compare('-4712 08 02', $hs_date = Date_Calc::DaysToDate(252, "%Y %m %d"), '252');
compare(252, Date_Calc::DateToDays(2, 8, -4712), '-4712 08 02');
compare('-4712 08 03', $hs_date = Date_Calc::DaysToDate(253, "%Y %m %d"), '253');
compare(253, Date_Calc::DateToDays(3, 8, -4712), '-4712 08 03');
compare('-4712 08 04', $hs_date = Date_Calc::DaysToDate(254, "%Y %m %d"), '254');
compare(254, Date_Calc::DateToDays(4, 8, -4712), '-4712 08 04');
compare('-4712 08 05', $hs_date = Date_Calc::DaysToDate(255, "%Y %m %d"), '255');
compare(255, Date_Calc::DateToDays(5, 8, -4712), '-4712 08 05');
compare('-4712 08 06', $hs_date = Date_Calc::DaysToDate(256, "%Y %m %d"), '256');
compare(256, Date_Calc::DateToDays(6, 8, -4712), '-4712 08 06');
compare('-4712 08 07', $hs_date = Date_Calc::DaysToDate(257, "%Y %m %d"), '257');
compare(257, Date_Calc::DateToDays(7, 8, -4712), '-4712 08 07');
compare('-4712 08 08', $hs_date = Date_Calc::DaysToDate(258, "%Y %m %d"), '258');
compare(258, Date_Calc::DateToDays(8, 8, -4712), '-4712 08 08');
compare('-4712 08 09', $hs_date = Date_Calc::DaysToDate(259, "%Y %m %d"), '259');
compare(259, Date_Calc::DateToDays(9, 8, -4712), '-4712 08 09');
compare('-4712 08 10', $hs_date = Date_Calc::DaysToDate(260, "%Y %m %d"), '260');
compare(260, Date_Calc::DateToDays(10, 8, -4712), '-4712 08 10');
compare('-4712 08 11', $hs_date = Date_Calc::DaysToDate(261, "%Y %m %d"), '261');
compare(261, Date_Calc::DateToDays(11, 8, -4712), '-4712 08 11');
compare('-4712 08 12', $hs_date = Date_Calc::DaysToDate(262, "%Y %m %d"), '262');
compare(262, Date_Calc::DateToDays(12, 8, -4712), '-4712 08 12');
compare('-4712 08 13', $hs_date = Date_Calc::DaysToDate(263, "%Y %m %d"), '263');
compare(263, Date_Calc::DateToDays(13, 8, -4712), '-4712 08 13');
compare('-4712 08 14', $hs_date = Date_Calc::DaysToDate(264, "%Y %m %d"), '264');
compare(264, Date_Calc::DateToDays(14, 8, -4712), '-4712 08 14');
compare('-4712 08 15', $hs_date = Date_Calc::DaysToDate(265, "%Y %m %d"), '265');
compare(265, Date_Calc::DateToDays(15, 8, -4712), '-4712 08 15');
compare('-4712 08 16', $hs_date = Date_Calc::DaysToDate(266, "%Y %m %d"), '266');
compare(266, Date_Calc::DateToDays(16, 8, -4712), '-4712 08 16');
compare('-4712 08 17', $hs_date = Date_Calc::DaysToDate(267, "%Y %m %d"), '267');
compare(267, Date_Calc::DateToDays(17, 8, -4712), '-4712 08 17');
compare('-4712 08 18', $hs_date = Date_Calc::DaysToDate(268, "%Y %m %d"), '268');
compare(268, Date_Calc::DateToDays(18, 8, -4712), '-4712 08 18');
compare('-4712 08 19', $hs_date = Date_Calc::DaysToDate(269, "%Y %m %d"), '269');
compare(269, Date_Calc::DateToDays(19, 8, -4712), '-4712 08 19');
compare('-4712 08 20', $hs_date = Date_Calc::DaysToDate(270, "%Y %m %d"), '270');
compare(270, Date_Calc::DateToDays(20, 8, -4712), '-4712 08 20');
compare('-4712 08 21', $hs_date = Date_Calc::DaysToDate(271, "%Y %m %d"), '271');
compare(271, Date_Calc::DateToDays(21, 8, -4712), '-4712 08 21');
compare('-4712 08 22', $hs_date = Date_Calc::DaysToDate(272, "%Y %m %d"), '272');
compare(272, Date_Calc::DateToDays(22, 8, -4712), '-4712 08 22');
compare('-4712 08 23', $hs_date = Date_Calc::DaysToDate(273, "%Y %m %d"), '273');
compare(273, Date_Calc::DateToDays(23, 8, -4712), '-4712 08 23');
compare('-4712 08 24', $hs_date = Date_Calc::DaysToDate(274, "%Y %m %d"), '274');
compare(274, Date_Calc::DateToDays(24, 8, -4712), '-4712 08 24');
compare('-4712 08 25', $hs_date = Date_Calc::DaysToDate(275, "%Y %m %d"), '275');
compare(275, Date_Calc::DateToDays(25, 8, -4712), '-4712 08 25');
compare('-4712 08 26', $hs_date = Date_Calc::DaysToDate(276, "%Y %m %d"), '276');
compare(276, Date_Calc::DateToDays(26, 8, -4712), '-4712 08 26');
compare('-4712 08 27', $hs_date = Date_Calc::DaysToDate(277, "%Y %m %d"), '277');
compare(277, Date_Calc::DateToDays(27, 8, -4712), '-4712 08 27');
compare('-4712 08 28', $hs_date = Date_Calc::DaysToDate(278, "%Y %m %d"), '278');
compare(278, Date_Calc::DateToDays(28, 8, -4712), '-4712 08 28');
compare('-4712 08 29', $hs_date = Date_Calc::DaysToDate(279, "%Y %m %d"), '279');
compare(279, Date_Calc::DateToDays(29, 8, -4712), '-4712 08 29');
compare('-4712 08 30', $hs_date = Date_Calc::DaysToDate(280, "%Y %m %d"), '280');
compare(280, Date_Calc::DateToDays(30, 8, -4712), '-4712 08 30');
compare('-4712 08 31', $hs_date = Date_Calc::DaysToDate(281, "%Y %m %d"), '281');
compare(281, Date_Calc::DateToDays(31, 8, -4712), '-4712 08 31');
compare('-4712 09 01', $hs_date = Date_Calc::DaysToDate(282, "%Y %m %d"), '282');
compare(282, Date_Calc::DateToDays(1, 9, -4712), '-4712 09 01');
compare('-4712 09 02', $hs_date = Date_Calc::DaysToDate(283, "%Y %m %d"), '283');
compare(283, Date_Calc::DateToDays(2, 9, -4712), '-4712 09 02');
compare('-4712 09 03', $hs_date = Date_Calc::DaysToDate(284, "%Y %m %d"), '284');
compare(284, Date_Calc::DateToDays(3, 9, -4712), '-4712 09 03');
compare('-4712 09 04', $hs_date = Date_Calc::DaysToDate(285, "%Y %m %d"), '285');
compare(285, Date_Calc::DateToDays(4, 9, -4712), '-4712 09 04');
compare('-4712 09 05', $hs_date = Date_Calc::DaysToDate(286, "%Y %m %d"), '286');
compare(286, Date_Calc::DateToDays(5, 9, -4712), '-4712 09 05');
compare('-4712 09 06', $hs_date = Date_Calc::DaysToDate(287, "%Y %m %d"), '287');
compare(287, Date_Calc::DateToDays(6, 9, -4712), '-4712 09 06');
compare('-4712 09 07', $hs_date = Date_Calc::DaysToDate(288, "%Y %m %d"), '288');
compare(288, Date_Calc::DateToDays(7, 9, -4712), '-4712 09 07');
compare('-4712 09 08', $hs_date = Date_Calc::DaysToDate(289, "%Y %m %d"), '289');
compare(289, Date_Calc::DateToDays(8, 9, -4712), '-4712 09 08');
compare('-4712 09 09', $hs_date = Date_Calc::DaysToDate(290, "%Y %m %d"), '290');
compare(290, Date_Calc::DateToDays(9, 9, -4712), '-4712 09 09');
compare('-4712 09 10', $hs_date = Date_Calc::DaysToDate(291, "%Y %m %d"), '291');
compare(291, Date_Calc::DateToDays(10, 9, -4712), '-4712 09 10');
compare('-4712 09 11', $hs_date = Date_Calc::DaysToDate(292, "%Y %m %d"), '292');
compare(292, Date_Calc::DateToDays(11, 9, -4712), '-4712 09 11');
compare('-4712 09 12', $hs_date = Date_Calc::DaysToDate(293, "%Y %m %d"), '293');
compare(293, Date_Calc::DateToDays(12, 9, -4712), '-4712 09 12');
compare('-4712 09 13', $hs_date = Date_Calc::DaysToDate(294, "%Y %m %d"), '294');
compare(294, Date_Calc::DateToDays(13, 9, -4712), '-4712 09 13');
compare('-4712 09 14', $hs_date = Date_Calc::DaysToDate(295, "%Y %m %d"), '295');
compare(295, Date_Calc::DateToDays(14, 9, -4712), '-4712 09 14');
compare('-4712 09 15', $hs_date = Date_Calc::DaysToDate(296, "%Y %m %d"), '296');
compare(296, Date_Calc::DateToDays(15, 9, -4712), '-4712 09 15');
compare('-4712 09 16', $hs_date = Date_Calc::DaysToDate(297, "%Y %m %d"), '297');
compare(297, Date_Calc::DateToDays(16, 9, -4712), '-4712 09 16');
compare('-4712 09 17', $hs_date = Date_Calc::DaysToDate(298, "%Y %m %d"), '298');
compare(298, Date_Calc::DateToDays(17, 9, -4712), '-4712 09 17');
compare('-4712 09 18', $hs_date = Date_Calc::DaysToDate(299, "%Y %m %d"), '299');
compare(299, Date_Calc::DateToDays(18, 9, -4712), '-4712 09 18');
compare('-4712 09 19', $hs_date = Date_Calc::DaysToDate(300, "%Y %m %d"), '300');
compare(300, Date_Calc::DateToDays(19, 9, -4712), '-4712 09 19');
compare('-4712 09 20', $hs_date = Date_Calc::DaysToDate(301, "%Y %m %d"), '301');
compare(301, Date_Calc::DateToDays(20, 9, -4712), '-4712 09 20');
compare('-4712 09 21', $hs_date = Date_Calc::DaysToDate(302, "%Y %m %d"), '302');
compare(302, Date_Calc::DateToDays(21, 9, -4712), '-4712 09 21');
compare('-4712 09 22', $hs_date = Date_Calc::DaysToDate(303, "%Y %m %d"), '303');
compare(303, Date_Calc::DateToDays(22, 9, -4712), '-4712 09 22');
compare('-4712 09 23', $hs_date = Date_Calc::DaysToDate(304, "%Y %m %d"), '304');
compare(304, Date_Calc::DateToDays(23, 9, -4712), '-4712 09 23');
compare('-4712 09 24', $hs_date = Date_Calc::DaysToDate(305, "%Y %m %d"), '305');
compare(305, Date_Calc::DateToDays(24, 9, -4712), '-4712 09 24');
compare('-4712 09 25', $hs_date = Date_Calc::DaysToDate(306, "%Y %m %d"), '306');
compare(306, Date_Calc::DateToDays(25, 9, -4712), '-4712 09 25');
compare('-4712 09 26', $hs_date = Date_Calc::DaysToDate(307, "%Y %m %d"), '307');
compare(307, Date_Calc::DateToDays(26, 9, -4712), '-4712 09 26');
compare('-4712 09 27', $hs_date = Date_Calc::DaysToDate(308, "%Y %m %d"), '308');
compare(308, Date_Calc::DateToDays(27, 9, -4712), '-4712 09 27');
compare('-4712 09 28', $hs_date = Date_Calc::DaysToDate(309, "%Y %m %d"), '309');
compare(309, Date_Calc::DateToDays(28, 9, -4712), '-4712 09 28');
compare('-4712 09 29', $hs_date = Date_Calc::DaysToDate(310, "%Y %m %d"), '310');
compare(310, Date_Calc::DateToDays(29, 9, -4712), '-4712 09 29');
compare('-4712 09 30', $hs_date = Date_Calc::DaysToDate(311, "%Y %m %d"), '311');
compare(311, Date_Calc::DateToDays(30, 9, -4712), '-4712 09 30');
compare('-4712 10 01', $hs_date = Date_Calc::DaysToDate(312, "%Y %m %d"), '312');
compare(312, Date_Calc::DateToDays(1, 10, -4712), '-4712 10 01');
compare('-4712 10 02', $hs_date = Date_Calc::DaysToDate(313, "%Y %m %d"), '313');
compare(313, Date_Calc::DateToDays(2, 10, -4712), '-4712 10 02');
compare('-4712 10 03', $hs_date = Date_Calc::DaysToDate(314, "%Y %m %d"), '314');
compare(314, Date_Calc::DateToDays(3, 10, -4712), '-4712 10 03');
compare('-4712 10 04', $hs_date = Date_Calc::DaysToDate(315, "%Y %m %d"), '315');
compare(315, Date_Calc::DateToDays(4, 10, -4712), '-4712 10 04');
compare('-4712 10 05', $hs_date = Date_Calc::DaysToDate(316, "%Y %m %d"), '316');
compare(316, Date_Calc::DateToDays(5, 10, -4712), '-4712 10 05');
compare('-4712 10 06', $hs_date = Date_Calc::DaysToDate(317, "%Y %m %d"), '317');
compare(317, Date_Calc::DateToDays(6, 10, -4712), '-4712 10 06');
compare('-4712 10 07', $hs_date = Date_Calc::DaysToDate(318, "%Y %m %d"), '318');
compare(318, Date_Calc::DateToDays(7, 10, -4712), '-4712 10 07');
compare('-4712 10 08', $hs_date = Date_Calc::DaysToDate(319, "%Y %m %d"), '319');
compare(319, Date_Calc::DateToDays(8, 10, -4712), '-4712 10 08');
compare('-4712 10 09', $hs_date = Date_Calc::DaysToDate(320, "%Y %m %d"), '320');
compare(320, Date_Calc::DateToDays(9, 10, -4712), '-4712 10 09');
compare('-4712 10 10', $hs_date = Date_Calc::DaysToDate(321, "%Y %m %d"), '321');
compare(321, Date_Calc::DateToDays(10, 10, -4712), '-4712 10 10');
compare('-4712 10 11', $hs_date = Date_Calc::DaysToDate(322, "%Y %m %d"), '322');
compare(322, Date_Calc::DateToDays(11, 10, -4712), '-4712 10 11');
compare('-4712 10 12', $hs_date = Date_Calc::DaysToDate(323, "%Y %m %d"), '323');
compare(323, Date_Calc::DateToDays(12, 10, -4712), '-4712 10 12');
compare('-4712 10 13', $hs_date = Date_Calc::DaysToDate(324, "%Y %m %d"), '324');
compare(324, Date_Calc::DateToDays(13, 10, -4712), '-4712 10 13');
compare('-4712 10 14', $hs_date = Date_Calc::DaysToDate(325, "%Y %m %d"), '325');
compare(325, Date_Calc::DateToDays(14, 10, -4712), '-4712 10 14');
compare('-4712 10 15', $hs_date = Date_Calc::DaysToDate(326, "%Y %m %d"), '326');
compare(326, Date_Calc::DateToDays(15, 10, -4712), '-4712 10 15');
compare('-4712 10 16', $hs_date = Date_Calc::DaysToDate(327, "%Y %m %d"), '327');
compare(327, Date_Calc::DateToDays(16, 10, -4712), '-4712 10 16');
compare('-4712 10 17', $hs_date = Date_Calc::DaysToDate(328, "%Y %m %d"), '328');
compare(328, Date_Calc::DateToDays(17, 10, -4712), '-4712 10 17');
compare('-4712 10 18', $hs_date = Date_Calc::DaysToDate(329, "%Y %m %d"), '329');
compare(329, Date_Calc::DateToDays(18, 10, -4712), '-4712 10 18');
compare('-4712 10 19', $hs_date = Date_Calc::DaysToDate(330, "%Y %m %d"), '330');
compare(330, Date_Calc::DateToDays(19, 10, -4712), '-4712 10 19');
compare('-4712 10 20', $hs_date = Date_Calc::DaysToDate(331, "%Y %m %d"), '331');
compare(331, Date_Calc::DateToDays(20, 10, -4712), '-4712 10 20');
compare('-4712 10 21', $hs_date = Date_Calc::DaysToDate(332, "%Y %m %d"), '332');
compare(332, Date_Calc::DateToDays(21, 10, -4712), '-4712 10 21');
compare('-4712 10 22', $hs_date = Date_Calc::DaysToDate(333, "%Y %m %d"), '333');
compare(333, Date_Calc::DateToDays(22, 10, -4712), '-4712 10 22');
compare('-4712 10 23', $hs_date = Date_Calc::DaysToDate(334, "%Y %m %d"), '334');
compare(334, Date_Calc::DateToDays(23, 10, -4712), '-4712 10 23');
compare('-4712 10 24', $hs_date = Date_Calc::DaysToDate(335, "%Y %m %d"), '335');
compare(335, Date_Calc::DateToDays(24, 10, -4712), '-4712 10 24');
compare('-4712 10 25', $hs_date = Date_Calc::DaysToDate(336, "%Y %m %d"), '336');
compare(336, Date_Calc::DateToDays(25, 10, -4712), '-4712 10 25');
compare('-4712 10 26', $hs_date = Date_Calc::DaysToDate(337, "%Y %m %d"), '337');
compare(337, Date_Calc::DateToDays(26, 10, -4712), '-4712 10 26');
compare('-4712 10 27', $hs_date = Date_Calc::DaysToDate(338, "%Y %m %d"), '338');
compare(338, Date_Calc::DateToDays(27, 10, -4712), '-4712 10 27');
compare('-4712 10 28', $hs_date = Date_Calc::DaysToDate(339, "%Y %m %d"), '339');
compare(339, Date_Calc::DateToDays(28, 10, -4712), '-4712 10 28');
compare('-4712 10 29', $hs_date = Date_Calc::DaysToDate(340, "%Y %m %d"), '340');
compare(340, Date_Calc::DateToDays(29, 10, -4712), '-4712 10 29');
compare('-4712 10 30', $hs_date = Date_Calc::DaysToDate(341, "%Y %m %d"), '341');
compare(341, Date_Calc::DateToDays(30, 10, -4712), '-4712 10 30');
compare('-4712 10 31', $hs_date = Date_Calc::DaysToDate(342, "%Y %m %d"), '342');
compare(342, Date_Calc::DateToDays(31, 10, -4712), '-4712 10 31');
compare('-4712 11 01', $hs_date = Date_Calc::DaysToDate(343, "%Y %m %d"), '343');
compare(343, Date_Calc::DateToDays(1, 11, -4712), '-4712 11 01');
compare('-4712 11 02', $hs_date = Date_Calc::DaysToDate(344, "%Y %m %d"), '344');
compare(344, Date_Calc::DateToDays(2, 11, -4712), '-4712 11 02');
compare('-4712 11 03', $hs_date = Date_Calc::DaysToDate(345, "%Y %m %d"), '345');
compare(345, Date_Calc::DateToDays(3, 11, -4712), '-4712 11 03');
compare('-4712 11 04', $hs_date = Date_Calc::DaysToDate(346, "%Y %m %d"), '346');
compare(346, Date_Calc::DateToDays(4, 11, -4712), '-4712 11 04');
compare('-4712 11 05', $hs_date = Date_Calc::DaysToDate(347, "%Y %m %d"), '347');
compare(347, Date_Calc::DateToDays(5, 11, -4712), '-4712 11 05');
compare('-4712 11 06', $hs_date = Date_Calc::DaysToDate(348, "%Y %m %d"), '348');
compare(348, Date_Calc::DateToDays(6, 11, -4712), '-4712 11 06');
compare('-4712 11 07', $hs_date = Date_Calc::DaysToDate(349, "%Y %m %d"), '349');
compare(349, Date_Calc::DateToDays(7, 11, -4712), '-4712 11 07');
compare('-4712 11 08', $hs_date = Date_Calc::DaysToDate(350, "%Y %m %d"), '350');
compare(350, Date_Calc::DateToDays(8, 11, -4712), '-4712 11 08');
compare('-4712 11 09', $hs_date = Date_Calc::DaysToDate(351, "%Y %m %d"), '351');
compare(351, Date_Calc::DateToDays(9, 11, -4712), '-4712 11 09');
compare('-4712 11 10', $hs_date = Date_Calc::DaysToDate(352, "%Y %m %d"), '352');
compare(352, Date_Calc::DateToDays(10, 11, -4712), '-4712 11 10');
compare('-4712 11 11', $hs_date = Date_Calc::DaysToDate(353, "%Y %m %d"), '353');
compare(353, Date_Calc::DateToDays(11, 11, -4712), '-4712 11 11');
compare('-4712 11 12', $hs_date = Date_Calc::DaysToDate(354, "%Y %m %d"), '354');
compare(354, Date_Calc::DateToDays(12, 11, -4712), '-4712 11 12');
compare('-4712 11 13', $hs_date = Date_Calc::DaysToDate(355, "%Y %m %d"), '355');
compare(355, Date_Calc::DateToDays(13, 11, -4712), '-4712 11 13');
compare('-4712 11 14', $hs_date = Date_Calc::DaysToDate(356, "%Y %m %d"), '356');
compare(356, Date_Calc::DateToDays(14, 11, -4712), '-4712 11 14');
compare('-4712 11 15', $hs_date = Date_Calc::DaysToDate(357, "%Y %m %d"), '357');
compare(357, Date_Calc::DateToDays(15, 11, -4712), '-4712 11 15');
compare('-4712 11 16', $hs_date = Date_Calc::DaysToDate(358, "%Y %m %d"), '358');
compare(358, Date_Calc::DateToDays(16, 11, -4712), '-4712 11 16');
compare('-4712 11 17', $hs_date = Date_Calc::DaysToDate(359, "%Y %m %d"), '359');
compare(359, Date_Calc::DateToDays(17, 11, -4712), '-4712 11 17');
compare('-4712 11 18', $hs_date = Date_Calc::DaysToDate(360, "%Y %m %d"), '360');
compare(360, Date_Calc::DateToDays(18, 11, -4712), '-4712 11 18');
compare('-4712 11 19', $hs_date = Date_Calc::DaysToDate(361, "%Y %m %d"), '361');
compare(361, Date_Calc::DateToDays(19, 11, -4712), '-4712 11 19');
compare('-4712 11 20', $hs_date = Date_Calc::DaysToDate(362, "%Y %m %d"), '362');
compare(362, Date_Calc::DateToDays(20, 11, -4712), '-4712 11 20');
compare('-4712 11 21', $hs_date = Date_Calc::DaysToDate(363, "%Y %m %d"), '363');
compare(363, Date_Calc::DateToDays(21, 11, -4712), '-4712 11 21');
compare('-4712 11 22', $hs_date = Date_Calc::DaysToDate(364, "%Y %m %d"), '364');
compare(364, Date_Calc::DateToDays(22, 11, -4712), '-4712 11 22');
compare('-4712 11 23', $hs_date = Date_Calc::DaysToDate(365, "%Y %m %d"), '365');
compare(365, Date_Calc::DateToDays(23, 11, -4712), '-4712 11 23');
compare('-4712 11 24', $hs_date = Date_Calc::DaysToDate(366, "%Y %m %d"), '366');
compare(366, Date_Calc::DateToDays(24, 11, -4712), '-4712 11 24');

compare('2006 11 07', Date_Calc::DaysToDate(2454047, "%Y %m %d"), '2454047');
compare(2454047, Date_Calc::DateToDays(7, 11, 2006), '2006 11 07');
compare('2006 11 08', Date_Calc::DaysToDate(2454048, "%Y %m %d"), '2454048');
compare(2454048, Date_Calc::DateToDays(8, 11, 2006), '2006 11 08');
compare('2006 11 09', Date_Calc::DaysToDate(2454049, "%Y %m %d"), '2454049');
compare(2454049, Date_Calc::DateToDays(9, 11, 2006), '2006 11 09');
compare('2006 11 10', Date_Calc::DaysToDate(2454050, "%Y %m %d"), '2454050');
compare(2454050, Date_Calc::DateToDays(10, 11, 2006), '2006 11 10');
compare('2006 11 11', Date_Calc::DaysToDate(2454051, "%Y %m %d"), '2454051');
compare(2454051, Date_Calc::DateToDays(11, 11, 2006), '2006 11 11');
compare('2006 11 12', Date_Calc::DaysToDate(2454052, "%Y %m %d"), '2454052');
compare(2454052, Date_Calc::DateToDays(12, 11, 2006), '2006 11 12');
compare('2006 11 13', Date_Calc::DaysToDate(2454053, "%Y %m %d"), '2454053');
compare(2454053, Date_Calc::DateToDays(13, 11, 2006), '2006 11 13');
compare('2006 11 14', Date_Calc::DaysToDate(2454054, "%Y %m %d"), '2454054');
compare(2454054, Date_Calc::DateToDays(14, 11, 2006), '2006 11 14');
compare('2006 11 15', Date_Calc::DaysToDate(2454055, "%Y %m %d"), '2454055');
compare(2454055, Date_Calc::DateToDays(15, 11, 2006), '2006 11 15');
compare('2006 11 16', Date_Calc::DaysToDate(2454056, "%Y %m %d"), '2454056');
compare(2454056, Date_Calc::DateToDays(16, 11, 2006), '2006 11 16');
compare('2006 11 17', Date_Calc::DaysToDate(2454057, "%Y %m %d"), '2454057');
compare(2454057, Date_Calc::DateToDays(17, 11, 2006), '2006 11 17');
compare('2006 11 18', Date_Calc::DaysToDate(2454058, "%Y %m %d"), '2454058');
compare(2454058, Date_Calc::DateToDays(18, 11, 2006), '2006 11 18');
compare('2006 11 19', Date_Calc::DaysToDate(2454059, "%Y %m %d"), '2454059');
compare(2454059, Date_Calc::DateToDays(19, 11, 2006), '2006 11 19');
compare('2006 11 20', Date_Calc::DaysToDate(2454060, "%Y %m %d"), '2454060');
compare(2454060, Date_Calc::DateToDays(20, 11, 2006), '2006 11 20');
compare('2006 11 21', Date_Calc::DaysToDate(2454061, "%Y %m %d"), '2454061');
compare(2454061, Date_Calc::DateToDays(21, 11, 2006), '2006 11 21');
compare('2006 11 22', Date_Calc::DaysToDate(2454062, "%Y %m %d"), '2454062');
compare(2454062, Date_Calc::DateToDays(22, 11, 2006), '2006 11 22');
compare('2006 11 23', Date_Calc::DaysToDate(2454063, "%Y %m %d"), '2454063');
compare(2454063, Date_Calc::DateToDays(23, 11, 2006), '2006 11 23');
compare('2006 11 24', Date_Calc::DaysToDate(2454064, "%Y %m %d"), '2454064');
compare(2454064, Date_Calc::DateToDays(24, 11, 2006), '2006 11 24');
compare('2006 11 25', Date_Calc::DaysToDate(2454065, "%Y %m %d"), '2454065');
compare(2454065, Date_Calc::DateToDays(25, 11, 2006), '2006 11 25');
compare('2006 11 26', Date_Calc::DaysToDate(2454066, "%Y %m %d"), '2454066');
compare(2454066, Date_Calc::DateToDays(26, 11, 2006), '2006 11 26');
compare('2006 11 27', Date_Calc::DaysToDate(2454067, "%Y %m %d"), '2454067');
compare(2454067, Date_Calc::DateToDays(27, 11, 2006), '2006 11 27');
compare('2006 11 28', Date_Calc::DaysToDate(2454068, "%Y %m %d"), '2454068');
compare(2454068, Date_Calc::DateToDays(28, 11, 2006), '2006 11 28');
compare('2006 11 29', Date_Calc::DaysToDate(2454069, "%Y %m %d"), '2454069');
compare(2454069, Date_Calc::DateToDays(29, 11, 2006), '2006 11 29');
compare('2006 11 30', Date_Calc::DaysToDate(2454070, "%Y %m %d"), '2454070');
compare(2454070, Date_Calc::DateToDays(30, 11, 2006), '2006 11 30');
compare('2006 12 01', Date_Calc::DaysToDate(2454071, "%Y %m %d"), '2454071');
compare(2454071, Date_Calc::DateToDays(1, 12, 2006), '2006 12 01');
compare('2006 12 02', Date_Calc::DaysToDate(2454072, "%Y %m %d"), '2454072');
compare(2454072, Date_Calc::DateToDays(2, 12, 2006), '2006 12 02');
compare('2006 12 03', Date_Calc::DaysToDate(2454073, "%Y %m %d"), '2454073');
compare(2454073, Date_Calc::DateToDays(3, 12, 2006), '2006 12 03');
compare('2006 12 04', Date_Calc::DaysToDate(2454074, "%Y %m %d"), '2454074');
compare(2454074, Date_Calc::DateToDays(4, 12, 2006), '2006 12 04');
compare('2006 12 05', Date_Calc::DaysToDate(2454075, "%Y %m %d"), '2454075');
compare(2454075, Date_Calc::DateToDays(5, 12, 2006), '2006 12 05');
compare('2006 12 06', Date_Calc::DaysToDate(2454076, "%Y %m %d"), '2454076');
compare(2454076, Date_Calc::DateToDays(6, 12, 2006), '2006 12 06');
compare('2006 12 07', Date_Calc::DaysToDate(2454077, "%Y %m %d"), '2454077');
compare(2454077, Date_Calc::DateToDays(7, 12, 2006), '2006 12 07');
compare('2006 12 08', Date_Calc::DaysToDate(2454078, "%Y %m %d"), '2454078');
compare(2454078, Date_Calc::DateToDays(8, 12, 2006), '2006 12 08');
compare('2006 12 09', Date_Calc::DaysToDate(2454079, "%Y %m %d"), '2454079');
compare(2454079, Date_Calc::DateToDays(9, 12, 2006), '2006 12 09');
compare('2006 12 10', Date_Calc::DaysToDate(2454080, "%Y %m %d"), '2454080');
compare(2454080, Date_Calc::DateToDays(10, 12, 2006), '2006 12 10');
compare('2006 12 11', Date_Calc::DaysToDate(2454081, "%Y %m %d"), '2454081');
compare(2454081, Date_Calc::DateToDays(11, 12, 2006), '2006 12 11');
compare('2006 12 12', Date_Calc::DaysToDate(2454082, "%Y %m %d"), '2454082');
compare(2454082, Date_Calc::DateToDays(12, 12, 2006), '2006 12 12');
compare('2006 12 13', Date_Calc::DaysToDate(2454083, "%Y %m %d"), '2454083');
compare(2454083, Date_Calc::DateToDays(13, 12, 2006), '2006 12 13');
compare('2006 12 14', Date_Calc::DaysToDate(2454084, "%Y %m %d"), '2454084');
compare(2454084, Date_Calc::DateToDays(14, 12, 2006), '2006 12 14');
compare('2006 12 15', Date_Calc::DaysToDate(2454085, "%Y %m %d"), '2454085');
compare(2454085, Date_Calc::DateToDays(15, 12, 2006), '2006 12 15');
compare('2006 12 16', Date_Calc::DaysToDate(2454086, "%Y %m %d"), '2454086');
compare(2454086, Date_Calc::DateToDays(16, 12, 2006), '2006 12 16');
compare('2006 12 17', Date_Calc::DaysToDate(2454087, "%Y %m %d"), '2454087');
compare(2454087, Date_Calc::DateToDays(17, 12, 2006), '2006 12 17');
compare('2006 12 18', Date_Calc::DaysToDate(2454088, "%Y %m %d"), '2454088');
compare(2454088, Date_Calc::DateToDays(18, 12, 2006), '2006 12 18');
compare('2006 12 19', Date_Calc::DaysToDate(2454089, "%Y %m %d"), '2454089');
compare(2454089, Date_Calc::DateToDays(19, 12, 2006), '2006 12 19');
compare('2006 12 20', Date_Calc::DaysToDate(2454090, "%Y %m %d"), '2454090');
compare(2454090, Date_Calc::DateToDays(20, 12, 2006), '2006 12 20');
compare('2006 12 21', Date_Calc::DaysToDate(2454091, "%Y %m %d"), '2454091');
compare(2454091, Date_Calc::DateToDays(21, 12, 2006), '2006 12 21');
compare('2006 12 22', Date_Calc::DaysToDate(2454092, "%Y %m %d"), '2454092');
compare(2454092, Date_Calc::DateToDays(22, 12, 2006), '2006 12 22');
compare('2006 12 23', Date_Calc::DaysToDate(2454093, "%Y %m %d"), '2454093');
compare(2454093, Date_Calc::DateToDays(23, 12, 2006), '2006 12 23');
compare('2006 12 24', Date_Calc::DaysToDate(2454094, "%Y %m %d"), '2454094');
compare(2454094, Date_Calc::DateToDays(24, 12, 2006), '2006 12 24');
compare('2006 12 25', Date_Calc::DaysToDate(2454095, "%Y %m %d"), '2454095');
compare(2454095, Date_Calc::DateToDays(25, 12, 2006), '2006 12 25');
compare('2006 12 26', Date_Calc::DaysToDate(2454096, "%Y %m %d"), '2454096');
compare(2454096, Date_Calc::DateToDays(26, 12, 2006), '2006 12 26');
compare('2006 12 27', Date_Calc::DaysToDate(2454097, "%Y %m %d"), '2454097');
compare(2454097, Date_Calc::DateToDays(27, 12, 2006), '2006 12 27');
compare('2006 12 28', Date_Calc::DaysToDate(2454098, "%Y %m %d"), '2454098');
compare(2454098, Date_Calc::DateToDays(28, 12, 2006), '2006 12 28');
compare('2006 12 29', Date_Calc::DaysToDate(2454099, "%Y %m %d"), '2454099');
compare(2454099, Date_Calc::DateToDays(29, 12, 2006), '2006 12 29');
compare('2006 12 30', Date_Calc::DaysToDate(2454100, "%Y %m %d"), '2454100');
compare(2454100, Date_Calc::DateToDays(30, 12, 2006), '2006 12 30');
compare('2006 12 31', Date_Calc::DaysToDate(2454101, "%Y %m %d"), '2454101');
compare(2454101, Date_Calc::DateToDays(31, 12, 2006), '2006 12 31');
compare('2007 01 01', Date_Calc::DaysToDate(2454102, "%Y %m %d"), '2454102');
compare(2454102, Date_Calc::DateToDays(1, 1, 2007), '2007 01 01');
compare('2007 01 02', Date_Calc::DaysToDate(2454103, "%Y %m %d"), '2454103');
compare(2454103, Date_Calc::DateToDays(2, 1, 2007), '2007 01 02');
compare('2007 01 03', Date_Calc::DaysToDate(2454104, "%Y %m %d"), '2454104');
compare(2454104, Date_Calc::DateToDays(3, 1, 2007), '2007 01 03');
compare('2007 01 04', Date_Calc::DaysToDate(2454105, "%Y %m %d"), '2454105');
compare(2454105, Date_Calc::DateToDays(4, 1, 2007), '2007 01 04');
compare('2007 01 05', Date_Calc::DaysToDate(2454106, "%Y %m %d"), '2454106');
compare(2454106, Date_Calc::DateToDays(5, 1, 2007), '2007 01 05');
compare('2007 01 06', Date_Calc::DaysToDate(2454107, "%Y %m %d"), '2454107');
compare(2454107, Date_Calc::DateToDays(6, 1, 2007), '2007 01 06');
compare('2007 01 07', Date_Calc::DaysToDate(2454108, "%Y %m %d"), '2454108');
compare(2454108, Date_Calc::DateToDays(7, 1, 2007), '2007 01 07');
compare('2007 01 08', Date_Calc::DaysToDate(2454109, "%Y %m %d"), '2454109');
compare(2454109, Date_Calc::DateToDays(8, 1, 2007), '2007 01 08');
compare('2007 01 09', Date_Calc::DaysToDate(2454110, "%Y %m %d"), '2454110');
compare(2454110, Date_Calc::DateToDays(9, 1, 2007), '2007 01 09');
compare('2007 01 10', Date_Calc::DaysToDate(2454111, "%Y %m %d"), '2454111');
compare(2454111, Date_Calc::DateToDays(10, 1, 2007), '2007 01 10');
compare('2007 01 11', Date_Calc::DaysToDate(2454112, "%Y %m %d"), '2454112');
compare(2454112, Date_Calc::DateToDays(11, 1, 2007), '2007 01 11');
compare('2007 01 12', Date_Calc::DaysToDate(2454113, "%Y %m %d"), '2454113');
compare(2454113, Date_Calc::DateToDays(12, 1, 2007), '2007 01 12');
compare('2007 01 13', Date_Calc::DaysToDate(2454114, "%Y %m %d"), '2454114');
compare(2454114, Date_Calc::DateToDays(13, 1, 2007), '2007 01 13');
compare('2007 01 14', Date_Calc::DaysToDate(2454115, "%Y %m %d"), '2454115');
compare(2454115, Date_Calc::DateToDays(14, 1, 2007), '2007 01 14');
compare('2007 01 15', Date_Calc::DaysToDate(2454116, "%Y %m %d"), '2454116');
compare(2454116, Date_Calc::DateToDays(15, 1, 2007), '2007 01 15');
compare('2007 01 16', Date_Calc::DaysToDate(2454117, "%Y %m %d"), '2454117');
compare(2454117, Date_Calc::DateToDays(16, 1, 2007), '2007 01 16');
compare('2007 01 17', Date_Calc::DaysToDate(2454118, "%Y %m %d"), '2454118');
compare(2454118, Date_Calc::DateToDays(17, 1, 2007), '2007 01 17');
compare('2007 01 18', Date_Calc::DaysToDate(2454119, "%Y %m %d"), '2454119');
compare(2454119, Date_Calc::DateToDays(18, 1, 2007), '2007 01 18');
compare('2007 01 19', Date_Calc::DaysToDate(2454120, "%Y %m %d"), '2454120');
compare(2454120, Date_Calc::DateToDays(19, 1, 2007), '2007 01 19');
compare('2007 01 20', Date_Calc::DaysToDate(2454121, "%Y %m %d"), '2454121');
compare(2454121, Date_Calc::DateToDays(20, 1, 2007), '2007 01 20');
compare('2007 01 21', Date_Calc::DaysToDate(2454122, "%Y %m %d"), '2454122');
compare(2454122, Date_Calc::DateToDays(21, 1, 2007), '2007 01 21');
compare('2007 01 22', Date_Calc::DaysToDate(2454123, "%Y %m %d"), '2454123');
compare(2454123, Date_Calc::DateToDays(22, 1, 2007), '2007 01 22');
compare('2007 01 23', Date_Calc::DaysToDate(2454124, "%Y %m %d"), '2454124');
compare(2454124, Date_Calc::DateToDays(23, 1, 2007), '2007 01 23');
compare('2007 01 24', Date_Calc::DaysToDate(2454125, "%Y %m %d"), '2454125');
compare(2454125, Date_Calc::DateToDays(24, 1, 2007), '2007 01 24');
compare('2007 01 25', Date_Calc::DaysToDate(2454126, "%Y %m %d"), '2454126');
compare(2454126, Date_Calc::DateToDays(25, 1, 2007), '2007 01 25');
compare('2007 01 26', Date_Calc::DaysToDate(2454127, "%Y %m %d"), '2454127');
compare(2454127, Date_Calc::DateToDays(26, 1, 2007), '2007 01 26');
compare('2007 01 27', Date_Calc::DaysToDate(2454128, "%Y %m %d"), '2454128');
compare(2454128, Date_Calc::DateToDays(27, 1, 2007), '2007 01 27');
compare('2007 01 28', Date_Calc::DaysToDate(2454129, "%Y %m %d"), '2454129');
compare(2454129, Date_Calc::DateToDays(28, 1, 2007), '2007 01 28');
compare('2007 01 29', Date_Calc::DaysToDate(2454130, "%Y %m %d"), '2454130');
compare(2454130, Date_Calc::DateToDays(29, 1, 2007), '2007 01 29');
compare('2007 01 30', Date_Calc::DaysToDate(2454131, "%Y %m %d"), '2454131');
compare(2454131, Date_Calc::DateToDays(30, 1, 2007), '2007 01 30');
compare('2007 01 31', Date_Calc::DaysToDate(2454132, "%Y %m %d"), '2454132');
compare(2454132, Date_Calc::DateToDays(31, 1, 2007), '2007 01 31');
compare('2007 02 01', Date_Calc::DaysToDate(2454133, "%Y %m %d"), '2454133');
compare(2454133, Date_Calc::DateToDays(1, 2, 2007), '2007 02 01');
compare('2007 02 02', Date_Calc::DaysToDate(2454134, "%Y %m %d"), '2454134');
compare(2454134, Date_Calc::DateToDays(2, 2, 2007), '2007 02 02');
compare('2007 02 03', Date_Calc::DaysToDate(2454135, "%Y %m %d"), '2454135');
compare(2454135, Date_Calc::DateToDays(3, 2, 2007), '2007 02 03');
compare('2007 02 04', Date_Calc::DaysToDate(2454136, "%Y %m %d"), '2454136');
compare(2454136, Date_Calc::DateToDays(4, 2, 2007), '2007 02 04');
compare('2007 02 05', Date_Calc::DaysToDate(2454137, "%Y %m %d"), '2454137');
compare(2454137, Date_Calc::DateToDays(5, 2, 2007), '2007 02 05');
compare('2007 02 06', Date_Calc::DaysToDate(2454138, "%Y %m %d"), '2454138');
compare(2454138, Date_Calc::DateToDays(6, 2, 2007), '2007 02 06');
compare('2007 02 07', Date_Calc::DaysToDate(2454139, "%Y %m %d"), '2454139');
compare(2454139, Date_Calc::DateToDays(7, 2, 2007), '2007 02 07');
compare('2007 02 08', Date_Calc::DaysToDate(2454140, "%Y %m %d"), '2454140');
compare(2454140, Date_Calc::DateToDays(8, 2, 2007), '2007 02 08');
compare('2007 02 09', Date_Calc::DaysToDate(2454141, "%Y %m %d"), '2454141');
compare(2454141, Date_Calc::DateToDays(9, 2, 2007), '2007 02 09');
compare('2007 02 10', Date_Calc::DaysToDate(2454142, "%Y %m %d"), '2454142');
compare(2454142, Date_Calc::DateToDays(10, 2, 2007), '2007 02 10');
compare('2007 02 11', Date_Calc::DaysToDate(2454143, "%Y %m %d"), '2454143');
compare(2454143, Date_Calc::DateToDays(11, 2, 2007), '2007 02 11');
compare('2007 02 12', Date_Calc::DaysToDate(2454144, "%Y %m %d"), '2454144');
compare(2454144, Date_Calc::DateToDays(12, 2, 2007), '2007 02 12');
compare('2007 02 13', Date_Calc::DaysToDate(2454145, "%Y %m %d"), '2454145');
compare(2454145, Date_Calc::DateToDays(13, 2, 2007), '2007 02 13');
compare('2007 02 14', Date_Calc::DaysToDate(2454146, "%Y %m %d"), '2454146');
compare(2454146, Date_Calc::DateToDays(14, 2, 2007), '2007 02 14');
compare('2007 02 15', Date_Calc::DaysToDate(2454147, "%Y %m %d"), '2454147');
compare(2454147, Date_Calc::DateToDays(15, 2, 2007), '2007 02 15');
compare('2007 02 16', Date_Calc::DaysToDate(2454148, "%Y %m %d"), '2454148');
compare(2454148, Date_Calc::DateToDays(16, 2, 2007), '2007 02 16');
compare('2007 02 17', Date_Calc::DaysToDate(2454149, "%Y %m %d"), '2454149');
compare(2454149, Date_Calc::DateToDays(17, 2, 2007), '2007 02 17');
compare('2007 02 18', Date_Calc::DaysToDate(2454150, "%Y %m %d"), '2454150');
compare(2454150, Date_Calc::DateToDays(18, 2, 2007), '2007 02 18');
compare('2007 02 19', Date_Calc::DaysToDate(2454151, "%Y %m %d"), '2454151');
compare(2454151, Date_Calc::DateToDays(19, 2, 2007), '2007 02 19');
compare('2007 02 20', Date_Calc::DaysToDate(2454152, "%Y %m %d"), '2454152');
compare(2454152, Date_Calc::DateToDays(20, 2, 2007), '2007 02 20');
compare('2007 02 21', Date_Calc::DaysToDate(2454153, "%Y %m %d"), '2454153');
compare(2454153, Date_Calc::DateToDays(21, 2, 2007), '2007 02 21');
compare('2007 02 22', Date_Calc::DaysToDate(2454154, "%Y %m %d"), '2454154');
compare(2454154, Date_Calc::DateToDays(22, 2, 2007), '2007 02 22');
compare('2007 02 23', Date_Calc::DaysToDate(2454155, "%Y %m %d"), '2454155');
compare(2454155, Date_Calc::DateToDays(23, 2, 2007), '2007 02 23');
compare('2007 02 24', Date_Calc::DaysToDate(2454156, "%Y %m %d"), '2454156');
compare(2454156, Date_Calc::DateToDays(24, 2, 2007), '2007 02 24');
compare('2007 02 25', Date_Calc::DaysToDate(2454157, "%Y %m %d"), '2454157');
compare(2454157, Date_Calc::DateToDays(25, 2, 2007), '2007 02 25');
compare('2007 02 26', Date_Calc::DaysToDate(2454158, "%Y %m %d"), '2454158');
compare(2454158, Date_Calc::DateToDays(26, 2, 2007), '2007 02 26');
compare('2007 02 27', Date_Calc::DaysToDate(2454159, "%Y %m %d"), '2454159');
compare(2454159, Date_Calc::DateToDays(27, 2, 2007), '2007 02 27');
compare('2007 02 28', Date_Calc::DaysToDate(2454160, "%Y %m %d"), '2454160');
compare(2454160, Date_Calc::DateToDays(28, 2, 2007), '2007 02 28');
compare('2007 03 01', Date_Calc::DaysToDate(2454161, "%Y %m %d"), '2454161');
compare(2454161, Date_Calc::DateToDays(1, 3, 2007), '2007 03 01');
compare('2007 03 02', Date_Calc::DaysToDate(2454162, "%Y %m %d"), '2454162');
compare(2454162, Date_Calc::DateToDays(2, 3, 2007), '2007 03 02');
compare('2007 03 03', Date_Calc::DaysToDate(2454163, "%Y %m %d"), '2454163');
compare(2454163, Date_Calc::DateToDays(3, 3, 2007), '2007 03 03');
compare('2007 03 04', Date_Calc::DaysToDate(2454164, "%Y %m %d"), '2454164');
compare(2454164, Date_Calc::DateToDays(4, 3, 2007), '2007 03 04');
compare('2007 03 05', Date_Calc::DaysToDate(2454165, "%Y %m %d"), '2454165');
compare(2454165, Date_Calc::DateToDays(5, 3, 2007), '2007 03 05');
compare('2007 03 06', Date_Calc::DaysToDate(2454166, "%Y %m %d"), '2454166');
compare(2454166, Date_Calc::DateToDays(6, 3, 2007), '2007 03 06');
compare('2007 03 07', Date_Calc::DaysToDate(2454167, "%Y %m %d"), '2454167');
compare(2454167, Date_Calc::DateToDays(7, 3, 2007), '2007 03 07');
compare('2007 03 08', Date_Calc::DaysToDate(2454168, "%Y %m %d"), '2454168');
compare(2454168, Date_Calc::DateToDays(8, 3, 2007), '2007 03 08');
compare('2007 03 09', Date_Calc::DaysToDate(2454169, "%Y %m %d"), '2454169');
compare(2454169, Date_Calc::DateToDays(9, 3, 2007), '2007 03 09');
compare('2007 03 10', Date_Calc::DaysToDate(2454170, "%Y %m %d"), '2454170');
compare(2454170, Date_Calc::DateToDays(10, 3, 2007), '2007 03 10');
compare('2007 03 11', Date_Calc::DaysToDate(2454171, "%Y %m %d"), '2454171');
compare(2454171, Date_Calc::DateToDays(11, 3, 2007), '2007 03 11');
compare('2007 03 12', Date_Calc::DaysToDate(2454172, "%Y %m %d"), '2454172');
compare(2454172, Date_Calc::DateToDays(12, 3, 2007), '2007 03 12');
compare('2007 03 13', Date_Calc::DaysToDate(2454173, "%Y %m %d"), '2454173');
compare(2454173, Date_Calc::DateToDays(13, 3, 2007), '2007 03 13');
compare('2007 03 14', Date_Calc::DaysToDate(2454174, "%Y %m %d"), '2454174');
compare(2454174, Date_Calc::DateToDays(14, 3, 2007), '2007 03 14');
compare('2007 03 15', Date_Calc::DaysToDate(2454175, "%Y %m %d"), '2454175');
compare(2454175, Date_Calc::DateToDays(15, 3, 2007), '2007 03 15');
compare('2007 03 16', Date_Calc::DaysToDate(2454176, "%Y %m %d"), '2454176');
compare(2454176, Date_Calc::DateToDays(16, 3, 2007), '2007 03 16');
compare('2007 03 17', Date_Calc::DaysToDate(2454177, "%Y %m %d"), '2454177');
compare(2454177, Date_Calc::DateToDays(17, 3, 2007), '2007 03 17');
compare('2007 03 18', Date_Calc::DaysToDate(2454178, "%Y %m %d"), '2454178');
compare(2454178, Date_Calc::DateToDays(18, 3, 2007), '2007 03 18');
compare('2007 03 19', Date_Calc::DaysToDate(2454179, "%Y %m %d"), '2454179');
compare(2454179, Date_Calc::DateToDays(19, 3, 2007), '2007 03 19');
compare('2007 03 20', Date_Calc::DaysToDate(2454180, "%Y %m %d"), '2454180');
compare(2454180, Date_Calc::DateToDays(20, 3, 2007), '2007 03 20');
compare('2007 03 21', Date_Calc::DaysToDate(2454181, "%Y %m %d"), '2454181');
compare(2454181, Date_Calc::DateToDays(21, 3, 2007), '2007 03 21');
compare('2007 03 22', Date_Calc::DaysToDate(2454182, "%Y %m %d"), '2454182');
compare(2454182, Date_Calc::DateToDays(22, 3, 2007), '2007 03 22');
compare('2007 03 23', Date_Calc::DaysToDate(2454183, "%Y %m %d"), '2454183');
compare(2454183, Date_Calc::DateToDays(23, 3, 2007), '2007 03 23');
compare('2007 03 24', Date_Calc::DaysToDate(2454184, "%Y %m %d"), '2454184');
compare(2454184, Date_Calc::DateToDays(24, 3, 2007), '2007 03 24');
compare('2007 03 25', Date_Calc::DaysToDate(2454185, "%Y %m %d"), '2454185');
compare(2454185, Date_Calc::DateToDays(25, 3, 2007), '2007 03 25');
compare('2007 03 26', Date_Calc::DaysToDate(2454186, "%Y %m %d"), '2454186');
compare(2454186, Date_Calc::DateToDays(26, 3, 2007), '2007 03 26');
compare('2007 03 27', Date_Calc::DaysToDate(2454187, "%Y %m %d"), '2454187');
compare(2454187, Date_Calc::DateToDays(27, 3, 2007), '2007 03 27');
compare('2007 03 28', Date_Calc::DaysToDate(2454188, "%Y %m %d"), '2454188');
compare(2454188, Date_Calc::DateToDays(28, 3, 2007), '2007 03 28');
compare('2007 03 29', Date_Calc::DaysToDate(2454189, "%Y %m %d"), '2454189');
compare(2454189, Date_Calc::DateToDays(29, 3, 2007), '2007 03 29');
compare('2007 03 30', Date_Calc::DaysToDate(2454190, "%Y %m %d"), '2454190');
compare(2454190, Date_Calc::DateToDays(30, 3, 2007), '2007 03 30');
compare('2007 03 31', Date_Calc::DaysToDate(2454191, "%Y %m %d"), '2454191');
compare(2454191, Date_Calc::DateToDays(31, 3, 2007), '2007 03 31');
compare('2007 04 01', Date_Calc::DaysToDate(2454192, "%Y %m %d"), '2454192');
compare(2454192, Date_Calc::DateToDays(1, 4, 2007), '2007 04 01');
compare('2007 04 02', Date_Calc::DaysToDate(2454193, "%Y %m %d"), '2454193');
compare(2454193, Date_Calc::DateToDays(2, 4, 2007), '2007 04 02');
compare('2007 04 03', Date_Calc::DaysToDate(2454194, "%Y %m %d"), '2454194');
compare(2454194, Date_Calc::DateToDays(3, 4, 2007), '2007 04 03');
compare('2007 04 04', Date_Calc::DaysToDate(2454195, "%Y %m %d"), '2454195');
compare(2454195, Date_Calc::DateToDays(4, 4, 2007), '2007 04 04');
compare('2007 04 05', Date_Calc::DaysToDate(2454196, "%Y %m %d"), '2454196');
compare(2454196, Date_Calc::DateToDays(5, 4, 2007), '2007 04 05');
compare('2007 04 06', Date_Calc::DaysToDate(2454197, "%Y %m %d"), '2454197');
compare(2454197, Date_Calc::DateToDays(6, 4, 2007), '2007 04 06');
compare('2007 04 07', Date_Calc::DaysToDate(2454198, "%Y %m %d"), '2454198');
compare(2454198, Date_Calc::DateToDays(7, 4, 2007), '2007 04 07');
compare('2007 04 08', Date_Calc::DaysToDate(2454199, "%Y %m %d"), '2454199');
compare(2454199, Date_Calc::DateToDays(8, 4, 2007), '2007 04 08');
compare('2007 04 09', Date_Calc::DaysToDate(2454200, "%Y %m %d"), '2454200');
compare(2454200, Date_Calc::DateToDays(9, 4, 2007), '2007 04 09');
compare('2007 04 10', Date_Calc::DaysToDate(2454201, "%Y %m %d"), '2454201');
compare(2454201, Date_Calc::DateToDays(10, 4, 2007), '2007 04 10');
compare('2007 04 11', Date_Calc::DaysToDate(2454202, "%Y %m %d"), '2454202');
compare(2454202, Date_Calc::DateToDays(11, 4, 2007), '2007 04 11');
compare('2007 04 12', Date_Calc::DaysToDate(2454203, "%Y %m %d"), '2454203');
compare(2454203, Date_Calc::DateToDays(12, 4, 2007), '2007 04 12');
compare('2007 04 13', Date_Calc::DaysToDate(2454204, "%Y %m %d"), '2454204');
compare(2454204, Date_Calc::DateToDays(13, 4, 2007), '2007 04 13');
compare('2007 04 14', Date_Calc::DaysToDate(2454205, "%Y %m %d"), '2454205');
compare(2454205, Date_Calc::DateToDays(14, 4, 2007), '2007 04 14');
compare('2007 04 15', Date_Calc::DaysToDate(2454206, "%Y %m %d"), '2454206');
compare(2454206, Date_Calc::DateToDays(15, 4, 2007), '2007 04 15');
compare('2007 04 16', Date_Calc::DaysToDate(2454207, "%Y %m %d"), '2454207');
compare(2454207, Date_Calc::DateToDays(16, 4, 2007), '2007 04 16');
compare('2007 04 17', Date_Calc::DaysToDate(2454208, "%Y %m %d"), '2454208');
compare(2454208, Date_Calc::DateToDays(17, 4, 2007), '2007 04 17');
compare('2007 04 18', Date_Calc::DaysToDate(2454209, "%Y %m %d"), '2454209');
compare(2454209, Date_Calc::DateToDays(18, 4, 2007), '2007 04 18');
compare('2007 04 19', Date_Calc::DaysToDate(2454210, "%Y %m %d"), '2454210');
compare(2454210, Date_Calc::DateToDays(19, 4, 2007), '2007 04 19');
compare('2007 04 20', Date_Calc::DaysToDate(2454211, "%Y %m %d"), '2454211');
compare(2454211, Date_Calc::DateToDays(20, 4, 2007), '2007 04 20');
compare('2007 04 21', Date_Calc::DaysToDate(2454212, "%Y %m %d"), '2454212');
compare(2454212, Date_Calc::DateToDays(21, 4, 2007), '2007 04 21');
compare('2007 04 22', Date_Calc::DaysToDate(2454213, "%Y %m %d"), '2454213');
compare(2454213, Date_Calc::DateToDays(22, 4, 2007), '2007 04 22');
compare('2007 04 23', Date_Calc::DaysToDate(2454214, "%Y %m %d"), '2454214');
compare(2454214, Date_Calc::DateToDays(23, 4, 2007), '2007 04 23');
compare('2007 04 24', Date_Calc::DaysToDate(2454215, "%Y %m %d"), '2454215');
compare(2454215, Date_Calc::DateToDays(24, 4, 2007), '2007 04 24');
compare('2007 04 25', Date_Calc::DaysToDate(2454216, "%Y %m %d"), '2454216');
compare(2454216, Date_Calc::DateToDays(25, 4, 2007), '2007 04 25');
compare('2007 04 26', Date_Calc::DaysToDate(2454217, "%Y %m %d"), '2454217');
compare(2454217, Date_Calc::DateToDays(26, 4, 2007), '2007 04 26');
compare('2007 04 27', Date_Calc::DaysToDate(2454218, "%Y %m %d"), '2454218');
compare(2454218, Date_Calc::DateToDays(27, 4, 2007), '2007 04 27');
compare('2007 04 28', Date_Calc::DaysToDate(2454219, "%Y %m %d"), '2454219');
compare(2454219, Date_Calc::DateToDays(28, 4, 2007), '2007 04 28');
compare('2007 04 29', Date_Calc::DaysToDate(2454220, "%Y %m %d"), '2454220');
compare(2454220, Date_Calc::DateToDays(29, 4, 2007), '2007 04 29');
compare('2007 04 30', Date_Calc::DaysToDate(2454221, "%Y %m %d"), '2454221');
compare(2454221, Date_Calc::DateToDays(30, 4, 2007), '2007 04 30');
compare('2007 05 01', Date_Calc::DaysToDate(2454222, "%Y %m %d"), '2454222');
compare(2454222, Date_Calc::DateToDays(1, 5, 2007), '2007 05 01');
compare('2007 05 02', Date_Calc::DaysToDate(2454223, "%Y %m %d"), '2454223');
compare(2454223, Date_Calc::DateToDays(2, 5, 2007), '2007 05 02');
compare('2007 05 03', Date_Calc::DaysToDate(2454224, "%Y %m %d"), '2454224');
compare(2454224, Date_Calc::DateToDays(3, 5, 2007), '2007 05 03');
compare('2007 05 04', Date_Calc::DaysToDate(2454225, "%Y %m %d"), '2454225');
compare(2454225, Date_Calc::DateToDays(4, 5, 2007), '2007 05 04');
compare('2007 05 05', Date_Calc::DaysToDate(2454226, "%Y %m %d"), '2454226');
compare(2454226, Date_Calc::DateToDays(5, 5, 2007), '2007 05 05');
compare('2007 05 06', Date_Calc::DaysToDate(2454227, "%Y %m %d"), '2454227');
compare(2454227, Date_Calc::DateToDays(6, 5, 2007), '2007 05 06');
compare('2007 05 07', Date_Calc::DaysToDate(2454228, "%Y %m %d"), '2454228');
compare(2454228, Date_Calc::DateToDays(7, 5, 2007), '2007 05 07');
compare('2007 05 08', Date_Calc::DaysToDate(2454229, "%Y %m %d"), '2454229');
compare(2454229, Date_Calc::DateToDays(8, 5, 2007), '2007 05 08');
compare('2007 05 09', Date_Calc::DaysToDate(2454230, "%Y %m %d"), '2454230');
compare(2454230, Date_Calc::DateToDays(9, 5, 2007), '2007 05 09');
compare('2007 05 10', Date_Calc::DaysToDate(2454231, "%Y %m %d"), '2454231');
compare(2454231, Date_Calc::DateToDays(10, 5, 2007), '2007 05 10');
compare('2007 05 11', Date_Calc::DaysToDate(2454232, "%Y %m %d"), '2454232');
compare(2454232, Date_Calc::DateToDays(11, 5, 2007), '2007 05 11');
compare('2007 05 12', Date_Calc::DaysToDate(2454233, "%Y %m %d"), '2454233');
compare(2454233, Date_Calc::DateToDays(12, 5, 2007), '2007 05 12');
compare('2007 05 13', Date_Calc::DaysToDate(2454234, "%Y %m %d"), '2454234');
compare(2454234, Date_Calc::DateToDays(13, 5, 2007), '2007 05 13');
compare('2007 05 14', Date_Calc::DaysToDate(2454235, "%Y %m %d"), '2454235');
compare(2454235, Date_Calc::DateToDays(14, 5, 2007), '2007 05 14');
compare('2007 05 15', Date_Calc::DaysToDate(2454236, "%Y %m %d"), '2454236');
compare(2454236, Date_Calc::DateToDays(15, 5, 2007), '2007 05 15');
compare('2007 05 16', Date_Calc::DaysToDate(2454237, "%Y %m %d"), '2454237');
compare(2454237, Date_Calc::DateToDays(16, 5, 2007), '2007 05 16');
compare('2007 05 17', Date_Calc::DaysToDate(2454238, "%Y %m %d"), '2454238');
compare(2454238, Date_Calc::DateToDays(17, 5, 2007), '2007 05 17');
compare('2007 05 18', Date_Calc::DaysToDate(2454239, "%Y %m %d"), '2454239');
compare(2454239, Date_Calc::DateToDays(18, 5, 2007), '2007 05 18');
compare('2007 05 19', Date_Calc::DaysToDate(2454240, "%Y %m %d"), '2454240');
compare(2454240, Date_Calc::DateToDays(19, 5, 2007), '2007 05 19');
compare('2007 05 20', Date_Calc::DaysToDate(2454241, "%Y %m %d"), '2454241');
compare(2454241, Date_Calc::DateToDays(20, 5, 2007), '2007 05 20');
compare('2007 05 21', Date_Calc::DaysToDate(2454242, "%Y %m %d"), '2454242');
compare(2454242, Date_Calc::DateToDays(21, 5, 2007), '2007 05 21');
compare('2007 05 22', Date_Calc::DaysToDate(2454243, "%Y %m %d"), '2454243');
compare(2454243, Date_Calc::DateToDays(22, 5, 2007), '2007 05 22');
compare('2007 05 23', Date_Calc::DaysToDate(2454244, "%Y %m %d"), '2454244');
compare(2454244, Date_Calc::DateToDays(23, 5, 2007), '2007 05 23');
compare('2007 05 24', Date_Calc::DaysToDate(2454245, "%Y %m %d"), '2454245');
compare(2454245, Date_Calc::DateToDays(24, 5, 2007), '2007 05 24');
compare('2007 05 25', Date_Calc::DaysToDate(2454246, "%Y %m %d"), '2454246');
compare(2454246, Date_Calc::DateToDays(25, 5, 2007), '2007 05 25');
compare('2007 05 26', Date_Calc::DaysToDate(2454247, "%Y %m %d"), '2454247');
compare(2454247, Date_Calc::DateToDays(26, 5, 2007), '2007 05 26');
compare('2007 05 27', Date_Calc::DaysToDate(2454248, "%Y %m %d"), '2454248');
compare(2454248, Date_Calc::DateToDays(27, 5, 2007), '2007 05 27');
compare('2007 05 28', Date_Calc::DaysToDate(2454249, "%Y %m %d"), '2454249');
compare(2454249, Date_Calc::DateToDays(28, 5, 2007), '2007 05 28');
compare('2007 05 29', Date_Calc::DaysToDate(2454250, "%Y %m %d"), '2454250');
compare(2454250, Date_Calc::DateToDays(29, 5, 2007), '2007 05 29');
compare('2007 05 30', Date_Calc::DaysToDate(2454251, "%Y %m %d"), '2454251');
compare(2454251, Date_Calc::DateToDays(30, 5, 2007), '2007 05 30');
compare('2007 05 31', Date_Calc::DaysToDate(2454252, "%Y %m %d"), '2454252');
compare(2454252, Date_Calc::DateToDays(31, 5, 2007), '2007 05 31');
compare('2007 06 01', Date_Calc::DaysToDate(2454253, "%Y %m %d"), '2454253');
compare(2454253, Date_Calc::DateToDays(1, 6, 2007), '2007 06 01');
compare('2007 06 02', Date_Calc::DaysToDate(2454254, "%Y %m %d"), '2454254');
compare(2454254, Date_Calc::DateToDays(2, 6, 2007), '2007 06 02');
compare('2007 06 03', Date_Calc::DaysToDate(2454255, "%Y %m %d"), '2454255');
compare(2454255, Date_Calc::DateToDays(3, 6, 2007), '2007 06 03');
compare('2007 06 04', Date_Calc::DaysToDate(2454256, "%Y %m %d"), '2454256');
compare(2454256, Date_Calc::DateToDays(4, 6, 2007), '2007 06 04');
compare('2007 06 05', Date_Calc::DaysToDate(2454257, "%Y %m %d"), '2454257');
compare(2454257, Date_Calc::DateToDays(5, 6, 2007), '2007 06 05');
compare('2007 06 06', Date_Calc::DaysToDate(2454258, "%Y %m %d"), '2454258');
compare(2454258, Date_Calc::DateToDays(6, 6, 2007), '2007 06 06');
compare('2007 06 07', Date_Calc::DaysToDate(2454259, "%Y %m %d"), '2454259');
compare(2454259, Date_Calc::DateToDays(7, 6, 2007), '2007 06 07');
compare('2007 06 08', Date_Calc::DaysToDate(2454260, "%Y %m %d"), '2454260');
compare(2454260, Date_Calc::DateToDays(8, 6, 2007), '2007 06 08');
compare('2007 06 09', Date_Calc::DaysToDate(2454261, "%Y %m %d"), '2454261');
compare(2454261, Date_Calc::DateToDays(9, 6, 2007), '2007 06 09');
compare('2007 06 10', Date_Calc::DaysToDate(2454262, "%Y %m %d"), '2454262');
compare(2454262, Date_Calc::DateToDays(10, 6, 2007), '2007 06 10');
compare('2007 06 11', Date_Calc::DaysToDate(2454263, "%Y %m %d"), '2454263');
compare(2454263, Date_Calc::DateToDays(11, 6, 2007), '2007 06 11');
compare('2007 06 12', Date_Calc::DaysToDate(2454264, "%Y %m %d"), '2454264');
compare(2454264, Date_Calc::DateToDays(12, 6, 2007), '2007 06 12');
compare('2007 06 13', Date_Calc::DaysToDate(2454265, "%Y %m %d"), '2454265');
compare(2454265, Date_Calc::DateToDays(13, 6, 2007), '2007 06 13');
compare('2007 06 14', Date_Calc::DaysToDate(2454266, "%Y %m %d"), '2454266');
compare(2454266, Date_Calc::DateToDays(14, 6, 2007), '2007 06 14');
compare('2007 06 15', Date_Calc::DaysToDate(2454267, "%Y %m %d"), '2454267');
compare(2454267, Date_Calc::DateToDays(15, 6, 2007), '2007 06 15');
compare('2007 06 16', Date_Calc::DaysToDate(2454268, "%Y %m %d"), '2454268');
compare(2454268, Date_Calc::DateToDays(16, 6, 2007), '2007 06 16');
compare('2007 06 17', Date_Calc::DaysToDate(2454269, "%Y %m %d"), '2454269');
compare(2454269, Date_Calc::DateToDays(17, 6, 2007), '2007 06 17');
compare('2007 06 18', Date_Calc::DaysToDate(2454270, "%Y %m %d"), '2454270');
compare(2454270, Date_Calc::DateToDays(18, 6, 2007), '2007 06 18');
compare('2007 06 19', Date_Calc::DaysToDate(2454271, "%Y %m %d"), '2454271');
compare(2454271, Date_Calc::DateToDays(19, 6, 2007), '2007 06 19');
compare('2007 06 20', Date_Calc::DaysToDate(2454272, "%Y %m %d"), '2454272');
compare(2454272, Date_Calc::DateToDays(20, 6, 2007), '2007 06 20');
compare('2007 06 21', Date_Calc::DaysToDate(2454273, "%Y %m %d"), '2454273');
compare(2454273, Date_Calc::DateToDays(21, 6, 2007), '2007 06 21');
compare('2007 06 22', Date_Calc::DaysToDate(2454274, "%Y %m %d"), '2454274');
compare(2454274, Date_Calc::DateToDays(22, 6, 2007), '2007 06 22');
compare('2007 06 23', Date_Calc::DaysToDate(2454275, "%Y %m %d"), '2454275');
compare(2454275, Date_Calc::DateToDays(23, 6, 2007), '2007 06 23');
compare('2007 06 24', Date_Calc::DaysToDate(2454276, "%Y %m %d"), '2454276');
compare(2454276, Date_Calc::DateToDays(24, 6, 2007), '2007 06 24');
compare('2007 06 25', Date_Calc::DaysToDate(2454277, "%Y %m %d"), '2454277');
compare(2454277, Date_Calc::DateToDays(25, 6, 2007), '2007 06 25');
compare('2007 06 26', Date_Calc::DaysToDate(2454278, "%Y %m %d"), '2454278');
compare(2454278, Date_Calc::DateToDays(26, 6, 2007), '2007 06 26');
compare('2007 06 27', Date_Calc::DaysToDate(2454279, "%Y %m %d"), '2454279');
compare(2454279, Date_Calc::DateToDays(27, 6, 2007), '2007 06 27');
compare('2007 06 28', Date_Calc::DaysToDate(2454280, "%Y %m %d"), '2454280');
compare(2454280, Date_Calc::DateToDays(28, 6, 2007), '2007 06 28');
compare('2007 06 29', Date_Calc::DaysToDate(2454281, "%Y %m %d"), '2454281');
compare(2454281, Date_Calc::DateToDays(29, 6, 2007), '2007 06 29');
compare('2007 06 30', Date_Calc::DaysToDate(2454282, "%Y %m %d"), '2454282');
compare(2454282, Date_Calc::DateToDays(30, 6, 2007), '2007 06 30');
compare('2007 07 01', Date_Calc::DaysToDate(2454283, "%Y %m %d"), '2454283');
compare(2454283, Date_Calc::DateToDays(1, 7, 2007), '2007 07 01');
compare('2007 07 02', Date_Calc::DaysToDate(2454284, "%Y %m %d"), '2454284');
compare(2454284, Date_Calc::DateToDays(2, 7, 2007), '2007 07 02');
compare('2007 07 03', Date_Calc::DaysToDate(2454285, "%Y %m %d"), '2454285');
compare(2454285, Date_Calc::DateToDays(3, 7, 2007), '2007 07 03');
compare('2007 07 04', Date_Calc::DaysToDate(2454286, "%Y %m %d"), '2454286');
compare(2454286, Date_Calc::DateToDays(4, 7, 2007), '2007 07 04');
compare('2007 07 05', Date_Calc::DaysToDate(2454287, "%Y %m %d"), '2454287');
compare(2454287, Date_Calc::DateToDays(5, 7, 2007), '2007 07 05');
compare('2007 07 06', Date_Calc::DaysToDate(2454288, "%Y %m %d"), '2454288');
compare(2454288, Date_Calc::DateToDays(6, 7, 2007), '2007 07 06');
compare('2007 07 07', Date_Calc::DaysToDate(2454289, "%Y %m %d"), '2454289');
compare(2454289, Date_Calc::DateToDays(7, 7, 2007), '2007 07 07');
compare('2007 07 08', Date_Calc::DaysToDate(2454290, "%Y %m %d"), '2454290');
compare(2454290, Date_Calc::DateToDays(8, 7, 2007), '2007 07 08');
compare('2007 07 09', Date_Calc::DaysToDate(2454291, "%Y %m %d"), '2454291');
compare(2454291, Date_Calc::DateToDays(9, 7, 2007), '2007 07 09');
compare('2007 07 10', Date_Calc::DaysToDate(2454292, "%Y %m %d"), '2454292');
compare(2454292, Date_Calc::DateToDays(10, 7, 2007), '2007 07 10');
compare('2007 07 11', Date_Calc::DaysToDate(2454293, "%Y %m %d"), '2454293');
compare(2454293, Date_Calc::DateToDays(11, 7, 2007), '2007 07 11');
compare('2007 07 12', Date_Calc::DaysToDate(2454294, "%Y %m %d"), '2454294');
compare(2454294, Date_Calc::DateToDays(12, 7, 2007), '2007 07 12');
compare('2007 07 13', Date_Calc::DaysToDate(2454295, "%Y %m %d"), '2454295');
compare(2454295, Date_Calc::DateToDays(13, 7, 2007), '2007 07 13');
compare('2007 07 14', Date_Calc::DaysToDate(2454296, "%Y %m %d"), '2454296');
compare(2454296, Date_Calc::DateToDays(14, 7, 2007), '2007 07 14');
compare('2007 07 15', Date_Calc::DaysToDate(2454297, "%Y %m %d"), '2454297');
compare(2454297, Date_Calc::DateToDays(15, 7, 2007), '2007 07 15');
compare('2007 07 16', Date_Calc::DaysToDate(2454298, "%Y %m %d"), '2454298');
compare(2454298, Date_Calc::DateToDays(16, 7, 2007), '2007 07 16');
compare('2007 07 17', Date_Calc::DaysToDate(2454299, "%Y %m %d"), '2454299');
compare(2454299, Date_Calc::DateToDays(17, 7, 2007), '2007 07 17');
compare('2007 07 18', Date_Calc::DaysToDate(2454300, "%Y %m %d"), '2454300');
compare(2454300, Date_Calc::DateToDays(18, 7, 2007), '2007 07 18');
compare('2007 07 19', Date_Calc::DaysToDate(2454301, "%Y %m %d"), '2454301');
compare(2454301, Date_Calc::DateToDays(19, 7, 2007), '2007 07 19');
compare('2007 07 20', Date_Calc::DaysToDate(2454302, "%Y %m %d"), '2454302');
compare(2454302, Date_Calc::DateToDays(20, 7, 2007), '2007 07 20');
compare('2007 07 21', Date_Calc::DaysToDate(2454303, "%Y %m %d"), '2454303');
compare(2454303, Date_Calc::DateToDays(21, 7, 2007), '2007 07 21');
compare('2007 07 22', Date_Calc::DaysToDate(2454304, "%Y %m %d"), '2454304');
compare(2454304, Date_Calc::DateToDays(22, 7, 2007), '2007 07 22');
compare('2007 07 23', Date_Calc::DaysToDate(2454305, "%Y %m %d"), '2454305');
compare(2454305, Date_Calc::DateToDays(23, 7, 2007), '2007 07 23');
compare('2007 07 24', Date_Calc::DaysToDate(2454306, "%Y %m %d"), '2454306');
compare(2454306, Date_Calc::DateToDays(24, 7, 2007), '2007 07 24');
compare('2007 07 25', Date_Calc::DaysToDate(2454307, "%Y %m %d"), '2454307');
compare(2454307, Date_Calc::DateToDays(25, 7, 2007), '2007 07 25');
compare('2007 07 26', Date_Calc::DaysToDate(2454308, "%Y %m %d"), '2454308');
compare(2454308, Date_Calc::DateToDays(26, 7, 2007), '2007 07 26');
compare('2007 07 27', Date_Calc::DaysToDate(2454309, "%Y %m %d"), '2454309');
compare(2454309, Date_Calc::DateToDays(27, 7, 2007), '2007 07 27');
compare('2007 07 28', Date_Calc::DaysToDate(2454310, "%Y %m %d"), '2454310');
compare(2454310, Date_Calc::DateToDays(28, 7, 2007), '2007 07 28');
compare('2007 07 29', Date_Calc::DaysToDate(2454311, "%Y %m %d"), '2454311');
compare(2454311, Date_Calc::DateToDays(29, 7, 2007), '2007 07 29');
compare('2007 07 30', Date_Calc::DaysToDate(2454312, "%Y %m %d"), '2454312');
compare(2454312, Date_Calc::DateToDays(30, 7, 2007), '2007 07 30');
compare('2007 07 31', Date_Calc::DaysToDate(2454313, "%Y %m %d"), '2454313');
compare(2454313, Date_Calc::DateToDays(31, 7, 2007), '2007 07 31');
compare('2007 08 01', Date_Calc::DaysToDate(2454314, "%Y %m %d"), '2454314');
compare(2454314, Date_Calc::DateToDays(1, 8, 2007), '2007 08 01');
compare('2007 08 02', Date_Calc::DaysToDate(2454315, "%Y %m %d"), '2454315');
compare(2454315, Date_Calc::DateToDays(2, 8, 2007), '2007 08 02');
compare('2007 08 03', Date_Calc::DaysToDate(2454316, "%Y %m %d"), '2454316');
compare(2454316, Date_Calc::DateToDays(3, 8, 2007), '2007 08 03');
compare('2007 08 04', Date_Calc::DaysToDate(2454317, "%Y %m %d"), '2454317');
compare(2454317, Date_Calc::DateToDays(4, 8, 2007), '2007 08 04');
compare('2007 08 05', Date_Calc::DaysToDate(2454318, "%Y %m %d"), '2454318');
compare(2454318, Date_Calc::DateToDays(5, 8, 2007), '2007 08 05');
compare('2007 08 06', Date_Calc::DaysToDate(2454319, "%Y %m %d"), '2454319');
compare(2454319, Date_Calc::DateToDays(6, 8, 2007), '2007 08 06');
compare('2007 08 07', Date_Calc::DaysToDate(2454320, "%Y %m %d"), '2454320');
compare(2454320, Date_Calc::DateToDays(7, 8, 2007), '2007 08 07');
compare('2007 08 08', Date_Calc::DaysToDate(2454321, "%Y %m %d"), '2454321');
compare(2454321, Date_Calc::DateToDays(8, 8, 2007), '2007 08 08');
compare('2007 08 09', Date_Calc::DaysToDate(2454322, "%Y %m %d"), '2454322');
compare(2454322, Date_Calc::DateToDays(9, 8, 2007), '2007 08 09');
compare('2007 08 10', Date_Calc::DaysToDate(2454323, "%Y %m %d"), '2454323');
compare(2454323, Date_Calc::DateToDays(10, 8, 2007), '2007 08 10');
compare('2007 08 11', Date_Calc::DaysToDate(2454324, "%Y %m %d"), '2454324');
compare(2454324, Date_Calc::DateToDays(11, 8, 2007), '2007 08 11');
compare('2007 08 12', Date_Calc::DaysToDate(2454325, "%Y %m %d"), '2454325');
compare(2454325, Date_Calc::DateToDays(12, 8, 2007), '2007 08 12');
compare('2007 08 13', Date_Calc::DaysToDate(2454326, "%Y %m %d"), '2454326');
compare(2454326, Date_Calc::DateToDays(13, 8, 2007), '2007 08 13');
compare('2007 08 14', Date_Calc::DaysToDate(2454327, "%Y %m %d"), '2454327');
compare(2454327, Date_Calc::DateToDays(14, 8, 2007), '2007 08 14');
compare('2007 08 15', Date_Calc::DaysToDate(2454328, "%Y %m %d"), '2454328');
compare(2454328, Date_Calc::DateToDays(15, 8, 2007), '2007 08 15');
compare('2007 08 16', Date_Calc::DaysToDate(2454329, "%Y %m %d"), '2454329');
compare(2454329, Date_Calc::DateToDays(16, 8, 2007), '2007 08 16');
compare('2007 08 17', Date_Calc::DaysToDate(2454330, "%Y %m %d"), '2454330');
compare(2454330, Date_Calc::DateToDays(17, 8, 2007), '2007 08 17');
compare('2007 08 18', Date_Calc::DaysToDate(2454331, "%Y %m %d"), '2454331');
compare(2454331, Date_Calc::DateToDays(18, 8, 2007), '2007 08 18');
compare('2007 08 19', Date_Calc::DaysToDate(2454332, "%Y %m %d"), '2454332');
compare(2454332, Date_Calc::DateToDays(19, 8, 2007), '2007 08 19');
compare('2007 08 20', Date_Calc::DaysToDate(2454333, "%Y %m %d"), '2454333');
compare(2454333, Date_Calc::DateToDays(20, 8, 2007), '2007 08 20');
compare('2007 08 21', Date_Calc::DaysToDate(2454334, "%Y %m %d"), '2454334');
compare(2454334, Date_Calc::DateToDays(21, 8, 2007), '2007 08 21');
compare('2007 08 22', Date_Calc::DaysToDate(2454335, "%Y %m %d"), '2454335');
compare(2454335, Date_Calc::DateToDays(22, 8, 2007), '2007 08 22');
compare('2007 08 23', Date_Calc::DaysToDate(2454336, "%Y %m %d"), '2454336');
compare(2454336, Date_Calc::DateToDays(23, 8, 2007), '2007 08 23');
compare('2007 08 24', Date_Calc::DaysToDate(2454337, "%Y %m %d"), '2454337');
compare(2454337, Date_Calc::DateToDays(24, 8, 2007), '2007 08 24');
compare('2007 08 25', Date_Calc::DaysToDate(2454338, "%Y %m %d"), '2454338');
compare(2454338, Date_Calc::DateToDays(25, 8, 2007), '2007 08 25');
compare('2007 08 26', Date_Calc::DaysToDate(2454339, "%Y %m %d"), '2454339');
compare(2454339, Date_Calc::DateToDays(26, 8, 2007), '2007 08 26');
compare('2007 08 27', Date_Calc::DaysToDate(2454340, "%Y %m %d"), '2454340');
compare(2454340, Date_Calc::DateToDays(27, 8, 2007), '2007 08 27');
compare('2007 08 28', Date_Calc::DaysToDate(2454341, "%Y %m %d"), '2454341');
compare(2454341, Date_Calc::DateToDays(28, 8, 2007), '2007 08 28');
compare('2007 08 29', Date_Calc::DaysToDate(2454342, "%Y %m %d"), '2454342');
compare(2454342, Date_Calc::DateToDays(29, 8, 2007), '2007 08 29');
compare('2007 08 30', Date_Calc::DaysToDate(2454343, "%Y %m %d"), '2454343');
compare(2454343, Date_Calc::DateToDays(30, 8, 2007), '2007 08 30');
compare('2007 08 31', Date_Calc::DaysToDate(2454344, "%Y %m %d"), '2454344');
compare(2454344, Date_Calc::DateToDays(31, 8, 2007), '2007 08 31');
compare('2007 09 01', Date_Calc::DaysToDate(2454345, "%Y %m %d"), '2454345');
compare(2454345, Date_Calc::DateToDays(1, 9, 2007), '2007 09 01');
compare('2007 09 02', Date_Calc::DaysToDate(2454346, "%Y %m %d"), '2454346');
compare(2454346, Date_Calc::DateToDays(2, 9, 2007), '2007 09 02');
compare('2007 09 03', Date_Calc::DaysToDate(2454347, "%Y %m %d"), '2454347');
compare(2454347, Date_Calc::DateToDays(3, 9, 2007), '2007 09 03');
compare('2007 09 04', Date_Calc::DaysToDate(2454348, "%Y %m %d"), '2454348');
compare(2454348, Date_Calc::DateToDays(4, 9, 2007), '2007 09 04');
compare('2007 09 05', Date_Calc::DaysToDate(2454349, "%Y %m %d"), '2454349');
compare(2454349, Date_Calc::DateToDays(5, 9, 2007), '2007 09 05');
compare('2007 09 06', Date_Calc::DaysToDate(2454350, "%Y %m %d"), '2454350');
compare(2454350, Date_Calc::DateToDays(6, 9, 2007), '2007 09 06');
compare('2007 09 07', Date_Calc::DaysToDate(2454351, "%Y %m %d"), '2454351');
compare(2454351, Date_Calc::DateToDays(7, 9, 2007), '2007 09 07');
compare('2007 09 08', Date_Calc::DaysToDate(2454352, "%Y %m %d"), '2454352');
compare(2454352, Date_Calc::DateToDays(8, 9, 2007), '2007 09 08');
compare('2007 09 09', Date_Calc::DaysToDate(2454353, "%Y %m %d"), '2454353');
compare(2454353, Date_Calc::DateToDays(9, 9, 2007), '2007 09 09');
compare('2007 09 10', Date_Calc::DaysToDate(2454354, "%Y %m %d"), '2454354');
compare(2454354, Date_Calc::DateToDays(10, 9, 2007), '2007 09 10');
compare('2007 09 11', Date_Calc::DaysToDate(2454355, "%Y %m %d"), '2454355');
compare(2454355, Date_Calc::DateToDays(11, 9, 2007), '2007 09 11');
compare('2007 09 12', Date_Calc::DaysToDate(2454356, "%Y %m %d"), '2454356');
compare(2454356, Date_Calc::DateToDays(12, 9, 2007), '2007 09 12');
compare('2007 09 13', Date_Calc::DaysToDate(2454357, "%Y %m %d"), '2454357');
compare(2454357, Date_Calc::DateToDays(13, 9, 2007), '2007 09 13');
compare('2007 09 14', Date_Calc::DaysToDate(2454358, "%Y %m %d"), '2454358');
compare(2454358, Date_Calc::DateToDays(14, 9, 2007), '2007 09 14');
compare('2007 09 15', Date_Calc::DaysToDate(2454359, "%Y %m %d"), '2454359');
compare(2454359, Date_Calc::DateToDays(15, 9, 2007), '2007 09 15');
compare('2007 09 16', Date_Calc::DaysToDate(2454360, "%Y %m %d"), '2454360');
compare(2454360, Date_Calc::DateToDays(16, 9, 2007), '2007 09 16');
compare('2007 09 17', Date_Calc::DaysToDate(2454361, "%Y %m %d"), '2454361');
compare(2454361, Date_Calc::DateToDays(17, 9, 2007), '2007 09 17');
compare('2007 09 18', Date_Calc::DaysToDate(2454362, "%Y %m %d"), '2454362');
compare(2454362, Date_Calc::DateToDays(18, 9, 2007), '2007 09 18');
compare('2007 09 19', Date_Calc::DaysToDate(2454363, "%Y %m %d"), '2454363');
compare(2454363, Date_Calc::DateToDays(19, 9, 2007), '2007 09 19');
compare('2007 09 20', Date_Calc::DaysToDate(2454364, "%Y %m %d"), '2454364');
compare(2454364, Date_Calc::DateToDays(20, 9, 2007), '2007 09 20');
compare('2007 09 21', Date_Calc::DaysToDate(2454365, "%Y %m %d"), '2454365');
compare(2454365, Date_Calc::DateToDays(21, 9, 2007), '2007 09 21');
compare('2007 09 22', Date_Calc::DaysToDate(2454366, "%Y %m %d"), '2454366');
compare(2454366, Date_Calc::DateToDays(22, 9, 2007), '2007 09 22');
compare('2007 09 23', Date_Calc::DaysToDate(2454367, "%Y %m %d"), '2454367');
compare(2454367, Date_Calc::DateToDays(23, 9, 2007), '2007 09 23');
compare('2007 09 24', Date_Calc::DaysToDate(2454368, "%Y %m %d"), '2454368');
compare(2454368, Date_Calc::DateToDays(24, 9, 2007), '2007 09 24');
compare('2007 09 25', Date_Calc::DaysToDate(2454369, "%Y %m %d"), '2454369');
compare(2454369, Date_Calc::DateToDays(25, 9, 2007), '2007 09 25');
compare('2007 09 26', Date_Calc::DaysToDate(2454370, "%Y %m %d"), '2454370');
compare(2454370, Date_Calc::DateToDays(26, 9, 2007), '2007 09 26');
compare('2007 09 27', Date_Calc::DaysToDate(2454371, "%Y %m %d"), '2454371');
compare(2454371, Date_Calc::DateToDays(27, 9, 2007), '2007 09 27');
compare('2007 09 28', Date_Calc::DaysToDate(2454372, "%Y %m %d"), '2454372');
compare(2454372, Date_Calc::DateToDays(28, 9, 2007), '2007 09 28');
compare('2007 09 29', Date_Calc::DaysToDate(2454373, "%Y %m %d"), '2454373');
compare(2454373, Date_Calc::DateToDays(29, 9, 2007), '2007 09 29');
compare('2007 09 30', Date_Calc::DaysToDate(2454374, "%Y %m %d"), '2454374');
compare(2454374, Date_Calc::DateToDays(30, 9, 2007), '2007 09 30');
compare('2007 10 01', Date_Calc::DaysToDate(2454375, "%Y %m %d"), '2454375');
compare(2454375, Date_Calc::DateToDays(1, 10, 2007), '2007 10 01');
compare('2007 10 02', Date_Calc::DaysToDate(2454376, "%Y %m %d"), '2454376');
compare(2454376, Date_Calc::DateToDays(2, 10, 2007), '2007 10 02');
compare('2007 10 03', Date_Calc::DaysToDate(2454377, "%Y %m %d"), '2454377');
compare(2454377, Date_Calc::DateToDays(3, 10, 2007), '2007 10 03');
compare('2007 10 04', Date_Calc::DaysToDate(2454378, "%Y %m %d"), '2454378');
compare(2454378, Date_Calc::DateToDays(4, 10, 2007), '2007 10 04');
compare('2007 10 05', Date_Calc::DaysToDate(2454379, "%Y %m %d"), '2454379');
compare(2454379, Date_Calc::DateToDays(5, 10, 2007), '2007 10 05');
compare('2007 10 06', Date_Calc::DaysToDate(2454380, "%Y %m %d"), '2454380');
compare(2454380, Date_Calc::DateToDays(6, 10, 2007), '2007 10 06');
compare('2007 10 07', Date_Calc::DaysToDate(2454381, "%Y %m %d"), '2454381');
compare(2454381, Date_Calc::DateToDays(7, 10, 2007), '2007 10 07');
compare('2007 10 08', Date_Calc::DaysToDate(2454382, "%Y %m %d"), '2454382');
compare(2454382, Date_Calc::DateToDays(8, 10, 2007), '2007 10 08');
compare('2007 10 09', Date_Calc::DaysToDate(2454383, "%Y %m %d"), '2454383');
compare(2454383, Date_Calc::DateToDays(9, 10, 2007), '2007 10 09');
compare('2007 10 10', Date_Calc::DaysToDate(2454384, "%Y %m %d"), '2454384');
compare(2454384, Date_Calc::DateToDays(10, 10, 2007), '2007 10 10');
compare('2007 10 11', Date_Calc::DaysToDate(2454385, "%Y %m %d"), '2454385');
compare(2454385, Date_Calc::DateToDays(11, 10, 2007), '2007 10 11');
compare('2007 10 12', Date_Calc::DaysToDate(2454386, "%Y %m %d"), '2454386');
compare(2454386, Date_Calc::DateToDays(12, 10, 2007), '2007 10 12');
compare('2007 10 13', Date_Calc::DaysToDate(2454387, "%Y %m %d"), '2454387');
compare(2454387, Date_Calc::DateToDays(13, 10, 2007), '2007 10 13');
compare('2007 10 14', Date_Calc::DaysToDate(2454388, "%Y %m %d"), '2454388');
compare(2454388, Date_Calc::DateToDays(14, 10, 2007), '2007 10 14');
compare('2007 10 15', Date_Calc::DaysToDate(2454389, "%Y %m %d"), '2454389');
compare(2454389, Date_Calc::DateToDays(15, 10, 2007), '2007 10 15');
compare('2007 10 16', Date_Calc::DaysToDate(2454390, "%Y %m %d"), '2454390');
compare(2454390, Date_Calc::DateToDays(16, 10, 2007), '2007 10 16');
compare('2007 10 17', Date_Calc::DaysToDate(2454391, "%Y %m %d"), '2454391');
compare(2454391, Date_Calc::DateToDays(17, 10, 2007), '2007 10 17');
compare('2007 10 18', Date_Calc::DaysToDate(2454392, "%Y %m %d"), '2454392');
compare(2454392, Date_Calc::DateToDays(18, 10, 2007), '2007 10 18');
compare('2007 10 19', Date_Calc::DaysToDate(2454393, "%Y %m %d"), '2454393');
compare(2454393, Date_Calc::DateToDays(19, 10, 2007), '2007 10 19');
compare('2007 10 20', Date_Calc::DaysToDate(2454394, "%Y %m %d"), '2454394');
compare(2454394, Date_Calc::DateToDays(20, 10, 2007), '2007 10 20');
compare('2007 10 21', Date_Calc::DaysToDate(2454395, "%Y %m %d"), '2454395');
compare(2454395, Date_Calc::DateToDays(21, 10, 2007), '2007 10 21');
compare('2007 10 22', Date_Calc::DaysToDate(2454396, "%Y %m %d"), '2454396');
compare(2454396, Date_Calc::DateToDays(22, 10, 2007), '2007 10 22');
compare('2007 10 23', Date_Calc::DaysToDate(2454397, "%Y %m %d"), '2454397');
compare(2454397, Date_Calc::DateToDays(23, 10, 2007), '2007 10 23');
compare('2007 10 24', Date_Calc::DaysToDate(2454398, "%Y %m %d"), '2454398');
compare(2454398, Date_Calc::DateToDays(24, 10, 2007), '2007 10 24');
compare('2007 10 25', Date_Calc::DaysToDate(2454399, "%Y %m %d"), '2454399');
compare(2454399, Date_Calc::DateToDays(25, 10, 2007), '2007 10 25');
compare('2007 10 26', Date_Calc::DaysToDate(2454400, "%Y %m %d"), '2454400');
compare(2454400, Date_Calc::DateToDays(26, 10, 2007), '2007 10 26');
compare('2007 10 27', Date_Calc::DaysToDate(2454401, "%Y %m %d"), '2454401');
compare(2454401, Date_Calc::DateToDays(27, 10, 2007), '2007 10 27');
compare('2007 10 28', Date_Calc::DaysToDate(2454402, "%Y %m %d"), '2454402');
compare(2454402, Date_Calc::DateToDays(28, 10, 2007), '2007 10 28');
compare('2007 10 29', Date_Calc::DaysToDate(2454403, "%Y %m %d"), '2454403');
compare(2454403, Date_Calc::DateToDays(29, 10, 2007), '2007 10 29');
compare('2007 10 30', Date_Calc::DaysToDate(2454404, "%Y %m %d"), '2454404');
compare(2454404, Date_Calc::DateToDays(30, 10, 2007), '2007 10 30');
compare('2007 10 31', Date_Calc::DaysToDate(2454405, "%Y %m %d"), '2454405');
compare(2454405, Date_Calc::DateToDays(31, 10, 2007), '2007 10 31');
compare('2007 11 01', Date_Calc::DaysToDate(2454406, "%Y %m %d"), '2454406');
compare(2454406, Date_Calc::DateToDays(1, 11, 2007), '2007 11 01');
compare('2007 11 02', Date_Calc::DaysToDate(2454407, "%Y %m %d"), '2454407');
compare(2454407, Date_Calc::DateToDays(2, 11, 2007), '2007 11 02');
compare('2007 11 03', Date_Calc::DaysToDate(2454408, "%Y %m %d"), '2454408');
compare(2454408, Date_Calc::DateToDays(3, 11, 2007), '2007 11 03');
compare('2007 11 04', Date_Calc::DaysToDate(2454409, "%Y %m %d"), '2454409');
compare(2454409, Date_Calc::DateToDays(4, 11, 2007), '2007 11 04');
compare('2007 11 05', Date_Calc::DaysToDate(2454410, "%Y %m %d"), '2454410');
compare(2454410, Date_Calc::DateToDays(5, 11, 2007), '2007 11 05');
compare('2007 11 06', Date_Calc::DaysToDate(2454411, "%Y %m %d"), '2454411');
compare(2454411, Date_Calc::DateToDays(6, 11, 2007), '2007 11 06');
compare('2007 11 07', Date_Calc::DaysToDate(2454412, "%Y %m %d"), '2454412');
compare(2454412, Date_Calc::DateToDays(7, 11, 2007), '2007 11 07');
compare('2007 11 08', Date_Calc::DaysToDate(2454413, "%Y %m %d"), '2454413');
compare(2454413, Date_Calc::DateToDays(8, 11, 2007), '2007 11 08');
compare('2007 11 09', Date_Calc::DaysToDate(2454414, "%Y %m %d"), '2454414');
compare(2454414, Date_Calc::DateToDays(9, 11, 2007), '2007 11 09');
compare('2007 11 10', Date_Calc::DaysToDate(2454415, "%Y %m %d"), '2454415');
compare(2454415, Date_Calc::DateToDays(10, 11, 2007), '2007 11 10');
compare('2007 11 11', Date_Calc::DaysToDate(2454416, "%Y %m %d"), '2454416');
compare(2454416, Date_Calc::DateToDays(11, 11, 2007), '2007 11 11');
compare('2007 11 12', Date_Calc::DaysToDate(2454417, "%Y %m %d"), '2454417');
compare(2454417, Date_Calc::DateToDays(12, 11, 2007), '2007 11 12');
compare('2007 11 13', Date_Calc::DaysToDate(2454418, "%Y %m %d"), '2454418');
compare(2454418, Date_Calc::DateToDays(13, 11, 2007), '2007 11 13');
compare('2007 11 14', Date_Calc::DaysToDate(2454419, "%Y %m %d"), '2454419');
compare(2454419, Date_Calc::DateToDays(14, 11, 2007), '2007 11 14');
compare('2007 11 15', Date_Calc::DaysToDate(2454420, "%Y %m %d"), '2454420');
compare(2454420, Date_Calc::DateToDays(15, 11, 2007), '2007 11 15');
compare('2007 11 16', Date_Calc::DaysToDate(2454421, "%Y %m %d"), '2454421');
compare(2454421, Date_Calc::DateToDays(16, 11, 2007), '2007 11 16');
compare('2007 11 17', Date_Calc::DaysToDate(2454422, "%Y %m %d"), '2454422');
compare(2454422, Date_Calc::DateToDays(17, 11, 2007), '2007 11 17');
compare('2007 11 18', Date_Calc::DaysToDate(2454423, "%Y %m %d"), '2454423');
compare(2454423, Date_Calc::DateToDays(18, 11, 2007), '2007 11 18');
compare('2007 11 19', Date_Calc::DaysToDate(2454424, "%Y %m %d"), '2454424');
compare(2454424, Date_Calc::DateToDays(19, 11, 2007), '2007 11 19');
compare('2007 11 20', Date_Calc::DaysToDate(2454425, "%Y %m %d"), '2454425');
compare(2454425, Date_Calc::DateToDays(20, 11, 2007), '2007 11 20');
compare('2007 11 21', Date_Calc::DaysToDate(2454426, "%Y %m %d"), '2454426');
compare(2454426, Date_Calc::DateToDays(21, 11, 2007), '2007 11 21');
compare('2007 11 22', Date_Calc::DaysToDate(2454427, "%Y %m %d"), '2454427');
compare(2454427, Date_Calc::DateToDays(22, 11, 2007), '2007 11 22');
compare('2007 11 23', Date_Calc::DaysToDate(2454428, "%Y %m %d"), '2454428');
compare(2454428, Date_Calc::DateToDays(23, 11, 2007), '2007 11 23');
compare('2007 11 24', Date_Calc::DaysToDate(2454429, "%Y %m %d"), '2454429');
compare(2454429, Date_Calc::DateToDays(24, 11, 2007), '2007 11 24');
compare('2007 11 25', Date_Calc::DaysToDate(2454430, "%Y %m %d"), '2454430');
compare(2454430, Date_Calc::DateToDays(25, 11, 2007), '2007 11 25');
compare('2007 11 26', Date_Calc::DaysToDate(2454431, "%Y %m %d"), '2454431');
compare(2454431, Date_Calc::DateToDays(26, 11, 2007), '2007 11 26');
compare('2007 11 27', Date_Calc::DaysToDate(2454432, "%Y %m %d"), '2454432');
compare(2454432, Date_Calc::DateToDays(27, 11, 2007), '2007 11 27');
compare('2007 11 28', Date_Calc::DaysToDate(2454433, "%Y %m %d"), '2454433');
compare(2454433, Date_Calc::DateToDays(28, 11, 2007), '2007 11 28');
compare('2007 11 29', Date_Calc::DaysToDate(2454434, "%Y %m %d"), '2454434');
compare(2454434, Date_Calc::DateToDays(29, 11, 2007), '2007 11 29');
compare('2007 11 30', Date_Calc::DaysToDate(2454435, "%Y %m %d"), '2454435');
compare(2454435, Date_Calc::DateToDays(30, 11, 2007), '2007 11 30');
compare('2007 12 01', Date_Calc::DaysToDate(2454436, "%Y %m %d"), '2454436');
compare(2454436, Date_Calc::DateToDays(1, 12, 2007), '2007 12 01');
compare('2007 12 02', Date_Calc::DaysToDate(2454437, "%Y %m %d"), '2454437');
compare(2454437, Date_Calc::DateToDays(2, 12, 2007), '2007 12 02');
compare('2007 12 03', Date_Calc::DaysToDate(2454438, "%Y %m %d"), '2454438');
compare(2454438, Date_Calc::DateToDays(3, 12, 2007), '2007 12 03');
compare('2007 12 04', Date_Calc::DaysToDate(2454439, "%Y %m %d"), '2454439');
compare(2454439, Date_Calc::DateToDays(4, 12, 2007), '2007 12 04');
compare('2007 12 05', Date_Calc::DaysToDate(2454440, "%Y %m %d"), '2454440');
compare(2454440, Date_Calc::DateToDays(5, 12, 2007), '2007 12 05');
compare('2007 12 06', Date_Calc::DaysToDate(2454441, "%Y %m %d"), '2454441');
compare(2454441, Date_Calc::DateToDays(6, 12, 2007), '2007 12 06');
compare('2007 12 07', Date_Calc::DaysToDate(2454442, "%Y %m %d"), '2454442');
compare(2454442, Date_Calc::DateToDays(7, 12, 2007), '2007 12 07');
compare('2007 12 08', Date_Calc::DaysToDate(2454443, "%Y %m %d"), '2454443');
compare(2454443, Date_Calc::DateToDays(8, 12, 2007), '2007 12 08');
compare('2007 12 09', Date_Calc::DaysToDate(2454444, "%Y %m %d"), '2454444');
compare(2454444, Date_Calc::DateToDays(9, 12, 2007), '2007 12 09');
compare('2007 12 10', Date_Calc::DaysToDate(2454445, "%Y %m %d"), '2454445');
compare(2454445, Date_Calc::DateToDays(10, 12, 2007), '2007 12 10');
compare('2007 12 11', Date_Calc::DaysToDate(2454446, "%Y %m %d"), '2454446');
compare(2454446, Date_Calc::DateToDays(11, 12, 2007), '2007 12 11');
compare('2007 12 12', Date_Calc::DaysToDate(2454447, "%Y %m %d"), '2454447');
compare(2454447, Date_Calc::DateToDays(12, 12, 2007), '2007 12 12');
compare('2007 12 13', Date_Calc::DaysToDate(2454448, "%Y %m %d"), '2454448');
compare(2454448, Date_Calc::DateToDays(13, 12, 2007), '2007 12 13');
compare('2007 12 14', Date_Calc::DaysToDate(2454449, "%Y %m %d"), '2454449');
compare(2454449, Date_Calc::DateToDays(14, 12, 2007), '2007 12 14');
compare('2007 12 15', Date_Calc::DaysToDate(2454450, "%Y %m %d"), '2454450');
compare(2454450, Date_Calc::DateToDays(15, 12, 2007), '2007 12 15');
compare('2007 12 16', Date_Calc::DaysToDate(2454451, "%Y %m %d"), '2454451');
compare(2454451, Date_Calc::DateToDays(16, 12, 2007), '2007 12 16');
compare('2007 12 17', Date_Calc::DaysToDate(2454452, "%Y %m %d"), '2454452');
compare(2454452, Date_Calc::DateToDays(17, 12, 2007), '2007 12 17');
compare('2007 12 18', Date_Calc::DaysToDate(2454453, "%Y %m %d"), '2454453');
compare(2454453, Date_Calc::DateToDays(18, 12, 2007), '2007 12 18');
compare('2007 12 19', Date_Calc::DaysToDate(2454454, "%Y %m %d"), '2454454');
compare(2454454, Date_Calc::DateToDays(19, 12, 2007), '2007 12 19');
compare('2007 12 20', Date_Calc::DaysToDate(2454455, "%Y %m %d"), '2454455');
compare(2454455, Date_Calc::DateToDays(20, 12, 2007), '2007 12 20');
compare('2007 12 21', Date_Calc::DaysToDate(2454456, "%Y %m %d"), '2454456');
compare(2454456, Date_Calc::DateToDays(21, 12, 2007), '2007 12 21');
compare('2007 12 22', Date_Calc::DaysToDate(2454457, "%Y %m %d"), '2454457');
compare(2454457, Date_Calc::DateToDays(22, 12, 2007), '2007 12 22');
compare('2007 12 23', Date_Calc::DaysToDate(2454458, "%Y %m %d"), '2454458');
compare(2454458, Date_Calc::DateToDays(23, 12, 2007), '2007 12 23');
compare('2007 12 24', Date_Calc::DaysToDate(2454459, "%Y %m %d"), '2454459');
compare(2454459, Date_Calc::DateToDays(24, 12, 2007), '2007 12 24');
compare('2007 12 25', Date_Calc::DaysToDate(2454460, "%Y %m %d"), '2454460');
compare(2454460, Date_Calc::DateToDays(25, 12, 2007), '2007 12 25');
compare('2007 12 26', Date_Calc::DaysToDate(2454461, "%Y %m %d"), '2454461');
compare(2454461, Date_Calc::DateToDays(26, 12, 2007), '2007 12 26');
compare('2007 12 27', Date_Calc::DaysToDate(2454462, "%Y %m %d"), '2454462');
compare(2454462, Date_Calc::DateToDays(27, 12, 2007), '2007 12 27');
compare('2007 12 28', Date_Calc::DaysToDate(2454463, "%Y %m %d"), '2454463');
compare(2454463, Date_Calc::DateToDays(28, 12, 2007), '2007 12 28');
compare('2007 12 29', Date_Calc::DaysToDate(2454464, "%Y %m %d"), '2454464');
compare(2454464, Date_Calc::DateToDays(29, 12, 2007), '2007 12 29');
compare('2007 12 30', Date_Calc::DaysToDate(2454465, "%Y %m %d"), '2454465');
compare(2454465, Date_Calc::DateToDays(30, 12, 2007), '2007 12 30');
compare('2007 12 31', Date_Calc::DaysToDate(2454466, "%Y %m %d"), '2454466');
compare(2454466, Date_Calc::DateToDays(31, 12, 2007), '2007 12 31');
compare('2008 01 01', Date_Calc::DaysToDate(2454467, "%Y %m %d"), '2454467');
compare(2454467, Date_Calc::DateToDays(1, 1, 2008), '2008 01 01');
compare('2008 01 02', Date_Calc::DaysToDate(2454468, "%Y %m %d"), '2454468');
compare(2454468, Date_Calc::DateToDays(2, 1, 2008), '2008 01 02');
compare('2008 01 03', Date_Calc::DaysToDate(2454469, "%Y %m %d"), '2454469');
compare(2454469, Date_Calc::DateToDays(3, 1, 2008), '2008 01 03');
compare('2008 01 04', Date_Calc::DaysToDate(2454470, "%Y %m %d"), '2454470');
compare(2454470, Date_Calc::DateToDays(4, 1, 2008), '2008 01 04');
compare('2008 01 05', Date_Calc::DaysToDate(2454471, "%Y %m %d"), '2454471');
compare(2454471, Date_Calc::DateToDays(5, 1, 2008), '2008 01 05');
compare('2008 01 06', Date_Calc::DaysToDate(2454472, "%Y %m %d"), '2454472');
compare(2454472, Date_Calc::DateToDays(6, 1, 2008), '2008 01 06');
compare('2008 01 07', Date_Calc::DaysToDate(2454473, "%Y %m %d"), '2454473');
compare(2454473, Date_Calc::DateToDays(7, 1, 2008), '2008 01 07');
compare('2008 01 08', Date_Calc::DaysToDate(2454474, "%Y %m %d"), '2454474');
compare(2454474, Date_Calc::DateToDays(8, 1, 2008), '2008 01 08');
compare('2008 01 09', Date_Calc::DaysToDate(2454475, "%Y %m %d"), '2454475');
compare(2454475, Date_Calc::DateToDays(9, 1, 2008), '2008 01 09');
compare('2008 01 10', Date_Calc::DaysToDate(2454476, "%Y %m %d"), '2454476');
compare(2454476, Date_Calc::DateToDays(10, 1, 2008), '2008 01 10');
compare('2008 01 11', Date_Calc::DaysToDate(2454477, "%Y %m %d"), '2454477');
compare(2454477, Date_Calc::DateToDays(11, 1, 2008), '2008 01 11');
compare('2008 01 12', Date_Calc::DaysToDate(2454478, "%Y %m %d"), '2454478');
compare(2454478, Date_Calc::DateToDays(12, 1, 2008), '2008 01 12');
compare('2008 01 13', Date_Calc::DaysToDate(2454479, "%Y %m %d"), '2454479');
compare(2454479, Date_Calc::DateToDays(13, 1, 2008), '2008 01 13');
compare('2008 01 14', Date_Calc::DaysToDate(2454480, "%Y %m %d"), '2454480');
compare(2454480, Date_Calc::DateToDays(14, 1, 2008), '2008 01 14');
compare('2008 01 15', Date_Calc::DaysToDate(2454481, "%Y %m %d"), '2454481');
compare(2454481, Date_Calc::DateToDays(15, 1, 2008), '2008 01 15');
compare('2008 01 16', Date_Calc::DaysToDate(2454482, "%Y %m %d"), '2454482');
compare(2454482, Date_Calc::DateToDays(16, 1, 2008), '2008 01 16');
compare('2008 01 17', Date_Calc::DaysToDate(2454483, "%Y %m %d"), '2454483');
compare(2454483, Date_Calc::DateToDays(17, 1, 2008), '2008 01 17');
compare('2008 01 18', Date_Calc::DaysToDate(2454484, "%Y %m %d"), '2454484');
compare(2454484, Date_Calc::DateToDays(18, 1, 2008), '2008 01 18');
compare('2008 01 19', Date_Calc::DaysToDate(2454485, "%Y %m %d"), '2454485');
compare(2454485, Date_Calc::DateToDays(19, 1, 2008), '2008 01 19');
compare('2008 01 20', Date_Calc::DaysToDate(2454486, "%Y %m %d"), '2454486');
compare(2454486, Date_Calc::DateToDays(20, 1, 2008), '2008 01 20');
compare('2008 01 21', Date_Calc::DaysToDate(2454487, "%Y %m %d"), '2454487');
compare(2454487, Date_Calc::DateToDays(21, 1, 2008), '2008 01 21');
compare('2008 01 22', Date_Calc::DaysToDate(2454488, "%Y %m %d"), '2454488');
compare(2454488, Date_Calc::DateToDays(22, 1, 2008), '2008 01 22');
compare('2008 01 23', Date_Calc::DaysToDate(2454489, "%Y %m %d"), '2454489');
compare(2454489, Date_Calc::DateToDays(23, 1, 2008), '2008 01 23');
compare('2008 01 24', Date_Calc::DaysToDate(2454490, "%Y %m %d"), '2454490');
compare(2454490, Date_Calc::DateToDays(24, 1, 2008), '2008 01 24');
compare('2008 01 25', Date_Calc::DaysToDate(2454491, "%Y %m %d"), '2454491');
compare(2454491, Date_Calc::DateToDays(25, 1, 2008), '2008 01 25');
compare('2008 01 26', Date_Calc::DaysToDate(2454492, "%Y %m %d"), '2454492');
compare(2454492, Date_Calc::DateToDays(26, 1, 2008), '2008 01 26');
compare('2008 01 27', Date_Calc::DaysToDate(2454493, "%Y %m %d"), '2454493');
compare(2454493, Date_Calc::DateToDays(27, 1, 2008), '2008 01 27');
compare('2008 01 28', Date_Calc::DaysToDate(2454494, "%Y %m %d"), '2454494');
compare(2454494, Date_Calc::DateToDays(28, 1, 2008), '2008 01 28');
compare('2008 01 29', Date_Calc::DaysToDate(2454495, "%Y %m %d"), '2454495');
compare(2454495, Date_Calc::DateToDays(29, 1, 2008), '2008 01 29');
compare('2008 01 30', Date_Calc::DaysToDate(2454496, "%Y %m %d"), '2454496');
compare(2454496, Date_Calc::DateToDays(30, 1, 2008), '2008 01 30');
compare('2008 01 31', Date_Calc::DaysToDate(2454497, "%Y %m %d"), '2454497');
compare(2454497, Date_Calc::DateToDays(31, 1, 2008), '2008 01 31');
compare('2008 02 01', Date_Calc::DaysToDate(2454498, "%Y %m %d"), '2454498');
compare(2454498, Date_Calc::DateToDays(1, 2, 2008), '2008 02 01');
compare('2008 02 02', Date_Calc::DaysToDate(2454499, "%Y %m %d"), '2454499');
compare(2454499, Date_Calc::DateToDays(2, 2, 2008), '2008 02 02');
compare('2008 02 03', Date_Calc::DaysToDate(2454500, "%Y %m %d"), '2454500');
compare(2454500, Date_Calc::DateToDays(3, 2, 2008), '2008 02 03');
compare('2008 02 04', Date_Calc::DaysToDate(2454501, "%Y %m %d"), '2454501');
compare(2454501, Date_Calc::DateToDays(4, 2, 2008), '2008 02 04');
compare('2008 02 05', Date_Calc::DaysToDate(2454502, "%Y %m %d"), '2454502');
compare(2454502, Date_Calc::DateToDays(5, 2, 2008), '2008 02 05');
compare('2008 02 06', Date_Calc::DaysToDate(2454503, "%Y %m %d"), '2454503');
compare(2454503, Date_Calc::DateToDays(6, 2, 2008), '2008 02 06');
compare('2008 02 07', Date_Calc::DaysToDate(2454504, "%Y %m %d"), '2454504');
compare(2454504, Date_Calc::DateToDays(7, 2, 2008), '2008 02 07');
compare('2008 02 08', Date_Calc::DaysToDate(2454505, "%Y %m %d"), '2454505');
compare(2454505, Date_Calc::DateToDays(8, 2, 2008), '2008 02 08');
compare('2008 02 09', Date_Calc::DaysToDate(2454506, "%Y %m %d"), '2454506');
compare(2454506, Date_Calc::DateToDays(9, 2, 2008), '2008 02 09');
compare('2008 02 10', Date_Calc::DaysToDate(2454507, "%Y %m %d"), '2454507');
compare(2454507, Date_Calc::DateToDays(10, 2, 2008), '2008 02 10');
compare('2008 02 11', Date_Calc::DaysToDate(2454508, "%Y %m %d"), '2454508');
compare(2454508, Date_Calc::DateToDays(11, 2, 2008), '2008 02 11');
compare('2008 02 12', Date_Calc::DaysToDate(2454509, "%Y %m %d"), '2454509');
compare(2454509, Date_Calc::DateToDays(12, 2, 2008), '2008 02 12');
compare('2008 02 13', Date_Calc::DaysToDate(2454510, "%Y %m %d"), '2454510');
compare(2454510, Date_Calc::DateToDays(13, 2, 2008), '2008 02 13');
compare('2008 02 14', Date_Calc::DaysToDate(2454511, "%Y %m %d"), '2454511');
compare(2454511, Date_Calc::DateToDays(14, 2, 2008), '2008 02 14');
compare('2008 02 15', Date_Calc::DaysToDate(2454512, "%Y %m %d"), '2454512');
compare(2454512, Date_Calc::DateToDays(15, 2, 2008), '2008 02 15');
compare('2008 02 16', Date_Calc::DaysToDate(2454513, "%Y %m %d"), '2454513');
compare(2454513, Date_Calc::DateToDays(16, 2, 2008), '2008 02 16');
compare('2008 02 17', Date_Calc::DaysToDate(2454514, "%Y %m %d"), '2454514');
compare(2454514, Date_Calc::DateToDays(17, 2, 2008), '2008 02 17');
compare('2008 02 18', Date_Calc::DaysToDate(2454515, "%Y %m %d"), '2454515');
compare(2454515, Date_Calc::DateToDays(18, 2, 2008), '2008 02 18');
compare('2008 02 19', Date_Calc::DaysToDate(2454516, "%Y %m %d"), '2454516');
compare(2454516, Date_Calc::DateToDays(19, 2, 2008), '2008 02 19');
compare('2008 02 20', Date_Calc::DaysToDate(2454517, "%Y %m %d"), '2454517');
compare(2454517, Date_Calc::DateToDays(20, 2, 2008), '2008 02 20');
compare('2008 02 21', Date_Calc::DaysToDate(2454518, "%Y %m %d"), '2454518');
compare(2454518, Date_Calc::DateToDays(21, 2, 2008), '2008 02 21');
compare('2008 02 22', Date_Calc::DaysToDate(2454519, "%Y %m %d"), '2454519');
compare(2454519, Date_Calc::DateToDays(22, 2, 2008), '2008 02 22');
compare('2008 02 23', Date_Calc::DaysToDate(2454520, "%Y %m %d"), '2454520');
compare(2454520, Date_Calc::DateToDays(23, 2, 2008), '2008 02 23');
compare('2008 02 24', Date_Calc::DaysToDate(2454521, "%Y %m %d"), '2454521');
compare(2454521, Date_Calc::DateToDays(24, 2, 2008), '2008 02 24');
compare('2008 02 25', Date_Calc::DaysToDate(2454522, "%Y %m %d"), '2454522');
compare(2454522, Date_Calc::DateToDays(25, 2, 2008), '2008 02 25');
compare('2008 02 26', Date_Calc::DaysToDate(2454523, "%Y %m %d"), '2454523');
compare(2454523, Date_Calc::DateToDays(26, 2, 2008), '2008 02 26');
compare('2008 02 27', Date_Calc::DaysToDate(2454524, "%Y %m %d"), '2454524');
compare(2454524, Date_Calc::DateToDays(27, 2, 2008), '2008 02 27');
compare('2008 02 28', Date_Calc::DaysToDate(2454525, "%Y %m %d"), '2454525');
compare(2454525, Date_Calc::DateToDays(28, 2, 2008), '2008 02 28');
compare('2008 02 29', Date_Calc::DaysToDate(2454526, "%Y %m %d"), '2454526');
compare(2454526, Date_Calc::DateToDays(29, 2, 2008), '2008 02 29');
compare('2008 03 01', Date_Calc::DaysToDate(2454527, "%Y %m %d"), '2454527');
compare(2454527, Date_Calc::DateToDays(1, 3, 2008), '2008 03 01');
compare('2008 03 02', Date_Calc::DaysToDate(2454528, "%Y %m %d"), '2454528');
compare(2454528, Date_Calc::DateToDays(2, 3, 2008), '2008 03 02');
compare('2008 03 03', Date_Calc::DaysToDate(2454529, "%Y %m %d"), '2454529');
compare(2454529, Date_Calc::DateToDays(3, 3, 2008), '2008 03 03');
compare('2008 03 04', Date_Calc::DaysToDate(2454530, "%Y %m %d"), '2454530');
compare(2454530, Date_Calc::DateToDays(4, 3, 2008), '2008 03 04');
compare('2008 03 05', Date_Calc::DaysToDate(2454531, "%Y %m %d"), '2454531');
compare(2454531, Date_Calc::DateToDays(5, 3, 2008), '2008 03 05');
compare('2008 03 06', Date_Calc::DaysToDate(2454532, "%Y %m %d"), '2454532');
compare(2454532, Date_Calc::DateToDays(6, 3, 2008), '2008 03 06');
compare('2008 03 07', Date_Calc::DaysToDate(2454533, "%Y %m %d"), '2454533');
compare(2454533, Date_Calc::DateToDays(7, 3, 2008), '2008 03 07');
compare('2008 03 08', Date_Calc::DaysToDate(2454534, "%Y %m %d"), '2454534');
compare(2454534, Date_Calc::DateToDays(8, 3, 2008), '2008 03 08');
compare('2008 03 09', Date_Calc::DaysToDate(2454535, "%Y %m %d"), '2454535');
compare(2454535, Date_Calc::DateToDays(9, 3, 2008), '2008 03 09');
compare('2008 03 10', Date_Calc::DaysToDate(2454536, "%Y %m %d"), '2454536');
compare(2454536, Date_Calc::DateToDays(10, 3, 2008), '2008 03 10');
compare('2008 03 11', Date_Calc::DaysToDate(2454537, "%Y %m %d"), '2454537');
compare(2454537, Date_Calc::DateToDays(11, 3, 2008), '2008 03 11');
compare('2008 03 12', Date_Calc::DaysToDate(2454538, "%Y %m %d"), '2454538');
compare(2454538, Date_Calc::DateToDays(12, 3, 2008), '2008 03 12');
compare('2008 03 13', Date_Calc::DaysToDate(2454539, "%Y %m %d"), '2454539');
compare(2454539, Date_Calc::DateToDays(13, 3, 2008), '2008 03 13');
compare('2008 03 14', Date_Calc::DaysToDate(2454540, "%Y %m %d"), '2454540');
compare(2454540, Date_Calc::DateToDays(14, 3, 2008), '2008 03 14');
compare('2008 03 15', Date_Calc::DaysToDate(2454541, "%Y %m %d"), '2454541');
compare(2454541, Date_Calc::DateToDays(15, 3, 2008), '2008 03 15');
compare('2008 03 16', Date_Calc::DaysToDate(2454542, "%Y %m %d"), '2454542');
compare(2454542, Date_Calc::DateToDays(16, 3, 2008), '2008 03 16');
compare('2008 03 17', Date_Calc::DaysToDate(2454543, "%Y %m %d"), '2454543');
compare(2454543, Date_Calc::DateToDays(17, 3, 2008), '2008 03 17');
compare('2008 03 18', Date_Calc::DaysToDate(2454544, "%Y %m %d"), '2454544');
compare(2454544, Date_Calc::DateToDays(18, 3, 2008), '2008 03 18');
compare('2008 03 19', Date_Calc::DaysToDate(2454545, "%Y %m %d"), '2454545');
compare(2454545, Date_Calc::DateToDays(19, 3, 2008), '2008 03 19');
compare('2008 03 20', Date_Calc::DaysToDate(2454546, "%Y %m %d"), '2454546');
compare(2454546, Date_Calc::DateToDays(20, 3, 2008), '2008 03 20');
compare('2008 03 21', Date_Calc::DaysToDate(2454547, "%Y %m %d"), '2454547');
compare(2454547, Date_Calc::DateToDays(21, 3, 2008), '2008 03 21');
compare('2008 03 22', Date_Calc::DaysToDate(2454548, "%Y %m %d"), '2454548');
compare(2454548, Date_Calc::DateToDays(22, 3, 2008), '2008 03 22');
compare('2008 03 23', Date_Calc::DaysToDate(2454549, "%Y %m %d"), '2454549');
compare(2454549, Date_Calc::DateToDays(23, 3, 2008), '2008 03 23');
compare('2008 03 24', Date_Calc::DaysToDate(2454550, "%Y %m %d"), '2454550');
compare(2454550, Date_Calc::DateToDays(24, 3, 2008), '2008 03 24');
compare('2008 03 25', Date_Calc::DaysToDate(2454551, "%Y %m %d"), '2454551');
compare(2454551, Date_Calc::DateToDays(25, 3, 2008), '2008 03 25');
compare('2008 03 26', Date_Calc::DaysToDate(2454552, "%Y %m %d"), '2454552');
compare(2454552, Date_Calc::DateToDays(26, 3, 2008), '2008 03 26');
compare('2008 03 27', Date_Calc::DaysToDate(2454553, "%Y %m %d"), '2454553');
compare(2454553, Date_Calc::DateToDays(27, 3, 2008), '2008 03 27');
compare('2008 03 28', Date_Calc::DaysToDate(2454554, "%Y %m %d"), '2454554');
compare(2454554, Date_Calc::DateToDays(28, 3, 2008), '2008 03 28');
compare('2008 03 29', Date_Calc::DaysToDate(2454555, "%Y %m %d"), '2454555');
compare(2454555, Date_Calc::DateToDays(29, 3, 2008), '2008 03 29');
compare('2008 03 30', Date_Calc::DaysToDate(2454556, "%Y %m %d"), '2454556');
compare(2454556, Date_Calc::DateToDays(30, 3, 2008), '2008 03 30');
compare('2008 03 31', Date_Calc::DaysToDate(2454557, "%Y %m %d"), '2454557');
compare(2454557, Date_Calc::DateToDays(31, 3, 2008), '2008 03 31');
compare('2008 04 01', Date_Calc::DaysToDate(2454558, "%Y %m %d"), '2454558');
compare(2454558, Date_Calc::DateToDays(1, 4, 2008), '2008 04 01');
compare('2008 04 02', Date_Calc::DaysToDate(2454559, "%Y %m %d"), '2454559');
compare(2454559, Date_Calc::DateToDays(2, 4, 2008), '2008 04 02');
compare('2008 04 03', Date_Calc::DaysToDate(2454560, "%Y %m %d"), '2454560');
compare(2454560, Date_Calc::DateToDays(3, 4, 2008), '2008 04 03');
compare('2008 04 04', Date_Calc::DaysToDate(2454561, "%Y %m %d"), '2454561');
compare(2454561, Date_Calc::DateToDays(4, 4, 2008), '2008 04 04');
compare('2008 04 05', Date_Calc::DaysToDate(2454562, "%Y %m %d"), '2454562');
compare(2454562, Date_Calc::DateToDays(5, 4, 2008), '2008 04 05');
compare('2008 04 06', Date_Calc::DaysToDate(2454563, "%Y %m %d"), '2454563');
compare(2454563, Date_Calc::DateToDays(6, 4, 2008), '2008 04 06');
compare('2008 04 07', Date_Calc::DaysToDate(2454564, "%Y %m %d"), '2454564');
compare(2454564, Date_Calc::DateToDays(7, 4, 2008), '2008 04 07');
compare('2008 04 08', Date_Calc::DaysToDate(2454565, "%Y %m %d"), '2454565');
compare(2454565, Date_Calc::DateToDays(8, 4, 2008), '2008 04 08');
compare('2008 04 09', Date_Calc::DaysToDate(2454566, "%Y %m %d"), '2454566');
compare(2454566, Date_Calc::DateToDays(9, 4, 2008), '2008 04 09');
compare('2008 04 10', Date_Calc::DaysToDate(2454567, "%Y %m %d"), '2454567');
compare(2454567, Date_Calc::DateToDays(10, 4, 2008), '2008 04 10');
compare('2008 04 11', Date_Calc::DaysToDate(2454568, "%Y %m %d"), '2454568');
compare(2454568, Date_Calc::DateToDays(11, 4, 2008), '2008 04 11');
compare('2008 04 12', Date_Calc::DaysToDate(2454569, "%Y %m %d"), '2454569');
compare(2454569, Date_Calc::DateToDays(12, 4, 2008), '2008 04 12');
compare('2008 04 13', Date_Calc::DaysToDate(2454570, "%Y %m %d"), '2454570');
compare(2454570, Date_Calc::DateToDays(13, 4, 2008), '2008 04 13');
compare('2008 04 14', Date_Calc::DaysToDate(2454571, "%Y %m %d"), '2454571');
compare(2454571, Date_Calc::DateToDays(14, 4, 2008), '2008 04 14');
compare('2008 04 15', Date_Calc::DaysToDate(2454572, "%Y %m %d"), '2454572');
compare(2454572, Date_Calc::DateToDays(15, 4, 2008), '2008 04 15');
compare('2008 04 16', Date_Calc::DaysToDate(2454573, "%Y %m %d"), '2454573');
compare(2454573, Date_Calc::DateToDays(16, 4, 2008), '2008 04 16');
compare('2008 04 17', Date_Calc::DaysToDate(2454574, "%Y %m %d"), '2454574');
compare(2454574, Date_Calc::DateToDays(17, 4, 2008), '2008 04 17');
compare('2008 04 18', Date_Calc::DaysToDate(2454575, "%Y %m %d"), '2454575');
compare(2454575, Date_Calc::DateToDays(18, 4, 2008), '2008 04 18');
compare('2008 04 19', Date_Calc::DaysToDate(2454576, "%Y %m %d"), '2454576');
compare(2454576, Date_Calc::DateToDays(19, 4, 2008), '2008 04 19');
compare('2008 04 20', Date_Calc::DaysToDate(2454577, "%Y %m %d"), '2454577');
compare(2454577, Date_Calc::DateToDays(20, 4, 2008), '2008 04 20');
compare('2008 04 21', Date_Calc::DaysToDate(2454578, "%Y %m %d"), '2454578');
compare(2454578, Date_Calc::DateToDays(21, 4, 2008), '2008 04 21');
compare('2008 04 22', Date_Calc::DaysToDate(2454579, "%Y %m %d"), '2454579');
compare(2454579, Date_Calc::DateToDays(22, 4, 2008), '2008 04 22');
compare('2008 04 23', Date_Calc::DaysToDate(2454580, "%Y %m %d"), '2454580');
compare(2454580, Date_Calc::DateToDays(23, 4, 2008), '2008 04 23');
compare('2008 04 24', Date_Calc::DaysToDate(2454581, "%Y %m %d"), '2454581');
compare(2454581, Date_Calc::DateToDays(24, 4, 2008), '2008 04 24');
compare('2008 04 25', Date_Calc::DaysToDate(2454582, "%Y %m %d"), '2454582');
compare(2454582, Date_Calc::DateToDays(25, 4, 2008), '2008 04 25');
compare('2008 04 26', Date_Calc::DaysToDate(2454583, "%Y %m %d"), '2454583');
compare(2454583, Date_Calc::DateToDays(26, 4, 2008), '2008 04 26');
compare('2008 04 27', Date_Calc::DaysToDate(2454584, "%Y %m %d"), '2454584');
compare(2454584, Date_Calc::DateToDays(27, 4, 2008), '2008 04 27');
compare('2008 04 28', Date_Calc::DaysToDate(2454585, "%Y %m %d"), '2454585');
compare(2454585, Date_Calc::DateToDays(28, 4, 2008), '2008 04 28');
compare('2008 04 29', Date_Calc::DaysToDate(2454586, "%Y %m %d"), '2454586');
compare(2454586, Date_Calc::DateToDays(29, 4, 2008), '2008 04 29');
compare('2008 04 30', Date_Calc::DaysToDate(2454587, "%Y %m %d"), '2454587');
compare(2454587, Date_Calc::DateToDays(30, 4, 2008), '2008 04 30');
compare('2008 05 01', Date_Calc::DaysToDate(2454588, "%Y %m %d"), '2454588');
compare(2454588, Date_Calc::DateToDays(1, 5, 2008), '2008 05 01');
compare('2008 05 02', Date_Calc::DaysToDate(2454589, "%Y %m %d"), '2454589');
compare(2454589, Date_Calc::DateToDays(2, 5, 2008), '2008 05 02');
compare('2008 05 03', Date_Calc::DaysToDate(2454590, "%Y %m %d"), '2454590');
compare(2454590, Date_Calc::DateToDays(3, 5, 2008), '2008 05 03');
compare('2008 05 04', Date_Calc::DaysToDate(2454591, "%Y %m %d"), '2454591');
compare(2454591, Date_Calc::DateToDays(4, 5, 2008), '2008 05 04');
compare('2008 05 05', Date_Calc::DaysToDate(2454592, "%Y %m %d"), '2454592');
compare(2454592, Date_Calc::DateToDays(5, 5, 2008), '2008 05 05');
compare('2008 05 06', Date_Calc::DaysToDate(2454593, "%Y %m %d"), '2454593');
compare(2454593, Date_Calc::DateToDays(6, 5, 2008), '2008 05 06');
compare('2008 05 07', Date_Calc::DaysToDate(2454594, "%Y %m %d"), '2454594');
compare(2454594, Date_Calc::DateToDays(7, 5, 2008), '2008 05 07');
compare('2008 05 08', Date_Calc::DaysToDate(2454595, "%Y %m %d"), '2454595');
compare(2454595, Date_Calc::DateToDays(8, 5, 2008), '2008 05 08');
compare('2008 05 09', Date_Calc::DaysToDate(2454596, "%Y %m %d"), '2454596');
compare(2454596, Date_Calc::DateToDays(9, 5, 2008), '2008 05 09');
compare('2008 05 10', Date_Calc::DaysToDate(2454597, "%Y %m %d"), '2454597');
compare(2454597, Date_Calc::DateToDays(10, 5, 2008), '2008 05 10');
compare('2008 05 11', Date_Calc::DaysToDate(2454598, "%Y %m %d"), '2454598');
compare(2454598, Date_Calc::DateToDays(11, 5, 2008), '2008 05 11');
compare('2008 05 12', Date_Calc::DaysToDate(2454599, "%Y %m %d"), '2454599');
compare(2454599, Date_Calc::DateToDays(12, 5, 2008), '2008 05 12');
compare('2008 05 13', Date_Calc::DaysToDate(2454600, "%Y %m %d"), '2454600');
compare(2454600, Date_Calc::DateToDays(13, 5, 2008), '2008 05 13');
compare('2008 05 14', Date_Calc::DaysToDate(2454601, "%Y %m %d"), '2454601');
compare(2454601, Date_Calc::DateToDays(14, 5, 2008), '2008 05 14');
compare('2008 05 15', Date_Calc::DaysToDate(2454602, "%Y %m %d"), '2454602');
compare(2454602, Date_Calc::DateToDays(15, 5, 2008), '2008 05 15');
compare('2008 05 16', Date_Calc::DaysToDate(2454603, "%Y %m %d"), '2454603');
compare(2454603, Date_Calc::DateToDays(16, 5, 2008), '2008 05 16');
compare('2008 05 17', Date_Calc::DaysToDate(2454604, "%Y %m %d"), '2454604');
compare(2454604, Date_Calc::DateToDays(17, 5, 2008), '2008 05 17');
compare('2008 05 18', Date_Calc::DaysToDate(2454605, "%Y %m %d"), '2454605');
compare(2454605, Date_Calc::DateToDays(18, 5, 2008), '2008 05 18');
compare('2008 05 19', Date_Calc::DaysToDate(2454606, "%Y %m %d"), '2454606');
compare(2454606, Date_Calc::DateToDays(19, 5, 2008), '2008 05 19');
compare('2008 05 20', Date_Calc::DaysToDate(2454607, "%Y %m %d"), '2454607');
compare(2454607, Date_Calc::DateToDays(20, 5, 2008), '2008 05 20');
compare('2008 05 21', Date_Calc::DaysToDate(2454608, "%Y %m %d"), '2454608');
compare(2454608, Date_Calc::DateToDays(21, 5, 2008), '2008 05 21');
compare('2008 05 22', Date_Calc::DaysToDate(2454609, "%Y %m %d"), '2454609');
compare(2454609, Date_Calc::DateToDays(22, 5, 2008), '2008 05 22');
compare('2008 05 23', Date_Calc::DaysToDate(2454610, "%Y %m %d"), '2454610');
compare(2454610, Date_Calc::DateToDays(23, 5, 2008), '2008 05 23');
compare('2008 05 24', Date_Calc::DaysToDate(2454611, "%Y %m %d"), '2454611');
compare(2454611, Date_Calc::DateToDays(24, 5, 2008), '2008 05 24');
compare('2008 05 25', Date_Calc::DaysToDate(2454612, "%Y %m %d"), '2454612');
compare(2454612, Date_Calc::DateToDays(25, 5, 2008), '2008 05 25');
compare('2008 05 26', Date_Calc::DaysToDate(2454613, "%Y %m %d"), '2454613');
compare(2454613, Date_Calc::DateToDays(26, 5, 2008), '2008 05 26');
compare('2008 05 27', Date_Calc::DaysToDate(2454614, "%Y %m %d"), '2454614');
compare(2454614, Date_Calc::DateToDays(27, 5, 2008), '2008 05 27');
compare('2008 05 28', Date_Calc::DaysToDate(2454615, "%Y %m %d"), '2454615');
compare(2454615, Date_Calc::DateToDays(28, 5, 2008), '2008 05 28');
compare('2008 05 29', Date_Calc::DaysToDate(2454616, "%Y %m %d"), '2454616');
compare(2454616, Date_Calc::DateToDays(29, 5, 2008), '2008 05 29');
compare('2008 05 30', Date_Calc::DaysToDate(2454617, "%Y %m %d"), '2454617');
compare(2454617, Date_Calc::DateToDays(30, 5, 2008), '2008 05 30');
compare('2008 05 31', Date_Calc::DaysToDate(2454618, "%Y %m %d"), '2454618');
compare(2454618, Date_Calc::DateToDays(31, 5, 2008), '2008 05 31');
compare('2008 06 01', Date_Calc::DaysToDate(2454619, "%Y %m %d"), '2454619');
compare(2454619, Date_Calc::DateToDays(1, 6, 2008), '2008 06 01');
compare('2008 06 02', Date_Calc::DaysToDate(2454620, "%Y %m %d"), '2454620');
compare(2454620, Date_Calc::DateToDays(2, 6, 2008), '2008 06 02');
compare('2008 06 03', Date_Calc::DaysToDate(2454621, "%Y %m %d"), '2454621');
compare(2454621, Date_Calc::DateToDays(3, 6, 2008), '2008 06 03');
compare('2008 06 04', Date_Calc::DaysToDate(2454622, "%Y %m %d"), '2454622');
compare(2454622, Date_Calc::DateToDays(4, 6, 2008), '2008 06 04');
compare('2008 06 05', Date_Calc::DaysToDate(2454623, "%Y %m %d"), '2454623');
compare(2454623, Date_Calc::DateToDays(5, 6, 2008), '2008 06 05');
compare('2008 06 06', Date_Calc::DaysToDate(2454624, "%Y %m %d"), '2454624');
compare(2454624, Date_Calc::DateToDays(6, 6, 2008), '2008 06 06');
compare('2008 06 07', Date_Calc::DaysToDate(2454625, "%Y %m %d"), '2454625');
compare(2454625, Date_Calc::DateToDays(7, 6, 2008), '2008 06 07');
compare('2008 06 08', Date_Calc::DaysToDate(2454626, "%Y %m %d"), '2454626');
compare(2454626, Date_Calc::DateToDays(8, 6, 2008), '2008 06 08');
compare('2008 06 09', Date_Calc::DaysToDate(2454627, "%Y %m %d"), '2454627');
compare(2454627, Date_Calc::DateToDays(9, 6, 2008), '2008 06 09');
compare('2008 06 10', Date_Calc::DaysToDate(2454628, "%Y %m %d"), '2454628');
compare(2454628, Date_Calc::DateToDays(10, 6, 2008), '2008 06 10');
compare('2008 06 11', Date_Calc::DaysToDate(2454629, "%Y %m %d"), '2454629');
compare(2454629, Date_Calc::DateToDays(11, 6, 2008), '2008 06 11');
compare('2008 06 12', Date_Calc::DaysToDate(2454630, "%Y %m %d"), '2454630');
compare(2454630, Date_Calc::DateToDays(12, 6, 2008), '2008 06 12');
compare('2008 06 13', Date_Calc::DaysToDate(2454631, "%Y %m %d"), '2454631');
compare(2454631, Date_Calc::DateToDays(13, 6, 2008), '2008 06 13');
compare('2008 06 14', Date_Calc::DaysToDate(2454632, "%Y %m %d"), '2454632');
compare(2454632, Date_Calc::DateToDays(14, 6, 2008), '2008 06 14');
compare('2008 06 15', Date_Calc::DaysToDate(2454633, "%Y %m %d"), '2454633');
compare(2454633, Date_Calc::DateToDays(15, 6, 2008), '2008 06 15');
compare('2008 06 16', Date_Calc::DaysToDate(2454634, "%Y %m %d"), '2454634');
compare(2454634, Date_Calc::DateToDays(16, 6, 2008), '2008 06 16');
compare('2008 06 17', Date_Calc::DaysToDate(2454635, "%Y %m %d"), '2454635');
compare(2454635, Date_Calc::DateToDays(17, 6, 2008), '2008 06 17');
compare('2008 06 18', Date_Calc::DaysToDate(2454636, "%Y %m %d"), '2454636');
compare(2454636, Date_Calc::DateToDays(18, 6, 2008), '2008 06 18');
compare('2008 06 19', Date_Calc::DaysToDate(2454637, "%Y %m %d"), '2454637');
compare(2454637, Date_Calc::DateToDays(19, 6, 2008), '2008 06 19');
compare('2008 06 20', Date_Calc::DaysToDate(2454638, "%Y %m %d"), '2454638');
compare(2454638, Date_Calc::DateToDays(20, 6, 2008), '2008 06 20');
compare('2008 06 21', Date_Calc::DaysToDate(2454639, "%Y %m %d"), '2454639');
compare(2454639, Date_Calc::DateToDays(21, 6, 2008), '2008 06 21');
compare('2008 06 22', Date_Calc::DaysToDate(2454640, "%Y %m %d"), '2454640');
compare(2454640, Date_Calc::DateToDays(22, 6, 2008), '2008 06 22');
compare('2008 06 23', Date_Calc::DaysToDate(2454641, "%Y %m %d"), '2454641');
compare(2454641, Date_Calc::DateToDays(23, 6, 2008), '2008 06 23');
compare('2008 06 24', Date_Calc::DaysToDate(2454642, "%Y %m %d"), '2454642');
compare(2454642, Date_Calc::DateToDays(24, 6, 2008), '2008 06 24');
compare('2008 06 25', Date_Calc::DaysToDate(2454643, "%Y %m %d"), '2454643');
compare(2454643, Date_Calc::DateToDays(25, 6, 2008), '2008 06 25');
compare('2008 06 26', Date_Calc::DaysToDate(2454644, "%Y %m %d"), '2454644');
compare(2454644, Date_Calc::DateToDays(26, 6, 2008), '2008 06 26');
compare('2008 06 27', Date_Calc::DaysToDate(2454645, "%Y %m %d"), '2454645');
compare(2454645, Date_Calc::DateToDays(27, 6, 2008), '2008 06 27');
compare('2008 06 28', Date_Calc::DaysToDate(2454646, "%Y %m %d"), '2454646');
compare(2454646, Date_Calc::DateToDays(28, 6, 2008), '2008 06 28');
compare('2008 06 29', Date_Calc::DaysToDate(2454647, "%Y %m %d"), '2454647');
compare(2454647, Date_Calc::DateToDays(29, 6, 2008), '2008 06 29');
compare('2008 06 30', Date_Calc::DaysToDate(2454648, "%Y %m %d"), '2454648');
compare(2454648, Date_Calc::DateToDays(30, 6, 2008), '2008 06 30');
compare('2008 07 01', Date_Calc::DaysToDate(2454649, "%Y %m %d"), '2454649');
compare(2454649, Date_Calc::DateToDays(1, 7, 2008), '2008 07 01');
compare('2008 07 02', Date_Calc::DaysToDate(2454650, "%Y %m %d"), '2454650');
compare(2454650, Date_Calc::DateToDays(2, 7, 2008), '2008 07 02');
compare('2008 07 03', Date_Calc::DaysToDate(2454651, "%Y %m %d"), '2454651');
compare(2454651, Date_Calc::DateToDays(3, 7, 2008), '2008 07 03');
compare('2008 07 04', Date_Calc::DaysToDate(2454652, "%Y %m %d"), '2454652');
compare(2454652, Date_Calc::DateToDays(4, 7, 2008), '2008 07 04');
compare('2008 07 05', Date_Calc::DaysToDate(2454653, "%Y %m %d"), '2454653');
compare(2454653, Date_Calc::DateToDays(5, 7, 2008), '2008 07 05');
compare('2008 07 06', Date_Calc::DaysToDate(2454654, "%Y %m %d"), '2454654');
compare(2454654, Date_Calc::DateToDays(6, 7, 2008), '2008 07 06');
compare('2008 07 07', Date_Calc::DaysToDate(2454655, "%Y %m %d"), '2454655');
compare(2454655, Date_Calc::DateToDays(7, 7, 2008), '2008 07 07');
compare('2008 07 08', Date_Calc::DaysToDate(2454656, "%Y %m %d"), '2454656');
compare(2454656, Date_Calc::DateToDays(8, 7, 2008), '2008 07 08');
compare('2008 07 09', Date_Calc::DaysToDate(2454657, "%Y %m %d"), '2454657');
compare(2454657, Date_Calc::DateToDays(9, 7, 2008), '2008 07 09');
compare('2008 07 10', Date_Calc::DaysToDate(2454658, "%Y %m %d"), '2454658');
compare(2454658, Date_Calc::DateToDays(10, 7, 2008), '2008 07 10');
compare('2008 07 11', Date_Calc::DaysToDate(2454659, "%Y %m %d"), '2454659');
compare(2454659, Date_Calc::DateToDays(11, 7, 2008), '2008 07 11');
compare('2008 07 12', Date_Calc::DaysToDate(2454660, "%Y %m %d"), '2454660');
compare(2454660, Date_Calc::DateToDays(12, 7, 2008), '2008 07 12');
compare('2008 07 13', Date_Calc::DaysToDate(2454661, "%Y %m %d"), '2454661');
compare(2454661, Date_Calc::DateToDays(13, 7, 2008), '2008 07 13');
compare('2008 07 14', Date_Calc::DaysToDate(2454662, "%Y %m %d"), '2454662');
compare(2454662, Date_Calc::DateToDays(14, 7, 2008), '2008 07 14');
compare('2008 07 15', Date_Calc::DaysToDate(2454663, "%Y %m %d"), '2454663');
compare(2454663, Date_Calc::DateToDays(15, 7, 2008), '2008 07 15');
compare('2008 07 16', Date_Calc::DaysToDate(2454664, "%Y %m %d"), '2454664');
compare(2454664, Date_Calc::DateToDays(16, 7, 2008), '2008 07 16');
compare('2008 07 17', Date_Calc::DaysToDate(2454665, "%Y %m %d"), '2454665');
compare(2454665, Date_Calc::DateToDays(17, 7, 2008), '2008 07 17');
compare('2008 07 18', Date_Calc::DaysToDate(2454666, "%Y %m %d"), '2454666');
compare(2454666, Date_Calc::DateToDays(18, 7, 2008), '2008 07 18');
compare('2008 07 19', Date_Calc::DaysToDate(2454667, "%Y %m %d"), '2454667');
compare(2454667, Date_Calc::DateToDays(19, 7, 2008), '2008 07 19');
compare('2008 07 20', Date_Calc::DaysToDate(2454668, "%Y %m %d"), '2454668');
compare(2454668, Date_Calc::DateToDays(20, 7, 2008), '2008 07 20');
compare('2008 07 21', Date_Calc::DaysToDate(2454669, "%Y %m %d"), '2454669');
compare(2454669, Date_Calc::DateToDays(21, 7, 2008), '2008 07 21');
compare('2008 07 22', Date_Calc::DaysToDate(2454670, "%Y %m %d"), '2454670');
compare(2454670, Date_Calc::DateToDays(22, 7, 2008), '2008 07 22');
compare('2008 07 23', Date_Calc::DaysToDate(2454671, "%Y %m %d"), '2454671');
compare(2454671, Date_Calc::DateToDays(23, 7, 2008), '2008 07 23');
compare('2008 07 24', Date_Calc::DaysToDate(2454672, "%Y %m %d"), '2454672');
compare(2454672, Date_Calc::DateToDays(24, 7, 2008), '2008 07 24');
compare('2008 07 25', Date_Calc::DaysToDate(2454673, "%Y %m %d"), '2454673');
compare(2454673, Date_Calc::DateToDays(25, 7, 2008), '2008 07 25');
compare('2008 07 26', Date_Calc::DaysToDate(2454674, "%Y %m %d"), '2454674');
compare(2454674, Date_Calc::DateToDays(26, 7, 2008), '2008 07 26');
compare('2008 07 27', Date_Calc::DaysToDate(2454675, "%Y %m %d"), '2454675');
compare(2454675, Date_Calc::DateToDays(27, 7, 2008), '2008 07 27');
compare('2008 07 28', Date_Calc::DaysToDate(2454676, "%Y %m %d"), '2454676');
compare(2454676, Date_Calc::DateToDays(28, 7, 2008), '2008 07 28');
compare('2008 07 29', Date_Calc::DaysToDate(2454677, "%Y %m %d"), '2454677');
compare(2454677, Date_Calc::DateToDays(29, 7, 2008), '2008 07 29');
compare('2008 07 30', Date_Calc::DaysToDate(2454678, "%Y %m %d"), '2454678');
compare(2454678, Date_Calc::DateToDays(30, 7, 2008), '2008 07 30');
compare('2008 07 31', Date_Calc::DaysToDate(2454679, "%Y %m %d"), '2454679');
compare(2454679, Date_Calc::DateToDays(31, 7, 2008), '2008 07 31');
compare('2008 08 01', Date_Calc::DaysToDate(2454680, "%Y %m %d"), '2454680');
compare(2454680, Date_Calc::DateToDays(1, 8, 2008), '2008 08 01');
compare('2008 08 02', Date_Calc::DaysToDate(2454681, "%Y %m %d"), '2454681');
compare(2454681, Date_Calc::DateToDays(2, 8, 2008), '2008 08 02');
compare('2008 08 03', Date_Calc::DaysToDate(2454682, "%Y %m %d"), '2454682');
compare(2454682, Date_Calc::DateToDays(3, 8, 2008), '2008 08 03');
compare('2008 08 04', Date_Calc::DaysToDate(2454683, "%Y %m %d"), '2454683');
compare(2454683, Date_Calc::DateToDays(4, 8, 2008), '2008 08 04');
compare('2008 08 05', Date_Calc::DaysToDate(2454684, "%Y %m %d"), '2454684');
compare(2454684, Date_Calc::DateToDays(5, 8, 2008), '2008 08 05');
compare('2008 08 06', Date_Calc::DaysToDate(2454685, "%Y %m %d"), '2454685');
compare(2454685, Date_Calc::DateToDays(6, 8, 2008), '2008 08 06');
compare('2008 08 07', Date_Calc::DaysToDate(2454686, "%Y %m %d"), '2454686');
compare(2454686, Date_Calc::DateToDays(7, 8, 2008), '2008 08 07');
compare('2008 08 08', Date_Calc::DaysToDate(2454687, "%Y %m %d"), '2454687');
compare(2454687, Date_Calc::DateToDays(8, 8, 2008), '2008 08 08');
compare('2008 08 09', Date_Calc::DaysToDate(2454688, "%Y %m %d"), '2454688');
compare(2454688, Date_Calc::DateToDays(9, 8, 2008), '2008 08 09');
compare('2008 08 10', Date_Calc::DaysToDate(2454689, "%Y %m %d"), '2454689');
compare(2454689, Date_Calc::DateToDays(10, 8, 2008), '2008 08 10');
compare('2008 08 11', Date_Calc::DaysToDate(2454690, "%Y %m %d"), '2454690');
compare(2454690, Date_Calc::DateToDays(11, 8, 2008), '2008 08 11');
compare('2008 08 12', Date_Calc::DaysToDate(2454691, "%Y %m %d"), '2454691');
compare(2454691, Date_Calc::DateToDays(12, 8, 2008), '2008 08 12');
compare('2008 08 13', Date_Calc::DaysToDate(2454692, "%Y %m %d"), '2454692');
compare(2454692, Date_Calc::DateToDays(13, 8, 2008), '2008 08 13');
compare('2008 08 14', Date_Calc::DaysToDate(2454693, "%Y %m %d"), '2454693');
compare(2454693, Date_Calc::DateToDays(14, 8, 2008), '2008 08 14');
compare('2008 08 15', Date_Calc::DaysToDate(2454694, "%Y %m %d"), '2454694');
compare(2454694, Date_Calc::DateToDays(15, 8, 2008), '2008 08 15');
compare('2008 08 16', Date_Calc::DaysToDate(2454695, "%Y %m %d"), '2454695');
compare(2454695, Date_Calc::DateToDays(16, 8, 2008), '2008 08 16');
compare('2008 08 17', Date_Calc::DaysToDate(2454696, "%Y %m %d"), '2454696');
compare(2454696, Date_Calc::DateToDays(17, 8, 2008), '2008 08 17');
compare('2008 08 18', Date_Calc::DaysToDate(2454697, "%Y %m %d"), '2454697');
compare(2454697, Date_Calc::DateToDays(18, 8, 2008), '2008 08 18');
compare('2008 08 19', Date_Calc::DaysToDate(2454698, "%Y %m %d"), '2454698');
compare(2454698, Date_Calc::DateToDays(19, 8, 2008), '2008 08 19');
compare('2008 08 20', Date_Calc::DaysToDate(2454699, "%Y %m %d"), '2454699');
compare(2454699, Date_Calc::DateToDays(20, 8, 2008), '2008 08 20');
compare('2008 08 21', Date_Calc::DaysToDate(2454700, "%Y %m %d"), '2454700');
compare(2454700, Date_Calc::DateToDays(21, 8, 2008), '2008 08 21');
compare('2008 08 22', Date_Calc::DaysToDate(2454701, "%Y %m %d"), '2454701');
compare(2454701, Date_Calc::DateToDays(22, 8, 2008), '2008 08 22');
compare('2008 08 23', Date_Calc::DaysToDate(2454702, "%Y %m %d"), '2454702');
compare(2454702, Date_Calc::DateToDays(23, 8, 2008), '2008 08 23');
compare('2008 08 24', Date_Calc::DaysToDate(2454703, "%Y %m %d"), '2454703');
compare(2454703, Date_Calc::DateToDays(24, 8, 2008), '2008 08 24');
compare('2008 08 25', Date_Calc::DaysToDate(2454704, "%Y %m %d"), '2454704');
compare(2454704, Date_Calc::DateToDays(25, 8, 2008), '2008 08 25');
compare('2008 08 26', Date_Calc::DaysToDate(2454705, "%Y %m %d"), '2454705');
compare(2454705, Date_Calc::DateToDays(26, 8, 2008), '2008 08 26');
compare('2008 08 27', Date_Calc::DaysToDate(2454706, "%Y %m %d"), '2454706');
compare(2454706, Date_Calc::DateToDays(27, 8, 2008), '2008 08 27');
compare('2008 08 28', Date_Calc::DaysToDate(2454707, "%Y %m %d"), '2454707');
compare(2454707, Date_Calc::DateToDays(28, 8, 2008), '2008 08 28');
compare('2008 08 29', Date_Calc::DaysToDate(2454708, "%Y %m %d"), '2454708');
compare(2454708, Date_Calc::DateToDays(29, 8, 2008), '2008 08 29');
compare('2008 08 30', Date_Calc::DaysToDate(2454709, "%Y %m %d"), '2454709');
compare(2454709, Date_Calc::DateToDays(30, 8, 2008), '2008 08 30');
compare('2008 08 31', Date_Calc::DaysToDate(2454710, "%Y %m %d"), '2454710');
compare(2454710, Date_Calc::DateToDays(31, 8, 2008), '2008 08 31');
compare('2008 09 01', Date_Calc::DaysToDate(2454711, "%Y %m %d"), '2454711');
compare(2454711, Date_Calc::DateToDays(1, 9, 2008), '2008 09 01');
compare('2008 09 02', Date_Calc::DaysToDate(2454712, "%Y %m %d"), '2454712');
compare(2454712, Date_Calc::DateToDays(2, 9, 2008), '2008 09 02');
compare('2008 09 03', Date_Calc::DaysToDate(2454713, "%Y %m %d"), '2454713');
compare(2454713, Date_Calc::DateToDays(3, 9, 2008), '2008 09 03');
compare('2008 09 04', Date_Calc::DaysToDate(2454714, "%Y %m %d"), '2454714');
compare(2454714, Date_Calc::DateToDays(4, 9, 2008), '2008 09 04');
compare('2008 09 05', Date_Calc::DaysToDate(2454715, "%Y %m %d"), '2454715');
compare(2454715, Date_Calc::DateToDays(5, 9, 2008), '2008 09 05');
compare('2008 09 06', Date_Calc::DaysToDate(2454716, "%Y %m %d"), '2454716');
compare(2454716, Date_Calc::DateToDays(6, 9, 2008), '2008 09 06');
compare('2008 09 07', Date_Calc::DaysToDate(2454717, "%Y %m %d"), '2454717');
compare(2454717, Date_Calc::DateToDays(7, 9, 2008), '2008 09 07');
compare('2008 09 08', Date_Calc::DaysToDate(2454718, "%Y %m %d"), '2454718');
compare(2454718, Date_Calc::DateToDays(8, 9, 2008), '2008 09 08');
compare('2008 09 09', Date_Calc::DaysToDate(2454719, "%Y %m %d"), '2454719');
compare(2454719, Date_Calc::DateToDays(9, 9, 2008), '2008 09 09');
compare('2008 09 10', Date_Calc::DaysToDate(2454720, "%Y %m %d"), '2454720');
compare(2454720, Date_Calc::DateToDays(10, 9, 2008), '2008 09 10');
compare('2008 09 11', Date_Calc::DaysToDate(2454721, "%Y %m %d"), '2454721');
compare(2454721, Date_Calc::DateToDays(11, 9, 2008), '2008 09 11');
compare('2008 09 12', Date_Calc::DaysToDate(2454722, "%Y %m %d"), '2454722');
compare(2454722, Date_Calc::DateToDays(12, 9, 2008), '2008 09 12');
compare('2008 09 13', Date_Calc::DaysToDate(2454723, "%Y %m %d"), '2454723');
compare(2454723, Date_Calc::DateToDays(13, 9, 2008), '2008 09 13');
compare('2008 09 14', Date_Calc::DaysToDate(2454724, "%Y %m %d"), '2454724');
compare(2454724, Date_Calc::DateToDays(14, 9, 2008), '2008 09 14');
compare('2008 09 15', Date_Calc::DaysToDate(2454725, "%Y %m %d"), '2454725');
compare(2454725, Date_Calc::DateToDays(15, 9, 2008), '2008 09 15');
compare('2008 09 16', Date_Calc::DaysToDate(2454726, "%Y %m %d"), '2454726');
compare(2454726, Date_Calc::DateToDays(16, 9, 2008), '2008 09 16');
compare('2008 09 17', Date_Calc::DaysToDate(2454727, "%Y %m %d"), '2454727');
compare(2454727, Date_Calc::DateToDays(17, 9, 2008), '2008 09 17');
compare('2008 09 18', Date_Calc::DaysToDate(2454728, "%Y %m %d"), '2454728');
compare(2454728, Date_Calc::DateToDays(18, 9, 2008), '2008 09 18');
compare('2008 09 19', Date_Calc::DaysToDate(2454729, "%Y %m %d"), '2454729');
compare(2454729, Date_Calc::DateToDays(19, 9, 2008), '2008 09 19');
compare('2008 09 20', Date_Calc::DaysToDate(2454730, "%Y %m %d"), '2454730');
compare(2454730, Date_Calc::DateToDays(20, 9, 2008), '2008 09 20');
compare('2008 09 21', Date_Calc::DaysToDate(2454731, "%Y %m %d"), '2454731');
compare(2454731, Date_Calc::DateToDays(21, 9, 2008), '2008 09 21');
compare('2008 09 22', Date_Calc::DaysToDate(2454732, "%Y %m %d"), '2454732');
compare(2454732, Date_Calc::DateToDays(22, 9, 2008), '2008 09 22');
compare('2008 09 23', Date_Calc::DaysToDate(2454733, "%Y %m %d"), '2454733');
compare(2454733, Date_Calc::DateToDays(23, 9, 2008), '2008 09 23');
compare('2008 09 24', Date_Calc::DaysToDate(2454734, "%Y %m %d"), '2454734');
compare(2454734, Date_Calc::DateToDays(24, 9, 2008), '2008 09 24');
compare('2008 09 25', Date_Calc::DaysToDate(2454735, "%Y %m %d"), '2454735');
compare(2454735, Date_Calc::DateToDays(25, 9, 2008), '2008 09 25');
compare('2008 09 26', Date_Calc::DaysToDate(2454736, "%Y %m %d"), '2454736');
compare(2454736, Date_Calc::DateToDays(26, 9, 2008), '2008 09 26');
compare('2008 09 27', Date_Calc::DaysToDate(2454737, "%Y %m %d"), '2454737');
compare(2454737, Date_Calc::DateToDays(27, 9, 2008), '2008 09 27');
compare('2008 09 28', Date_Calc::DaysToDate(2454738, "%Y %m %d"), '2454738');
compare(2454738, Date_Calc::DateToDays(28, 9, 2008), '2008 09 28');
compare('2008 09 29', Date_Calc::DaysToDate(2454739, "%Y %m %d"), '2454739');
compare(2454739, Date_Calc::DateToDays(29, 9, 2008), '2008 09 29');
compare('2008 09 30', Date_Calc::DaysToDate(2454740, "%Y %m %d"), '2454740');
compare(2454740, Date_Calc::DateToDays(30, 9, 2008), '2008 09 30');
compare('2008 10 01', Date_Calc::DaysToDate(2454741, "%Y %m %d"), '2454741');
compare(2454741, Date_Calc::DateToDays(1, 10, 2008), '2008 10 01');
compare('2008 10 02', Date_Calc::DaysToDate(2454742, "%Y %m %d"), '2454742');
compare(2454742, Date_Calc::DateToDays(2, 10, 2008), '2008 10 02');
compare('2008 10 03', Date_Calc::DaysToDate(2454743, "%Y %m %d"), '2454743');
compare(2454743, Date_Calc::DateToDays(3, 10, 2008), '2008 10 03');
compare('2008 10 04', Date_Calc::DaysToDate(2454744, "%Y %m %d"), '2454744');
compare(2454744, Date_Calc::DateToDays(4, 10, 2008), '2008 10 04');
compare('2008 10 05', Date_Calc::DaysToDate(2454745, "%Y %m %d"), '2454745');
compare(2454745, Date_Calc::DateToDays(5, 10, 2008), '2008 10 05');
compare('2008 10 06', Date_Calc::DaysToDate(2454746, "%Y %m %d"), '2454746');
compare(2454746, Date_Calc::DateToDays(6, 10, 2008), '2008 10 06');
compare('2008 10 07', Date_Calc::DaysToDate(2454747, "%Y %m %d"), '2454747');
compare(2454747, Date_Calc::DateToDays(7, 10, 2008), '2008 10 07');
compare('2008 10 08', Date_Calc::DaysToDate(2454748, "%Y %m %d"), '2454748');
compare(2454748, Date_Calc::DateToDays(8, 10, 2008), '2008 10 08');
compare('2008 10 09', Date_Calc::DaysToDate(2454749, "%Y %m %d"), '2454749');
compare(2454749, Date_Calc::DateToDays(9, 10, 2008), '2008 10 09');
compare('2008 10 10', Date_Calc::DaysToDate(2454750, "%Y %m %d"), '2454750');
compare(2454750, Date_Calc::DateToDays(10, 10, 2008), '2008 10 10');
compare('2008 10 11', Date_Calc::DaysToDate(2454751, "%Y %m %d"), '2454751');
compare(2454751, Date_Calc::DateToDays(11, 10, 2008), '2008 10 11');
compare('2008 10 12', Date_Calc::DaysToDate(2454752, "%Y %m %d"), '2454752');
compare(2454752, Date_Calc::DateToDays(12, 10, 2008), '2008 10 12');
compare('2008 10 13', Date_Calc::DaysToDate(2454753, "%Y %m %d"), '2454753');
compare(2454753, Date_Calc::DateToDays(13, 10, 2008), '2008 10 13');
compare('2008 10 14', Date_Calc::DaysToDate(2454754, "%Y %m %d"), '2454754');
compare(2454754, Date_Calc::DateToDays(14, 10, 2008), '2008 10 14');
compare('2008 10 15', Date_Calc::DaysToDate(2454755, "%Y %m %d"), '2454755');
compare(2454755, Date_Calc::DateToDays(15, 10, 2008), '2008 10 15');
compare('2008 10 16', Date_Calc::DaysToDate(2454756, "%Y %m %d"), '2454756');
compare(2454756, Date_Calc::DateToDays(16, 10, 2008), '2008 10 16');
compare('2008 10 17', Date_Calc::DaysToDate(2454757, "%Y %m %d"), '2454757');
compare(2454757, Date_Calc::DateToDays(17, 10, 2008), '2008 10 17');
compare('2008 10 18', Date_Calc::DaysToDate(2454758, "%Y %m %d"), '2454758');
compare(2454758, Date_Calc::DateToDays(18, 10, 2008), '2008 10 18');
compare('2008 10 19', Date_Calc::DaysToDate(2454759, "%Y %m %d"), '2454759');
compare(2454759, Date_Calc::DateToDays(19, 10, 2008), '2008 10 19');
compare('2008 10 20', Date_Calc::DaysToDate(2454760, "%Y %m %d"), '2454760');
compare(2454760, Date_Calc::DateToDays(20, 10, 2008), '2008 10 20');
compare('2008 10 21', Date_Calc::DaysToDate(2454761, "%Y %m %d"), '2454761');
compare(2454761, Date_Calc::DateToDays(21, 10, 2008), '2008 10 21');
compare('2008 10 22', Date_Calc::DaysToDate(2454762, "%Y %m %d"), '2454762');
compare(2454762, Date_Calc::DateToDays(22, 10, 2008), '2008 10 22');
compare('2008 10 23', Date_Calc::DaysToDate(2454763, "%Y %m %d"), '2454763');
compare(2454763, Date_Calc::DateToDays(23, 10, 2008), '2008 10 23');
compare('2008 10 24', Date_Calc::DaysToDate(2454764, "%Y %m %d"), '2454764');
compare(2454764, Date_Calc::DateToDays(24, 10, 2008), '2008 10 24');
compare('2008 10 25', Date_Calc::DaysToDate(2454765, "%Y %m %d"), '2454765');
compare(2454765, Date_Calc::DateToDays(25, 10, 2008), '2008 10 25');
compare('2008 10 26', Date_Calc::DaysToDate(2454766, "%Y %m %d"), '2454766');
compare(2454766, Date_Calc::DateToDays(26, 10, 2008), '2008 10 26');
compare('2008 10 27', Date_Calc::DaysToDate(2454767, "%Y %m %d"), '2454767');
compare(2454767, Date_Calc::DateToDays(27, 10, 2008), '2008 10 27');
compare('2008 10 28', Date_Calc::DaysToDate(2454768, "%Y %m %d"), '2454768');
compare(2454768, Date_Calc::DateToDays(28, 10, 2008), '2008 10 28');
compare('2008 10 29', Date_Calc::DaysToDate(2454769, "%Y %m %d"), '2454769');
compare(2454769, Date_Calc::DateToDays(29, 10, 2008), '2008 10 29');
compare('2008 10 30', Date_Calc::DaysToDate(2454770, "%Y %m %d"), '2454770');
compare(2454770, Date_Calc::DateToDays(30, 10, 2008), '2008 10 30');
compare('2008 10 31', Date_Calc::DaysToDate(2454771, "%Y %m %d"), '2454771');
compare(2454771, Date_Calc::DateToDays(31, 10, 2008), '2008 10 31');
compare('2008 11 01', Date_Calc::DaysToDate(2454772, "%Y %m %d"), '2454772');
compare(2454772, Date_Calc::DateToDays(1, 11, 2008), '2008 11 01');
compare('2008 11 02', Date_Calc::DaysToDate(2454773, "%Y %m %d"), '2454773');
compare(2454773, Date_Calc::DateToDays(2, 11, 2008), '2008 11 02');
compare('2008 11 03', Date_Calc::DaysToDate(2454774, "%Y %m %d"), '2454774');
compare(2454774, Date_Calc::DateToDays(3, 11, 2008), '2008 11 03');
compare('2008 11 04', Date_Calc::DaysToDate(2454775, "%Y %m %d"), '2454775');
compare(2454775, Date_Calc::DateToDays(4, 11, 2008), '2008 11 04');
compare('2008 11 05', Date_Calc::DaysToDate(2454776, "%Y %m %d"), '2454776');
compare(2454776, Date_Calc::DateToDays(5, 11, 2008), '2008 11 05');
compare('2008 11 06', Date_Calc::DaysToDate(2454777, "%Y %m %d"), '2454777');
compare(2454777, Date_Calc::DateToDays(6, 11, 2008), '2008 11 06');
compare('2008 11 07', Date_Calc::DaysToDate(2454778, "%Y %m %d"), '2454778');
compare(2454778, Date_Calc::DateToDays(7, 11, 2008), '2008 11 07');

compare('-0002 12 31', Date_Calc::DaysToDate(1720694, "%Y %m %d"), '1720694');
compare(1720694, Date_Calc::DateToDays(31, 12, -2), '-0002 12 31');
compare('-0001 01 01', Date_Calc::DaysToDate(1720695, "%Y %m %d"), '1720695');
compare(1720695, Date_Calc::DateToDays(1, 1, -1), '-0001 01 01');
compare('-0001 01 02', Date_Calc::DaysToDate(1720696, "%Y %m %d"), '1720696');
compare(1720696, Date_Calc::DateToDays(2, 1, -1), '-0001 01 02');
compare('-0001 01 03', Date_Calc::DaysToDate(1720697, "%Y %m %d"), '1720697');
compare(1720697, Date_Calc::DateToDays(3, 1, -1), '-0001 01 03');
compare('-0001 01 04', Date_Calc::DaysToDate(1720698, "%Y %m %d"), '1720698');
compare(1720698, Date_Calc::DateToDays(4, 1, -1), '-0001 01 04');
compare('-0001 01 05', Date_Calc::DaysToDate(1720699, "%Y %m %d"), '1720699');
compare(1720699, Date_Calc::DateToDays(5, 1, -1), '-0001 01 05');
compare('-0001 01 06', Date_Calc::DaysToDate(1720700, "%Y %m %d"), '1720700');
compare(1720700, Date_Calc::DateToDays(6, 1, -1), '-0001 01 06');
compare('-0001 01 07', Date_Calc::DaysToDate(1720701, "%Y %m %d"), '1720701');
compare(1720701, Date_Calc::DateToDays(7, 1, -1), '-0001 01 07');
compare('-0001 01 08', Date_Calc::DaysToDate(1720702, "%Y %m %d"), '1720702');
compare(1720702, Date_Calc::DateToDays(8, 1, -1), '-0001 01 08');
compare('-0001 01 09', Date_Calc::DaysToDate(1720703, "%Y %m %d"), '1720703');
compare(1720703, Date_Calc::DateToDays(9, 1, -1), '-0001 01 09');
compare('-0001 01 10', Date_Calc::DaysToDate(1720704, "%Y %m %d"), '1720704');
compare(1720704, Date_Calc::DateToDays(10, 1, -1), '-0001 01 10');
compare('-0001 01 11', Date_Calc::DaysToDate(1720705, "%Y %m %d"), '1720705');
compare(1720705, Date_Calc::DateToDays(11, 1, -1), '-0001 01 11');
compare('-0001 01 12', Date_Calc::DaysToDate(1720706, "%Y %m %d"), '1720706');
compare(1720706, Date_Calc::DateToDays(12, 1, -1), '-0001 01 12');
compare('-0001 01 13', Date_Calc::DaysToDate(1720707, "%Y %m %d"), '1720707');
compare(1720707, Date_Calc::DateToDays(13, 1, -1), '-0001 01 13');
compare('-0001 01 14', Date_Calc::DaysToDate(1720708, "%Y %m %d"), '1720708');
compare(1720708, Date_Calc::DateToDays(14, 1, -1), '-0001 01 14');
compare('-0001 01 15', Date_Calc::DaysToDate(1720709, "%Y %m %d"), '1720709');
compare(1720709, Date_Calc::DateToDays(15, 1, -1), '-0001 01 15');
compare('-0001 01 16', Date_Calc::DaysToDate(1720710, "%Y %m %d"), '1720710');
compare(1720710, Date_Calc::DateToDays(16, 1, -1), '-0001 01 16');
compare('-0001 01 17', Date_Calc::DaysToDate(1720711, "%Y %m %d"), '1720711');
compare(1720711, Date_Calc::DateToDays(17, 1, -1), '-0001 01 17');
compare('-0001 01 18', Date_Calc::DaysToDate(1720712, "%Y %m %d"), '1720712');
compare(1720712, Date_Calc::DateToDays(18, 1, -1), '-0001 01 18');
compare('-0001 01 19', Date_Calc::DaysToDate(1720713, "%Y %m %d"), '1720713');
compare(1720713, Date_Calc::DateToDays(19, 1, -1), '-0001 01 19');
compare('-0001 01 20', Date_Calc::DaysToDate(1720714, "%Y %m %d"), '1720714');
compare(1720714, Date_Calc::DateToDays(20, 1, -1), '-0001 01 20');
compare('-0001 01 21', Date_Calc::DaysToDate(1720715, "%Y %m %d"), '1720715');
compare(1720715, Date_Calc::DateToDays(21, 1, -1), '-0001 01 21');
compare('-0001 01 22', Date_Calc::DaysToDate(1720716, "%Y %m %d"), '1720716');
compare(1720716, Date_Calc::DateToDays(22, 1, -1), '-0001 01 22');
compare('-0001 01 23', Date_Calc::DaysToDate(1720717, "%Y %m %d"), '1720717');
compare(1720717, Date_Calc::DateToDays(23, 1, -1), '-0001 01 23');
compare('-0001 01 24', Date_Calc::DaysToDate(1720718, "%Y %m %d"), '1720718');
compare(1720718, Date_Calc::DateToDays(24, 1, -1), '-0001 01 24');
compare('-0001 01 25', Date_Calc::DaysToDate(1720719, "%Y %m %d"), '1720719');
compare(1720719, Date_Calc::DateToDays(25, 1, -1), '-0001 01 25');
compare('-0001 01 26', Date_Calc::DaysToDate(1720720, "%Y %m %d"), '1720720');
compare(1720720, Date_Calc::DateToDays(26, 1, -1), '-0001 01 26');
compare('-0001 01 27', Date_Calc::DaysToDate(1720721, "%Y %m %d"), '1720721');
compare(1720721, Date_Calc::DateToDays(27, 1, -1), '-0001 01 27');
compare('-0001 01 28', Date_Calc::DaysToDate(1720722, "%Y %m %d"), '1720722');
compare(1720722, Date_Calc::DateToDays(28, 1, -1), '-0001 01 28');
compare('-0001 01 29', Date_Calc::DaysToDate(1720723, "%Y %m %d"), '1720723');
compare(1720723, Date_Calc::DateToDays(29, 1, -1), '-0001 01 29');
compare('-0001 01 30', Date_Calc::DaysToDate(1720724, "%Y %m %d"), '1720724');
compare(1720724, Date_Calc::DateToDays(30, 1, -1), '-0001 01 30');
compare('-0001 01 31', Date_Calc::DaysToDate(1720725, "%Y %m %d"), '1720725');
compare(1720725, Date_Calc::DateToDays(31, 1, -1), '-0001 01 31');
compare('-0001 02 01', Date_Calc::DaysToDate(1720726, "%Y %m %d"), '1720726');
compare(1720726, Date_Calc::DateToDays(1, 2, -1), '-0001 02 01');
compare('-0001 02 02', Date_Calc::DaysToDate(1720727, "%Y %m %d"), '1720727');
compare(1720727, Date_Calc::DateToDays(2, 2, -1), '-0001 02 02');
compare('-0001 02 03', Date_Calc::DaysToDate(1720728, "%Y %m %d"), '1720728');
compare(1720728, Date_Calc::DateToDays(3, 2, -1), '-0001 02 03');
compare('-0001 02 04', Date_Calc::DaysToDate(1720729, "%Y %m %d"), '1720729');
compare(1720729, Date_Calc::DateToDays(4, 2, -1), '-0001 02 04');
compare('-0001 02 05', Date_Calc::DaysToDate(1720730, "%Y %m %d"), '1720730');
compare(1720730, Date_Calc::DateToDays(5, 2, -1), '-0001 02 05');
compare('-0001 02 06', Date_Calc::DaysToDate(1720731, "%Y %m %d"), '1720731');
compare(1720731, Date_Calc::DateToDays(6, 2, -1), '-0001 02 06');
compare('-0001 02 07', Date_Calc::DaysToDate(1720732, "%Y %m %d"), '1720732');
compare(1720732, Date_Calc::DateToDays(7, 2, -1), '-0001 02 07');
compare('-0001 02 08', Date_Calc::DaysToDate(1720733, "%Y %m %d"), '1720733');
compare(1720733, Date_Calc::DateToDays(8, 2, -1), '-0001 02 08');
compare('-0001 02 09', Date_Calc::DaysToDate(1720734, "%Y %m %d"), '1720734');
compare(1720734, Date_Calc::DateToDays(9, 2, -1), '-0001 02 09');
compare('-0001 02 10', Date_Calc::DaysToDate(1720735, "%Y %m %d"), '1720735');
compare(1720735, Date_Calc::DateToDays(10, 2, -1), '-0001 02 10');
compare('-0001 02 11', Date_Calc::DaysToDate(1720736, "%Y %m %d"), '1720736');
compare(1720736, Date_Calc::DateToDays(11, 2, -1), '-0001 02 11');
compare('-0001 02 12', Date_Calc::DaysToDate(1720737, "%Y %m %d"), '1720737');
compare(1720737, Date_Calc::DateToDays(12, 2, -1), '-0001 02 12');
compare('-0001 02 13', Date_Calc::DaysToDate(1720738, "%Y %m %d"), '1720738');
compare(1720738, Date_Calc::DateToDays(13, 2, -1), '-0001 02 13');
compare('-0001 02 14', Date_Calc::DaysToDate(1720739, "%Y %m %d"), '1720739');
compare(1720739, Date_Calc::DateToDays(14, 2, -1), '-0001 02 14');
compare('-0001 02 15', Date_Calc::DaysToDate(1720740, "%Y %m %d"), '1720740');
compare(1720740, Date_Calc::DateToDays(15, 2, -1), '-0001 02 15');
compare('-0001 02 16', Date_Calc::DaysToDate(1720741, "%Y %m %d"), '1720741');
compare(1720741, Date_Calc::DateToDays(16, 2, -1), '-0001 02 16');
compare('-0001 02 17', Date_Calc::DaysToDate(1720742, "%Y %m %d"), '1720742');
compare(1720742, Date_Calc::DateToDays(17, 2, -1), '-0001 02 17');
compare('-0001 02 18', Date_Calc::DaysToDate(1720743, "%Y %m %d"), '1720743');
compare(1720743, Date_Calc::DateToDays(18, 2, -1), '-0001 02 18');
compare('-0001 02 19', Date_Calc::DaysToDate(1720744, "%Y %m %d"), '1720744');
compare(1720744, Date_Calc::DateToDays(19, 2, -1), '-0001 02 19');
compare('-0001 02 20', Date_Calc::DaysToDate(1720745, "%Y %m %d"), '1720745');
compare(1720745, Date_Calc::DateToDays(20, 2, -1), '-0001 02 20');
compare('-0001 02 21', Date_Calc::DaysToDate(1720746, "%Y %m %d"), '1720746');
compare(1720746, Date_Calc::DateToDays(21, 2, -1), '-0001 02 21');
compare('-0001 02 22', Date_Calc::DaysToDate(1720747, "%Y %m %d"), '1720747');
compare(1720747, Date_Calc::DateToDays(22, 2, -1), '-0001 02 22');
compare('-0001 02 23', Date_Calc::DaysToDate(1720748, "%Y %m %d"), '1720748');
compare(1720748, Date_Calc::DateToDays(23, 2, -1), '-0001 02 23');
compare('-0001 02 24', Date_Calc::DaysToDate(1720749, "%Y %m %d"), '1720749');
compare(1720749, Date_Calc::DateToDays(24, 2, -1), '-0001 02 24');
compare('-0001 02 25', Date_Calc::DaysToDate(1720750, "%Y %m %d"), '1720750');
compare(1720750, Date_Calc::DateToDays(25, 2, -1), '-0001 02 25');
compare('-0001 02 26', Date_Calc::DaysToDate(1720751, "%Y %m %d"), '1720751');
compare(1720751, Date_Calc::DateToDays(26, 2, -1), '-0001 02 26');
compare('-0001 02 27', Date_Calc::DaysToDate(1720752, "%Y %m %d"), '1720752');
compare(1720752, Date_Calc::DateToDays(27, 2, -1), '-0001 02 27');
compare('-0001 02 28', Date_Calc::DaysToDate(1720753, "%Y %m %d"), '1720753');
compare(1720753, Date_Calc::DateToDays(28, 2, -1), '-0001 02 28');
compare('-0001 03 01', Date_Calc::DaysToDate(1720754, "%Y %m %d"), '1720754');
compare(1720754, Date_Calc::DateToDays(1, 3, -1), '-0001 03 01');
compare('-0001 03 02', Date_Calc::DaysToDate(1720755, "%Y %m %d"), '1720755');
compare(1720755, Date_Calc::DateToDays(2, 3, -1), '-0001 03 02');
compare('-0001 03 03', Date_Calc::DaysToDate(1720756, "%Y %m %d"), '1720756');
compare(1720756, Date_Calc::DateToDays(3, 3, -1), '-0001 03 03');
compare('-0001 03 04', Date_Calc::DaysToDate(1720757, "%Y %m %d"), '1720757');
compare(1720757, Date_Calc::DateToDays(4, 3, -1), '-0001 03 04');
compare('-0001 03 05', Date_Calc::DaysToDate(1720758, "%Y %m %d"), '1720758');
compare(1720758, Date_Calc::DateToDays(5, 3, -1), '-0001 03 05');
compare('-0001 03 06', Date_Calc::DaysToDate(1720759, "%Y %m %d"), '1720759');
compare(1720759, Date_Calc::DateToDays(6, 3, -1), '-0001 03 06');
compare('-0001 03 07', Date_Calc::DaysToDate(1720760, "%Y %m %d"), '1720760');
compare(1720760, Date_Calc::DateToDays(7, 3, -1), '-0001 03 07');
compare('-0001 03 08', Date_Calc::DaysToDate(1720761, "%Y %m %d"), '1720761');
compare(1720761, Date_Calc::DateToDays(8, 3, -1), '-0001 03 08');
compare('-0001 03 09', Date_Calc::DaysToDate(1720762, "%Y %m %d"), '1720762');
compare(1720762, Date_Calc::DateToDays(9, 3, -1), '-0001 03 09');
compare('-0001 03 10', Date_Calc::DaysToDate(1720763, "%Y %m %d"), '1720763');
compare(1720763, Date_Calc::DateToDays(10, 3, -1), '-0001 03 10');
compare('-0001 03 11', Date_Calc::DaysToDate(1720764, "%Y %m %d"), '1720764');
compare(1720764, Date_Calc::DateToDays(11, 3, -1), '-0001 03 11');
compare('-0001 03 12', Date_Calc::DaysToDate(1720765, "%Y %m %d"), '1720765');
compare(1720765, Date_Calc::DateToDays(12, 3, -1), '-0001 03 12');
compare('-0001 03 13', Date_Calc::DaysToDate(1720766, "%Y %m %d"), '1720766');
compare(1720766, Date_Calc::DateToDays(13, 3, -1), '-0001 03 13');
compare('-0001 03 14', Date_Calc::DaysToDate(1720767, "%Y %m %d"), '1720767');
compare(1720767, Date_Calc::DateToDays(14, 3, -1), '-0001 03 14');
compare('-0001 03 15', Date_Calc::DaysToDate(1720768, "%Y %m %d"), '1720768');
compare(1720768, Date_Calc::DateToDays(15, 3, -1), '-0001 03 15');
compare('-0001 03 16', Date_Calc::DaysToDate(1720769, "%Y %m %d"), '1720769');
compare(1720769, Date_Calc::DateToDays(16, 3, -1), '-0001 03 16');
compare('-0001 03 17', Date_Calc::DaysToDate(1720770, "%Y %m %d"), '1720770');
compare(1720770, Date_Calc::DateToDays(17, 3, -1), '-0001 03 17');
compare('-0001 03 18', Date_Calc::DaysToDate(1720771, "%Y %m %d"), '1720771');
compare(1720771, Date_Calc::DateToDays(18, 3, -1), '-0001 03 18');
compare('-0001 03 19', Date_Calc::DaysToDate(1720772, "%Y %m %d"), '1720772');
compare(1720772, Date_Calc::DateToDays(19, 3, -1), '-0001 03 19');
compare('-0001 03 20', Date_Calc::DaysToDate(1720773, "%Y %m %d"), '1720773');
compare(1720773, Date_Calc::DateToDays(20, 3, -1), '-0001 03 20');
compare('-0001 03 21', Date_Calc::DaysToDate(1720774, "%Y %m %d"), '1720774');
compare(1720774, Date_Calc::DateToDays(21, 3, -1), '-0001 03 21');
compare('-0001 03 22', Date_Calc::DaysToDate(1720775, "%Y %m %d"), '1720775');
compare(1720775, Date_Calc::DateToDays(22, 3, -1), '-0001 03 22');
compare('-0001 03 23', Date_Calc::DaysToDate(1720776, "%Y %m %d"), '1720776');
compare(1720776, Date_Calc::DateToDays(23, 3, -1), '-0001 03 23');
compare('-0001 03 24', Date_Calc::DaysToDate(1720777, "%Y %m %d"), '1720777');
compare(1720777, Date_Calc::DateToDays(24, 3, -1), '-0001 03 24');
compare('-0001 03 25', Date_Calc::DaysToDate(1720778, "%Y %m %d"), '1720778');
compare(1720778, Date_Calc::DateToDays(25, 3, -1), '-0001 03 25');
compare('-0001 03 26', Date_Calc::DaysToDate(1720779, "%Y %m %d"), '1720779');
compare(1720779, Date_Calc::DateToDays(26, 3, -1), '-0001 03 26');
compare('-0001 03 27', Date_Calc::DaysToDate(1720780, "%Y %m %d"), '1720780');
compare(1720780, Date_Calc::DateToDays(27, 3, -1), '-0001 03 27');
compare('-0001 03 28', Date_Calc::DaysToDate(1720781, "%Y %m %d"), '1720781');
compare(1720781, Date_Calc::DateToDays(28, 3, -1), '-0001 03 28');
compare('-0001 03 29', Date_Calc::DaysToDate(1720782, "%Y %m %d"), '1720782');
compare(1720782, Date_Calc::DateToDays(29, 3, -1), '-0001 03 29');
compare('-0001 03 30', Date_Calc::DaysToDate(1720783, "%Y %m %d"), '1720783');
compare(1720783, Date_Calc::DateToDays(30, 3, -1), '-0001 03 30');
compare('-0001 03 31', Date_Calc::DaysToDate(1720784, "%Y %m %d"), '1720784');
compare(1720784, Date_Calc::DateToDays(31, 3, -1), '-0001 03 31');
compare('-0001 04 01', Date_Calc::DaysToDate(1720785, "%Y %m %d"), '1720785');
compare(1720785, Date_Calc::DateToDays(1, 4, -1), '-0001 04 01');
compare('-0001 04 02', Date_Calc::DaysToDate(1720786, "%Y %m %d"), '1720786');
compare(1720786, Date_Calc::DateToDays(2, 4, -1), '-0001 04 02');
compare('-0001 04 03', Date_Calc::DaysToDate(1720787, "%Y %m %d"), '1720787');
compare(1720787, Date_Calc::DateToDays(3, 4, -1), '-0001 04 03');
compare('-0001 04 04', Date_Calc::DaysToDate(1720788, "%Y %m %d"), '1720788');
compare(1720788, Date_Calc::DateToDays(4, 4, -1), '-0001 04 04');
compare('-0001 04 05', Date_Calc::DaysToDate(1720789, "%Y %m %d"), '1720789');
compare(1720789, Date_Calc::DateToDays(5, 4, -1), '-0001 04 05');
compare('-0001 04 06', Date_Calc::DaysToDate(1720790, "%Y %m %d"), '1720790');
compare(1720790, Date_Calc::DateToDays(6, 4, -1), '-0001 04 06');
compare('-0001 04 07', Date_Calc::DaysToDate(1720791, "%Y %m %d"), '1720791');
compare(1720791, Date_Calc::DateToDays(7, 4, -1), '-0001 04 07');
compare('-0001 04 08', Date_Calc::DaysToDate(1720792, "%Y %m %d"), '1720792');
compare(1720792, Date_Calc::DateToDays(8, 4, -1), '-0001 04 08');
compare('-0001 04 09', Date_Calc::DaysToDate(1720793, "%Y %m %d"), '1720793');
compare(1720793, Date_Calc::DateToDays(9, 4, -1), '-0001 04 09');
compare('-0001 04 10', Date_Calc::DaysToDate(1720794, "%Y %m %d"), '1720794');
compare(1720794, Date_Calc::DateToDays(10, 4, -1), '-0001 04 10');
compare('-0001 04 11', Date_Calc::DaysToDate(1720795, "%Y %m %d"), '1720795');
compare(1720795, Date_Calc::DateToDays(11, 4, -1), '-0001 04 11');
compare('-0001 04 12', Date_Calc::DaysToDate(1720796, "%Y %m %d"), '1720796');
compare(1720796, Date_Calc::DateToDays(12, 4, -1), '-0001 04 12');
compare('-0001 04 13', Date_Calc::DaysToDate(1720797, "%Y %m %d"), '1720797');
compare(1720797, Date_Calc::DateToDays(13, 4, -1), '-0001 04 13');
compare('-0001 04 14', Date_Calc::DaysToDate(1720798, "%Y %m %d"), '1720798');
compare(1720798, Date_Calc::DateToDays(14, 4, -1), '-0001 04 14');
compare('-0001 04 15', Date_Calc::DaysToDate(1720799, "%Y %m %d"), '1720799');
compare(1720799, Date_Calc::DateToDays(15, 4, -1), '-0001 04 15');
compare('-0001 04 16', Date_Calc::DaysToDate(1720800, "%Y %m %d"), '1720800');
compare(1720800, Date_Calc::DateToDays(16, 4, -1), '-0001 04 16');
compare('-0001 04 17', Date_Calc::DaysToDate(1720801, "%Y %m %d"), '1720801');
compare(1720801, Date_Calc::DateToDays(17, 4, -1), '-0001 04 17');
compare('-0001 04 18', Date_Calc::DaysToDate(1720802, "%Y %m %d"), '1720802');
compare(1720802, Date_Calc::DateToDays(18, 4, -1), '-0001 04 18');
compare('-0001 04 19', Date_Calc::DaysToDate(1720803, "%Y %m %d"), '1720803');
compare(1720803, Date_Calc::DateToDays(19, 4, -1), '-0001 04 19');
compare('-0001 04 20', Date_Calc::DaysToDate(1720804, "%Y %m %d"), '1720804');
compare(1720804, Date_Calc::DateToDays(20, 4, -1), '-0001 04 20');
compare('-0001 04 21', Date_Calc::DaysToDate(1720805, "%Y %m %d"), '1720805');
compare(1720805, Date_Calc::DateToDays(21, 4, -1), '-0001 04 21');
compare('-0001 04 22', Date_Calc::DaysToDate(1720806, "%Y %m %d"), '1720806');
compare(1720806, Date_Calc::DateToDays(22, 4, -1), '-0001 04 22');
compare('-0001 04 23', Date_Calc::DaysToDate(1720807, "%Y %m %d"), '1720807');
compare(1720807, Date_Calc::DateToDays(23, 4, -1), '-0001 04 23');
compare('-0001 04 24', Date_Calc::DaysToDate(1720808, "%Y %m %d"), '1720808');
compare(1720808, Date_Calc::DateToDays(24, 4, -1), '-0001 04 24');
compare('-0001 04 25', Date_Calc::DaysToDate(1720809, "%Y %m %d"), '1720809');
compare(1720809, Date_Calc::DateToDays(25, 4, -1), '-0001 04 25');
compare('-0001 04 26', Date_Calc::DaysToDate(1720810, "%Y %m %d"), '1720810');
compare(1720810, Date_Calc::DateToDays(26, 4, -1), '-0001 04 26');
compare('-0001 04 27', Date_Calc::DaysToDate(1720811, "%Y %m %d"), '1720811');
compare(1720811, Date_Calc::DateToDays(27, 4, -1), '-0001 04 27');
compare('-0001 04 28', Date_Calc::DaysToDate(1720812, "%Y %m %d"), '1720812');
compare(1720812, Date_Calc::DateToDays(28, 4, -1), '-0001 04 28');
compare('-0001 04 29', Date_Calc::DaysToDate(1720813, "%Y %m %d"), '1720813');
compare(1720813, Date_Calc::DateToDays(29, 4, -1), '-0001 04 29');
compare('-0001 04 30', Date_Calc::DaysToDate(1720814, "%Y %m %d"), '1720814');
compare(1720814, Date_Calc::DateToDays(30, 4, -1), '-0001 04 30');
compare('-0001 05 01', Date_Calc::DaysToDate(1720815, "%Y %m %d"), '1720815');
compare(1720815, Date_Calc::DateToDays(1, 5, -1), '-0001 05 01');
compare('-0001 05 02', Date_Calc::DaysToDate(1720816, "%Y %m %d"), '1720816');
compare(1720816, Date_Calc::DateToDays(2, 5, -1), '-0001 05 02');
compare('-0001 05 03', Date_Calc::DaysToDate(1720817, "%Y %m %d"), '1720817');
compare(1720817, Date_Calc::DateToDays(3, 5, -1), '-0001 05 03');
compare('-0001 05 04', Date_Calc::DaysToDate(1720818, "%Y %m %d"), '1720818');
compare(1720818, Date_Calc::DateToDays(4, 5, -1), '-0001 05 04');
compare('-0001 05 05', Date_Calc::DaysToDate(1720819, "%Y %m %d"), '1720819');
compare(1720819, Date_Calc::DateToDays(5, 5, -1), '-0001 05 05');
compare('-0001 05 06', Date_Calc::DaysToDate(1720820, "%Y %m %d"), '1720820');
compare(1720820, Date_Calc::DateToDays(6, 5, -1), '-0001 05 06');
compare('-0001 05 07', Date_Calc::DaysToDate(1720821, "%Y %m %d"), '1720821');
compare(1720821, Date_Calc::DateToDays(7, 5, -1), '-0001 05 07');
compare('-0001 05 08', Date_Calc::DaysToDate(1720822, "%Y %m %d"), '1720822');
compare(1720822, Date_Calc::DateToDays(8, 5, -1), '-0001 05 08');
compare('-0001 05 09', Date_Calc::DaysToDate(1720823, "%Y %m %d"), '1720823');
compare(1720823, Date_Calc::DateToDays(9, 5, -1), '-0001 05 09');
compare('-0001 05 10', Date_Calc::DaysToDate(1720824, "%Y %m %d"), '1720824');
compare(1720824, Date_Calc::DateToDays(10, 5, -1), '-0001 05 10');
compare('-0001 05 11', Date_Calc::DaysToDate(1720825, "%Y %m %d"), '1720825');
compare(1720825, Date_Calc::DateToDays(11, 5, -1), '-0001 05 11');
compare('-0001 05 12', Date_Calc::DaysToDate(1720826, "%Y %m %d"), '1720826');
compare(1720826, Date_Calc::DateToDays(12, 5, -1), '-0001 05 12');
compare('-0001 05 13', Date_Calc::DaysToDate(1720827, "%Y %m %d"), '1720827');
compare(1720827, Date_Calc::DateToDays(13, 5, -1), '-0001 05 13');
compare('-0001 05 14', Date_Calc::DaysToDate(1720828, "%Y %m %d"), '1720828');
compare(1720828, Date_Calc::DateToDays(14, 5, -1), '-0001 05 14');
compare('-0001 05 15', Date_Calc::DaysToDate(1720829, "%Y %m %d"), '1720829');
compare(1720829, Date_Calc::DateToDays(15, 5, -1), '-0001 05 15');
compare('-0001 05 16', Date_Calc::DaysToDate(1720830, "%Y %m %d"), '1720830');
compare(1720830, Date_Calc::DateToDays(16, 5, -1), '-0001 05 16');
compare('-0001 05 17', Date_Calc::DaysToDate(1720831, "%Y %m %d"), '1720831');
compare(1720831, Date_Calc::DateToDays(17, 5, -1), '-0001 05 17');
compare('-0001 05 18', Date_Calc::DaysToDate(1720832, "%Y %m %d"), '1720832');
compare(1720832, Date_Calc::DateToDays(18, 5, -1), '-0001 05 18');
compare('-0001 05 19', Date_Calc::DaysToDate(1720833, "%Y %m %d"), '1720833');
compare(1720833, Date_Calc::DateToDays(19, 5, -1), '-0001 05 19');
compare('-0001 05 20', Date_Calc::DaysToDate(1720834, "%Y %m %d"), '1720834');
compare(1720834, Date_Calc::DateToDays(20, 5, -1), '-0001 05 20');
compare('-0001 05 21', Date_Calc::DaysToDate(1720835, "%Y %m %d"), '1720835');
compare(1720835, Date_Calc::DateToDays(21, 5, -1), '-0001 05 21');
compare('-0001 05 22', Date_Calc::DaysToDate(1720836, "%Y %m %d"), '1720836');
compare(1720836, Date_Calc::DateToDays(22, 5, -1), '-0001 05 22');
compare('-0001 05 23', Date_Calc::DaysToDate(1720837, "%Y %m %d"), '1720837');
compare(1720837, Date_Calc::DateToDays(23, 5, -1), '-0001 05 23');
compare('-0001 05 24', Date_Calc::DaysToDate(1720838, "%Y %m %d"), '1720838');
compare(1720838, Date_Calc::DateToDays(24, 5, -1), '-0001 05 24');
compare('-0001 05 25', Date_Calc::DaysToDate(1720839, "%Y %m %d"), '1720839');
compare(1720839, Date_Calc::DateToDays(25, 5, -1), '-0001 05 25');
compare('-0001 05 26', Date_Calc::DaysToDate(1720840, "%Y %m %d"), '1720840');
compare(1720840, Date_Calc::DateToDays(26, 5, -1), '-0001 05 26');
compare('-0001 05 27', Date_Calc::DaysToDate(1720841, "%Y %m %d"), '1720841');
compare(1720841, Date_Calc::DateToDays(27, 5, -1), '-0001 05 27');
compare('-0001 05 28', Date_Calc::DaysToDate(1720842, "%Y %m %d"), '1720842');
compare(1720842, Date_Calc::DateToDays(28, 5, -1), '-0001 05 28');
compare('-0001 05 29', Date_Calc::DaysToDate(1720843, "%Y %m %d"), '1720843');
compare(1720843, Date_Calc::DateToDays(29, 5, -1), '-0001 05 29');
compare('-0001 05 30', Date_Calc::DaysToDate(1720844, "%Y %m %d"), '1720844');
compare(1720844, Date_Calc::DateToDays(30, 5, -1), '-0001 05 30');
compare('-0001 05 31', Date_Calc::DaysToDate(1720845, "%Y %m %d"), '1720845');
compare(1720845, Date_Calc::DateToDays(31, 5, -1), '-0001 05 31');
compare('-0001 06 01', Date_Calc::DaysToDate(1720846, "%Y %m %d"), '1720846');
compare(1720846, Date_Calc::DateToDays(1, 6, -1), '-0001 06 01');
compare('-0001 06 02', Date_Calc::DaysToDate(1720847, "%Y %m %d"), '1720847');
compare(1720847, Date_Calc::DateToDays(2, 6, -1), '-0001 06 02');
compare('-0001 06 03', Date_Calc::DaysToDate(1720848, "%Y %m %d"), '1720848');
compare(1720848, Date_Calc::DateToDays(3, 6, -1), '-0001 06 03');
compare('-0001 06 04', Date_Calc::DaysToDate(1720849, "%Y %m %d"), '1720849');
compare(1720849, Date_Calc::DateToDays(4, 6, -1), '-0001 06 04');
compare('-0001 06 05', Date_Calc::DaysToDate(1720850, "%Y %m %d"), '1720850');
compare(1720850, Date_Calc::DateToDays(5, 6, -1), '-0001 06 05');
compare('-0001 06 06', Date_Calc::DaysToDate(1720851, "%Y %m %d"), '1720851');
compare(1720851, Date_Calc::DateToDays(6, 6, -1), '-0001 06 06');
compare('-0001 06 07', Date_Calc::DaysToDate(1720852, "%Y %m %d"), '1720852');
compare(1720852, Date_Calc::DateToDays(7, 6, -1), '-0001 06 07');
compare('-0001 06 08', Date_Calc::DaysToDate(1720853, "%Y %m %d"), '1720853');
compare(1720853, Date_Calc::DateToDays(8, 6, -1), '-0001 06 08');
compare('-0001 06 09', Date_Calc::DaysToDate(1720854, "%Y %m %d"), '1720854');
compare(1720854, Date_Calc::DateToDays(9, 6, -1), '-0001 06 09');
compare('-0001 06 10', Date_Calc::DaysToDate(1720855, "%Y %m %d"), '1720855');
compare(1720855, Date_Calc::DateToDays(10, 6, -1), '-0001 06 10');
compare('-0001 06 11', Date_Calc::DaysToDate(1720856, "%Y %m %d"), '1720856');
compare(1720856, Date_Calc::DateToDays(11, 6, -1), '-0001 06 11');
compare('-0001 06 12', Date_Calc::DaysToDate(1720857, "%Y %m %d"), '1720857');
compare(1720857, Date_Calc::DateToDays(12, 6, -1), '-0001 06 12');
compare('-0001 06 13', Date_Calc::DaysToDate(1720858, "%Y %m %d"), '1720858');
compare(1720858, Date_Calc::DateToDays(13, 6, -1), '-0001 06 13');
compare('-0001 06 14', Date_Calc::DaysToDate(1720859, "%Y %m %d"), '1720859');
compare(1720859, Date_Calc::DateToDays(14, 6, -1), '-0001 06 14');
compare('-0001 06 15', Date_Calc::DaysToDate(1720860, "%Y %m %d"), '1720860');
compare(1720860, Date_Calc::DateToDays(15, 6, -1), '-0001 06 15');
compare('-0001 06 16', Date_Calc::DaysToDate(1720861, "%Y %m %d"), '1720861');
compare(1720861, Date_Calc::DateToDays(16, 6, -1), '-0001 06 16');
compare('-0001 06 17', Date_Calc::DaysToDate(1720862, "%Y %m %d"), '1720862');
compare(1720862, Date_Calc::DateToDays(17, 6, -1), '-0001 06 17');
compare('-0001 06 18', Date_Calc::DaysToDate(1720863, "%Y %m %d"), '1720863');
compare(1720863, Date_Calc::DateToDays(18, 6, -1), '-0001 06 18');
compare('-0001 06 19', Date_Calc::DaysToDate(1720864, "%Y %m %d"), '1720864');
compare(1720864, Date_Calc::DateToDays(19, 6, -1), '-0001 06 19');
compare('-0001 06 20', Date_Calc::DaysToDate(1720865, "%Y %m %d"), '1720865');
compare(1720865, Date_Calc::DateToDays(20, 6, -1), '-0001 06 20');
compare('-0001 06 21', Date_Calc::DaysToDate(1720866, "%Y %m %d"), '1720866');
compare(1720866, Date_Calc::DateToDays(21, 6, -1), '-0001 06 21');
compare('-0001 06 22', Date_Calc::DaysToDate(1720867, "%Y %m %d"), '1720867');
compare(1720867, Date_Calc::DateToDays(22, 6, -1), '-0001 06 22');
compare('-0001 06 23', Date_Calc::DaysToDate(1720868, "%Y %m %d"), '1720868');
compare(1720868, Date_Calc::DateToDays(23, 6, -1), '-0001 06 23');
compare('-0001 06 24', Date_Calc::DaysToDate(1720869, "%Y %m %d"), '1720869');
compare(1720869, Date_Calc::DateToDays(24, 6, -1), '-0001 06 24');
compare('-0001 06 25', Date_Calc::DaysToDate(1720870, "%Y %m %d"), '1720870');
compare(1720870, Date_Calc::DateToDays(25, 6, -1), '-0001 06 25');
compare('-0001 06 26', Date_Calc::DaysToDate(1720871, "%Y %m %d"), '1720871');
compare(1720871, Date_Calc::DateToDays(26, 6, -1), '-0001 06 26');
compare('-0001 06 27', Date_Calc::DaysToDate(1720872, "%Y %m %d"), '1720872');
compare(1720872, Date_Calc::DateToDays(27, 6, -1), '-0001 06 27');
compare('-0001 06 28', Date_Calc::DaysToDate(1720873, "%Y %m %d"), '1720873');
compare(1720873, Date_Calc::DateToDays(28, 6, -1), '-0001 06 28');
compare('-0001 06 29', Date_Calc::DaysToDate(1720874, "%Y %m %d"), '1720874');
compare(1720874, Date_Calc::DateToDays(29, 6, -1), '-0001 06 29');
compare('-0001 06 30', Date_Calc::DaysToDate(1720875, "%Y %m %d"), '1720875');
compare(1720875, Date_Calc::DateToDays(30, 6, -1), '-0001 06 30');
compare('-0001 07 01', Date_Calc::DaysToDate(1720876, "%Y %m %d"), '1720876');
compare(1720876, Date_Calc::DateToDays(1, 7, -1), '-0001 07 01');
compare('-0001 07 02', Date_Calc::DaysToDate(1720877, "%Y %m %d"), '1720877');
compare(1720877, Date_Calc::DateToDays(2, 7, -1), '-0001 07 02');
compare('-0001 07 03', Date_Calc::DaysToDate(1720878, "%Y %m %d"), '1720878');
compare(1720878, Date_Calc::DateToDays(3, 7, -1), '-0001 07 03');
compare('-0001 07 04', Date_Calc::DaysToDate(1720879, "%Y %m %d"), '1720879');
compare(1720879, Date_Calc::DateToDays(4, 7, -1), '-0001 07 04');
compare('-0001 07 05', Date_Calc::DaysToDate(1720880, "%Y %m %d"), '1720880');
compare(1720880, Date_Calc::DateToDays(5, 7, -1), '-0001 07 05');
compare('-0001 07 06', Date_Calc::DaysToDate(1720881, "%Y %m %d"), '1720881');
compare(1720881, Date_Calc::DateToDays(6, 7, -1), '-0001 07 06');
compare('-0001 07 07', Date_Calc::DaysToDate(1720882, "%Y %m %d"), '1720882');
compare(1720882, Date_Calc::DateToDays(7, 7, -1), '-0001 07 07');
compare('-0001 07 08', Date_Calc::DaysToDate(1720883, "%Y %m %d"), '1720883');
compare(1720883, Date_Calc::DateToDays(8, 7, -1), '-0001 07 08');
compare('-0001 07 09', Date_Calc::DaysToDate(1720884, "%Y %m %d"), '1720884');
compare(1720884, Date_Calc::DateToDays(9, 7, -1), '-0001 07 09');
compare('-0001 07 10', Date_Calc::DaysToDate(1720885, "%Y %m %d"), '1720885');
compare(1720885, Date_Calc::DateToDays(10, 7, -1), '-0001 07 10');
compare('-0001 07 11', Date_Calc::DaysToDate(1720886, "%Y %m %d"), '1720886');
compare(1720886, Date_Calc::DateToDays(11, 7, -1), '-0001 07 11');
compare('-0001 07 12', Date_Calc::DaysToDate(1720887, "%Y %m %d"), '1720887');
compare(1720887, Date_Calc::DateToDays(12, 7, -1), '-0001 07 12');
compare('-0001 07 13', Date_Calc::DaysToDate(1720888, "%Y %m %d"), '1720888');
compare(1720888, Date_Calc::DateToDays(13, 7, -1), '-0001 07 13');
compare('-0001 07 14', Date_Calc::DaysToDate(1720889, "%Y %m %d"), '1720889');
compare(1720889, Date_Calc::DateToDays(14, 7, -1), '-0001 07 14');
compare('-0001 07 15', Date_Calc::DaysToDate(1720890, "%Y %m %d"), '1720890');
compare(1720890, Date_Calc::DateToDays(15, 7, -1), '-0001 07 15');
compare('-0001 07 16', Date_Calc::DaysToDate(1720891, "%Y %m %d"), '1720891');
compare(1720891, Date_Calc::DateToDays(16, 7, -1), '-0001 07 16');
compare('-0001 07 17', Date_Calc::DaysToDate(1720892, "%Y %m %d"), '1720892');
compare(1720892, Date_Calc::DateToDays(17, 7, -1), '-0001 07 17');
compare('-0001 07 18', Date_Calc::DaysToDate(1720893, "%Y %m %d"), '1720893');
compare(1720893, Date_Calc::DateToDays(18, 7, -1), '-0001 07 18');
compare('-0001 07 19', Date_Calc::DaysToDate(1720894, "%Y %m %d"), '1720894');
compare(1720894, Date_Calc::DateToDays(19, 7, -1), '-0001 07 19');
compare('-0001 07 20', Date_Calc::DaysToDate(1720895, "%Y %m %d"), '1720895');
compare(1720895, Date_Calc::DateToDays(20, 7, -1), '-0001 07 20');
compare('-0001 07 21', Date_Calc::DaysToDate(1720896, "%Y %m %d"), '1720896');
compare(1720896, Date_Calc::DateToDays(21, 7, -1), '-0001 07 21');
compare('-0001 07 22', Date_Calc::DaysToDate(1720897, "%Y %m %d"), '1720897');
compare(1720897, Date_Calc::DateToDays(22, 7, -1), '-0001 07 22');
compare('-0001 07 23', Date_Calc::DaysToDate(1720898, "%Y %m %d"), '1720898');
compare(1720898, Date_Calc::DateToDays(23, 7, -1), '-0001 07 23');
compare('-0001 07 24', Date_Calc::DaysToDate(1720899, "%Y %m %d"), '1720899');
compare(1720899, Date_Calc::DateToDays(24, 7, -1), '-0001 07 24');
compare('-0001 07 25', Date_Calc::DaysToDate(1720900, "%Y %m %d"), '1720900');
compare(1720900, Date_Calc::DateToDays(25, 7, -1), '-0001 07 25');
compare('-0001 07 26', Date_Calc::DaysToDate(1720901, "%Y %m %d"), '1720901');
compare(1720901, Date_Calc::DateToDays(26, 7, -1), '-0001 07 26');
compare('-0001 07 27', Date_Calc::DaysToDate(1720902, "%Y %m %d"), '1720902');
compare(1720902, Date_Calc::DateToDays(27, 7, -1), '-0001 07 27');
compare('-0001 07 28', Date_Calc::DaysToDate(1720903, "%Y %m %d"), '1720903');
compare(1720903, Date_Calc::DateToDays(28, 7, -1), '-0001 07 28');
compare('-0001 07 29', Date_Calc::DaysToDate(1720904, "%Y %m %d"), '1720904');
compare(1720904, Date_Calc::DateToDays(29, 7, -1), '-0001 07 29');
compare('-0001 07 30', Date_Calc::DaysToDate(1720905, "%Y %m %d"), '1720905');
compare(1720905, Date_Calc::DateToDays(30, 7, -1), '-0001 07 30');
compare('-0001 07 31', Date_Calc::DaysToDate(1720906, "%Y %m %d"), '1720906');
compare(1720906, Date_Calc::DateToDays(31, 7, -1), '-0001 07 31');
compare('-0001 08 01', Date_Calc::DaysToDate(1720907, "%Y %m %d"), '1720907');
compare(1720907, Date_Calc::DateToDays(1, 8, -1), '-0001 08 01');
compare('-0001 08 02', Date_Calc::DaysToDate(1720908, "%Y %m %d"), '1720908');
compare(1720908, Date_Calc::DateToDays(2, 8, -1), '-0001 08 02');
compare('-0001 08 03', Date_Calc::DaysToDate(1720909, "%Y %m %d"), '1720909');
compare(1720909, Date_Calc::DateToDays(3, 8, -1), '-0001 08 03');
compare('-0001 08 04', Date_Calc::DaysToDate(1720910, "%Y %m %d"), '1720910');
compare(1720910, Date_Calc::DateToDays(4, 8, -1), '-0001 08 04');
compare('-0001 08 05', Date_Calc::DaysToDate(1720911, "%Y %m %d"), '1720911');
compare(1720911, Date_Calc::DateToDays(5, 8, -1), '-0001 08 05');
compare('-0001 08 06', Date_Calc::DaysToDate(1720912, "%Y %m %d"), '1720912');
compare(1720912, Date_Calc::DateToDays(6, 8, -1), '-0001 08 06');
compare('-0001 08 07', Date_Calc::DaysToDate(1720913, "%Y %m %d"), '1720913');
compare(1720913, Date_Calc::DateToDays(7, 8, -1), '-0001 08 07');
compare('-0001 08 08', Date_Calc::DaysToDate(1720914, "%Y %m %d"), '1720914');
compare(1720914, Date_Calc::DateToDays(8, 8, -1), '-0001 08 08');
compare('-0001 08 09', Date_Calc::DaysToDate(1720915, "%Y %m %d"), '1720915');
compare(1720915, Date_Calc::DateToDays(9, 8, -1), '-0001 08 09');
compare('-0001 08 10', Date_Calc::DaysToDate(1720916, "%Y %m %d"), '1720916');
compare(1720916, Date_Calc::DateToDays(10, 8, -1), '-0001 08 10');
compare('-0001 08 11', Date_Calc::DaysToDate(1720917, "%Y %m %d"), '1720917');
compare(1720917, Date_Calc::DateToDays(11, 8, -1), '-0001 08 11');
compare('-0001 08 12', Date_Calc::DaysToDate(1720918, "%Y %m %d"), '1720918');
compare(1720918, Date_Calc::DateToDays(12, 8, -1), '-0001 08 12');
compare('-0001 08 13', Date_Calc::DaysToDate(1720919, "%Y %m %d"), '1720919');
compare(1720919, Date_Calc::DateToDays(13, 8, -1), '-0001 08 13');
compare('-0001 08 14', Date_Calc::DaysToDate(1720920, "%Y %m %d"), '1720920');
compare(1720920, Date_Calc::DateToDays(14, 8, -1), '-0001 08 14');
compare('-0001 08 15', Date_Calc::DaysToDate(1720921, "%Y %m %d"), '1720921');
compare(1720921, Date_Calc::DateToDays(15, 8, -1), '-0001 08 15');
compare('-0001 08 16', Date_Calc::DaysToDate(1720922, "%Y %m %d"), '1720922');
compare(1720922, Date_Calc::DateToDays(16, 8, -1), '-0001 08 16');
compare('-0001 08 17', Date_Calc::DaysToDate(1720923, "%Y %m %d"), '1720923');
compare(1720923, Date_Calc::DateToDays(17, 8, -1), '-0001 08 17');
compare('-0001 08 18', Date_Calc::DaysToDate(1720924, "%Y %m %d"), '1720924');
compare(1720924, Date_Calc::DateToDays(18, 8, -1), '-0001 08 18');
compare('-0001 08 19', Date_Calc::DaysToDate(1720925, "%Y %m %d"), '1720925');
compare(1720925, Date_Calc::DateToDays(19, 8, -1), '-0001 08 19');
compare('-0001 08 20', Date_Calc::DaysToDate(1720926, "%Y %m %d"), '1720926');
compare(1720926, Date_Calc::DateToDays(20, 8, -1), '-0001 08 20');
compare('-0001 08 21', Date_Calc::DaysToDate(1720927, "%Y %m %d"), '1720927');
compare(1720927, Date_Calc::DateToDays(21, 8, -1), '-0001 08 21');
compare('-0001 08 22', Date_Calc::DaysToDate(1720928, "%Y %m %d"), '1720928');
compare(1720928, Date_Calc::DateToDays(22, 8, -1), '-0001 08 22');
compare('-0001 08 23', Date_Calc::DaysToDate(1720929, "%Y %m %d"), '1720929');
compare(1720929, Date_Calc::DateToDays(23, 8, -1), '-0001 08 23');
compare('-0001 08 24', Date_Calc::DaysToDate(1720930, "%Y %m %d"), '1720930');
compare(1720930, Date_Calc::DateToDays(24, 8, -1), '-0001 08 24');
compare('-0001 08 25', Date_Calc::DaysToDate(1720931, "%Y %m %d"), '1720931');
compare(1720931, Date_Calc::DateToDays(25, 8, -1), '-0001 08 25');
compare('-0001 08 26', Date_Calc::DaysToDate(1720932, "%Y %m %d"), '1720932');
compare(1720932, Date_Calc::DateToDays(26, 8, -1), '-0001 08 26');
compare('-0001 08 27', Date_Calc::DaysToDate(1720933, "%Y %m %d"), '1720933');
compare(1720933, Date_Calc::DateToDays(27, 8, -1), '-0001 08 27');
compare('-0001 08 28', Date_Calc::DaysToDate(1720934, "%Y %m %d"), '1720934');
compare(1720934, Date_Calc::DateToDays(28, 8, -1), '-0001 08 28');
compare('-0001 08 29', Date_Calc::DaysToDate(1720935, "%Y %m %d"), '1720935');
compare(1720935, Date_Calc::DateToDays(29, 8, -1), '-0001 08 29');
compare('-0001 08 30', Date_Calc::DaysToDate(1720936, "%Y %m %d"), '1720936');
compare(1720936, Date_Calc::DateToDays(30, 8, -1), '-0001 08 30');
compare('-0001 08 31', Date_Calc::DaysToDate(1720937, "%Y %m %d"), '1720937');
compare(1720937, Date_Calc::DateToDays(31, 8, -1), '-0001 08 31');
compare('-0001 09 01', Date_Calc::DaysToDate(1720938, "%Y %m %d"), '1720938');
compare(1720938, Date_Calc::DateToDays(1, 9, -1), '-0001 09 01');
compare('-0001 09 02', Date_Calc::DaysToDate(1720939, "%Y %m %d"), '1720939');
compare(1720939, Date_Calc::DateToDays(2, 9, -1), '-0001 09 02');
compare('-0001 09 03', Date_Calc::DaysToDate(1720940, "%Y %m %d"), '1720940');
compare(1720940, Date_Calc::DateToDays(3, 9, -1), '-0001 09 03');
compare('-0001 09 04', Date_Calc::DaysToDate(1720941, "%Y %m %d"), '1720941');
compare(1720941, Date_Calc::DateToDays(4, 9, -1), '-0001 09 04');
compare('-0001 09 05', Date_Calc::DaysToDate(1720942, "%Y %m %d"), '1720942');
compare(1720942, Date_Calc::DateToDays(5, 9, -1), '-0001 09 05');
compare('-0001 09 06', Date_Calc::DaysToDate(1720943, "%Y %m %d"), '1720943');
compare(1720943, Date_Calc::DateToDays(6, 9, -1), '-0001 09 06');
compare('-0001 09 07', Date_Calc::DaysToDate(1720944, "%Y %m %d"), '1720944');
compare(1720944, Date_Calc::DateToDays(7, 9, -1), '-0001 09 07');
compare('-0001 09 08', Date_Calc::DaysToDate(1720945, "%Y %m %d"), '1720945');
compare(1720945, Date_Calc::DateToDays(8, 9, -1), '-0001 09 08');
compare('-0001 09 09', Date_Calc::DaysToDate(1720946, "%Y %m %d"), '1720946');
compare(1720946, Date_Calc::DateToDays(9, 9, -1), '-0001 09 09');
compare('-0001 09 10', Date_Calc::DaysToDate(1720947, "%Y %m %d"), '1720947');
compare(1720947, Date_Calc::DateToDays(10, 9, -1), '-0001 09 10');
compare('-0001 09 11', Date_Calc::DaysToDate(1720948, "%Y %m %d"), '1720948');
compare(1720948, Date_Calc::DateToDays(11, 9, -1), '-0001 09 11');
compare('-0001 09 12', Date_Calc::DaysToDate(1720949, "%Y %m %d"), '1720949');
compare(1720949, Date_Calc::DateToDays(12, 9, -1), '-0001 09 12');
compare('-0001 09 13', Date_Calc::DaysToDate(1720950, "%Y %m %d"), '1720950');
compare(1720950, Date_Calc::DateToDays(13, 9, -1), '-0001 09 13');
compare('-0001 09 14', Date_Calc::DaysToDate(1720951, "%Y %m %d"), '1720951');
compare(1720951, Date_Calc::DateToDays(14, 9, -1), '-0001 09 14');
compare('-0001 09 15', Date_Calc::DaysToDate(1720952, "%Y %m %d"), '1720952');
compare(1720952, Date_Calc::DateToDays(15, 9, -1), '-0001 09 15');
compare('-0001 09 16', Date_Calc::DaysToDate(1720953, "%Y %m %d"), '1720953');
compare(1720953, Date_Calc::DateToDays(16, 9, -1), '-0001 09 16');
compare('-0001 09 17', Date_Calc::DaysToDate(1720954, "%Y %m %d"), '1720954');
compare(1720954, Date_Calc::DateToDays(17, 9, -1), '-0001 09 17');
compare('-0001 09 18', Date_Calc::DaysToDate(1720955, "%Y %m %d"), '1720955');
compare(1720955, Date_Calc::DateToDays(18, 9, -1), '-0001 09 18');
compare('-0001 09 19', Date_Calc::DaysToDate(1720956, "%Y %m %d"), '1720956');
compare(1720956, Date_Calc::DateToDays(19, 9, -1), '-0001 09 19');
compare('-0001 09 20', Date_Calc::DaysToDate(1720957, "%Y %m %d"), '1720957');
compare(1720957, Date_Calc::DateToDays(20, 9, -1), '-0001 09 20');
compare('-0001 09 21', Date_Calc::DaysToDate(1720958, "%Y %m %d"), '1720958');
compare(1720958, Date_Calc::DateToDays(21, 9, -1), '-0001 09 21');
compare('-0001 09 22', Date_Calc::DaysToDate(1720959, "%Y %m %d"), '1720959');
compare(1720959, Date_Calc::DateToDays(22, 9, -1), '-0001 09 22');
compare('-0001 09 23', Date_Calc::DaysToDate(1720960, "%Y %m %d"), '1720960');
compare(1720960, Date_Calc::DateToDays(23, 9, -1), '-0001 09 23');
compare('-0001 09 24', Date_Calc::DaysToDate(1720961, "%Y %m %d"), '1720961');
compare(1720961, Date_Calc::DateToDays(24, 9, -1), '-0001 09 24');
compare('-0001 09 25', Date_Calc::DaysToDate(1720962, "%Y %m %d"), '1720962');
compare(1720962, Date_Calc::DateToDays(25, 9, -1), '-0001 09 25');
compare('-0001 09 26', Date_Calc::DaysToDate(1720963, "%Y %m %d"), '1720963');
compare(1720963, Date_Calc::DateToDays(26, 9, -1), '-0001 09 26');
compare('-0001 09 27', Date_Calc::DaysToDate(1720964, "%Y %m %d"), '1720964');
compare(1720964, Date_Calc::DateToDays(27, 9, -1), '-0001 09 27');
compare('-0001 09 28', Date_Calc::DaysToDate(1720965, "%Y %m %d"), '1720965');
compare(1720965, Date_Calc::DateToDays(28, 9, -1), '-0001 09 28');
compare('-0001 09 29', Date_Calc::DaysToDate(1720966, "%Y %m %d"), '1720966');
compare(1720966, Date_Calc::DateToDays(29, 9, -1), '-0001 09 29');
compare('-0001 09 30', Date_Calc::DaysToDate(1720967, "%Y %m %d"), '1720967');
compare(1720967, Date_Calc::DateToDays(30, 9, -1), '-0001 09 30');
compare('-0001 10 01', Date_Calc::DaysToDate(1720968, "%Y %m %d"), '1720968');
compare(1720968, Date_Calc::DateToDays(1, 10, -1), '-0001 10 01');
compare('-0001 10 02', Date_Calc::DaysToDate(1720969, "%Y %m %d"), '1720969');
compare(1720969, Date_Calc::DateToDays(2, 10, -1), '-0001 10 02');
compare('-0001 10 03', Date_Calc::DaysToDate(1720970, "%Y %m %d"), '1720970');
compare(1720970, Date_Calc::DateToDays(3, 10, -1), '-0001 10 03');
compare('-0001 10 04', Date_Calc::DaysToDate(1720971, "%Y %m %d"), '1720971');
compare(1720971, Date_Calc::DateToDays(4, 10, -1), '-0001 10 04');
compare('-0001 10 05', Date_Calc::DaysToDate(1720972, "%Y %m %d"), '1720972');
compare(1720972, Date_Calc::DateToDays(5, 10, -1), '-0001 10 05');
compare('-0001 10 06', Date_Calc::DaysToDate(1720973, "%Y %m %d"), '1720973');
compare(1720973, Date_Calc::DateToDays(6, 10, -1), '-0001 10 06');
compare('-0001 10 07', Date_Calc::DaysToDate(1720974, "%Y %m %d"), '1720974');
compare(1720974, Date_Calc::DateToDays(7, 10, -1), '-0001 10 07');
compare('-0001 10 08', Date_Calc::DaysToDate(1720975, "%Y %m %d"), '1720975');
compare(1720975, Date_Calc::DateToDays(8, 10, -1), '-0001 10 08');
compare('-0001 10 09', Date_Calc::DaysToDate(1720976, "%Y %m %d"), '1720976');
compare(1720976, Date_Calc::DateToDays(9, 10, -1), '-0001 10 09');
compare('-0001 10 10', Date_Calc::DaysToDate(1720977, "%Y %m %d"), '1720977');
compare(1720977, Date_Calc::DateToDays(10, 10, -1), '-0001 10 10');
compare('-0001 10 11', Date_Calc::DaysToDate(1720978, "%Y %m %d"), '1720978');
compare(1720978, Date_Calc::DateToDays(11, 10, -1), '-0001 10 11');
compare('-0001 10 12', Date_Calc::DaysToDate(1720979, "%Y %m %d"), '1720979');
compare(1720979, Date_Calc::DateToDays(12, 10, -1), '-0001 10 12');
compare('-0001 10 13', Date_Calc::DaysToDate(1720980, "%Y %m %d"), '1720980');
compare(1720980, Date_Calc::DateToDays(13, 10, -1), '-0001 10 13');
compare('-0001 10 14', Date_Calc::DaysToDate(1720981, "%Y %m %d"), '1720981');
compare(1720981, Date_Calc::DateToDays(14, 10, -1), '-0001 10 14');
compare('-0001 10 15', Date_Calc::DaysToDate(1720982, "%Y %m %d"), '1720982');
compare(1720982, Date_Calc::DateToDays(15, 10, -1), '-0001 10 15');
compare('-0001 10 16', Date_Calc::DaysToDate(1720983, "%Y %m %d"), '1720983');
compare(1720983, Date_Calc::DateToDays(16, 10, -1), '-0001 10 16');
compare('-0001 10 17', Date_Calc::DaysToDate(1720984, "%Y %m %d"), '1720984');
compare(1720984, Date_Calc::DateToDays(17, 10, -1), '-0001 10 17');
compare('-0001 10 18', Date_Calc::DaysToDate(1720985, "%Y %m %d"), '1720985');
compare(1720985, Date_Calc::DateToDays(18, 10, -1), '-0001 10 18');
compare('-0001 10 19', Date_Calc::DaysToDate(1720986, "%Y %m %d"), '1720986');
compare(1720986, Date_Calc::DateToDays(19, 10, -1), '-0001 10 19');
compare('-0001 10 20', Date_Calc::DaysToDate(1720987, "%Y %m %d"), '1720987');
compare(1720987, Date_Calc::DateToDays(20, 10, -1), '-0001 10 20');
compare('-0001 10 21', Date_Calc::DaysToDate(1720988, "%Y %m %d"), '1720988');
compare(1720988, Date_Calc::DateToDays(21, 10, -1), '-0001 10 21');
compare('-0001 10 22', Date_Calc::DaysToDate(1720989, "%Y %m %d"), '1720989');
compare(1720989, Date_Calc::DateToDays(22, 10, -1), '-0001 10 22');
compare('-0001 10 23', Date_Calc::DaysToDate(1720990, "%Y %m %d"), '1720990');
compare(1720990, Date_Calc::DateToDays(23, 10, -1), '-0001 10 23');
compare('-0001 10 24', Date_Calc::DaysToDate(1720991, "%Y %m %d"), '1720991');
compare(1720991, Date_Calc::DateToDays(24, 10, -1), '-0001 10 24');
compare('-0001 10 25', Date_Calc::DaysToDate(1720992, "%Y %m %d"), '1720992');
compare(1720992, Date_Calc::DateToDays(25, 10, -1), '-0001 10 25');
compare('-0001 10 26', Date_Calc::DaysToDate(1720993, "%Y %m %d"), '1720993');
compare(1720993, Date_Calc::DateToDays(26, 10, -1), '-0001 10 26');
compare('-0001 10 27', Date_Calc::DaysToDate(1720994, "%Y %m %d"), '1720994');
compare(1720994, Date_Calc::DateToDays(27, 10, -1), '-0001 10 27');
compare('-0001 10 28', Date_Calc::DaysToDate(1720995, "%Y %m %d"), '1720995');
compare(1720995, Date_Calc::DateToDays(28, 10, -1), '-0001 10 28');
compare('-0001 10 29', Date_Calc::DaysToDate(1720996, "%Y %m %d"), '1720996');
compare(1720996, Date_Calc::DateToDays(29, 10, -1), '-0001 10 29');
compare('-0001 10 30', Date_Calc::DaysToDate(1720997, "%Y %m %d"), '1720997');
compare(1720997, Date_Calc::DateToDays(30, 10, -1), '-0001 10 30');
compare('-0001 10 31', Date_Calc::DaysToDate(1720998, "%Y %m %d"), '1720998');
compare(1720998, Date_Calc::DateToDays(31, 10, -1), '-0001 10 31');
compare('-0001 11 01', Date_Calc::DaysToDate(1720999, "%Y %m %d"), '1720999');
compare(1720999, Date_Calc::DateToDays(1, 11, -1), '-0001 11 01');
compare('-0001 11 02', Date_Calc::DaysToDate(1721000, "%Y %m %d"), '1721000');
compare(1721000, Date_Calc::DateToDays(2, 11, -1), '-0001 11 02');
compare('-0001 11 03', Date_Calc::DaysToDate(1721001, "%Y %m %d"), '1721001');
compare(1721001, Date_Calc::DateToDays(3, 11, -1), '-0001 11 03');
compare('-0001 11 04', Date_Calc::DaysToDate(1721002, "%Y %m %d"), '1721002');
compare(1721002, Date_Calc::DateToDays(4, 11, -1), '-0001 11 04');
compare('-0001 11 05', Date_Calc::DaysToDate(1721003, "%Y %m %d"), '1721003');
compare(1721003, Date_Calc::DateToDays(5, 11, -1), '-0001 11 05');
compare('-0001 11 06', Date_Calc::DaysToDate(1721004, "%Y %m %d"), '1721004');
compare(1721004, Date_Calc::DateToDays(6, 11, -1), '-0001 11 06');
compare('-0001 11 07', Date_Calc::DaysToDate(1721005, "%Y %m %d"), '1721005');
compare(1721005, Date_Calc::DateToDays(7, 11, -1), '-0001 11 07');
compare('-0001 11 08', Date_Calc::DaysToDate(1721006, "%Y %m %d"), '1721006');
compare(1721006, Date_Calc::DateToDays(8, 11, -1), '-0001 11 08');
compare('-0001 11 09', Date_Calc::DaysToDate(1721007, "%Y %m %d"), '1721007');
compare(1721007, Date_Calc::DateToDays(9, 11, -1), '-0001 11 09');
compare('-0001 11 10', Date_Calc::DaysToDate(1721008, "%Y %m %d"), '1721008');
compare(1721008, Date_Calc::DateToDays(10, 11, -1), '-0001 11 10');
compare('-0001 11 11', Date_Calc::DaysToDate(1721009, "%Y %m %d"), '1721009');
compare(1721009, Date_Calc::DateToDays(11, 11, -1), '-0001 11 11');
compare('-0001 11 12', Date_Calc::DaysToDate(1721010, "%Y %m %d"), '1721010');
compare(1721010, Date_Calc::DateToDays(12, 11, -1), '-0001 11 12');
compare('-0001 11 13', Date_Calc::DaysToDate(1721011, "%Y %m %d"), '1721011');
compare(1721011, Date_Calc::DateToDays(13, 11, -1), '-0001 11 13');
compare('-0001 11 14', Date_Calc::DaysToDate(1721012, "%Y %m %d"), '1721012');
compare(1721012, Date_Calc::DateToDays(14, 11, -1), '-0001 11 14');
compare('-0001 11 15', Date_Calc::DaysToDate(1721013, "%Y %m %d"), '1721013');
compare(1721013, Date_Calc::DateToDays(15, 11, -1), '-0001 11 15');
compare('-0001 11 16', Date_Calc::DaysToDate(1721014, "%Y %m %d"), '1721014');
compare(1721014, Date_Calc::DateToDays(16, 11, -1), '-0001 11 16');
compare('-0001 11 17', Date_Calc::DaysToDate(1721015, "%Y %m %d"), '1721015');
compare(1721015, Date_Calc::DateToDays(17, 11, -1), '-0001 11 17');
compare('-0001 11 18', Date_Calc::DaysToDate(1721016, "%Y %m %d"), '1721016');
compare(1721016, Date_Calc::DateToDays(18, 11, -1), '-0001 11 18');
compare('-0001 11 19', Date_Calc::DaysToDate(1721017, "%Y %m %d"), '1721017');
compare(1721017, Date_Calc::DateToDays(19, 11, -1), '-0001 11 19');
compare('-0001 11 20', Date_Calc::DaysToDate(1721018, "%Y %m %d"), '1721018');
compare(1721018, Date_Calc::DateToDays(20, 11, -1), '-0001 11 20');
compare('-0001 11 21', Date_Calc::DaysToDate(1721019, "%Y %m %d"), '1721019');
compare(1721019, Date_Calc::DateToDays(21, 11, -1), '-0001 11 21');
compare('-0001 11 22', Date_Calc::DaysToDate(1721020, "%Y %m %d"), '1721020');
compare(1721020, Date_Calc::DateToDays(22, 11, -1), '-0001 11 22');
compare('-0001 11 23', Date_Calc::DaysToDate(1721021, "%Y %m %d"), '1721021');
compare(1721021, Date_Calc::DateToDays(23, 11, -1), '-0001 11 23');
compare('-0001 11 24', Date_Calc::DaysToDate(1721022, "%Y %m %d"), '1721022');
compare(1721022, Date_Calc::DateToDays(24, 11, -1), '-0001 11 24');
compare('-0001 11 25', Date_Calc::DaysToDate(1721023, "%Y %m %d"), '1721023');
compare(1721023, Date_Calc::DateToDays(25, 11, -1), '-0001 11 25');
compare('-0001 11 26', Date_Calc::DaysToDate(1721024, "%Y %m %d"), '1721024');
compare(1721024, Date_Calc::DateToDays(26, 11, -1), '-0001 11 26');
compare('-0001 11 27', Date_Calc::DaysToDate(1721025, "%Y %m %d"), '1721025');
compare(1721025, Date_Calc::DateToDays(27, 11, -1), '-0001 11 27');
compare('-0001 11 28', Date_Calc::DaysToDate(1721026, "%Y %m %d"), '1721026');
compare(1721026, Date_Calc::DateToDays(28, 11, -1), '-0001 11 28');
compare('-0001 11 29', Date_Calc::DaysToDate(1721027, "%Y %m %d"), '1721027');
compare(1721027, Date_Calc::DateToDays(29, 11, -1), '-0001 11 29');
compare('-0001 11 30', Date_Calc::DaysToDate(1721028, "%Y %m %d"), '1721028');
compare(1721028, Date_Calc::DateToDays(30, 11, -1), '-0001 11 30');
compare('-0001 12 01', Date_Calc::DaysToDate(1721029, "%Y %m %d"), '1721029');
compare(1721029, Date_Calc::DateToDays(1, 12, -1), '-0001 12 01');
compare('-0001 12 02', Date_Calc::DaysToDate(1721030, "%Y %m %d"), '1721030');
compare(1721030, Date_Calc::DateToDays(2, 12, -1), '-0001 12 02');
compare('-0001 12 03', Date_Calc::DaysToDate(1721031, "%Y %m %d"), '1721031');
compare(1721031, Date_Calc::DateToDays(3, 12, -1), '-0001 12 03');
compare('-0001 12 04', Date_Calc::DaysToDate(1721032, "%Y %m %d"), '1721032');
compare(1721032, Date_Calc::DateToDays(4, 12, -1), '-0001 12 04');
compare('-0001 12 05', Date_Calc::DaysToDate(1721033, "%Y %m %d"), '1721033');
compare(1721033, Date_Calc::DateToDays(5, 12, -1), '-0001 12 05');
compare('-0001 12 06', Date_Calc::DaysToDate(1721034, "%Y %m %d"), '1721034');
compare(1721034, Date_Calc::DateToDays(6, 12, -1), '-0001 12 06');
compare('-0001 12 07', Date_Calc::DaysToDate(1721035, "%Y %m %d"), '1721035');
compare(1721035, Date_Calc::DateToDays(7, 12, -1), '-0001 12 07');
compare('-0001 12 08', Date_Calc::DaysToDate(1721036, "%Y %m %d"), '1721036');
compare(1721036, Date_Calc::DateToDays(8, 12, -1), '-0001 12 08');
compare('-0001 12 09', Date_Calc::DaysToDate(1721037, "%Y %m %d"), '1721037');
compare(1721037, Date_Calc::DateToDays(9, 12, -1), '-0001 12 09');
compare('-0001 12 10', Date_Calc::DaysToDate(1721038, "%Y %m %d"), '1721038');
compare(1721038, Date_Calc::DateToDays(10, 12, -1), '-0001 12 10');
compare('-0001 12 11', Date_Calc::DaysToDate(1721039, "%Y %m %d"), '1721039');
compare(1721039, Date_Calc::DateToDays(11, 12, -1), '-0001 12 11');
compare('-0001 12 12', Date_Calc::DaysToDate(1721040, "%Y %m %d"), '1721040');
compare(1721040, Date_Calc::DateToDays(12, 12, -1), '-0001 12 12');
compare('-0001 12 13', Date_Calc::DaysToDate(1721041, "%Y %m %d"), '1721041');
compare(1721041, Date_Calc::DateToDays(13, 12, -1), '-0001 12 13');
compare('-0001 12 14', Date_Calc::DaysToDate(1721042, "%Y %m %d"), '1721042');
compare(1721042, Date_Calc::DateToDays(14, 12, -1), '-0001 12 14');
compare('-0001 12 15', Date_Calc::DaysToDate(1721043, "%Y %m %d"), '1721043');
compare(1721043, Date_Calc::DateToDays(15, 12, -1), '-0001 12 15');
compare('-0001 12 16', Date_Calc::DaysToDate(1721044, "%Y %m %d"), '1721044');
compare(1721044, Date_Calc::DateToDays(16, 12, -1), '-0001 12 16');
compare('-0001 12 17', Date_Calc::DaysToDate(1721045, "%Y %m %d"), '1721045');
compare(1721045, Date_Calc::DateToDays(17, 12, -1), '-0001 12 17');
compare('-0001 12 18', Date_Calc::DaysToDate(1721046, "%Y %m %d"), '1721046');
compare(1721046, Date_Calc::DateToDays(18, 12, -1), '-0001 12 18');
compare('-0001 12 19', Date_Calc::DaysToDate(1721047, "%Y %m %d"), '1721047');
compare(1721047, Date_Calc::DateToDays(19, 12, -1), '-0001 12 19');
compare('-0001 12 20', Date_Calc::DaysToDate(1721048, "%Y %m %d"), '1721048');
compare(1721048, Date_Calc::DateToDays(20, 12, -1), '-0001 12 20');
compare('-0001 12 21', Date_Calc::DaysToDate(1721049, "%Y %m %d"), '1721049');
compare(1721049, Date_Calc::DateToDays(21, 12, -1), '-0001 12 21');
compare('-0001 12 22', Date_Calc::DaysToDate(1721050, "%Y %m %d"), '1721050');
compare(1721050, Date_Calc::DateToDays(22, 12, -1), '-0001 12 22');
compare('-0001 12 23', Date_Calc::DaysToDate(1721051, "%Y %m %d"), '1721051');
compare(1721051, Date_Calc::DateToDays(23, 12, -1), '-0001 12 23');
compare('-0001 12 24', Date_Calc::DaysToDate(1721052, "%Y %m %d"), '1721052');
compare(1721052, Date_Calc::DateToDays(24, 12, -1), '-0001 12 24');
compare('-0001 12 25', Date_Calc::DaysToDate(1721053, "%Y %m %d"), '1721053');
compare(1721053, Date_Calc::DateToDays(25, 12, -1), '-0001 12 25');
compare('-0001 12 26', Date_Calc::DaysToDate(1721054, "%Y %m %d"), '1721054');
compare(1721054, Date_Calc::DateToDays(26, 12, -1), '-0001 12 26');
compare('-0001 12 27', Date_Calc::DaysToDate(1721055, "%Y %m %d"), '1721055');
compare(1721055, Date_Calc::DateToDays(27, 12, -1), '-0001 12 27');
compare('-0001 12 28', Date_Calc::DaysToDate(1721056, "%Y %m %d"), '1721056');
compare(1721056, Date_Calc::DateToDays(28, 12, -1), '-0001 12 28');
compare('-0001 12 29', Date_Calc::DaysToDate(1721057, "%Y %m %d"), '1721057');
compare(1721057, Date_Calc::DateToDays(29, 12, -1), '-0001 12 29');
compare('-0001 12 30', Date_Calc::DaysToDate(1721058, "%Y %m %d"), '1721058');
compare(1721058, Date_Calc::DateToDays(30, 12, -1), '-0001 12 30');
compare('-0001 12 31', Date_Calc::DaysToDate(1721059, "%Y %m %d"), '1721059');
compare(1721059, Date_Calc::DateToDays(31, 12, -1), '-0001 12 31');
compare('0000 01 01', Date_Calc::DaysToDate(1721060, "%Y %m %d"), '1721060');
compare(1721060, Date_Calc::DateToDays(1, 1, 0), '0000 01 01');
compare('0000 01 02', Date_Calc::DaysToDate(1721061, "%Y %m %d"), '1721061');
compare(1721061, Date_Calc::DateToDays(2, 1, 0), '0000 01 02');
compare('0000 01 03', Date_Calc::DaysToDate(1721062, "%Y %m %d"), '1721062');
compare(1721062, Date_Calc::DateToDays(3, 1, 0), '0000 01 03');
compare('0000 01 04', Date_Calc::DaysToDate(1721063, "%Y %m %d"), '1721063');
compare(1721063, Date_Calc::DateToDays(4, 1, 0), '0000 01 04');
compare('0000 01 05', Date_Calc::DaysToDate(1721064, "%Y %m %d"), '1721064');
compare(1721064, Date_Calc::DateToDays(5, 1, 0), '0000 01 05');
compare('0000 01 06', Date_Calc::DaysToDate(1721065, "%Y %m %d"), '1721065');
compare(1721065, Date_Calc::DateToDays(6, 1, 0), '0000 01 06');
compare('0000 01 07', Date_Calc::DaysToDate(1721066, "%Y %m %d"), '1721066');
compare(1721066, Date_Calc::DateToDays(7, 1, 0), '0000 01 07');
compare('0000 01 08', Date_Calc::DaysToDate(1721067, "%Y %m %d"), '1721067');
compare(1721067, Date_Calc::DateToDays(8, 1, 0), '0000 01 08');
compare('0000 01 09', Date_Calc::DaysToDate(1721068, "%Y %m %d"), '1721068');
compare(1721068, Date_Calc::DateToDays(9, 1, 0), '0000 01 09');
compare('0000 01 10', Date_Calc::DaysToDate(1721069, "%Y %m %d"), '1721069');
compare(1721069, Date_Calc::DateToDays(10, 1, 0), '0000 01 10');
compare('0000 01 11', Date_Calc::DaysToDate(1721070, "%Y %m %d"), '1721070');
compare(1721070, Date_Calc::DateToDays(11, 1, 0), '0000 01 11');
compare('0000 01 12', Date_Calc::DaysToDate(1721071, "%Y %m %d"), '1721071');
compare(1721071, Date_Calc::DateToDays(12, 1, 0), '0000 01 12');
compare('0000 01 13', Date_Calc::DaysToDate(1721072, "%Y %m %d"), '1721072');
compare(1721072, Date_Calc::DateToDays(13, 1, 0), '0000 01 13');
compare('0000 01 14', Date_Calc::DaysToDate(1721073, "%Y %m %d"), '1721073');
compare(1721073, Date_Calc::DateToDays(14, 1, 0), '0000 01 14');
compare('0000 01 15', Date_Calc::DaysToDate(1721074, "%Y %m %d"), '1721074');
compare(1721074, Date_Calc::DateToDays(15, 1, 0), '0000 01 15');
compare('0000 01 16', Date_Calc::DaysToDate(1721075, "%Y %m %d"), '1721075');
compare(1721075, Date_Calc::DateToDays(16, 1, 0), '0000 01 16');
compare('0000 01 17', Date_Calc::DaysToDate(1721076, "%Y %m %d"), '1721076');
compare(1721076, Date_Calc::DateToDays(17, 1, 0), '0000 01 17');
compare('0000 01 18', Date_Calc::DaysToDate(1721077, "%Y %m %d"), '1721077');
compare(1721077, Date_Calc::DateToDays(18, 1, 0), '0000 01 18');
compare('0000 01 19', Date_Calc::DaysToDate(1721078, "%Y %m %d"), '1721078');
compare(1721078, Date_Calc::DateToDays(19, 1, 0), '0000 01 19');
compare('0000 01 20', Date_Calc::DaysToDate(1721079, "%Y %m %d"), '1721079');
compare(1721079, Date_Calc::DateToDays(20, 1, 0), '0000 01 20');
compare('0000 01 21', Date_Calc::DaysToDate(1721080, "%Y %m %d"), '1721080');
compare(1721080, Date_Calc::DateToDays(21, 1, 0), '0000 01 21');
compare('0000 01 22', Date_Calc::DaysToDate(1721081, "%Y %m %d"), '1721081');
compare(1721081, Date_Calc::DateToDays(22, 1, 0), '0000 01 22');
compare('0000 01 23', Date_Calc::DaysToDate(1721082, "%Y %m %d"), '1721082');
compare(1721082, Date_Calc::DateToDays(23, 1, 0), '0000 01 23');
compare('0000 01 24', Date_Calc::DaysToDate(1721083, "%Y %m %d"), '1721083');
compare(1721083, Date_Calc::DateToDays(24, 1, 0), '0000 01 24');
compare('0000 01 25', Date_Calc::DaysToDate(1721084, "%Y %m %d"), '1721084');
compare(1721084, Date_Calc::DateToDays(25, 1, 0), '0000 01 25');
compare('0000 01 26', Date_Calc::DaysToDate(1721085, "%Y %m %d"), '1721085');
compare(1721085, Date_Calc::DateToDays(26, 1, 0), '0000 01 26');
compare('0000 01 27', Date_Calc::DaysToDate(1721086, "%Y %m %d"), '1721086');
compare(1721086, Date_Calc::DateToDays(27, 1, 0), '0000 01 27');
compare('0000 01 28', Date_Calc::DaysToDate(1721087, "%Y %m %d"), '1721087');
compare(1721087, Date_Calc::DateToDays(28, 1, 0), '0000 01 28');
compare('0000 01 29', Date_Calc::DaysToDate(1721088, "%Y %m %d"), '1721088');
compare(1721088, Date_Calc::DateToDays(29, 1, 0), '0000 01 29');
compare('0000 01 30', Date_Calc::DaysToDate(1721089, "%Y %m %d"), '1721089');
compare(1721089, Date_Calc::DateToDays(30, 1, 0), '0000 01 30');
compare('0000 01 31', Date_Calc::DaysToDate(1721090, "%Y %m %d"), '1721090');
compare(1721090, Date_Calc::DateToDays(31, 1, 0), '0000 01 31');
compare('0000 02 01', Date_Calc::DaysToDate(1721091, "%Y %m %d"), '1721091');
compare(1721091, Date_Calc::DateToDays(1, 2, 0), '0000 02 01');
compare('0000 02 02', Date_Calc::DaysToDate(1721092, "%Y %m %d"), '1721092');
compare(1721092, Date_Calc::DateToDays(2, 2, 0), '0000 02 02');
compare('0000 02 03', Date_Calc::DaysToDate(1721093, "%Y %m %d"), '1721093');
compare(1721093, Date_Calc::DateToDays(3, 2, 0), '0000 02 03');
compare('0000 02 04', Date_Calc::DaysToDate(1721094, "%Y %m %d"), '1721094');
compare(1721094, Date_Calc::DateToDays(4, 2, 0), '0000 02 04');
compare('0000 02 05', Date_Calc::DaysToDate(1721095, "%Y %m %d"), '1721095');
compare(1721095, Date_Calc::DateToDays(5, 2, 0), '0000 02 05');
compare('0000 02 06', Date_Calc::DaysToDate(1721096, "%Y %m %d"), '1721096');
compare(1721096, Date_Calc::DateToDays(6, 2, 0), '0000 02 06');
compare('0000 02 07', Date_Calc::DaysToDate(1721097, "%Y %m %d"), '1721097');
compare(1721097, Date_Calc::DateToDays(7, 2, 0), '0000 02 07');
compare('0000 02 08', Date_Calc::DaysToDate(1721098, "%Y %m %d"), '1721098');
compare(1721098, Date_Calc::DateToDays(8, 2, 0), '0000 02 08');
compare('0000 02 09', Date_Calc::DaysToDate(1721099, "%Y %m %d"), '1721099');
compare(1721099, Date_Calc::DateToDays(9, 2, 0), '0000 02 09');
compare('0000 02 10', Date_Calc::DaysToDate(1721100, "%Y %m %d"), '1721100');
compare(1721100, Date_Calc::DateToDays(10, 2, 0), '0000 02 10');
compare('0000 02 11', Date_Calc::DaysToDate(1721101, "%Y %m %d"), '1721101');
compare(1721101, Date_Calc::DateToDays(11, 2, 0), '0000 02 11');
compare('0000 02 12', Date_Calc::DaysToDate(1721102, "%Y %m %d"), '1721102');
compare(1721102, Date_Calc::DateToDays(12, 2, 0), '0000 02 12');
compare('0000 02 13', Date_Calc::DaysToDate(1721103, "%Y %m %d"), '1721103');
compare(1721103, Date_Calc::DateToDays(13, 2, 0), '0000 02 13');
compare('0000 02 14', Date_Calc::DaysToDate(1721104, "%Y %m %d"), '1721104');
compare(1721104, Date_Calc::DateToDays(14, 2, 0), '0000 02 14');
compare('0000 02 15', Date_Calc::DaysToDate(1721105, "%Y %m %d"), '1721105');
compare(1721105, Date_Calc::DateToDays(15, 2, 0), '0000 02 15');
compare('0000 02 16', Date_Calc::DaysToDate(1721106, "%Y %m %d"), '1721106');
compare(1721106, Date_Calc::DateToDays(16, 2, 0), '0000 02 16');
compare('0000 02 17', Date_Calc::DaysToDate(1721107, "%Y %m %d"), '1721107');
compare(1721107, Date_Calc::DateToDays(17, 2, 0), '0000 02 17');
compare('0000 02 18', Date_Calc::DaysToDate(1721108, "%Y %m %d"), '1721108');
compare(1721108, Date_Calc::DateToDays(18, 2, 0), '0000 02 18');
compare('0000 02 19', Date_Calc::DaysToDate(1721109, "%Y %m %d"), '1721109');
compare(1721109, Date_Calc::DateToDays(19, 2, 0), '0000 02 19');
compare('0000 02 20', Date_Calc::DaysToDate(1721110, "%Y %m %d"), '1721110');
compare(1721110, Date_Calc::DateToDays(20, 2, 0), '0000 02 20');
compare('0000 02 21', Date_Calc::DaysToDate(1721111, "%Y %m %d"), '1721111');
compare(1721111, Date_Calc::DateToDays(21, 2, 0), '0000 02 21');
compare('0000 02 22', Date_Calc::DaysToDate(1721112, "%Y %m %d"), '1721112');
compare(1721112, Date_Calc::DateToDays(22, 2, 0), '0000 02 22');
compare('0000 02 23', Date_Calc::DaysToDate(1721113, "%Y %m %d"), '1721113');
compare(1721113, Date_Calc::DateToDays(23, 2, 0), '0000 02 23');
compare('0000 02 24', Date_Calc::DaysToDate(1721114, "%Y %m %d"), '1721114');
compare(1721114, Date_Calc::DateToDays(24, 2, 0), '0000 02 24');
compare('0000 02 25', Date_Calc::DaysToDate(1721115, "%Y %m %d"), '1721115');
compare(1721115, Date_Calc::DateToDays(25, 2, 0), '0000 02 25');
compare('0000 02 26', Date_Calc::DaysToDate(1721116, "%Y %m %d"), '1721116');
compare(1721116, Date_Calc::DateToDays(26, 2, 0), '0000 02 26');
compare('0000 02 27', Date_Calc::DaysToDate(1721117, "%Y %m %d"), '1721117');
compare(1721117, Date_Calc::DateToDays(27, 2, 0), '0000 02 27');
compare('0000 02 28', Date_Calc::DaysToDate(1721118, "%Y %m %d"), '1721118');
compare(1721118, Date_Calc::DateToDays(28, 2, 0), '0000 02 28');
compare('0000 02 29', Date_Calc::DaysToDate(1721119, "%Y %m %d"), '1721119');
compare(1721119, Date_Calc::DateToDays(29, 2, 0), '0000 02 29');
compare('0000 03 01', Date_Calc::DaysToDate(1721120, "%Y %m %d"), '1721120');
compare(1721120, Date_Calc::DateToDays(1, 3, 0), '0000 03 01');
compare('0000 03 02', Date_Calc::DaysToDate(1721121, "%Y %m %d"), '1721121');
compare(1721121, Date_Calc::DateToDays(2, 3, 0), '0000 03 02');
compare('0000 03 03', Date_Calc::DaysToDate(1721122, "%Y %m %d"), '1721122');
compare(1721122, Date_Calc::DateToDays(3, 3, 0), '0000 03 03');
compare('0000 03 04', Date_Calc::DaysToDate(1721123, "%Y %m %d"), '1721123');
compare(1721123, Date_Calc::DateToDays(4, 3, 0), '0000 03 04');
compare('0000 03 05', Date_Calc::DaysToDate(1721124, "%Y %m %d"), '1721124');
compare(1721124, Date_Calc::DateToDays(5, 3, 0), '0000 03 05');
compare('0000 03 06', Date_Calc::DaysToDate(1721125, "%Y %m %d"), '1721125');
compare(1721125, Date_Calc::DateToDays(6, 3, 0), '0000 03 06');
compare('0000 03 07', Date_Calc::DaysToDate(1721126, "%Y %m %d"), '1721126');
compare(1721126, Date_Calc::DateToDays(7, 3, 0), '0000 03 07');
compare('0000 03 08', Date_Calc::DaysToDate(1721127, "%Y %m %d"), '1721127');
compare(1721127, Date_Calc::DateToDays(8, 3, 0), '0000 03 08');
compare('0000 03 09', Date_Calc::DaysToDate(1721128, "%Y %m %d"), '1721128');
compare(1721128, Date_Calc::DateToDays(9, 3, 0), '0000 03 09');
compare('0000 03 10', Date_Calc::DaysToDate(1721129, "%Y %m %d"), '1721129');
compare(1721129, Date_Calc::DateToDays(10, 3, 0), '0000 03 10');
compare('0000 03 11', Date_Calc::DaysToDate(1721130, "%Y %m %d"), '1721130');
compare(1721130, Date_Calc::DateToDays(11, 3, 0), '0000 03 11');
compare('0000 03 12', Date_Calc::DaysToDate(1721131, "%Y %m %d"), '1721131');
compare(1721131, Date_Calc::DateToDays(12, 3, 0), '0000 03 12');
compare('0000 03 13', Date_Calc::DaysToDate(1721132, "%Y %m %d"), '1721132');
compare(1721132, Date_Calc::DateToDays(13, 3, 0), '0000 03 13');
compare('0000 03 14', Date_Calc::DaysToDate(1721133, "%Y %m %d"), '1721133');
compare(1721133, Date_Calc::DateToDays(14, 3, 0), '0000 03 14');
compare('0000 03 15', Date_Calc::DaysToDate(1721134, "%Y %m %d"), '1721134');
compare(1721134, Date_Calc::DateToDays(15, 3, 0), '0000 03 15');
compare('0000 03 16', Date_Calc::DaysToDate(1721135, "%Y %m %d"), '1721135');
compare(1721135, Date_Calc::DateToDays(16, 3, 0), '0000 03 16');
compare('0000 03 17', Date_Calc::DaysToDate(1721136, "%Y %m %d"), '1721136');
compare(1721136, Date_Calc::DateToDays(17, 3, 0), '0000 03 17');
compare('0000 03 18', Date_Calc::DaysToDate(1721137, "%Y %m %d"), '1721137');
compare(1721137, Date_Calc::DateToDays(18, 3, 0), '0000 03 18');
compare('0000 03 19', Date_Calc::DaysToDate(1721138, "%Y %m %d"), '1721138');
compare(1721138, Date_Calc::DateToDays(19, 3, 0), '0000 03 19');
compare('0000 03 20', Date_Calc::DaysToDate(1721139, "%Y %m %d"), '1721139');
compare(1721139, Date_Calc::DateToDays(20, 3, 0), '0000 03 20');
compare('0000 03 21', Date_Calc::DaysToDate(1721140, "%Y %m %d"), '1721140');
compare(1721140, Date_Calc::DateToDays(21, 3, 0), '0000 03 21');
compare('0000 03 22', Date_Calc::DaysToDate(1721141, "%Y %m %d"), '1721141');
compare(1721141, Date_Calc::DateToDays(22, 3, 0), '0000 03 22');
compare('0000 03 23', Date_Calc::DaysToDate(1721142, "%Y %m %d"), '1721142');
compare(1721142, Date_Calc::DateToDays(23, 3, 0), '0000 03 23');
compare('0000 03 24', Date_Calc::DaysToDate(1721143, "%Y %m %d"), '1721143');
compare(1721143, Date_Calc::DateToDays(24, 3, 0), '0000 03 24');
compare('0000 03 25', Date_Calc::DaysToDate(1721144, "%Y %m %d"), '1721144');
compare(1721144, Date_Calc::DateToDays(25, 3, 0), '0000 03 25');
compare('0000 03 26', Date_Calc::DaysToDate(1721145, "%Y %m %d"), '1721145');
compare(1721145, Date_Calc::DateToDays(26, 3, 0), '0000 03 26');
compare('0000 03 27', Date_Calc::DaysToDate(1721146, "%Y %m %d"), '1721146');
compare(1721146, Date_Calc::DateToDays(27, 3, 0), '0000 03 27');
compare('0000 03 28', Date_Calc::DaysToDate(1721147, "%Y %m %d"), '1721147');
compare(1721147, Date_Calc::DateToDays(28, 3, 0), '0000 03 28');
compare('0000 03 29', Date_Calc::DaysToDate(1721148, "%Y %m %d"), '1721148');
compare(1721148, Date_Calc::DateToDays(29, 3, 0), '0000 03 29');
compare('0000 03 30', Date_Calc::DaysToDate(1721149, "%Y %m %d"), '1721149');
compare(1721149, Date_Calc::DateToDays(30, 3, 0), '0000 03 30');
compare('0000 03 31', Date_Calc::DaysToDate(1721150, "%Y %m %d"), '1721150');
compare(1721150, Date_Calc::DateToDays(31, 3, 0), '0000 03 31');
compare('0000 04 01', Date_Calc::DaysToDate(1721151, "%Y %m %d"), '1721151');
compare(1721151, Date_Calc::DateToDays(1, 4, 0), '0000 04 01');
compare('0000 04 02', Date_Calc::DaysToDate(1721152, "%Y %m %d"), '1721152');
compare(1721152, Date_Calc::DateToDays(2, 4, 0), '0000 04 02');
compare('0000 04 03', Date_Calc::DaysToDate(1721153, "%Y %m %d"), '1721153');
compare(1721153, Date_Calc::DateToDays(3, 4, 0), '0000 04 03');
compare('0000 04 04', Date_Calc::DaysToDate(1721154, "%Y %m %d"), '1721154');
compare(1721154, Date_Calc::DateToDays(4, 4, 0), '0000 04 04');
compare('0000 04 05', Date_Calc::DaysToDate(1721155, "%Y %m %d"), '1721155');
compare(1721155, Date_Calc::DateToDays(5, 4, 0), '0000 04 05');
compare('0000 04 06', Date_Calc::DaysToDate(1721156, "%Y %m %d"), '1721156');
compare(1721156, Date_Calc::DateToDays(6, 4, 0), '0000 04 06');
compare('0000 04 07', Date_Calc::DaysToDate(1721157, "%Y %m %d"), '1721157');
compare(1721157, Date_Calc::DateToDays(7, 4, 0), '0000 04 07');
compare('0000 04 08', Date_Calc::DaysToDate(1721158, "%Y %m %d"), '1721158');
compare(1721158, Date_Calc::DateToDays(8, 4, 0), '0000 04 08');
compare('0000 04 09', Date_Calc::DaysToDate(1721159, "%Y %m %d"), '1721159');
compare(1721159, Date_Calc::DateToDays(9, 4, 0), '0000 04 09');
compare('0000 04 10', Date_Calc::DaysToDate(1721160, "%Y %m %d"), '1721160');
compare(1721160, Date_Calc::DateToDays(10, 4, 0), '0000 04 10');
compare('0000 04 11', Date_Calc::DaysToDate(1721161, "%Y %m %d"), '1721161');
compare(1721161, Date_Calc::DateToDays(11, 4, 0), '0000 04 11');
compare('0000 04 12', Date_Calc::DaysToDate(1721162, "%Y %m %d"), '1721162');
compare(1721162, Date_Calc::DateToDays(12, 4, 0), '0000 04 12');
compare('0000 04 13', Date_Calc::DaysToDate(1721163, "%Y %m %d"), '1721163');
compare(1721163, Date_Calc::DateToDays(13, 4, 0), '0000 04 13');
compare('0000 04 14', Date_Calc::DaysToDate(1721164, "%Y %m %d"), '1721164');
compare(1721164, Date_Calc::DateToDays(14, 4, 0), '0000 04 14');
compare('0000 04 15', Date_Calc::DaysToDate(1721165, "%Y %m %d"), '1721165');
compare(1721165, Date_Calc::DateToDays(15, 4, 0), '0000 04 15');
compare('0000 04 16', Date_Calc::DaysToDate(1721166, "%Y %m %d"), '1721166');
compare(1721166, Date_Calc::DateToDays(16, 4, 0), '0000 04 16');
compare('0000 04 17', Date_Calc::DaysToDate(1721167, "%Y %m %d"), '1721167');
compare(1721167, Date_Calc::DateToDays(17, 4, 0), '0000 04 17');
compare('0000 04 18', Date_Calc::DaysToDate(1721168, "%Y %m %d"), '1721168');
compare(1721168, Date_Calc::DateToDays(18, 4, 0), '0000 04 18');
compare('0000 04 19', Date_Calc::DaysToDate(1721169, "%Y %m %d"), '1721169');
compare(1721169, Date_Calc::DateToDays(19, 4, 0), '0000 04 19');
compare('0000 04 20', Date_Calc::DaysToDate(1721170, "%Y %m %d"), '1721170');
compare(1721170, Date_Calc::DateToDays(20, 4, 0), '0000 04 20');
compare('0000 04 21', Date_Calc::DaysToDate(1721171, "%Y %m %d"), '1721171');
compare(1721171, Date_Calc::DateToDays(21, 4, 0), '0000 04 21');
compare('0000 04 22', Date_Calc::DaysToDate(1721172, "%Y %m %d"), '1721172');
compare(1721172, Date_Calc::DateToDays(22, 4, 0), '0000 04 22');
compare('0000 04 23', Date_Calc::DaysToDate(1721173, "%Y %m %d"), '1721173');
compare(1721173, Date_Calc::DateToDays(23, 4, 0), '0000 04 23');
compare('0000 04 24', Date_Calc::DaysToDate(1721174, "%Y %m %d"), '1721174');
compare(1721174, Date_Calc::DateToDays(24, 4, 0), '0000 04 24');
compare('0000 04 25', Date_Calc::DaysToDate(1721175, "%Y %m %d"), '1721175');
compare(1721175, Date_Calc::DateToDays(25, 4, 0), '0000 04 25');
compare('0000 04 26', Date_Calc::DaysToDate(1721176, "%Y %m %d"), '1721176');
compare(1721176, Date_Calc::DateToDays(26, 4, 0), '0000 04 26');
compare('0000 04 27', Date_Calc::DaysToDate(1721177, "%Y %m %d"), '1721177');
compare(1721177, Date_Calc::DateToDays(27, 4, 0), '0000 04 27');
compare('0000 04 28', Date_Calc::DaysToDate(1721178, "%Y %m %d"), '1721178');
compare(1721178, Date_Calc::DateToDays(28, 4, 0), '0000 04 28');
compare('0000 04 29', Date_Calc::DaysToDate(1721179, "%Y %m %d"), '1721179');
compare(1721179, Date_Calc::DateToDays(29, 4, 0), '0000 04 29');
compare('0000 04 30', Date_Calc::DaysToDate(1721180, "%Y %m %d"), '1721180');
compare(1721180, Date_Calc::DateToDays(30, 4, 0), '0000 04 30');
compare('0000 05 01', Date_Calc::DaysToDate(1721181, "%Y %m %d"), '1721181');
compare(1721181, Date_Calc::DateToDays(1, 5, 0), '0000 05 01');
compare('0000 05 02', Date_Calc::DaysToDate(1721182, "%Y %m %d"), '1721182');
compare(1721182, Date_Calc::DateToDays(2, 5, 0), '0000 05 02');
compare('0000 05 03', Date_Calc::DaysToDate(1721183, "%Y %m %d"), '1721183');
compare(1721183, Date_Calc::DateToDays(3, 5, 0), '0000 05 03');
compare('0000 05 04', Date_Calc::DaysToDate(1721184, "%Y %m %d"), '1721184');
compare(1721184, Date_Calc::DateToDays(4, 5, 0), '0000 05 04');
compare('0000 05 05', Date_Calc::DaysToDate(1721185, "%Y %m %d"), '1721185');
compare(1721185, Date_Calc::DateToDays(5, 5, 0), '0000 05 05');
compare('0000 05 06', Date_Calc::DaysToDate(1721186, "%Y %m %d"), '1721186');
compare(1721186, Date_Calc::DateToDays(6, 5, 0), '0000 05 06');
compare('0000 05 07', Date_Calc::DaysToDate(1721187, "%Y %m %d"), '1721187');
compare(1721187, Date_Calc::DateToDays(7, 5, 0), '0000 05 07');
compare('0000 05 08', Date_Calc::DaysToDate(1721188, "%Y %m %d"), '1721188');
compare(1721188, Date_Calc::DateToDays(8, 5, 0), '0000 05 08');
compare('0000 05 09', Date_Calc::DaysToDate(1721189, "%Y %m %d"), '1721189');
compare(1721189, Date_Calc::DateToDays(9, 5, 0), '0000 05 09');
compare('0000 05 10', Date_Calc::DaysToDate(1721190, "%Y %m %d"), '1721190');
compare(1721190, Date_Calc::DateToDays(10, 5, 0), '0000 05 10');
compare('0000 05 11', Date_Calc::DaysToDate(1721191, "%Y %m %d"), '1721191');
compare(1721191, Date_Calc::DateToDays(11, 5, 0), '0000 05 11');
compare('0000 05 12', Date_Calc::DaysToDate(1721192, "%Y %m %d"), '1721192');
compare(1721192, Date_Calc::DateToDays(12, 5, 0), '0000 05 12');
compare('0000 05 13', Date_Calc::DaysToDate(1721193, "%Y %m %d"), '1721193');
compare(1721193, Date_Calc::DateToDays(13, 5, 0), '0000 05 13');
compare('0000 05 14', Date_Calc::DaysToDate(1721194, "%Y %m %d"), '1721194');
compare(1721194, Date_Calc::DateToDays(14, 5, 0), '0000 05 14');
compare('0000 05 15', Date_Calc::DaysToDate(1721195, "%Y %m %d"), '1721195');
compare(1721195, Date_Calc::DateToDays(15, 5, 0), '0000 05 15');
compare('0000 05 16', Date_Calc::DaysToDate(1721196, "%Y %m %d"), '1721196');
compare(1721196, Date_Calc::DateToDays(16, 5, 0), '0000 05 16');
compare('0000 05 17', Date_Calc::DaysToDate(1721197, "%Y %m %d"), '1721197');
compare(1721197, Date_Calc::DateToDays(17, 5, 0), '0000 05 17');
compare('0000 05 18', Date_Calc::DaysToDate(1721198, "%Y %m %d"), '1721198');
compare(1721198, Date_Calc::DateToDays(18, 5, 0), '0000 05 18');
compare('0000 05 19', Date_Calc::DaysToDate(1721199, "%Y %m %d"), '1721199');
compare(1721199, Date_Calc::DateToDays(19, 5, 0), '0000 05 19');
compare('0000 05 20', Date_Calc::DaysToDate(1721200, "%Y %m %d"), '1721200');
compare(1721200, Date_Calc::DateToDays(20, 5, 0), '0000 05 20');
compare('0000 05 21', Date_Calc::DaysToDate(1721201, "%Y %m %d"), '1721201');
compare(1721201, Date_Calc::DateToDays(21, 5, 0), '0000 05 21');
compare('0000 05 22', Date_Calc::DaysToDate(1721202, "%Y %m %d"), '1721202');
compare(1721202, Date_Calc::DateToDays(22, 5, 0), '0000 05 22');
compare('0000 05 23', Date_Calc::DaysToDate(1721203, "%Y %m %d"), '1721203');
compare(1721203, Date_Calc::DateToDays(23, 5, 0), '0000 05 23');
compare('0000 05 24', Date_Calc::DaysToDate(1721204, "%Y %m %d"), '1721204');
compare(1721204, Date_Calc::DateToDays(24, 5, 0), '0000 05 24');
compare('0000 05 25', Date_Calc::DaysToDate(1721205, "%Y %m %d"), '1721205');
compare(1721205, Date_Calc::DateToDays(25, 5, 0), '0000 05 25');
compare('0000 05 26', Date_Calc::DaysToDate(1721206, "%Y %m %d"), '1721206');
compare(1721206, Date_Calc::DateToDays(26, 5, 0), '0000 05 26');
compare('0000 05 27', Date_Calc::DaysToDate(1721207, "%Y %m %d"), '1721207');
compare(1721207, Date_Calc::DateToDays(27, 5, 0), '0000 05 27');
compare('0000 05 28', Date_Calc::DaysToDate(1721208, "%Y %m %d"), '1721208');
compare(1721208, Date_Calc::DateToDays(28, 5, 0), '0000 05 28');
compare('0000 05 29', Date_Calc::DaysToDate(1721209, "%Y %m %d"), '1721209');
compare(1721209, Date_Calc::DateToDays(29, 5, 0), '0000 05 29');
compare('0000 05 30', Date_Calc::DaysToDate(1721210, "%Y %m %d"), '1721210');
compare(1721210, Date_Calc::DateToDays(30, 5, 0), '0000 05 30');
compare('0000 05 31', Date_Calc::DaysToDate(1721211, "%Y %m %d"), '1721211');
compare(1721211, Date_Calc::DateToDays(31, 5, 0), '0000 05 31');
compare('0000 06 01', Date_Calc::DaysToDate(1721212, "%Y %m %d"), '1721212');
compare(1721212, Date_Calc::DateToDays(1, 6, 0), '0000 06 01');
compare('0000 06 02', Date_Calc::DaysToDate(1721213, "%Y %m %d"), '1721213');
compare(1721213, Date_Calc::DateToDays(2, 6, 0), '0000 06 02');
compare('0000 06 03', Date_Calc::DaysToDate(1721214, "%Y %m %d"), '1721214');
compare(1721214, Date_Calc::DateToDays(3, 6, 0), '0000 06 03');
compare('0000 06 04', Date_Calc::DaysToDate(1721215, "%Y %m %d"), '1721215');
compare(1721215, Date_Calc::DateToDays(4, 6, 0), '0000 06 04');
compare('0000 06 05', Date_Calc::DaysToDate(1721216, "%Y %m %d"), '1721216');
compare(1721216, Date_Calc::DateToDays(5, 6, 0), '0000 06 05');
compare('0000 06 06', Date_Calc::DaysToDate(1721217, "%Y %m %d"), '1721217');
compare(1721217, Date_Calc::DateToDays(6, 6, 0), '0000 06 06');
compare('0000 06 07', Date_Calc::DaysToDate(1721218, "%Y %m %d"), '1721218');
compare(1721218, Date_Calc::DateToDays(7, 6, 0), '0000 06 07');
compare('0000 06 08', Date_Calc::DaysToDate(1721219, "%Y %m %d"), '1721219');
compare(1721219, Date_Calc::DateToDays(8, 6, 0), '0000 06 08');
compare('0000 06 09', Date_Calc::DaysToDate(1721220, "%Y %m %d"), '1721220');
compare(1721220, Date_Calc::DateToDays(9, 6, 0), '0000 06 09');
compare('0000 06 10', Date_Calc::DaysToDate(1721221, "%Y %m %d"), '1721221');
compare(1721221, Date_Calc::DateToDays(10, 6, 0), '0000 06 10');
compare('0000 06 11', Date_Calc::DaysToDate(1721222, "%Y %m %d"), '1721222');
compare(1721222, Date_Calc::DateToDays(11, 6, 0), '0000 06 11');
compare('0000 06 12', Date_Calc::DaysToDate(1721223, "%Y %m %d"), '1721223');
compare(1721223, Date_Calc::DateToDays(12, 6, 0), '0000 06 12');
compare('0000 06 13', Date_Calc::DaysToDate(1721224, "%Y %m %d"), '1721224');
compare(1721224, Date_Calc::DateToDays(13, 6, 0), '0000 06 13');
compare('0000 06 14', Date_Calc::DaysToDate(1721225, "%Y %m %d"), '1721225');
compare(1721225, Date_Calc::DateToDays(14, 6, 0), '0000 06 14');
compare('0000 06 15', Date_Calc::DaysToDate(1721226, "%Y %m %d"), '1721226');
compare(1721226, Date_Calc::DateToDays(15, 6, 0), '0000 06 15');
compare('0000 06 16', Date_Calc::DaysToDate(1721227, "%Y %m %d"), '1721227');
compare(1721227, Date_Calc::DateToDays(16, 6, 0), '0000 06 16');
compare('0000 06 17', Date_Calc::DaysToDate(1721228, "%Y %m %d"), '1721228');
compare(1721228, Date_Calc::DateToDays(17, 6, 0), '0000 06 17');
compare('0000 06 18', Date_Calc::DaysToDate(1721229, "%Y %m %d"), '1721229');
compare(1721229, Date_Calc::DateToDays(18, 6, 0), '0000 06 18');
compare('0000 06 19', Date_Calc::DaysToDate(1721230, "%Y %m %d"), '1721230');
compare(1721230, Date_Calc::DateToDays(19, 6, 0), '0000 06 19');
compare('0000 06 20', Date_Calc::DaysToDate(1721231, "%Y %m %d"), '1721231');
compare(1721231, Date_Calc::DateToDays(20, 6, 0), '0000 06 20');
compare('0000 06 21', Date_Calc::DaysToDate(1721232, "%Y %m %d"), '1721232');
compare(1721232, Date_Calc::DateToDays(21, 6, 0), '0000 06 21');
compare('0000 06 22', Date_Calc::DaysToDate(1721233, "%Y %m %d"), '1721233');
compare(1721233, Date_Calc::DateToDays(22, 6, 0), '0000 06 22');
compare('0000 06 23', Date_Calc::DaysToDate(1721234, "%Y %m %d"), '1721234');
compare(1721234, Date_Calc::DateToDays(23, 6, 0), '0000 06 23');
compare('0000 06 24', Date_Calc::DaysToDate(1721235, "%Y %m %d"), '1721235');
compare(1721235, Date_Calc::DateToDays(24, 6, 0), '0000 06 24');
compare('0000 06 25', Date_Calc::DaysToDate(1721236, "%Y %m %d"), '1721236');
compare(1721236, Date_Calc::DateToDays(25, 6, 0), '0000 06 25');
compare('0000 06 26', Date_Calc::DaysToDate(1721237, "%Y %m %d"), '1721237');
compare(1721237, Date_Calc::DateToDays(26, 6, 0), '0000 06 26');
compare('0000 06 27', Date_Calc::DaysToDate(1721238, "%Y %m %d"), '1721238');
compare(1721238, Date_Calc::DateToDays(27, 6, 0), '0000 06 27');
compare('0000 06 28', Date_Calc::DaysToDate(1721239, "%Y %m %d"), '1721239');
compare(1721239, Date_Calc::DateToDays(28, 6, 0), '0000 06 28');
compare('0000 06 29', Date_Calc::DaysToDate(1721240, "%Y %m %d"), '1721240');
compare(1721240, Date_Calc::DateToDays(29, 6, 0), '0000 06 29');
compare('0000 06 30', Date_Calc::DaysToDate(1721241, "%Y %m %d"), '1721241');
compare(1721241, Date_Calc::DateToDays(30, 6, 0), '0000 06 30');
compare('0000 07 01', Date_Calc::DaysToDate(1721242, "%Y %m %d"), '1721242');
compare(1721242, Date_Calc::DateToDays(1, 7, 0), '0000 07 01');
compare('0000 07 02', Date_Calc::DaysToDate(1721243, "%Y %m %d"), '1721243');
compare(1721243, Date_Calc::DateToDays(2, 7, 0), '0000 07 02');
compare('0000 07 03', Date_Calc::DaysToDate(1721244, "%Y %m %d"), '1721244');
compare(1721244, Date_Calc::DateToDays(3, 7, 0), '0000 07 03');
compare('0000 07 04', Date_Calc::DaysToDate(1721245, "%Y %m %d"), '1721245');
compare(1721245, Date_Calc::DateToDays(4, 7, 0), '0000 07 04');
compare('0000 07 05', Date_Calc::DaysToDate(1721246, "%Y %m %d"), '1721246');
compare(1721246, Date_Calc::DateToDays(5, 7, 0), '0000 07 05');
compare('0000 07 06', Date_Calc::DaysToDate(1721247, "%Y %m %d"), '1721247');
compare(1721247, Date_Calc::DateToDays(6, 7, 0), '0000 07 06');
compare('0000 07 07', Date_Calc::DaysToDate(1721248, "%Y %m %d"), '1721248');
compare(1721248, Date_Calc::DateToDays(7, 7, 0), '0000 07 07');
compare('0000 07 08', Date_Calc::DaysToDate(1721249, "%Y %m %d"), '1721249');
compare(1721249, Date_Calc::DateToDays(8, 7, 0), '0000 07 08');
compare('0000 07 09', Date_Calc::DaysToDate(1721250, "%Y %m %d"), '1721250');
compare(1721250, Date_Calc::DateToDays(9, 7, 0), '0000 07 09');
compare('0000 07 10', Date_Calc::DaysToDate(1721251, "%Y %m %d"), '1721251');
compare(1721251, Date_Calc::DateToDays(10, 7, 0), '0000 07 10');
compare('0000 07 11', Date_Calc::DaysToDate(1721252, "%Y %m %d"), '1721252');
compare(1721252, Date_Calc::DateToDays(11, 7, 0), '0000 07 11');
compare('0000 07 12', Date_Calc::DaysToDate(1721253, "%Y %m %d"), '1721253');
compare(1721253, Date_Calc::DateToDays(12, 7, 0), '0000 07 12');
compare('0000 07 13', Date_Calc::DaysToDate(1721254, "%Y %m %d"), '1721254');
compare(1721254, Date_Calc::DateToDays(13, 7, 0), '0000 07 13');
compare('0000 07 14', Date_Calc::DaysToDate(1721255, "%Y %m %d"), '1721255');
compare(1721255, Date_Calc::DateToDays(14, 7, 0), '0000 07 14');
compare('0000 07 15', Date_Calc::DaysToDate(1721256, "%Y %m %d"), '1721256');
compare(1721256, Date_Calc::DateToDays(15, 7, 0), '0000 07 15');
compare('0000 07 16', Date_Calc::DaysToDate(1721257, "%Y %m %d"), '1721257');
compare(1721257, Date_Calc::DateToDays(16, 7, 0), '0000 07 16');
compare('0000 07 17', Date_Calc::DaysToDate(1721258, "%Y %m %d"), '1721258');
compare(1721258, Date_Calc::DateToDays(17, 7, 0), '0000 07 17');
compare('0000 07 18', Date_Calc::DaysToDate(1721259, "%Y %m %d"), '1721259');
compare(1721259, Date_Calc::DateToDays(18, 7, 0), '0000 07 18');
compare('0000 07 19', Date_Calc::DaysToDate(1721260, "%Y %m %d"), '1721260');
compare(1721260, Date_Calc::DateToDays(19, 7, 0), '0000 07 19');
compare('0000 07 20', Date_Calc::DaysToDate(1721261, "%Y %m %d"), '1721261');
compare(1721261, Date_Calc::DateToDays(20, 7, 0), '0000 07 20');
compare('0000 07 21', Date_Calc::DaysToDate(1721262, "%Y %m %d"), '1721262');
compare(1721262, Date_Calc::DateToDays(21, 7, 0), '0000 07 21');
compare('0000 07 22', Date_Calc::DaysToDate(1721263, "%Y %m %d"), '1721263');
compare(1721263, Date_Calc::DateToDays(22, 7, 0), '0000 07 22');
compare('0000 07 23', Date_Calc::DaysToDate(1721264, "%Y %m %d"), '1721264');
compare(1721264, Date_Calc::DateToDays(23, 7, 0), '0000 07 23');
compare('0000 07 24', Date_Calc::DaysToDate(1721265, "%Y %m %d"), '1721265');
compare(1721265, Date_Calc::DateToDays(24, 7, 0), '0000 07 24');
compare('0000 07 25', Date_Calc::DaysToDate(1721266, "%Y %m %d"), '1721266');
compare(1721266, Date_Calc::DateToDays(25, 7, 0), '0000 07 25');
compare('0000 07 26', Date_Calc::DaysToDate(1721267, "%Y %m %d"), '1721267');
compare(1721267, Date_Calc::DateToDays(26, 7, 0), '0000 07 26');
compare('0000 07 27', Date_Calc::DaysToDate(1721268, "%Y %m %d"), '1721268');
compare(1721268, Date_Calc::DateToDays(27, 7, 0), '0000 07 27');
compare('0000 07 28', Date_Calc::DaysToDate(1721269, "%Y %m %d"), '1721269');
compare(1721269, Date_Calc::DateToDays(28, 7, 0), '0000 07 28');
compare('0000 07 29', Date_Calc::DaysToDate(1721270, "%Y %m %d"), '1721270');
compare(1721270, Date_Calc::DateToDays(29, 7, 0), '0000 07 29');
compare('0000 07 30', Date_Calc::DaysToDate(1721271, "%Y %m %d"), '1721271');
compare(1721271, Date_Calc::DateToDays(30, 7, 0), '0000 07 30');
compare('0000 07 31', Date_Calc::DaysToDate(1721272, "%Y %m %d"), '1721272');
compare(1721272, Date_Calc::DateToDays(31, 7, 0), '0000 07 31');
compare('0000 08 01', Date_Calc::DaysToDate(1721273, "%Y %m %d"), '1721273');
compare(1721273, Date_Calc::DateToDays(1, 8, 0), '0000 08 01');
compare('0000 08 02', Date_Calc::DaysToDate(1721274, "%Y %m %d"), '1721274');
compare(1721274, Date_Calc::DateToDays(2, 8, 0), '0000 08 02');
compare('0000 08 03', Date_Calc::DaysToDate(1721275, "%Y %m %d"), '1721275');
compare(1721275, Date_Calc::DateToDays(3, 8, 0), '0000 08 03');
compare('0000 08 04', Date_Calc::DaysToDate(1721276, "%Y %m %d"), '1721276');
compare(1721276, Date_Calc::DateToDays(4, 8, 0), '0000 08 04');
compare('0000 08 05', Date_Calc::DaysToDate(1721277, "%Y %m %d"), '1721277');
compare(1721277, Date_Calc::DateToDays(5, 8, 0), '0000 08 05');
compare('0000 08 06', Date_Calc::DaysToDate(1721278, "%Y %m %d"), '1721278');
compare(1721278, Date_Calc::DateToDays(6, 8, 0), '0000 08 06');
compare('0000 08 07', Date_Calc::DaysToDate(1721279, "%Y %m %d"), '1721279');
compare(1721279, Date_Calc::DateToDays(7, 8, 0), '0000 08 07');
compare('0000 08 08', Date_Calc::DaysToDate(1721280, "%Y %m %d"), '1721280');
compare(1721280, Date_Calc::DateToDays(8, 8, 0), '0000 08 08');
compare('0000 08 09', Date_Calc::DaysToDate(1721281, "%Y %m %d"), '1721281');
compare(1721281, Date_Calc::DateToDays(9, 8, 0), '0000 08 09');
compare('0000 08 10', Date_Calc::DaysToDate(1721282, "%Y %m %d"), '1721282');
compare(1721282, Date_Calc::DateToDays(10, 8, 0), '0000 08 10');
compare('0000 08 11', Date_Calc::DaysToDate(1721283, "%Y %m %d"), '1721283');
compare(1721283, Date_Calc::DateToDays(11, 8, 0), '0000 08 11');
compare('0000 08 12', Date_Calc::DaysToDate(1721284, "%Y %m %d"), '1721284');
compare(1721284, Date_Calc::DateToDays(12, 8, 0), '0000 08 12');
compare('0000 08 13', Date_Calc::DaysToDate(1721285, "%Y %m %d"), '1721285');
compare(1721285, Date_Calc::DateToDays(13, 8, 0), '0000 08 13');
compare('0000 08 14', Date_Calc::DaysToDate(1721286, "%Y %m %d"), '1721286');
compare(1721286, Date_Calc::DateToDays(14, 8, 0), '0000 08 14');
compare('0000 08 15', Date_Calc::DaysToDate(1721287, "%Y %m %d"), '1721287');
compare(1721287, Date_Calc::DateToDays(15, 8, 0), '0000 08 15');
compare('0000 08 16', Date_Calc::DaysToDate(1721288, "%Y %m %d"), '1721288');
compare(1721288, Date_Calc::DateToDays(16, 8, 0), '0000 08 16');
compare('0000 08 17', Date_Calc::DaysToDate(1721289, "%Y %m %d"), '1721289');
compare(1721289, Date_Calc::DateToDays(17, 8, 0), '0000 08 17');
compare('0000 08 18', Date_Calc::DaysToDate(1721290, "%Y %m %d"), '1721290');
compare(1721290, Date_Calc::DateToDays(18, 8, 0), '0000 08 18');
compare('0000 08 19', Date_Calc::DaysToDate(1721291, "%Y %m %d"), '1721291');
compare(1721291, Date_Calc::DateToDays(19, 8, 0), '0000 08 19');
compare('0000 08 20', Date_Calc::DaysToDate(1721292, "%Y %m %d"), '1721292');
compare(1721292, Date_Calc::DateToDays(20, 8, 0), '0000 08 20');
compare('0000 08 21', Date_Calc::DaysToDate(1721293, "%Y %m %d"), '1721293');
compare(1721293, Date_Calc::DateToDays(21, 8, 0), '0000 08 21');
compare('0000 08 22', Date_Calc::DaysToDate(1721294, "%Y %m %d"), '1721294');
compare(1721294, Date_Calc::DateToDays(22, 8, 0), '0000 08 22');
compare('0000 08 23', Date_Calc::DaysToDate(1721295, "%Y %m %d"), '1721295');
compare(1721295, Date_Calc::DateToDays(23, 8, 0), '0000 08 23');
compare('0000 08 24', Date_Calc::DaysToDate(1721296, "%Y %m %d"), '1721296');
compare(1721296, Date_Calc::DateToDays(24, 8, 0), '0000 08 24');
compare('0000 08 25', Date_Calc::DaysToDate(1721297, "%Y %m %d"), '1721297');
compare(1721297, Date_Calc::DateToDays(25, 8, 0), '0000 08 25');
compare('0000 08 26', Date_Calc::DaysToDate(1721298, "%Y %m %d"), '1721298');
compare(1721298, Date_Calc::DateToDays(26, 8, 0), '0000 08 26');
compare('0000 08 27', Date_Calc::DaysToDate(1721299, "%Y %m %d"), '1721299');
compare(1721299, Date_Calc::DateToDays(27, 8, 0), '0000 08 27');
compare('0000 08 28', Date_Calc::DaysToDate(1721300, "%Y %m %d"), '1721300');
compare(1721300, Date_Calc::DateToDays(28, 8, 0), '0000 08 28');
compare('0000 08 29', Date_Calc::DaysToDate(1721301, "%Y %m %d"), '1721301');
compare(1721301, Date_Calc::DateToDays(29, 8, 0), '0000 08 29');
compare('0000 08 30', Date_Calc::DaysToDate(1721302, "%Y %m %d"), '1721302');
compare(1721302, Date_Calc::DateToDays(30, 8, 0), '0000 08 30');
compare('0000 08 31', Date_Calc::DaysToDate(1721303, "%Y %m %d"), '1721303');
compare(1721303, Date_Calc::DateToDays(31, 8, 0), '0000 08 31');
compare('0000 09 01', Date_Calc::DaysToDate(1721304, "%Y %m %d"), '1721304');
compare(1721304, Date_Calc::DateToDays(1, 9, 0), '0000 09 01');
compare('0000 09 02', Date_Calc::DaysToDate(1721305, "%Y %m %d"), '1721305');
compare(1721305, Date_Calc::DateToDays(2, 9, 0), '0000 09 02');
compare('0000 09 03', Date_Calc::DaysToDate(1721306, "%Y %m %d"), '1721306');
compare(1721306, Date_Calc::DateToDays(3, 9, 0), '0000 09 03');
compare('0000 09 04', Date_Calc::DaysToDate(1721307, "%Y %m %d"), '1721307');
compare(1721307, Date_Calc::DateToDays(4, 9, 0), '0000 09 04');
compare('0000 09 05', Date_Calc::DaysToDate(1721308, "%Y %m %d"), '1721308');
compare(1721308, Date_Calc::DateToDays(5, 9, 0), '0000 09 05');
compare('0000 09 06', Date_Calc::DaysToDate(1721309, "%Y %m %d"), '1721309');
compare(1721309, Date_Calc::DateToDays(6, 9, 0), '0000 09 06');
compare('0000 09 07', Date_Calc::DaysToDate(1721310, "%Y %m %d"), '1721310');
compare(1721310, Date_Calc::DateToDays(7, 9, 0), '0000 09 07');
compare('0000 09 08', Date_Calc::DaysToDate(1721311, "%Y %m %d"), '1721311');
compare(1721311, Date_Calc::DateToDays(8, 9, 0), '0000 09 08');
compare('0000 09 09', Date_Calc::DaysToDate(1721312, "%Y %m %d"), '1721312');
compare(1721312, Date_Calc::DateToDays(9, 9, 0), '0000 09 09');
compare('0000 09 10', Date_Calc::DaysToDate(1721313, "%Y %m %d"), '1721313');
compare(1721313, Date_Calc::DateToDays(10, 9, 0), '0000 09 10');
compare('0000 09 11', Date_Calc::DaysToDate(1721314, "%Y %m %d"), '1721314');
compare(1721314, Date_Calc::DateToDays(11, 9, 0), '0000 09 11');
compare('0000 09 12', Date_Calc::DaysToDate(1721315, "%Y %m %d"), '1721315');
compare(1721315, Date_Calc::DateToDays(12, 9, 0), '0000 09 12');
compare('0000 09 13', Date_Calc::DaysToDate(1721316, "%Y %m %d"), '1721316');
compare(1721316, Date_Calc::DateToDays(13, 9, 0), '0000 09 13');
compare('0000 09 14', Date_Calc::DaysToDate(1721317, "%Y %m %d"), '1721317');
compare(1721317, Date_Calc::DateToDays(14, 9, 0), '0000 09 14');
compare('0000 09 15', Date_Calc::DaysToDate(1721318, "%Y %m %d"), '1721318');
compare(1721318, Date_Calc::DateToDays(15, 9, 0), '0000 09 15');
compare('0000 09 16', Date_Calc::DaysToDate(1721319, "%Y %m %d"), '1721319');
compare(1721319, Date_Calc::DateToDays(16, 9, 0), '0000 09 16');
compare('0000 09 17', Date_Calc::DaysToDate(1721320, "%Y %m %d"), '1721320');
compare(1721320, Date_Calc::DateToDays(17, 9, 0), '0000 09 17');
compare('0000 09 18', Date_Calc::DaysToDate(1721321, "%Y %m %d"), '1721321');
compare(1721321, Date_Calc::DateToDays(18, 9, 0), '0000 09 18');
compare('0000 09 19', Date_Calc::DaysToDate(1721322, "%Y %m %d"), '1721322');
compare(1721322, Date_Calc::DateToDays(19, 9, 0), '0000 09 19');
compare('0000 09 20', Date_Calc::DaysToDate(1721323, "%Y %m %d"), '1721323');
compare(1721323, Date_Calc::DateToDays(20, 9, 0), '0000 09 20');
compare('0000 09 21', Date_Calc::DaysToDate(1721324, "%Y %m %d"), '1721324');
compare(1721324, Date_Calc::DateToDays(21, 9, 0), '0000 09 21');
compare('0000 09 22', Date_Calc::DaysToDate(1721325, "%Y %m %d"), '1721325');
compare(1721325, Date_Calc::DateToDays(22, 9, 0), '0000 09 22');
compare('0000 09 23', Date_Calc::DaysToDate(1721326, "%Y %m %d"), '1721326');
compare(1721326, Date_Calc::DateToDays(23, 9, 0), '0000 09 23');
compare('0000 09 24', Date_Calc::DaysToDate(1721327, "%Y %m %d"), '1721327');
compare(1721327, Date_Calc::DateToDays(24, 9, 0), '0000 09 24');
compare('0000 09 25', Date_Calc::DaysToDate(1721328, "%Y %m %d"), '1721328');
compare(1721328, Date_Calc::DateToDays(25, 9, 0), '0000 09 25');
compare('0000 09 26', Date_Calc::DaysToDate(1721329, "%Y %m %d"), '1721329');
compare(1721329, Date_Calc::DateToDays(26, 9, 0), '0000 09 26');
compare('0000 09 27', Date_Calc::DaysToDate(1721330, "%Y %m %d"), '1721330');
compare(1721330, Date_Calc::DateToDays(27, 9, 0), '0000 09 27');
compare('0000 09 28', Date_Calc::DaysToDate(1721331, "%Y %m %d"), '1721331');
compare(1721331, Date_Calc::DateToDays(28, 9, 0), '0000 09 28');
compare('0000 09 29', Date_Calc::DaysToDate(1721332, "%Y %m %d"), '1721332');
compare(1721332, Date_Calc::DateToDays(29, 9, 0), '0000 09 29');
compare('0000 09 30', Date_Calc::DaysToDate(1721333, "%Y %m %d"), '1721333');
compare(1721333, Date_Calc::DateToDays(30, 9, 0), '0000 09 30');
compare('0000 10 01', Date_Calc::DaysToDate(1721334, "%Y %m %d"), '1721334');
compare(1721334, Date_Calc::DateToDays(1, 10, 0), '0000 10 01');
compare('0000 10 02', Date_Calc::DaysToDate(1721335, "%Y %m %d"), '1721335');
compare(1721335, Date_Calc::DateToDays(2, 10, 0), '0000 10 02');
compare('0000 10 03', Date_Calc::DaysToDate(1721336, "%Y %m %d"), '1721336');
compare(1721336, Date_Calc::DateToDays(3, 10, 0), '0000 10 03');
compare('0000 10 04', Date_Calc::DaysToDate(1721337, "%Y %m %d"), '1721337');
compare(1721337, Date_Calc::DateToDays(4, 10, 0), '0000 10 04');
compare('0000 10 05', Date_Calc::DaysToDate(1721338, "%Y %m %d"), '1721338');
compare(1721338, Date_Calc::DateToDays(5, 10, 0), '0000 10 05');
compare('0000 10 06', Date_Calc::DaysToDate(1721339, "%Y %m %d"), '1721339');
compare(1721339, Date_Calc::DateToDays(6, 10, 0), '0000 10 06');
compare('0000 10 07', Date_Calc::DaysToDate(1721340, "%Y %m %d"), '1721340');
compare(1721340, Date_Calc::DateToDays(7, 10, 0), '0000 10 07');
compare('0000 10 08', Date_Calc::DaysToDate(1721341, "%Y %m %d"), '1721341');
compare(1721341, Date_Calc::DateToDays(8, 10, 0), '0000 10 08');
compare('0000 10 09', Date_Calc::DaysToDate(1721342, "%Y %m %d"), '1721342');
compare(1721342, Date_Calc::DateToDays(9, 10, 0), '0000 10 09');
compare('0000 10 10', Date_Calc::DaysToDate(1721343, "%Y %m %d"), '1721343');
compare(1721343, Date_Calc::DateToDays(10, 10, 0), '0000 10 10');
compare('0000 10 11', Date_Calc::DaysToDate(1721344, "%Y %m %d"), '1721344');
compare(1721344, Date_Calc::DateToDays(11, 10, 0), '0000 10 11');
compare('0000 10 12', Date_Calc::DaysToDate(1721345, "%Y %m %d"), '1721345');
compare(1721345, Date_Calc::DateToDays(12, 10, 0), '0000 10 12');
compare('0000 10 13', Date_Calc::DaysToDate(1721346, "%Y %m %d"), '1721346');
compare(1721346, Date_Calc::DateToDays(13, 10, 0), '0000 10 13');
compare('0000 10 14', Date_Calc::DaysToDate(1721347, "%Y %m %d"), '1721347');
compare(1721347, Date_Calc::DateToDays(14, 10, 0), '0000 10 14');
compare('0000 10 15', Date_Calc::DaysToDate(1721348, "%Y %m %d"), '1721348');
compare(1721348, Date_Calc::DateToDays(15, 10, 0), '0000 10 15');
compare('0000 10 16', Date_Calc::DaysToDate(1721349, "%Y %m %d"), '1721349');
compare(1721349, Date_Calc::DateToDays(16, 10, 0), '0000 10 16');
compare('0000 10 17', Date_Calc::DaysToDate(1721350, "%Y %m %d"), '1721350');
compare(1721350, Date_Calc::DateToDays(17, 10, 0), '0000 10 17');
compare('0000 10 18', Date_Calc::DaysToDate(1721351, "%Y %m %d"), '1721351');
compare(1721351, Date_Calc::DateToDays(18, 10, 0), '0000 10 18');
compare('0000 10 19', Date_Calc::DaysToDate(1721352, "%Y %m %d"), '1721352');
compare(1721352, Date_Calc::DateToDays(19, 10, 0), '0000 10 19');
compare('0000 10 20', Date_Calc::DaysToDate(1721353, "%Y %m %d"), '1721353');
compare(1721353, Date_Calc::DateToDays(20, 10, 0), '0000 10 20');
compare('0000 10 21', Date_Calc::DaysToDate(1721354, "%Y %m %d"), '1721354');
compare(1721354, Date_Calc::DateToDays(21, 10, 0), '0000 10 21');
compare('0000 10 22', Date_Calc::DaysToDate(1721355, "%Y %m %d"), '1721355');
compare(1721355, Date_Calc::DateToDays(22, 10, 0), '0000 10 22');
compare('0000 10 23', Date_Calc::DaysToDate(1721356, "%Y %m %d"), '1721356');
compare(1721356, Date_Calc::DateToDays(23, 10, 0), '0000 10 23');
compare('0000 10 24', Date_Calc::DaysToDate(1721357, "%Y %m %d"), '1721357');
compare(1721357, Date_Calc::DateToDays(24, 10, 0), '0000 10 24');
compare('0000 10 25', Date_Calc::DaysToDate(1721358, "%Y %m %d"), '1721358');
compare(1721358, Date_Calc::DateToDays(25, 10, 0), '0000 10 25');
compare('0000 10 26', Date_Calc::DaysToDate(1721359, "%Y %m %d"), '1721359');
compare(1721359, Date_Calc::DateToDays(26, 10, 0), '0000 10 26');
compare('0000 10 27', Date_Calc::DaysToDate(1721360, "%Y %m %d"), '1721360');
compare(1721360, Date_Calc::DateToDays(27, 10, 0), '0000 10 27');
compare('0000 10 28', Date_Calc::DaysToDate(1721361, "%Y %m %d"), '1721361');
compare(1721361, Date_Calc::DateToDays(28, 10, 0), '0000 10 28');
compare('0000 10 29', Date_Calc::DaysToDate(1721362, "%Y %m %d"), '1721362');
compare(1721362, Date_Calc::DateToDays(29, 10, 0), '0000 10 29');
compare('0000 10 30', Date_Calc::DaysToDate(1721363, "%Y %m %d"), '1721363');
compare(1721363, Date_Calc::DateToDays(30, 10, 0), '0000 10 30');
compare('0000 10 31', Date_Calc::DaysToDate(1721364, "%Y %m %d"), '1721364');
compare(1721364, Date_Calc::DateToDays(31, 10, 0), '0000 10 31');
compare('0000 11 01', Date_Calc::DaysToDate(1721365, "%Y %m %d"), '1721365');
compare(1721365, Date_Calc::DateToDays(1, 11, 0), '0000 11 01');
compare('0000 11 02', Date_Calc::DaysToDate(1721366, "%Y %m %d"), '1721366');
compare(1721366, Date_Calc::DateToDays(2, 11, 0), '0000 11 02');
compare('0000 11 03', Date_Calc::DaysToDate(1721367, "%Y %m %d"), '1721367');
compare(1721367, Date_Calc::DateToDays(3, 11, 0), '0000 11 03');
compare('0000 11 04', Date_Calc::DaysToDate(1721368, "%Y %m %d"), '1721368');
compare(1721368, Date_Calc::DateToDays(4, 11, 0), '0000 11 04');
compare('0000 11 05', Date_Calc::DaysToDate(1721369, "%Y %m %d"), '1721369');
compare(1721369, Date_Calc::DateToDays(5, 11, 0), '0000 11 05');
compare('0000 11 06', Date_Calc::DaysToDate(1721370, "%Y %m %d"), '1721370');
compare(1721370, Date_Calc::DateToDays(6, 11, 0), '0000 11 06');
compare('0000 11 07', Date_Calc::DaysToDate(1721371, "%Y %m %d"), '1721371');
compare(1721371, Date_Calc::DateToDays(7, 11, 0), '0000 11 07');
compare('0000 11 08', Date_Calc::DaysToDate(1721372, "%Y %m %d"), '1721372');
compare(1721372, Date_Calc::DateToDays(8, 11, 0), '0000 11 08');
compare('0000 11 09', Date_Calc::DaysToDate(1721373, "%Y %m %d"), '1721373');
compare(1721373, Date_Calc::DateToDays(9, 11, 0), '0000 11 09');
compare('0000 11 10', Date_Calc::DaysToDate(1721374, "%Y %m %d"), '1721374');
compare(1721374, Date_Calc::DateToDays(10, 11, 0), '0000 11 10');
compare('0000 11 11', Date_Calc::DaysToDate(1721375, "%Y %m %d"), '1721375');
compare(1721375, Date_Calc::DateToDays(11, 11, 0), '0000 11 11');
compare('0000 11 12', Date_Calc::DaysToDate(1721376, "%Y %m %d"), '1721376');
compare(1721376, Date_Calc::DateToDays(12, 11, 0), '0000 11 12');
compare('0000 11 13', Date_Calc::DaysToDate(1721377, "%Y %m %d"), '1721377');
compare(1721377, Date_Calc::DateToDays(13, 11, 0), '0000 11 13');
compare('0000 11 14', Date_Calc::DaysToDate(1721378, "%Y %m %d"), '1721378');
compare(1721378, Date_Calc::DateToDays(14, 11, 0), '0000 11 14');
compare('0000 11 15', Date_Calc::DaysToDate(1721379, "%Y %m %d"), '1721379');
compare(1721379, Date_Calc::DateToDays(15, 11, 0), '0000 11 15');
compare('0000 11 16', Date_Calc::DaysToDate(1721380, "%Y %m %d"), '1721380');
compare(1721380, Date_Calc::DateToDays(16, 11, 0), '0000 11 16');
compare('0000 11 17', Date_Calc::DaysToDate(1721381, "%Y %m %d"), '1721381');
compare(1721381, Date_Calc::DateToDays(17, 11, 0), '0000 11 17');
compare('0000 11 18', Date_Calc::DaysToDate(1721382, "%Y %m %d"), '1721382');
compare(1721382, Date_Calc::DateToDays(18, 11, 0), '0000 11 18');
compare('0000 11 19', Date_Calc::DaysToDate(1721383, "%Y %m %d"), '1721383');
compare(1721383, Date_Calc::DateToDays(19, 11, 0), '0000 11 19');
compare('0000 11 20', Date_Calc::DaysToDate(1721384, "%Y %m %d"), '1721384');
compare(1721384, Date_Calc::DateToDays(20, 11, 0), '0000 11 20');
compare('0000 11 21', Date_Calc::DaysToDate(1721385, "%Y %m %d"), '1721385');
compare(1721385, Date_Calc::DateToDays(21, 11, 0), '0000 11 21');
compare('0000 11 22', Date_Calc::DaysToDate(1721386, "%Y %m %d"), '1721386');
compare(1721386, Date_Calc::DateToDays(22, 11, 0), '0000 11 22');
compare('0000 11 23', Date_Calc::DaysToDate(1721387, "%Y %m %d"), '1721387');
compare(1721387, Date_Calc::DateToDays(23, 11, 0), '0000 11 23');
compare('0000 11 24', Date_Calc::DaysToDate(1721388, "%Y %m %d"), '1721388');
compare(1721388, Date_Calc::DateToDays(24, 11, 0), '0000 11 24');
compare('0000 11 25', Date_Calc::DaysToDate(1721389, "%Y %m %d"), '1721389');
compare(1721389, Date_Calc::DateToDays(25, 11, 0), '0000 11 25');
compare('0000 11 26', Date_Calc::DaysToDate(1721390, "%Y %m %d"), '1721390');
compare(1721390, Date_Calc::DateToDays(26, 11, 0), '0000 11 26');
compare('0000 11 27', Date_Calc::DaysToDate(1721391, "%Y %m %d"), '1721391');
compare(1721391, Date_Calc::DateToDays(27, 11, 0), '0000 11 27');
compare('0000 11 28', Date_Calc::DaysToDate(1721392, "%Y %m %d"), '1721392');
compare(1721392, Date_Calc::DateToDays(28, 11, 0), '0000 11 28');
compare('0000 11 29', Date_Calc::DaysToDate(1721393, "%Y %m %d"), '1721393');
compare(1721393, Date_Calc::DateToDays(29, 11, 0), '0000 11 29');
compare('0000 11 30', Date_Calc::DaysToDate(1721394, "%Y %m %d"), '1721394');
compare(1721394, Date_Calc::DateToDays(30, 11, 0), '0000 11 30');
compare('0000 12 01', Date_Calc::DaysToDate(1721395, "%Y %m %d"), '1721395');
compare(1721395, Date_Calc::DateToDays(1, 12, 0), '0000 12 01');
compare('0000 12 02', Date_Calc::DaysToDate(1721396, "%Y %m %d"), '1721396');
compare(1721396, Date_Calc::DateToDays(2, 12, 0), '0000 12 02');
compare('0000 12 03', Date_Calc::DaysToDate(1721397, "%Y %m %d"), '1721397');
compare(1721397, Date_Calc::DateToDays(3, 12, 0), '0000 12 03');
compare('0000 12 04', Date_Calc::DaysToDate(1721398, "%Y %m %d"), '1721398');
compare(1721398, Date_Calc::DateToDays(4, 12, 0), '0000 12 04');
compare('0000 12 05', Date_Calc::DaysToDate(1721399, "%Y %m %d"), '1721399');
compare(1721399, Date_Calc::DateToDays(5, 12, 0), '0000 12 05');
compare('0000 12 06', Date_Calc::DaysToDate(1721400, "%Y %m %d"), '1721400');
compare(1721400, Date_Calc::DateToDays(6, 12, 0), '0000 12 06');
compare('0000 12 07', Date_Calc::DaysToDate(1721401, "%Y %m %d"), '1721401');
compare(1721401, Date_Calc::DateToDays(7, 12, 0), '0000 12 07');
compare('0000 12 08', Date_Calc::DaysToDate(1721402, "%Y %m %d"), '1721402');
compare(1721402, Date_Calc::DateToDays(8, 12, 0), '0000 12 08');
compare('0000 12 09', Date_Calc::DaysToDate(1721403, "%Y %m %d"), '1721403');
compare(1721403, Date_Calc::DateToDays(9, 12, 0), '0000 12 09');
compare('0000 12 10', Date_Calc::DaysToDate(1721404, "%Y %m %d"), '1721404');
compare(1721404, Date_Calc::DateToDays(10, 12, 0), '0000 12 10');
compare('0000 12 11', Date_Calc::DaysToDate(1721405, "%Y %m %d"), '1721405');
compare(1721405, Date_Calc::DateToDays(11, 12, 0), '0000 12 11');
compare('0000 12 12', Date_Calc::DaysToDate(1721406, "%Y %m %d"), '1721406');
compare(1721406, Date_Calc::DateToDays(12, 12, 0), '0000 12 12');
compare('0000 12 13', Date_Calc::DaysToDate(1721407, "%Y %m %d"), '1721407');
compare(1721407, Date_Calc::DateToDays(13, 12, 0), '0000 12 13');
compare('0000 12 14', Date_Calc::DaysToDate(1721408, "%Y %m %d"), '1721408');
compare(1721408, Date_Calc::DateToDays(14, 12, 0), '0000 12 14');
compare('0000 12 15', Date_Calc::DaysToDate(1721409, "%Y %m %d"), '1721409');
compare(1721409, Date_Calc::DateToDays(15, 12, 0), '0000 12 15');
compare('0000 12 16', Date_Calc::DaysToDate(1721410, "%Y %m %d"), '1721410');
compare(1721410, Date_Calc::DateToDays(16, 12, 0), '0000 12 16');
compare('0000 12 17', Date_Calc::DaysToDate(1721411, "%Y %m %d"), '1721411');
compare(1721411, Date_Calc::DateToDays(17, 12, 0), '0000 12 17');
compare('0000 12 18', Date_Calc::DaysToDate(1721412, "%Y %m %d"), '1721412');
compare(1721412, Date_Calc::DateToDays(18, 12, 0), '0000 12 18');
compare('0000 12 19', Date_Calc::DaysToDate(1721413, "%Y %m %d"), '1721413');
compare(1721413, Date_Calc::DateToDays(19, 12, 0), '0000 12 19');
compare('0000 12 20', Date_Calc::DaysToDate(1721414, "%Y %m %d"), '1721414');
compare(1721414, Date_Calc::DateToDays(20, 12, 0), '0000 12 20');
compare('0000 12 21', Date_Calc::DaysToDate(1721415, "%Y %m %d"), '1721415');
compare(1721415, Date_Calc::DateToDays(21, 12, 0), '0000 12 21');
compare('0000 12 22', Date_Calc::DaysToDate(1721416, "%Y %m %d"), '1721416');
compare(1721416, Date_Calc::DateToDays(22, 12, 0), '0000 12 22');
compare('0000 12 23', Date_Calc::DaysToDate(1721417, "%Y %m %d"), '1721417');
compare(1721417, Date_Calc::DateToDays(23, 12, 0), '0000 12 23');
compare('0000 12 24', Date_Calc::DaysToDate(1721418, "%Y %m %d"), '1721418');
compare(1721418, Date_Calc::DateToDays(24, 12, 0), '0000 12 24');
compare('0000 12 25', Date_Calc::DaysToDate(1721419, "%Y %m %d"), '1721419');
compare(1721419, Date_Calc::DateToDays(25, 12, 0), '0000 12 25');
compare('0000 12 26', Date_Calc::DaysToDate(1721420, "%Y %m %d"), '1721420');
compare(1721420, Date_Calc::DateToDays(26, 12, 0), '0000 12 26');
compare('0000 12 27', Date_Calc::DaysToDate(1721421, "%Y %m %d"), '1721421');
compare(1721421, Date_Calc::DateToDays(27, 12, 0), '0000 12 27');
compare('0000 12 28', Date_Calc::DaysToDate(1721422, "%Y %m %d"), '1721422');
compare(1721422, Date_Calc::DateToDays(28, 12, 0), '0000 12 28');
compare('0000 12 29', Date_Calc::DaysToDate(1721423, "%Y %m %d"), '1721423');
compare(1721423, Date_Calc::DateToDays(29, 12, 0), '0000 12 29');
compare('0000 12 30', Date_Calc::DaysToDate(1721424, "%Y %m %d"), '1721424');
compare(1721424, Date_Calc::DateToDays(30, 12, 0), '0000 12 30');
compare('0000 12 31', Date_Calc::DaysToDate(1721425, "%Y %m %d"), '1721425');
compare(1721425, Date_Calc::DateToDays(31, 12, 0), '0000 12 31');
compare('0001 01 01', Date_Calc::DaysToDate(1721426, "%Y %m %d"), '1721426');
compare(1721426, Date_Calc::DateToDays(1, 1, 1), '0001 01 01');


?>