/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.regexp.REMatch;
import java.util.regex.Pattern;

public final class Matcher {
    private Pattern pattern;
    private CharSequence input;
    private int position;
    private int appendPosition;
    private REMatch match;

    public final Matcher appendReplacement(StringBuffer sb, String replacement) throws IllegalStateException {
        this.assertMatchOp();
        sb.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        sb.append(this.match.substituteInto(replacement));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public final StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return sb;
    }

    public final int end() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public final int end(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getEndIndex(group);
    }

    public final boolean find() {
        boolean bl = false;
        if (this.match == null) {
            bl = true;
        }
        boolean first = bl;
        this.match = this.pattern.getRE().getMatch(this.input, this.position);
        if (this.match != null) {
            int endIndex = this.match.getEndIndex();
            if (!first && endIndex == this.position) {
                this.match = null;
                if (this.position < this.input.length() - 1) {
                    ++this.position;
                    return this.find(this.position);
                }
                return false;
            }
            this.position = endIndex;
            return true;
        }
        return false;
    }

    public final boolean find(int start) {
        this.match = this.pattern.getRE().getMatch(this.input, start);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    public final String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public final String group(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.toString(group);
    }

    public final String replaceFirst(String replacement) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, replacement, this.position);
    }

    public final String replaceAll(String replacement) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, replacement, this.position);
    }

    public final int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public final boolean lookingAt() {
        this.match = this.pattern.getRE().getMatch(this.input, 0);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                this.position = this.match.getEndIndex();
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public final boolean matches() {
        if (this.lookingAt()) {
            if (this.position == this.input.length()) {
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public final Pattern pattern() {
        return this.pattern;
    }

    public final Matcher reset() {
        this.position = 0;
        this.match = null;
        return this;
    }

    public final Matcher reset(CharSequence input) {
        this.input = input;
        return this.reset();
    }

    public final int start() throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public final int start(int group) throws IllegalStateException {
        this.assertMatchOp();
        return this.match.getStartIndex(group);
    }

    private final void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }

    Matcher(Pattern pattern2, CharSequence input) {
        this.pattern = pattern2;
        this.input = input;
    }
}

