/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AbstractConcatAlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.DefaultAlignmentReaderFactory;
import org.campagnelab.goby.alignments.ReadGroupHelper;
import org.campagnelab.goby.alignments.ReadOriginInfo;
import org.campagnelab.goby.alignments.ReferenceLocation;
import org.campagnelab.goby.alignments.perms.ConcatenatePermutations;

public class ConcatAlignmentReader
extends AbstractConcatAlignmentReader {
    private static final Log LOG = LogFactory.getLog(ConcatAlignmentReader.class);
    protected final AlignmentReader[] readers;
    protected final IntSet readersWithMoreEntries;
    private final int[] numQueriesPerReader;
    private final int[] queryIndexOffset;
    protected int activeIndex;
    protected boolean adjustQueryIndices = true;
    private int numberOfAlignedReads;
    protected int[][] readOriginPermutations;
    private boolean needsPermutation;
    private String[] basenames;
    protected boolean[] hasReadOrigin;
    private ConcatenatePermutations concatenatePerms;
    private int nextAvailableReadOriginIndex = 0;
    ObjectArrayList<Alignments.ReadOriginInfo> mergedReadOriginInfoList = new ObjectArrayList();
    private String startOffsetArgument;
    private String endOffsetArgument;

    public ConcatAlignmentReader(String ... basenames) throws IOException {
        this((AlignmentReaderFactory)new DefaultAlignmentReaderFactory(), true, basenames);
    }

    public ConcatAlignmentReader(boolean adjustQueryIndices, String ... basenames) throws IOException {
        this((AlignmentReaderFactory)new DefaultAlignmentReaderFactory(), adjustQueryIndices, basenames);
    }

    public ConcatAlignmentReader(AlignmentReaderFactory alignmentReaderFactory, boolean adjustQueryIndices, String ... basenames) throws IOException {
        super(true, null);
        this.adjustQueryIndices = adjustQueryIndices;
        this.readers = alignmentReaderFactory.createReaderArray(basenames.length);
        this.hasReadOrigin = new boolean[basenames.length];
        this.readersWithMoreEntries = new IntArraySet();
        for (int readerIndex = 0; readerIndex < basenames.length; ++readerIndex) {
            this.readers[readerIndex] = alignmentReaderFactory.createReader(basenames[readerIndex]);
            this.readersWithMoreEntries.add(readerIndex);
            this.sampleBasenames.add((Object)basenames[readerIndex]);
        }
        this.numQueriesPerReader = new int[basenames.length];
        this.queryIndexOffset = new int[basenames.length];
        this.concatenatePerms = new ConcatenatePermutations(basenames);
        this.basenames = basenames;
        this.readHeader();
    }

    public ConcatenatePermutations getConcatPerm() {
        return this.concatenatePerms;
    }

    public ConcatAlignmentReader(AlignmentReaderFactory alignmentReaderFactory, boolean adjustQueryIndices, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition, String ... basenames) throws IOException {
        super(true, null);
        this.adjustQueryIndices = adjustQueryIndices;
        this.readers = alignmentReaderFactory.createReaderArray(basenames.length);
        this.hasReadOrigin = new boolean[basenames.length];
        this.readersWithMoreEntries = new IntArraySet();
        int readerIndex = 0;
        for (String basename : basenames) {
            this.readers[readerIndex] = alignmentReaderFactory.createReader(basename, startReferenceIndex, startPosition, endReferenceIndex, endPosition);
            this.readersWithMoreEntries.add(readerIndex);
            this.sampleBasenames.add((Object)basename);
            ++readerIndex;
        }
        this.numQueriesPerReader = new int[basenames.length];
        this.queryIndexOffset = new int[basenames.length];
        this.concatenatePerms = new ConcatenatePermutations(basenames);
        this.basenames = basenames;
        this.readHeader();
    }

    @Override
    public final void readHeader() throws IOException {
        if (!this.isHeaderLoaded()) {
            this.adjustQueryIndices |= this.concatenatePerms.needsPermutation();
            this.needsPermutation = this.concatenatePerms.needsPermutation();
            IntArraySet targetNumbers = new IntArraySet();
            int readerIndex = 0;
            ObjectArrayList alignerNames = new ObjectArrayList();
            ObjectArrayList alignerVersions = new ObjectArrayList();
            this.numberOfQueries = 0;
            this.smallestQueryIndex = Integer.MAX_VALUE;
            this.largestQueryIndex = this.adjustQueryIndices ? Integer.MIN_VALUE : 0;
            this.readOriginPermutations = new int[this.readers.length][];
            for (AlignmentReader reader : this.readers) {
                int numQueriesForReader;
                reader.readHeader();
                String alignerName = reader.getAlignerName();
                String alignerVersion = reader.getAlignerVersion();
                if (!alignerNames.contains((Object)alignerName) || !alignerVersions.contains((Object)alignerVersion)) {
                    alignerNames.add((Object)alignerName);
                    alignerVersions.add((Object)alignerVersion);
                }
                this.smallestQueryIndex = Math.min(reader.getSmallestSplitQueryIndex(), this.smallestQueryIndex);
                this.largestQueryIndex = this.adjustQueryIndices ? Math.max(this.largestQueryIndex, 0) + 1 + reader.getLargestSplitQueryIndex() : Math.max(reader.getLargestSplitQueryIndex(), this.largestQueryIndex);
                targetNumbers.add(reader.getNumberOfTargets());
                this.numQueriesPerReader[readerIndex] = numQueriesForReader = reader.getNumberOfQueries();
                this.numberOfQueries = this.adjustQueryIndices ? (this.numberOfQueries += numQueriesForReader) : Math.max(this.numberOfQueries, numQueriesForReader);
                this.numberOfAlignedReads += reader.getNumberOfAlignedReads();
                ReadOriginInfo readOriginInfo = reader.getReadOriginInfo();
                ReadGroupHelper readGroupHelper = this.getReadGroupHelper();
                if (readOriginInfo.size() > 0 && readGroupHelper.isOverrideReadGroups()) {
                    LOG.warn((Object)"Source contained read origin info, but overriding.");
                }
                if (readGroupHelper.isOverrideReadGroups()) {
                    readOriginInfo = this.makeDefaultReadOriginInfo(reader);
                }
                this.mergeReadOrigins(readerIndex, readOriginInfo.getPbList(), this.readers.length);
                ++readerIndex;
            }
            this.alignerName = alignerNames.toString();
            this.alignerVersion = alignerVersions.toString();
            if (targetNumbers.size() != 1) {
                throw new IllegalArgumentException("The number of targets must match exactly across the input basenames. Found " + targetNumbers.toString());
            }
            this.numberOfTargets = targetNumbers.iterator().nextInt();
            this.targetIdentifiers = new IndexedIdentifier();
            boolean error = false;
            for (AlignmentReader reader : this.readers) {
                IndexedIdentifier targetIds = reader.getTargetIdentifiers();
                for (MutableString key : targetIds.keySet()) {
                    int localValue;
                    if (!this.targetIdentifiers.containsKey((Object)key)) {
                        this.targetIdentifiers.put((Object)key, targetIds.getInt((Object)key));
                        continue;
                    }
                    int globalValue = this.targetIdentifiers.getInt((Object)key);
                    if (globalValue == (localValue = targetIds.getInt((Object)key))) continue;
                    error = true;
                    LOG.error((Object)String.format("target indices must match across input alignments. Key %s was found with the distinct values global: %d local %d in alignment %s", key, globalValue, localValue, reader.basename()));
                }
            }
            if (error) {
                throw new RuntimeException("target indices must match across input alignments.");
            }
            this.targetLengths = new int[this.targetIdentifiers.size()];
            for (int targetIndex = 0; targetIndex < this.targetIdentifiers.size(); ++targetIndex) {
                int maxLength = -1;
                for (AlignmentReader reader : this.readers) {
                    int[] readerLengths = reader.getTargetLength();
                    if (readerLengths == null || readerLengths.length <= targetIndex) continue;
                    this.targetLengths[targetIndex] = maxLength = Math.max(readerLengths[targetIndex], maxLength);
                }
            }
            for (int i = 0; i < this.queryIndexOffset.length; ++i) {
                this.queryIndexOffset[i] = this.adjustQueryIndices ? (i == 0 ? 0 : this.readers[i - 1].getLargestSplitQueryIndex() + 1) : 0;
            }
        }
        this.setHeaderLoaded(true);
    }

    private ReadOriginInfo makeDefaultReadOriginInfo(AlignmentReader reader) {
        ObjectArrayList list = new ObjectArrayList();
        Alignments.ReadOriginInfo.Builder builder = Alignments.ReadOriginInfo.newBuilder();
        builder.setOriginIndex(0);
        String basename = reader.basename();
        ReadGroupHelper readGroupHelper = this.getReadGroupHelper();
        builder.setOriginId(readGroupHelper.getId(basename));
        builder.setSample(readGroupHelper.getSample(basename));
        builder.setPlatformUnit(readGroupHelper.getSample(basename));
        builder.setPlatform(readGroupHelper.getPlatform(basename));
        list.add(builder.build());
        return new ReadOriginInfo((List<Alignments.ReadOriginInfo>)list);
    }

    public ReadGroupHelper getReadGroupHelper() {
        return new ReadGroupHelper();
    }

    private void mergeReadOrigins(int readerIndex, List<Alignments.ReadOriginInfo> readOriginInfo, int numberOfReaders) {
        this.hasReadOrigin[readerIndex] = !readOriginInfo.isEmpty();
        for (Alignments.ReadOriginInfo roi : readOriginInfo) {
            int newReadOriginIndex;
            int[] permutation = new int[readOriginInfo.size()];
            this.readOriginPermutations[readerIndex] = permutation;
            ++this.nextAvailableReadOriginIndex;
            permutation[roi.getOriginIndex()] = newReadOriginIndex;
            Alignments.ReadOriginInfo.Builder newRoi = Alignments.ReadOriginInfo.newBuilder(roi);
            newRoi.setOriginIndex(newReadOriginIndex);
            this.mergedReadOriginInfoList.add((Object)newRoi.build());
        }
    }

    protected int mergedQueryIndex(int readerIndex, int queryIndex) {
        if (this.needsPermutation) {
            try {
                return this.concatenatePerms.combine(readerIndex, queryIndex);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to retrieve original query index from permutation for reader " + readerIndex + " basename=" + this.basenames[readerIndex]), (Throwable)e);
                return -1;
            }
        }
        return this.adjustQueryIndices ? this.queryIndexOffset[readerIndex] + queryIndex : queryIndex;
    }

    @Override
    public final Iterator<Alignments.AlignmentEntry> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        while (!this.readersWithMoreEntries.isEmpty()) {
            this.activeIndex = this.readersWithMoreEntries.iterator().nextInt();
            AlignmentReader reader = this.readers[this.activeIndex];
            boolean hasNext = reader.hasNext();
            if (!hasNext) {
                this.readersWithMoreEntries.remove(this.activeIndex);
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getAlignerName() {
        return super.getAlignerName();
    }

    @Override
    public String getAlignerVersion() {
        return super.getAlignerVersion();
    }

    @Override
    public Alignments.AlignmentEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Alignments.AlignmentEntry alignmentEntry = this.readers[this.activeIndex].next();
        int queryIndex = alignmentEntry.getQueryIndex();
        int newQueryIndex = this.mergedQueryIndex(this.activeIndex, queryIndex);
        Alignments.AlignmentEntry.Builder builder = alignmentEntry.newBuilderForType().mergeFrom(alignmentEntry);
        if (this.adjustQueryIndices && newQueryIndex != queryIndex) {
            builder = builder.setQueryIndex(newQueryIndex);
        }
        if (this.adjustSampleIndices) {
            builder = builder.setSampleIndex(this.activeIndex);
        }
        builder = this.processReadGroups(alignmentEntry, builder, this.activeIndex);
        return builder.build();
    }

    protected Alignments.AlignmentEntry.Builder processReadGroups(Alignments.AlignmentEntry alignmentEntry, Alignments.AlignmentEntry.Builder builder, int readerIndex) {
        if (alignmentEntry.hasReadOriginIndex() && this.hasReadOrigin[readerIndex]) {
            builder = builder.setReadOriginIndex(this.readOriginPermutations[readerIndex][alignmentEntry.getReadOriginIndex()]);
        }
        return builder;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a reader.");
    }

    @Deprecated
    public void setAdjustQueryIndices(boolean adjustQueryIndices) {
        throw new UnsupportedOperationException("This operation is unsafe. Set flag through the constructor.");
    }

    public Properties getStatistics() {
        int index = 1;
        Properties result = new Properties();
        for (AlignmentReader reader : this.readers) {
            Properties localProps = reader.getStatistics();
            for (Map.Entry<Object, Object> localProp : localProps.entrySet()) {
                result.put("part" + index + "." + localProp.getKey().toString(), localProp.getValue());
            }
            ++index;
        }
        return result;
    }

    public int getNumberOfAlignedReads() {
        return this.numberOfAlignedReads;
    }

    @Override
    public void close() throws IOException {
        for (AlignmentReader reader : this.readers) {
            reader.close();
        }
    }

    @Override
    public ReferenceLocation getMinLocation() throws IOException {
        ReferenceLocation minLocation = this.readers[0].getMinLocation();
        for (AlignmentReader reader : this.readers) {
            ReferenceLocation loc = reader.getMinLocation();
            if (loc.compareTo(minLocation) >= 0) continue;
            minLocation = loc;
        }
        return minLocation;
    }

    @Override
    public ReferenceLocation getMaxLocation() throws IOException {
        ReferenceLocation maxLocation = this.readers[0].getMaxLocation();
        for (AlignmentReader reader : this.readers) {
            ReferenceLocation loc = reader.getMaxLocation();
            if (loc.compareTo(maxLocation) <= 0) continue;
            maxLocation = loc;
        }
        return maxLocation;
    }

    public ObjectList<ReferenceLocation> getLocationsByBytes(int numBytesPerSlice) throws IOException {
        this.readHeader();
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        int numReaders = this.readers.length;
        long byteAccumulation = 0L;
        int readerIndex = 0;
        ObjectList[] locations = new ObjectList[numReaders];
        int[] locationIndices = new int[numReaders];
        int maxLocationIndices = -1;
        for (AlignmentReader reader : this.readers) {
            locations[readerIndex] = reader.getLocationsByBytes(numBytesPerSlice / numReaders);
            maxLocationIndices = Math.max(maxLocationIndices, locations[readerIndex].size());
            ++readerIndex;
        }
        long sizeSinceLastSlice = 0L;
        ReferenceLocation startLocation = new ReferenceLocation(Integer.MAX_VALUE, Integer.MAX_VALUE);
        ReferenceLocation endLocation = new ReferenceLocation(0, 0);
        for (readerIndex = 0; readerIndex < numReaders; ++readerIndex) {
            ReferenceLocation readerFirst = (ReferenceLocation)locations[readerIndex].get(0);
            ReferenceLocation readerLast = (ReferenceLocation)locations[readerIndex].get(locations[readerIndex].size() - 1);
            if (readerFirst.compareTo(startLocation) < 0) {
                startLocation = readerFirst;
            }
            if (readerLast.compareTo(endLocation) <= 0) continue;
            endLocation = readerLast;
        }
        startLocation = this.getMinLocation();
        endLocation = this.getMaxLocation();
        for (int i = 0; i < maxLocationIndices; ++i) {
            ReferenceLocation medianLocation;
            readerIndex = 0;
            while (readerIndex < numReaders) {
                if (i < locations[readerIndex].size()) {
                    assert (readerIndex < locations.length) : "readerIndex must be smaller than locations length";
                    assert (readerIndex < locationIndices.length) : "i must be smaller than locationIndices length";
                    ReferenceLocation readerLocation = (ReferenceLocation)locations[readerIndex].get(locationIndices[readerIndex]);
                    sizeSinceLastSlice += readerLocation.compressedByteAmountSincePreviousLocation;
                }
                int n = readerIndex++;
                locationIndices[n] = locationIndices[n] + 1;
            }
            if (sizeSinceLastSlice <= (long)numBytesPerSlice) continue;
            ObjectArrayList currentLocations = new ObjectArrayList();
            for (readerIndex = 0; readerIndex < numReaders; ++readerIndex) {
                if (locationIndices[readerIndex] != 0 && locationIndices[readerIndex] >= locations[readerIndex].size()) continue;
                ReferenceLocation readerLocation = (ReferenceLocation)locations[readerIndex].get(locationIndices[readerIndex]);
                currentLocations.add((Object)readerLocation);
            }
            Collections.sort(currentLocations);
            int medianIndex = currentLocations.size() / 2;
            if (medianIndex < currentLocations.size() && !result.contains((Object)(medianLocation = (ReferenceLocation)currentLocations.get(medianIndex)))) {
                result.add((Object)medianLocation);
            }
            sizeSinceLastSlice = 0L;
        }
        ObjectArrayList list = new ObjectArrayList();
        result.add((Object)this.getMinLocation());
        result.add((Object)this.getMaxLocation());
        list.addAll((Collection)result);
        Collections.sort(list);
        return list;
    }

    public ObjectList<ReferenceLocation> getLocations(int modulo) throws IOException {
        this.readHeader();
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (AlignmentReader reader : this.readers) {
            result.addAll(reader.getLocations(modulo));
        }
        ObjectArrayList list = new ObjectArrayList();
        list.addAll((Collection)result);
        Collections.sort(list);
        return list;
    }

    public ReadOriginInfo getReadOriginInfo() {
        return new ReadOriginInfo((List<Alignments.ReadOriginInfo>)this.mergedReadOriginInfoList);
    }

    public void setStartEndOffsets(String startOffsetArgument, String endOffsetArgument) {
        this.startOffsetArgument = startOffsetArgument;
        this.endOffsetArgument = endOffsetArgument;
    }
}

