/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.iterators;

import edu.cornell.med.icb.iterators.FlatteningIterator;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;

public class RecursiveFileListIterator
implements Iterable<File> {
    private final FlatteningIterator flatteningIterator;

    @Override
    public Iterator<File> iterator() {
        return this.flatteningIterator;
    }

    public RecursiveFileListIterator(File file, FileFilter filter) {
        this.flatteningIterator = new FlatteningIterator(new FileIterator(file, filter));
    }

    public RecursiveFileListIterator(File file) {
        this(file, null);
    }

    private static class FileIterator
    implements Iterator<Object> {
        private final Iterator<File> files;
        private final FileFilter filter;

        FileIterator(File file, FileFilter filterVal) {
            this.files = Arrays.asList(file.listFiles(filterVal)).iterator();
            this.filter = filterVal;
        }

        @Override
        public void remove() {
        }

        @Override
        public Object next() {
            File next = this.files.next();
            if (next.isDirectory()) {
                return new FileIterator(next, this.filter);
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.files.hasNext();
        }
    }
}

