/*
 * Decompiled with CFR 0.152.
 */
package ngs.itf;

import ngs.Alignment;
import ngs.ErrorMsg;
import ngs.itf.Refcount;

class AlignmentItf
extends Refcount
implements Alignment {
    @Override
    public String getFragmentId() throws ErrorMsg {
        return this.GetFragmentId(this.self);
    }

    @Override
    public String getFragmentBases() throws ErrorMsg {
        return this.GetFragmentBases(this.self, 0L, -1L);
    }

    @Override
    public String getFragmentBases(long l) throws ErrorMsg, IndexOutOfBoundsException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset " + l + " is negative");
        }
        return this.GetFragmentBases(this.self, l, -1L);
    }

    @Override
    public String getFragmentBases(long l, long l2) throws ErrorMsg, IndexOutOfBoundsException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset " + l + " is negative");
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException("length " + l2 + " is negative");
        }
        return this.GetFragmentBases(this.self, l, l2);
    }

    @Override
    public String getFragmentQualities() throws ErrorMsg {
        return this.GetFragmentQualities(this.self, 0L, -1L);
    }

    @Override
    public String getFragmentQualities(long l) throws ErrorMsg, IndexOutOfBoundsException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset " + l + " is negative");
        }
        return this.getFragmentQualities(l, -1L);
    }

    @Override
    public String getFragmentQualities(long l, long l2) throws ErrorMsg, IndexOutOfBoundsException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("offset " + l + " is negative");
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException("length " + l2 + " is negative");
        }
        return this.GetFragmentQualities(this.self, l, l2);
    }

    @Override
    public boolean isPaired() throws ErrorMsg {
        return this.IsPaired(this.self);
    }

    @Override
    public boolean isAligned() throws ErrorMsg {
        return true;
    }

    @Override
    public String getAlignmentId() throws ErrorMsg {
        return this.GetAlignmentId(this.self);
    }

    @Override
    public String getReferenceSpec() throws ErrorMsg {
        return this.GetReferenceSpec(this.self);
    }

    @Override
    public int getMappingQuality() throws ErrorMsg {
        return this.GetMappingQuality(this.self);
    }

    @Override
    public String getReferenceBases() throws ErrorMsg {
        return this.GetReferenceBases(this.self);
    }

    @Override
    public String getReadGroup() throws ErrorMsg {
        return this.GetReadGroup(this.self);
    }

    @Override
    public String getReadId() throws ErrorMsg {
        return this.GetReadId(this.self);
    }

    @Override
    public String getClippedFragmentBases() throws ErrorMsg {
        return this.GetClippedFragmentBases(this.self);
    }

    @Override
    public String getClippedFragmentQualities() throws ErrorMsg {
        return this.GetClippedFragmentQualities(this.self);
    }

    @Override
    public String getAlignedFragmentBases() throws ErrorMsg {
        return this.GetAlignedFragmentBases(this.self);
    }

    @Override
    public int getAlignmentCategory() throws ErrorMsg {
        return this.GetAlignmentCategory(this.self);
    }

    @Override
    public long getAlignmentPosition() throws ErrorMsg {
        return this.GetAlignmentPosition(this.self);
    }

    @Override
    public long getAlignmentLength() throws ErrorMsg {
        return this.GetAlignmentLength(this.self);
    }

    @Override
    public boolean getIsReversedOrientation() throws ErrorMsg {
        return this.GetIsReversedOrientation(this.self);
    }

    @Override
    public int getSoftClip(int n) throws ErrorMsg {
        return this.GetSoftClip(this.self, n);
    }

    @Override
    public long getTemplateLength() throws ErrorMsg {
        return this.GetTemplateLength(this.self);
    }

    @Override
    public String getShortCigar(boolean bl) throws ErrorMsg {
        return this.GetShortCigar(this.self, bl);
    }

    @Override
    public String getLongCigar(boolean bl) throws ErrorMsg {
        return this.GetLongCigar(this.self, bl);
    }

    @Override
    public char getRNAOrientation() throws ErrorMsg {
        return this.GetRNAOrientation(this.self);
    }

    @Override
    public boolean hasMate() {
        return this.HasMate(this.self);
    }

    @Override
    public String getMateAlignmentId() throws ErrorMsg {
        return this.GetMateAlignmentId(this.self);
    }

    @Override
    public Alignment getMateAlignment() throws ErrorMsg {
        long l = this.GetMateAlignment(this.self);
        try {
            return new AlignmentItf(l);
        }
        catch (Exception exception) {
            AlignmentItf.release(l);
            throw new ErrorMsg(exception.toString());
        }
    }

    @Override
    public String getMateReferenceSpec() throws ErrorMsg {
        return this.GetMateReferenceSpec(this.self);
    }

    @Override
    public boolean getMateIsReversedOrientation() throws ErrorMsg {
        return this.GetMateIsReversedOrientation(this.self);
    }

    AlignmentItf(long l) {
        super(l);
    }

    AlignmentItf(Alignment alignment) throws ErrorMsg {
        super(0L);
        try {
            AlignmentItf alignmentItf = (AlignmentItf)alignment;
            this.self = alignmentItf.duplicate();
        }
        catch (Exception exception) {
            throw new ErrorMsg(exception.toString());
        }
    }

    private native String GetFragmentId(long var1) throws ErrorMsg;

    private native String GetFragmentBases(long var1, long var3, long var5) throws ErrorMsg;

    private native String GetFragmentQualities(long var1, long var3, long var5) throws ErrorMsg;

    private native boolean IsPaired(long var1) throws ErrorMsg;

    private native String GetAlignmentId(long var1) throws ErrorMsg;

    private native String GetReferenceSpec(long var1) throws ErrorMsg;

    private native int GetMappingQuality(long var1) throws ErrorMsg;

    private native String GetReferenceBases(long var1) throws ErrorMsg;

    private native String GetReadGroup(long var1) throws ErrorMsg;

    private native String GetReadId(long var1) throws ErrorMsg;

    private native String GetClippedFragmentBases(long var1) throws ErrorMsg;

    private native String GetClippedFragmentQualities(long var1) throws ErrorMsg;

    private native String GetAlignedFragmentBases(long var1) throws ErrorMsg;

    private native int GetAlignmentCategory(long var1) throws ErrorMsg;

    private native long GetAlignmentPosition(long var1) throws ErrorMsg;

    private native long GetAlignmentLength(long var1) throws ErrorMsg;

    private native boolean GetIsReversedOrientation(long var1) throws ErrorMsg;

    private native int GetSoftClip(long var1, int var3) throws ErrorMsg;

    private native long GetTemplateLength(long var1) throws ErrorMsg;

    private native String GetShortCigar(long var1, boolean var3) throws ErrorMsg;

    private native String GetLongCigar(long var1, boolean var3) throws ErrorMsg;

    private native char GetRNAOrientation(long var1) throws ErrorMsg;

    private native boolean HasMate(long var1);

    private native String GetMateAlignmentId(long var1) throws ErrorMsg;

    private native long GetMateAlignment(long var1) throws ErrorMsg;

    private native String GetMateReferenceSpec(long var1) throws ErrorMsg;

    private native boolean GetMateIsReversedOrientation(long var1) throws ErrorMsg;
}

